<?php
//============================================================+
// File name   : example_006.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 006 for TCPDF class
//               WriteHTML and RTL support
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: WriteHTML and RTL support
 * @author Nicola Asuni
 * @since 2008-03-04
 */

// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');

include ("include/data_pdf.php");

Init_boutique() ;

global $base, $MySQL_Host, $MySQL_User, $MySQL_Passw, $myart, $A_NumArt,$i, $result, $NbLigne, 
$mygroupeart, $mysousgroupeart, $semaine, $limitesuivante, $limiteprecedente, $limite, $total, $rendement, 
$page, $Nom_Client, $NumAbat, $mrs, $total_entre, $total_sortie, $total_entre_cass, $total_sortie_cass, 
$total_entre_cass, $total_sortie_cass, $total_entre_decoupe, $total_sortie_decoupe, $total_entre_stockPf, $total_sortie_stockPf,
$total_entre_transf, $total_sortie_transf, $total_entre_congel, $total_sortie_congel ;

// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Orius');
$pdf->SetTitle('Bon de Livraison');
$pdf->SetSubject('');
$pdf->SetKeywords('BL ORIUS');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 006', PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setPrintHeader(false);
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/fra.php')) {
	require_once(dirname(__FILE__).'/lang/fra.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
//$pdf->SetFont('helvetica', '', 10);

// add a page
$pdf->AddPage();

// writeHTML($html, $ln=true, $fill=false, $reseth=false, $cell=false, $align='')
// writeHTMLCell($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=0, $reseth=true, $align='', $autopadding=true)

$date = date("d-m-Y");


if (!isset($_GET['num_entre']))
{
    $num_lot=0;
    $num_lot_sel=0;
} else {
    $num_bl_ligne=($_GET['num_entre']);
    $num_bl_ligne=($_GET['num_entre']);
}

    $sql = "SELECT * FROM gestion_bl_haut WHERE num_li_bl='$num_bl_ligne'"; 
		$req = mysqli_query($link, $sql);
		while ($row = mysqli_fetch_assoc($req)) {
        $num_bl_base = $row["num_bl"];
        $date_bl = $row["date_bl"];
        $date_livraison_bl = $row["date_livraison"];
        $num_client_entre = $row["num_client_bl"];
        $CodeTrsp = $row["num_trsp"];
        $CodePaie = $row["num_paie"]; 
    }  
		
		$sql2 = "SELECT `Code_Trsp` FROM categorie_trsp WHERE `Num_Ligne_Cate_Trsp`=$CodeTrsp";  
		$req2 = mysqli_query($link, $sql2);  
		while ($row = mysqli_fetch_assoc($req2)) {$Code_Trsp_texte = $row["Code_Trsp"];} 
		
		$sql3 = "SELECT  `Code_Paiement` FROM categorie_paiement WHERE `Num_Ligne_Cate_Paiement`=$CodePaie";  
		$req3 = mysqli_query($link, $sql3);  
		while ($row = mysqli_fetch_assoc($req3)) {$Code_Paiement_texte = $row["Code_Paiement"];} 


$sql1 = "SELECT * FROM clients_base WHERE Num_Client='$num_client_entre'"; 
$req1 = mysqli_query($link, $sql1);
while ($row = mysqli_fetch_assoc($req1)) {
        $nom_Client = $row["Nom_Client"];
        $Adresse_1 = $row["Adresse_1"];
        $Adresse_2 = $row["Adresse_2"];
        $Adresse_3 = $row["Adresse_3"];
        $Code_Postal = $row["Code_Postal"];
        $Ville = $row["Ville"];
        $CodeTarifs = $row["Code_tarif"];
      } 

$date_bl_e=date("d/m/Y", strtotime($date_bl));
$date_livraison_bl_e = date("d/m/Y", strtotime($date_livraison_bl));
$Anne_bl=date("y", strtotime($date_bl));

$num_bl_complet ="$Anne_bl-$num_bl-".$num_bl_base ;

$date_livraison_bl_e = date("d/m/Y", strtotime($date_livraison_bl));


$html = <<<EOF
<!-- EXAMPLE OF CSS STYLE -->
<style>
.t-text 			{ font-size: 10px; font-weight: Bold; font-variant: small-caps;  text-transform: capitalize; }
.v-text 			{ font-size: 14px; font-weight: Bold; }
.t-text-titre	{ font-size: 14px; font-weight: Bold; font-variant: small-caps;  text-transform: capitalize; }
.titre-text 	{	font-size: 12px; font-weight: Bold; text-transform: capitalize;  text-shadow: 1px 1px Silver;} 

Table.t-text { font-size: 10px;	COLOR: #000000;	font-weight: normal ;}
Table.text { font-size: 12px;	COLOR: #000000;	font-weight: normal ;}
Table.texthaut { font-size: 12px;	COLOR: #000000;	font-weight: normal ;}
Table.texthautFicheLot {font-size: 18px;	COLOR: #000000;	font-weight: normal ;letter-spacing: 3px;}

tr.haut {	font-size: 14px;	background-color: #666;	color: #FFF;	text-align: center;	vertical-align: middle;	}
tr.text {	font-size: 12px;	text-align: center;	vertical-align: middle;  font-weight: normal ;    }

td.t-text { font-size: 12px; font-weight: Bold; font-variant: small-caps;  text-transform: capitalize; }

td.text {	font-size: 12px;	text-align: center;	vertical-align: middle;  font-weight: normal ;    }
td.textpoids {	font-size: 12px;	text-align: right;	vertical-align: middle;  font-weight: normal ;    }
td.textdroite {	font-size: 12px;	text-align: right;	vertical-align: middle;  font-weight: normal ;    }
td.textgauche {	font-size: 12px;	text-align: left;	vertical-align: middle;  font-weight: normal ;    }

td.text14 {	font-size: 14px;	text-align: center;	vertical-align: middle;  font-weight: normal ;    }
td.textpoids14 {	font-size: 14px;	text-align: right;	vertical-align: middle;  font-weight: normal ;    }
td.textdroite14 {	font-size: 14px;	text-align: right;	vertical-align: middle;  font-weight: normal ;    }
td.textgauche14 {	font-size: 14px;	text-align: left;	vertical-align: middle;  font-weight: normal ;    }
td.texttop14 {	font-size: 14px;	text-align: center;	vertical-align: top;  font-weight: normal ;    }

td.textbas 				{font-size: 12px;	text-align: center;	vertical-align: middle;  font-weight: Bold ; background-color: #C0C0C0;	color: #000000; }
td.textpoidsbas 	{font-size: 12px;	text-align: right;	vertical-align: middle;  font-weight: Bold ; background-color: #C0C0C0;	color: #000000; }
td.textdroitebas 	{font-size: 12px;	text-align: right;	vertical-align: middle;  font-weight: Bold ; background-color: #C0C0C0;	color: #000000; }
td.textgauchebas 	{font-size: 12px;	text-align: left;		vertical-align: middle;  font-weight: Bold ; background-color: #C0C0C0;	color: #000000; }


td.texttitre {	font-size: 14px;	text-align: center;	vertical-align: middle;  font-weight: bold ;    }
td.texthaut {	FONT-FAMILY:  Tahoma ;	font-size: 12px;	text-align: center;	vertical-align: middle;  font-weight: normal ;    }
td.textfiche {	FONT-FAMILY:  Tahoma ;	font-size: 8px;	text-align: center;	vertical-align: middle;  font-weight: normal ;    }

td.titretableau {font-size: 16px;	background-color: #C0C0C0;	color: #000000;	font-weight: Bold; font-variant: small-caps; text-transform: capitalize; text-align: center;	vertical-align: middle;	}


}
</style>

<table class="t-text" width="800" border="0" cellpadding="1" cellspacing="1">
<tr>
<td width="100"><center><img src="images/$LogoSite" width="80"></center></td>
<td class="texthaut" width="250">$SocieteSite<br>$RueSite<br>$CpostalSite $VilleSite<br>T&eacute;l : $TelephoneSite <br> $MailSite </td>
<td width="50"><center><img src="images/agrem_$IdNumClient.jpg" width="50"></center></td>
<td width="20"><center>&nbsp;</center></td>
<td width="300">
								<table width="300" border="1" cellpadding="2" cellspacing="3">
								<tr>
								<td colspan="3" class="t-text12"><center>BON DE LIVRAISON</center></td>
								</tr><tr>
								<td class="texthaut">Date</td>
								<td class="texthaut">N&deg; Bon</td>
								<td class="texthaut">Date Livraison</td>
								</tr><tr>
								<td class="texthaut">$date_bl_e </td>
								<td class="texthaut">$num_bl_complet </td>
								<td class="texthaut">$date_livraison_bl_e </td>
								</tr>
								</table></center></td>	



</tr>	
</table>		
<br><br>

<table class="t-text" width="800" border="0" cellpadding="0" cellspacing="0">
<tr>
<td width="350">
			<table width="350" border="1" cellpadding="2" cellspacing="3">
			<tr>
			<td class="t-text"><center>Livraison</center></td>
			</tr><tr>
			<td class="texthaut">$CodeTrsp | $Code_Trsp_texte</td>
			</tr></table><br><br>
			<table width="350" border="1" cellpadding="2" cellspacing="3">
			<tr>
			<td class="t-text"><center>Code Tarifs</center></td>
			<td class="t-text"><center>Paiement - Ech&eacute;ance</center></td>
			</tr><tr>
			<td class="texthaut">$CodeTarifs</td>
			<td class="texthaut">$CodePaie | $Code_Paiement_texte</td>
			</tr></table>
			</td>
<td width="20"><center>&nbsp;</center></td>
<td width="350"><center>
					<table width="350" border="1" cellpadding="2" cellspacing="3">
					<tr>
					<td><center><h3>$nom_Client <br> $Adresse_1 <br> $Adresse_2 <br> $Adresse_3 <br> $Code_Postal - $Ville</h3></center></td>
					</tr>
					</table>
</td>
</tr>
</table>
<br><br>Nos viandes sont 100% origine Fran&ccedil;e<br>N&eacute;es, &eacute;lev&eacute;es, abattues, et transform&eacute;es en France<br><br><br>

<table width="800" border="1" cellpadding="2" cellspacing="3">
<tr height="40">
<td height="40" class="titretableau" width="50" >N&deg;</td>
<td class="titretableau" width="50" >Plu</td>
<td class="titretableau" width="50" >Nb Pi</td>
<td class="titretableau" width="400" >D&eacute;signation</td>
<td class="titretableau" width="150" >Poids</td>
</tr>
</table>
EOF;


// output the HTML content
$pdf->writeHTML($html, true, false, true, false, 'C');



// reset pointer to the last page
$pdf->lastPage();

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Print a table

// add a page
$pdf->AddPage();

// create some HTML content
$subtable = '<table border="1" cellspacing="6" cellpadding="4"><tr><td>a</td><td>b</td></tr><tr><td>c</td><td>d</td></tr></table>';

$html = '<h2>HTML TABLE:</h2>
<table border="1" cellspacing="3" cellpadding="4">
	<tr>
		<th>#</th>
		<th align="right">RIGHT align</th>
		<th align="left">LEFT align</th>
		<th>4A</th>
	</tr>
	<tr>
		<td>1</td>
		<td bgcolor="#cccccc" align="center" colspan="2">A1 ex<i>amp</i>le <a href="http://www.tcpdf.org">link</a> column span. One two tree four five six seven eight nine ten.<br />line after br<br /><small>small text</small> normal <sub>subscript</sub> normal <sup>superscript</sup> normal  bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla bla<ol><li>first<ol><li>sublist</li><li>sublist</li></ol></li><li>second</li></ol><small color="#FF0000" bgcolor="#FFFF00">small small small small small small small small small small small small small small small small small small small small</small></td>
		<td>4B</td>
	</tr>
	<tr>
		<td>'.$subtable.'</td>
		<td bgcolor="#0000FF" color="yellow" align="center">A2 € &euro; &#8364; &amp; è &egrave;<br/>A2 € &euro; &#8364; &amp; è &egrave;</td>
		<td bgcolor="#FFFF00" align="left"><font color="#FF0000">Red</font> Yellow BG</td>
		<td>4C</td>
	</tr>
	<tr>
		<td>1A</td>
		<td rowspan="2" colspan="2" bgcolor="#FFFFCC">2AA<br />2AB<br />2AC</td>
		<td bgcolor="#FF0000">4D</td>
	</tr>
	<tr>
		<td>1B</td>
		<td>4E</td>
	</tr>
	<tr>
		<td>1C</td>
		<td>2C</td>
		<td>3C</td>
		<td>4F</td>
	</tr>
</table>';

// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');

// Print some HTML Cells

$html = '<span color="red">red</span> <span color="green">green</span> <span color="blue">blue</span><br /><span color="red">red</span> <span color="green">green</span> <span color="blue">blue</span>';

$pdf->SetFillColor(255,255,0);

$pdf->writeHTMLCell(0, 0, '', '', $html, 'LRTB', 1, 0, true, 'L', true);
$pdf->writeHTMLCell(0, 0, '', '', $html, 'LRTB', 1, 1, true, 'C', true);
$pdf->writeHTMLCell(0, 0, '', '', $html, 'LRTB', 1, 0, true, 'R', true);

// reset pointer to the last page
$pdf->lastPage();

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Print a table

// add a page
$pdf->AddPage();

// create some HTML content
$htmla = '<h1>Image alignments on HTML table</h1>
<table cellpadding="1" cellspacing="1" border="1" style="text-align:center;">
<tr><td><img src="images/logo_example.png" border="0" height="41" width="41" /></td></tr>
<tr style="text-align:left;"><td><img src="images/logo_example.png" border="0" height="41" width="41" align="top" /></td></tr>
<tr style="text-align:center;"><td><img src="images/logo_example.png" border="0" height="41" width="41" align="middle" /></td></tr>
<tr style="text-align:right;"><td><img src="images/logo_example.png" border="0" height="41" width="41" align="bottom" /></td></tr>
<tr><td style="text-align:left;"><img src="images/logo_example.png" border="0" height="41" width="41" align="top" /></td></tr>
<tr><td style="text-align:center;"><img src="images/logo_example.png" border="0" height="41" width="41" align="middle" /></td></tr>
<tr><td style="text-align:right;"><img src="images/logo_example.png" border="0" height="41" width="41" align="bottom" /></td></tr>
</table>';

// output the HTML content
$pdf->writeHTML($htmla, true, false, true, false, '');

// reset pointer to the last page
$pdf->lastPage();

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Print all HTML colors

// add a page
$pdf->AddPage();

$textcolors = '<h1>HTML Text Colors</h1>';
$bgcolors = '<hr /><h1>HTML Background Colors</h1>';

foreach(TCPDF_COLORS::$webcolor as $k => $v) {
	$textcolors .= '<span color="#'.$v.'">'.$v.'</span> ';
	$bgcolors .= '<span bgcolor="#'.$v.'" color="#333333">'.$v.'</span> ';
}

// output the HTML content
$pdf->writeHTML($textcolors, true, false, true, false, '');
$pdf->writeHTML($bgcolors, true, false, true, false, '');

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// Test word-wrap

// create some HTML content
$html = '<hr />
<h1>Various tests</h1>
<a href="#2">link to page 2</a><br />
<font face="courier"><b>thisisaverylongword</b></font> <font face="helvetica"><i>thisisanotherverylongword</i></font> <font face="times"><b>thisisaverylongword</b></font> thisisanotherverylongword <font face="times">thisisaverylongword</font> <font face="courier"><b>thisisaverylongword</b></font> <font face="helvetica"><i>thisisanotherverylongword</i></font> <font face="times"><b>thisisaverylongword</b></font> thisisanotherverylongword <font face="times">thisisaverylongword</font> <font face="courier"><b>thisisaverylongword</b></font> <font face="helvetica"><i>thisisanotherverylongword</i></font> <font face="times"><b>thisisaverylongword</b></font> thisisanotherverylongword <font face="times">thisisaverylongword</font> <font face="courier"><b>thisisaverylongword</b></font> <font face="helvetica"><i>thisisanotherverylongword</i></font> <font face="times"><b>thisisaverylongword</b></font> thisisanotherverylongword <font face="times">thisisaverylongword</font> <font face="courier"><b>thisisaverylongword</b></font> <font face="helvetica"><i>thisisanotherverylongword</i></font> <font face="times"><b>thisisaverylongword</b></font> thisisanotherverylongword <font face="times">thisisaverylongword</font>';

// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');

// Test fonts nesting
$html1 = 'Default <font face="courier">Courier <font face="helvetica">Helvetica <font face="times">Times <font face="dejavusans">dejavusans </font>Times </font>Helvetica </font>Courier </font>Default';
$html2 = '<small>small text</small> normal <small>small text</small> normal <sub>subscript</sub> normal <sup>superscript</sup> normal';
$html3 = '<font size="10" color="#ff7f50">The</font> <font size="10" color="#6495ed">quick</font> <font size="14" color="#dc143c">brown</font> <font size="18" color="#008000">fox</font> <font size="22"><a href="http://www.tcpdf.org">jumps</a></font> <font size="22" color="#a0522d">over</font> <font size="18" color="#da70d6">the</font> <font size="14" color="#9400d3">lazy</font> <font size="10" color="#4169el">dog</font>.';

$html = $html1.'<br />'.$html2.'<br />'.$html3.'<br />'.$html3.'<br />'.$html2;

// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// test pre tag

// add a page
$pdf->AddPage();

$html = <<<EOF
<div style="background-color:#880000;color:white;">
Hello World!<br />
Hello
</div>
<pre style="background-color:#336699;color:white;">
int main() {
    printf("HelloWorld");
    return 0;
}
</pre>
<tt>Monospace font</tt>, normal font, <tt>monospace font</tt>, normal font.
<br />
<div style="background-color:#880000;color:white;">DIV LEVEL 1<div style="background-color:#008800;color:white;">DIV LEVEL 2</div>DIV LEVEL 1</div>
<br />
<span style="background-color:#880000;color:white;">SPAN LEVEL 1 <span style="background-color:#008800;color:white;">SPAN LEVEL 2</span> SPAN LEVEL 1</span>
EOF;

// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// test custom bullet points for list

// add a page
$pdf->AddPage();

$html = <<<EOF
<h1>Test custom bullet image for list items</h1>
<ul style="font-size:14pt;list-style-type:img|png|4|4|images/logo_example.png">
	<li>test custom bullet image</li>
	<li>test custom bullet image</li>
	<li>test custom bullet image</li>
	<li>test custom bullet image</li>
<ul>
EOF;

// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// reset pointer to the last page
$pdf->lastPage();

// ---------------------------------------------------------

//Close and output PDF document
$pdf->Output('example_006.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+
