<?php
// (c) Xavier Nicolay
// Exemple de gnration de devis/facture PDF

require('invoice.php');

$pdf = new PDF_Invoice( 'P', 'mm', 'A4' );
$pdf->SetMargins(5,5,5);
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->addLogo("logo_10001.jpg");
$pdf->addSociete( "Les Fermes du Pays Bourian",
                  "\n" .
                  "Le Fournel\n" .
                  "46 310 Montamel\n");
$pdf->addSocieteComplement("Cooperative-les-fermes-du-pays-bourian@orange.fr\n".
                            "R.C.S. CAHORS 481 589 893 \n".
                            "Capital : variable 62 550 " . EURO."\n".
                            "Agrment HCCA : 11 754");

$NumDoc = "FA 19-10001-02.31";
$pdf->fact_dev( "Facture ", $NumDoc );
$txttemp="Projet de Facture" ;
$pdf->temporaire($txttemp);
$pdf->addClient("1001 10 215");
$pdf->addDate( "03/12/2003");
$pdf->addPageNumber("1","1");
$pdf->addClientAdresse("Ste\nM. XXXX\n3me tage\n33, rue d'ailleurs\n75000 PARIS");
$pdf->addReglement("Chque  rception de facture");
$pdf->addEcheance("03/12/2003");
$pdf->addNumTVA("FR888777666");
$pdf->addReference("Devis ... du ....");
$col1s=array( "PLU"    => 23,
             "DESIGNATION"  => 78,
             "QUANTITE"     => 22,
             "P.U. HT"      => 26,
             "MONTANT H.T." => 30,
             "TVA"          => 11 );
$pdf->addCols( $col1s);
$col2s=array( "REFERENCE"    => "L",
             "DESIGNATION"  => "L",
             "QUANTITE"     => "C",
             "P.U. HT"      => "R",
             "MONTANT H.T." => "R",
             "TVA"          => "C" );
$pdf->addLineFormat($col2s);


$y    = 109;
for($ij=0;$ij<8;$ij++){
$line = array( "PLU"    => "REF1",
               "DESIGNATION"  => "Carte Mre MSI 6378\n" .
                                 "Processeur AMD 1Ghz\n" .
                                 "128Mo SDRAM, 30 Go Disque, CD-ROM, Floppy, Carte vido",
               "QUANTITE"     => "1",
               "P.U. HT"      => sprintf("%.2F ",600),
               "MONTANT H.T." => sprintf("%.2F ",600),
               "TVA"          => "1" );
$size = $pdf->addLine( $y, $line,$col1s,$col2s,$txttemp,$NumDoc );
$y   += $size + 3;
}

for($ij=0;$ij<5;$ij++){
$line = array( "PLU"    => "REF2".$ij,
               "DESIGNATION"  => "Cble RS232",
               "QUANTITE"     => sprintf("%.2F ",$ij) ,
               "P.U. HT"      => sprintf("%.2F ",10),
               "MONTANT H.T." => sprintf("%.2F ",$ij * 10) ,
               "TVA"          => "1" );
$size = $pdf->addLine( $y, $line,$col1s,$col2s,$txttemp,$NumDoc );
$y   += $size + 3;
}

for($ij=0;$ij<2;$ij++){
$line = array( "PLU"    => "REF1",
               "DESIGNATION"  => "Carte Mre MSI 6378\n" .
                                 "Processeur AMD 1Ghz\n" .
                                 "128Mo SDRAM, 30 Go Disque, CD-ROM, Floppy, Carte vido",
               "QUANTITE"     => "1",
               "P.U. HT"      => sprintf("%.2F ",600),
               "MONTANT H.T." => sprintf("%.2F ",600),
               "TVA"          => "1" );
$size = $pdf->addLine( $y, $line,$col1s,$col2s,$txttemp,$NumDoc );
$y   += $size + 3;
}
$pdf->addCadreTVAs();
        
// invoice = array( "px_unit" => value,
//                  "qte"     => qte,
//                  "tva"     => code_tva );
// tab_tva = array( "1"       => 19.6,
//                  "2"       => 5.5, ... );
// params  = array( "RemiseGlobale" => [0|1],
//                      "remise_tva"     => [1|2...],  // {la remise s'applique sur ce code TVA}
//                      "remise"         => value,     // {montant de la remise}
//                      "remise_percent" => percent,   // {pourcentage de remise sur ce montant de TVA}
//                  "FraisPort"     => [0|1],
//                      "portTTC"        => value,     // montant des frais de ports TTC
//                                                     // par defaut la TVA = 19.6 %
//                      "portHT"         => value,     // montant des frais de ports HT
//                      "portTVA"        => tva_value, // valeur de la TVA a appliquer sur le montant HT
//                  "AccompteExige" => [0|1],
//                      "accompte"         => value    // montant de l'acompte (TTC)
//                      "accompte_percent" => percent  // pourcentage d'acompte (TTC)
//                  "Remarque" => "texte"              // texte
$tot_prods = array( array ( "px_unit" => 600, "qte" => 1, "tva" => 1 ),
                    array ( "px_unit" => 600, "qte" => 1, "tva" => 2 ),
                    array ( "px_unit" => 100, "qte" => 1, "tva" => 3 ));
$tab_tva = array( "1"       => 19.6,
                  "2"       => 5.5);
$params  = array( "RemiseGlobale" => 1,
                      "remise_tva"     => 1,       // {la remise s'applique sur ce code TVA}
                      "remise"         => 0,      // {montant de la remise}
                      "remise_percent" => 25,    // {pourcentage de remise sur ce montant de TVA}
                      
                      "FraisPort"     => 1,
                      "portTTC"        => 0,    // montant des frais de ports TTC
                                                   // par defaut la TVA = 19.6 %
                      "portHT"         => 100,      // montant des frais de ports HT
                      "portTVA"        => 5.5,    // valeur de la TVA a appliquer sur le montant HT
                  
                  "AccompteExige" => 1,
                  "accompte"         => 150,     // montant de l'acompte (TTC)
                  "accompte_percent" => 0,    // pourcentage d'acompte (TTC)
                  "Remarque" => "" );

$pdf->addTVAs( $params, $tab_tva, $tot_prods);
$pdf->addCadreEurosFrancs();
$pdf->addPapillon ("FA 19-10001-02.31","03/12/2003","1226.70","10 215" );
$pdf->addMentionLegale("Selon l'article 1583 du code civil, l'acheteur est totalement propritaire du bien impay et le vendeur ne peut pas reprendre possession de son bien. Toutefois, les parties peuvent droger  cette rgle, qui n'est pas d'ordre public, et insrer dans leur contrat de vente une clause rservant la proprit au vendeur jusqu'au paiement du prix par l'acheteur.\n".
                      "Autre avantage : en cas de sauvegarde, mise en redressement ou liquidation de l'acheteur, la clause de rserve de proprit permet aussi de passer avant les autres cranciers, et de reprendre le bien impay dont le fournisseur reste propritaire Autre avantage : en cas de sauvegarde, mise en redressement ou liquidation de l'acheteur, la clause de rserve de proprit permet aussi de passer avant les autres cranciers, et de reprendre le bien impay dont le fournisseur reste propritaire.");

//$pdf->Output('D',$numclient." - ".$NumDoc.'.pdf');
$pdf->Output();
?>
