$(document).ready(function () {

	// Lorsque l'on clique sur show on affiche la fenêtre modale
	$('#show').click(function (e) {
		//On désactive le comportement du lien
		e.preventDefault();
		showModal();
	});
	//
	// Lorsque l'on clique sur le fond on cache la fenetre modale
	$('#fond').click(function () {
		hideModal();
	});
	//
	// Lorsque l'on modifie la taille du navigateur la taille du fond change
	$(window).resize(function () {
		resizeModal()
	});

	$('.btn-danger').click(function (e) {
		e.preventDefault();
		var $a = $(this);
		var url = $a.attr('href');
		$.ajax(url)
			.done(function (data, text, jqxhr) {
				$a.parents('tr').fadeOut();
			})
			.fail(function (jqxhr, text) {
				alert(jqxhr.responseText);
			})
			.always(function () {
				$a.text('supprimer');
			});
	});

	$('#form-add').on('submit', function (e) {
		e.preventDefault();
		var $form = $(this);
		$form.find('button').text('Chargement')
		$.post($form.attr('action'), $form.serializeArray())
			.done(function (data, text, jqxhr) {
				$form.find('input').val('');
				console.log(jqxhr);

			})
			.fail(function (jqxhr, text) {
				alert(jqxhr.responseText);
			})
			.always(function () {
				$form.find('button').text('envoyer')
			});

	});

	$('.dropdown-menu a.dropdown-toggle').on('click', function (e) {
		if (!$(this).next().hasClass('show')) {
			$(this).parents('.dropdown-menu').first().find('.show').removeClass("show");
		}
		var $subMenu = $(this).next(".dropdown-menu");
		$subMenu.toggleClass('show'); 			// appliqué au ul
		$(this).parent().toggleClass('show'); 	// appliqué au li parent

		$(this).parents('li.nav-item.dropdown.show').on('hidden.bs.dropdown', function (e) {
			$('.dropdown-submenu .show').removeClass('show'); 	// appliqué au ul
			$('.dropdown-submenu.show').removeClass('show'); 		// appliqué au li parent
		});
		return false;
	});



});

function showModal() {
	var id = '#modal';

	$(function () {
		function timer(n) {
			$(".progress-bar").css("width", n + "%");
			if (n < 100) {
				setTimeout(function () {
					timer(n + 5);
				}, 200);
			} else {
				setTimeout(function () {
					timer(n - 100);
				}, 200);
			}
		}

		timer(1);
	});
	$(id).html('Chargement en cours.....<br><br> Veuillez Patienter....<br><br><div class="progress"style="height: 10px; width:200px "><div class="progress-bar progress-bar-striped bg-success progress-bar-animated" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100"></div></div>');

	// On definit la taille de la fenetre modale
	resizeModal();

	// Effet de transition
	$('#fond').fadeIn(1000);
	$('#fond').fadeTo("slow", 0.8);
	// Effet de transition
	$(id).fadeIn(2000);

}

function hideModal() {
	// On cache le fond et la fenêtre modale
	$('#fond, .popup').hide();
	$('.popup').html('');
}

function resizeModal() {
	var modal = $('#modal');
	// On récupère la largeur de l'écran et la hauteur de la page afin de cacher la totalité de l'écran
	var winH = $(document).height();
	var winW = $(window).width();

	// le fond aura la taille de l'écran
	$('#fond').css({ 'width': winW, 'height': winH });

	// On récupère la hauteur et la largeur de l'écran
	var winH = $(window).height();
	// On met la fenêtre modale au centre de l'écran
	modal.css('top', winH / 2 - modal.height() / 2);
	modal.css('left', winW / 2 - modal.width() / 2);
}

function Popup(page, largeur, hauteur, options) {
	var top = (screen.height - hauteur) / 2;
	var left = (screen.width - largeur) / 2;
	window.open(page, "", "top=" + top + ",left=" + left + ",width=" + largeur + ",height=" + hauteur + "," + options);
}

function format(valeur, decimal, separateur) {
	// formate un chiffre avec 'decimal' chiffres apr�s la virgule et un separateur
	var deci = Math.round(Math.pow(10, decimal) * (Math.abs(valeur) - Math.floor(Math.abs(valeur))));
	var val = Math.floor(Math.abs(valeur));
	if ((decimal == 0) || (deci == Math.pow(10, decimal))) { val = Math.floor(Math.abs(valeur)); deci = 0; }
	var val_format = val + "";
	var nb = val_format.length;
	for (var i = 1; i < 4; i++) {
		if (val >= Math.pow(10, (3 * i))) {
			val_format = val_format.substring(0, nb - (3 * i)) + separateur + val_format.substring(nb - (3 * i));
		}
	}
	if (decimal > 0) {
		var decim = "";
		for (var j = 0; j < (decimal - deci.toString().length); j++) { decim += "0"; }
		deci = decim + deci.toString();
		val_format = val_format + "." + deci;
	}
	if (parseFloat(valeur) < 0) { val_format = "-" + val_format; }
	return val_format;
}

jQuery(function ($) {
	$("#Telephone").mask("99 99 99 99 99");
	$("#Portable").mask("99 99 99 99 99");
	$("#Code_postal").mask("99 999");
	$("#let_client").mask("99 999");
	$("#Num_piece").mask("9999 999 999");
});
