@if ($items->count() > 0)
    <table class="table table-box pml-table" current-page="{{ empty(request()->page) ? 1 : empty(request()->page) }}">
        @foreach ($items as $key => $item)
            <tr>
                <td width="1%">         
                    <div class="text-nowrap">
                        <div class="checkbox inline">
                        <label>                 
                            <input type="checkbox" class="node styled" custom-order="{{ $item->custom_order }}" name="ids[]" value="{{ $item->uid }}" />
                        </label>
                        </div>
                    </div>
                </td>
                <td>
                    <h5 class="no-margin text-bold">
                        <a class="kq_search" href="{{ action('Admin\SendingDomainController@show', $item->uid) }}">{{ $item->name }}</a>
                    </h5>
                    <span class="text-muted">
                        {!! is_object($item->admin) ? '<i class="icon-user-tie"></i>' . $item->admin->displayName() : '' !!}
                        {!! is_object($item->customer) ? '<i class="icon-user"></i>' . $item->customer->displayName() : '' !!}
                    </span>
                    <br />
                    <span class="text-muted">{{ trans('messages.created_at') }}: {{ Tool::formatDateTime($item->created_at) }}</span>
                </td>
                    
                <td class="text-center">
                    <div class="single-stat-box pull-left">
                        <i class="table-checkmark-{{ $item->domain_verified }}"></i>
                        <br />
                        <span class="text-muted">{{ trans("messages.sending_domain.domain_verification") }}</span>
                    </div>
                </td>
                    
                <td class="text-center">
                    <div class="single-stat-box pull-left">
                        <i class="table-checkmark-{{ $item->dkim_verified }}"></i>
                        <br />
                        <span class="text-muted">{{ trans("messages.sending_domain.dkim_verification") }}</span>
                    </div>
                </td>
                    
                <td class="text-center">
                    <div class="single-stat-box pull-left">
                        <i class="table-checkmark-{{ $item->signing_enabled }}"></i>
                        <br />
                        <span class="text-muted">{{ trans("messages.signing_enabled") }}</span>
                    </div>
                </td>
                
                <td class="text-right">
                    <span class="text-muted2 list-status pull-left">
                        <span class="label label-flat bg-{{ $item->status }}">{{ trans('messages.sending_domain_status_' . $item->status) }}</span>
                    </span>

                    @if (Auth::user()->admin->can('read', $item))
                        <a href="{{ action('Admin\SendingDomainController@show', $item->uid) }}" data-popup="tooltip" title="{{ trans('messages.sending_domain.view') }}" type="button" class="btn bg-grey btn-icon">
                            {{ trans('messages.sending_domain.view') }}
                        </a>
                    @endif

                    @if (Auth::user()->admin->can('delete', $item))
                        <div class="btn-group">
                            <button type="button" class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret ml-0"></span></button>
                            <ul class="dropdown-menu dropdown-menu-right">
                                <li>
                                    <a delete-confirm="{{ trans('messages.delete_sending_domains_confirm') }}" href="{{ action('Admin\SendingDomainController@delete', ["uids" => $item->uid]) }}">
                                        <i class="icon-trash"></i> {{ trans('messages.delete') }}
                                    </a>
                                </li>
                            </ul>
                        </div>
                    @endif
                </td>
            </tr>
        @endforeach
    </table>
    
    @include('elements/_per_page_select')
    
    {{ $items->links() }}
    
@elseif (!empty(request()->keyword))
    <div class="empty-list">
        <i class="icon-earth"></i>
        <span class="line-1">
            {{ trans('messages.no_search_result') }}
        </span>
    </div>
@else
    <div class="empty-list">
        <i class="icon-earth"></i>
        <span class="line-1">
            {{ trans('messages.sending_domain_empty_line_1') }}
        </span>
    </div>
@endif
