<?php

namespace Acelle\Http\Controllers;

use Illuminate\Http\Request;

class AdminController extends Controller
{

    /**
     * Render admin image.
     */
    public function avatar(Request $request)
    {
        // Get current admin
        if ($request->uid != '0') {
            $admin = \Acelle\Model\Admin::findByUid($request->uid);
        } else {
            $admin = new \Acelle\Model\Admin();
        }
        if (!empty($admin->imagePath())) {
            $img = \Image::make($admin->imagePath());
        } else {
            $img = \Image::make(public_path('assets/images/placeholder.jpg'));
        }

        return $img->response();
    }

    /**
     * User uid for editor.
     */
    public function showUid(Request $request)
    {
        $user = $request->user();
        echo $user->uid;
    }

    /**
     * Log in back user.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function loginBack(Request $request)
    {
        $id = \Session::pull('orig_user_id');
        $orig_user = \Acelle\Model\User::findByUid($id);

        \Auth::login($orig_user);

        return redirect()->action('Admin\UserController@index');
    }
}
