<?php
//**************************************************//
//                                                  //
//                 Gagatemplate 4.1                 //
//                    Mars   2008                   //
//                                                  //
//                    Par Gaga26                    //
//                                                  //
//    Email : gaga26@gmail.com                      //
//      Web : www.gagatemplate.com                  //
//  Licence : GNU LGPL                              //
//                                                  //
//      Have fun                                    //
//                                  Gaga26          //
//**************************************************//

class gagatemplate
{
	// les balises
		public $bal = array(
			'var' => array('{', '}', '$'),										// balises des vars
			'foreach' => array('foreach', 'var', 'as'),						// balises des blocks
			'include' => array('include', 'file', 'cache'),			// balises de la fin des blocks
			'cond' => array('if', 'elseif', 'else', 'cond'),	// balises des condition
			'com' => array('/#', '#/'));									// balises des commentaires

	// les dossiers
		public $template_dir = 'templates/';	// dossier des fichiers templates
		public $compile_dir = 'templates_c/';
		public $this_dir;					    // dossier actuel
		public $cache_dir = 'cache/';			// dossier des fichier mis en cache

	// var pour les blocks et vars
		protected $vars = array();				// tableau contenant les variables

	// var pour le cache
		public $cache = false;					// activation de la mise en cache
		public $cache_time = 0;					// temps du cache en secondes
		public $compile = false;                // Forcer la compilation systmatique

	// var pour le temps d'execution
		private $temps_tpl = array();			// temps de cration par template
		private $one_cache = false;
	
	// infos
		private $infos = array();
		private $infos_new = false;
		private $infos_dir= false;

	// message d'erreur
		public $error_display = true;			// activer l'affichage des erreurs
		public $error_msg = '<br /><strong>GagaTemplate error :</strong><br />'; // le dbut des messages d'erreur
		public $error = false;
	
	public function __construct($dir = '', $i='cache/') {
		$this->this_dir = addslashes($dir);
		$this->infos_dir = $i;
		$this->get_infos();
	}

	public function assign($nom, $valeur = NULL){
		if(is_array($nom))
			$this->vars = array_merge($this->vars, $nom);
		else
			$this->vars[$nom] = $valeur;
	}
	
	public function assign_array($nom, $a) {
		if(isset($this->vars[$nom]) && !is_array($this->vars[$nom]))
			$this->error('Vous crasez une variable par un array');
		krsort($a);
		
		if(strpos($nom, '.')) {
			$e = explode('.', $nom);
			$b = '$this->vars';
			$c = count($e) -1;
			for ($i=0 ; $i<$c ; $i++) {
				$b .= '[\'' . $e[$i] . '\']';
				eval('$c_b_p = count(' . $b . ') - 1;');
				$b .= '[' . $c_b_p . ']';
			}
			$b .= '[\'' . $e[$c] . '\'][] = $a;';
			eval($b);
		}else{
			$this->vars[$nom][] = $a;
		}
	}
	
	public function is_in_cache($f, $s=false) {
		$s = $s ? $s : 'base';
		$f_tpl = $this->this_dir.$this->template_dir.$f;
		if($this->cache && !$this->compile) {
			if(isset($this->infos[$f_tpl][$s]['cache'])){
				$d = time()-$this->infos[$f_tpl][$s]['cache']-$this->cache_time;
				return ($this->cache_time == 0 || $d < 0);
			}
		}
		return false;
	}
	
	public function parse($file, $surnom = false, $disp = true) {
		$d = microtime(true);
		$f_tpl = $this->this_dir.$this->template_dir.$file;

		$r = $this->cache ? $this->parse_cache_file($file, $f_tpl, $surnom, $disp) : $r = $this->parse_compile_file($file, $f_tpl, $disp);
			
		if($this->infos_new)
			$this->set_infos();
		
		$this->temps_tpl[$file] = microtime(true)-$d;
		
		return $r;
	}
	
	private function parse_compile_file($file, $f_tpl, $disp=true) {
		$rp = false;
		if(isset($this->infos[$f_tpl]['base']['compile_file'])){
			$nc = $this->infos[$f_tpl]['base']['compile_file'];
			if(filemtime($f_tpl) > $this->infos[$f_tpl]['base']['compile']) $rp=true;
		}else $nc = $this->this_dir.$this->compile_dir.$this->name($file).'.g.php';
		
		if(!is_file($nc) || $rp || $this->compile){
			$nc = $this->parse_file($file, $f_tpl);
		
			$this->infos_new = true;
			$this->infos[$f_tpl]['base']['compile'] = time();
			$this->infos[$f_tpl]['base']['compile_file'] = $nc;
		}
				
		if($disp) {
			foreach($this->vars as $k=>$v) {
				${$k} = $v;
			}
			include($nc);
		}
		
		return $nc;
	}
	
	private function parse_cache_file($file, $f_tpl, $surnom, $disp=true) {
		$s = $surnom ? $surnom : 'base';
		if($this->is_in_cache($file, $surnom)){
			$r = $this->infos[$f_tpl][$s]['cache_file'];
		}else{
			ob_start();
			$this->parse_compile_file($file, $f_tpl, true);
			$c = ob_get_contents();
			ob_end_clean();
			
			$n = $surnom ? '-'.$surnom : '';
			$n_c = $this->this_dir.$this->cache_dir.$this->name($file).$n.'.g.txt';
			@unlink($n_c);
			if(!file_put_contents($n_c, $c))
				$this->error('Le <strong>dossier des fichiers mis en cache</strong> n\'est pas ouvert en &eacute;criture !', true);
			$this->infos_new = true;
			$this->infos[$f_tpl][$s]['cache'] = time();
			$this->infos[$f_tpl][$s]['cache_file'] = $n_c;
			$r = $n_c;
		}	
		if($disp)
			include($r);
		$this->one_cache = true;
		return $r;
	}
	
	protected function parse_file($file, $f_tpl){
		if(!is_file($f_tpl))
			$this->error('le fichier <i>'.$f_tpl.'</i> n\'exite pas !', true);
		$c = file_get_contents($f_tpl);

		$c = preg_replace('`'.preg_quote($this->bal['com'][0]).'(.+)'.preg_quote($this->bal['com'][1]).'`isU', '', $c);

		$c = $this->parse_include($c);    // include
		$c = $this->parse_vars($c);       // vars
		$c = $this->parse_array($c);     // blocks
		$c = $this->parse_condition($c); // conditions

		$n_c = $this->this_dir.$this->compile_dir.$this->name($file).'.g.php';
		
		@unlink($n_c);
		if(!file_put_contents($n_c, $c))
			$this->error('Le <strong>dossier des fichiers compil&eacute;s</strong> n\'est pas ouvert en &eacute;criture !', true);
		

		return $n_c;
	}
	
	protected function parse_vars($c) {
		$c = preg_replace('`\[(\S+)\]`U', '[\'\1\']', $c);
		$c = preg_replace('`'.preg_quote($this->bal['var'][0]).'(\S+)'.preg_quote($this->bal['var'][1]).'`isU', '<?php echo $\1; ?>', $c);
		return $c;
	}
	
	protected function parse_array($c) {
		for($i = 0; ($i < 10) && (strpos($c, '</foreach') !== FALSE); ++$i){
			$c = preg_replace('`<(foreach)\s*var="(.+)"\s*as="(.+)"\s*>((?:.(?!<foreach>))*)</foreach>`sU', '<?php if(isset(\2)){ foreach(\2 as $\3) { ?>\4 <?php }} ?>', $c);
		}
		return $c;
	}
	
	protected function parse_include($c) {
		$c = preg_replace_callback('`<'.preg_quote($this->bal['include'][0]).' '.preg_quote($this->bal['include'][1]).'="(.+)"\s?('.preg_quote($this->bal['include'][2]).'="on")?\s?/?>`isU', array('gagatemplate', 'parse_include_callback'), $c);
		
		return $c;
	}
	
	private function parse_include_callback($m){
		if(strpos($m[1], '$')==1) {//var
			$v = substr($m[1], 1);
			if(!isset($this->vars[$v])) {
				$this->error('Variable pour l\'include non dclar !');
				return false;
			}
			$f = $this->vars[$v];
		}else
			$f = $m[1];
		
		return isset($m[2]) ? '<?php $gaga_cache=$this->cache; $this->cache=true; $this->parse("'.str_replace('\\','\\\\',$f).'"); $this->cache=$gaga_cache; ?>' : '<?php $this->parse("'.str_replace('\\','\\\\',$f).'"); ?>';
	}
	
	protected function parse_condition($c) {
		return preg_replace(array(
				'`<'.preg_quote($this->bal['cond'][0]).' '.preg_quote($this->bal['cond'][3]).'="(.+)">`sU',
				'`</'.preg_quote($this->bal['cond'][0]).'>`sU',
				'`<'.preg_quote($this->bal['cond'][1]).' '.preg_quote($this->bal['cond'][3]).'="(.+)"\s?/?>`sU',
				'`<'.preg_quote($this->bal['cond'][2]).'\s?/?>`sU',
			),array(
				'<?php if(\1) { ?>', 
				'<?php } ?>',
				'<?php }elseif(\1){ ?>', 
				'<?php }else{ ?>'
			),
			$c);
	}
	
	protected function name($f){
		return str_replace('/', '-', substr($f, 0, strrpos($f, '.')));
	}

	protected function error($texte, $exit = false) {
		if ($this->error_display) {
			echo $this->error_msg.$texte.'<br /><br />';
			if ($exit)	exit();
		}
		$this->error = true;
	}
	
	public function del_cache($f, $s='base') {
		$f_tpl = $this->this_dir.$this->template_dir.$f;
		if(isset($this->infos[$f_tpl][$s])) {
			@unlink($this->infos[$f_tpl][$s]['cache_file']);
			unset($this->infos[$f_tpl][$s]['cache']);
			unset($this->infos[$f_tpl][$s]['cache_file']);
		}
		$this->set_infos();
	}

	private function clean($dir,$ext=false) {
		$l = $this->this_dir.$dir;
		$a = array();
		$d = opendir($l);
		while ($f = readdir($d)) {
			if ($f != '.' && $f != '..') {
				if (($ext == false) || strpos($f, $ext)) {
					$a[] = $f;
					@unlink($l.$f);
				}
			}
		}
		closedir($d);
		return $a;
	}

	public function clean_compile_dir() {
		$this->infos = array();
		$this->set_infos();
		return $this->clean($this->compile_dir, '.g.php');
	}

	public function clean_cache_dir() {
		foreach($this->infos as $k => $v){
			foreach($v as $sk=>$sv){
				unset($this->infos[$k][$sk]['cache']);
				unset($this->infos[$k][$sk]['cache_file']);
			}
		}
		$this->set_infos();
		return $this->clean($this->cache_dir, '.g.txt');
	}

	public function debug($url, $dec) {
		include($this->this_dir.'libs/debug.php');
	}
	
	private function get_infos() {
		$f = $this->this_dir.$this->infos_dir.'infos.php';
		if(is_file($f))
			include($f);
	}
	
	private function set_infos() {
		$f = $this->this_dir.$this->infos_dir.'infos.php';
		@unlink($f);
		file_put_contents($f, '<?php $this->infos = '.var_export($this->infos, true).'; ?>');
	}
	
	public function infos() {
		echo '<pre>';
		print_r($this->infos);
		echo '</pre>';
	}
}
?>