<?php

  function DrawBullet($image, $x, $y, $type, $color) {
    switch ($type) {
      case 0: 
      case 5: 
        for ($i=0; $i<8; $i++)
        ImageArc($image, $x, $y, $i, $i, 0, 359, $color);
        break;
      case 1: 
      case 6: 
        ImageFilledRectangle($image, $x-3, $y-3, $x+3, $y+3, $color);
        break;
      case 2: 
      case 7: 
        ImageFilledRectangle($image, $x-1, $y-4, $x+1, $y+4, $color);
        ImageFilledRectangle($image, $x-4, $y-1, $x+4, $y+1, $color);
        break;
      case 3: 
      case 8: 
        $points[0]=$x;
        $points[1]=$y-4;
        $points[2]=$x+4;
        $points[3]=$y;
        $points[4]=$x;
        $points[5]=$y+4;
        $points[6]=$x-4;
        $points[7]=$y;
        ImageFilledPolygon($image,  $points, 4, $color);
        break;
      case 4: 
      case 9: 
        $points[0]=$x;
        $points[1]=$y-4;
        $points[2]=$x+4;
        $points[3]=$y+4;
        $points[4]=$x-4;
        $points[5]=$y+4;
        ImageFilledPolygon($image,  $points, 3, $color);
        break;
      default: ;
    }
    return;
  }

  function MakeLinePointChart($imagedata) {
    $id = uniqid("");

    $width = $imagedata["width"];
    if (!$width) $width=1;
    $height = $imagedata["height"];
    if (!$height) $height=1;

    $chartx = 5;
    $charty = 5;
    $chartw = $width-10;
    $charth = $height-10;

    $scaleyx = 0;

    $im = imagecreate($width, $height);
    $black = ImageColorAllocate($im, 0,0,0);
    $white = ImageColorAllocate($im, 255,255,255);
    
    $colors[0] = ImageColorAllocate($im, 240, 128, 128);
    $colors[1] = ImageColorAllocate($im, 100, 149, 237);
    $colors[2] = ImageColorAllocate($im,  50, 205,  50);
    $colors[3] = ImageColorAllocate($im, 255, 215,   0);
    $colors[4] = ImageColorAllocate($im, 131, 111, 255);
    $colors[5] = ImageColorAllocate($im, 144, 238, 144);
    $colors[6] = ImageColorAllocate($im,  70, 130, 180);
    $colors[7] = ImageColorAllocate($im, 244, 164,  96);
    $colors[8] = ImageColorAllocate($im, 139, 121,  94);
    $colors[9] = ImageColorAllocate($im, 190, 190, 190);

    ImageFill($im,0,0,$white);

    $caption = $imagedata["caption"];
    if ($caption) {
      $font1 = 5;
      $ifh1 = ImageFontHeight($font1);
      $ifw1 = ImageFontWidth($font1);
      
      $captionw = strlen($caption)*$ifw1;
      ImageString($im, $font1, ($width - $captionw)/2, 0, $caption, $black);
      ImageLine($im, ($width - $captionw)/2, $ifh1, ($width+$captionw)/2, $ifh1, $black);
      
      $charth -= $ifh1;
    }

    $xcaption = $imagedata["xCaption"];
    if ($xcaption) {
      $font2 = 4;
      $ifh2 = ImageFontHeight($font2);
      $ifw2 = ImageFontWidth($font2);
      
      $xcaptionw = strlen($xcaption)*$ifw2;
      ImageString($im, $font2, ($width - $xcaptionw)/2, $height-$ifh2, $xcaption, $black);
      
      $charty += $ifh2;
      $charth -= $ifh2;
    }
 
    $xscale = $imagedata["xScale"];
    if ($xscale) {
      $font4 = 3;
      $ifh4 = ImageFontHeight($font4);
      $ifw4 = ImageFontWidth($font4);
      
      $charty += $ifh4; 
      $charth -= $ifh4; 
    }  

    $ycaption = $imagedata["yCaption"];
    if ($ycaption) {
      $font3 = 4;
      $ifh3 = ImageFontHeight($font3);
      $ifw3 = ImageFontWidth($font3);
      
      $ycaptionh = strlen($ycaption)*$ifw3;
      ImageStringUp($im, $font3, $ifw3, ($height + $ycaptionh)/2, $ycaption, $black);
      
      $chartx += $ifh3+5;
      $chartw -= $ifh3+5;
      $scaleyx += $ifh3+7;
    }

    //  echo $chartw." ".$chartx." ".$chartw+$chartx."<br>";
   
    $yscale = $imagedata["yScale"];
    if ($yscale) {
      $font6 = 3;
      $ifh6 = ImageFontHeight($font6);
      $ifw6 = ImageFontWidth($font6);
      if ($imagedata["numberFormat"]) {
        $longestyscale=strlen(sprintf($imagedata["numberFormat"],$imagedata["yMax"])); 
        $tmp = strlen(sprintf($imagedata["numberFormat"],$imagedata["yMin"]));  
      } else { 
        $longestyscale=strlen($imagedata["yMax"]); 
        $tmp = strlen($imagedata["yMin"]);  
      }
      $longestyscale=max($longestyscale, $tmp);
      $chartx += $longestyscale*$ifw6; 
      $chartw -= $longestyscale*$ifw6; 
    }  

    $ycount = $imagedata["yCount"];
    $format = $imagedata["numberFormat"];
    if ($ycount) {
      $yinc = $charth/$ycount;
      $yscaleinc = (-$imagedata["yMin"]+$imagedata["yMax"])/$ycount;
      $y=$charty;
      $yscaleval = $imagedata["yMin"];
      for ($i=0; $i<=$ycount;$i++) {
        ImageDashedLine($im, $chartx-2, $height-$y,$chartx+$chartw, $height-$y, $black); 
        if ($yscaleval==0) {
	  ImageLIne($im, $chartx-2, $height-$y,$chartx+$chartw, $height-$y, $black); 
        }
        if ($yscale) {
          if ($format) {
            $yscaleval = sprintf($imagedata["numberFormat"],$yscaleval);
          }
          ImageString($im, $font6, $scaleyx, $height-$y-$ifh6/2,$yscaleval,$black);
        }
        $yscaleval += $yscaleinc;
        $y += $yinc;
      }
    }
    
    $xval = $imagedata["xValues"];
    if ($xscale) {
      $font5 = 3;
      $ifh5 = ImageFontHeight($font5);
      $ifw5 = ImageFontWidth($font5);
    }  

    ImageLine($im, $chartx-2, $height-$charty,$chartx+$chartw, $height-$charty, $black); 
    ImageLine($im, $chartx, $height-$charty+2,$chartx, $height-$charty-$charth-2, $black); 

    $valuecount = $imagedata["valueCount"];
    if ($valuecount && ($xscale || $xval)) {
      $xdelta=$chartw/($valuecount*4);
      for ($i=0; $i<$valuecount;$i++) {
        $xoff= $chartx+($i*4+1)*$xdelta;
        $ymax = $height-$charty-$charth*$imagedata["value".$i]/$imagedata["yMax"];
        if ($xscale) {
          ImageString($im, $font4, $xoff+$xdelta-(strlen($imagedata["scale".$i])*$ifw4)/2,$height-$charty,$imagedata["scale".$i],$black); 
        }
        if ($xval) {
          ImageString($im, $font5, $xoff+$xdelta-(strlen($imagedata["value".$i])*$ifw5)/2,$ymax-$ifh5,$imagedata["value".$i],$black); 
        }
      }
    }
    
    $linecount = $imagedata["lineCount"];
    for ($j=0;$j<$linecount;$j++) {
      $valuecount = $imagedata["valueCount"];
      $xold=$yold=-1;
      if ($valuecount) {
        $xdelta=$chartw/($valuecount*2);
        for ($i=0; $i<$valuecount;$i++) {
          $xoff= $chartx+($i*2+$imagedata["lineOffset"])*$xdelta;
          $ymax = $height-$charty-$charth*($imagedata["value".$i."_".$j]-$imagedata["yMin"])/($imagedata["yMax"]-$imagedata["yMin"]);
          if ($xold!=-1) {
//          echo " $xold, $yold, $xoff, $ymax\n<br>";
            ImageLine($im, $xold, $yold, $xoff, $ymax,$colors[$j]);
          }
          if ($imagedata["bullets"]==1) {
            DrawBullet($im, $xoff, $ymax, $j, $colors[$j]);
          }
          if ($xscale) {
            ImageString($im, $font4, $xoff+5,$ymax-$ifh4,$imagedata["value".$i."_".$j],$colors[$j]); 
          }
          $xold=$xoff; $yold=$ymax;
  //      ImageFilledRectangle($im, $xoff, $ymax, $xoff+2*$xdelta, $height-$charty, $blue);
  
        }
      }
    }
    
    ImagePNG($im);
    ImageDestroy($im);
  }


  function MakeBarChart($imagedata) {
    $id = uniqid("");

    $width = $imagedata["width"];
    if (!$width) $width=1;
    $height = $imagedata["height"];
    if (!$height) $height=1;

    $chartx = 5;
    $charty = 5;
    $chartw = $width-10;
    $charth = $height-10;

    $scaleyx = 0;

    $im = imagecreate($width, $height);
    $black = ImageColorAllocate($im, 0,0,0);
    $white = ImageColorAllocate($im, 255,255,255);
    $blue = ImageColorAllocate($im, 0,0,255);
    ImageFill($im,0,0,$white);

    $caption = $imagedata["caption"];
    if ($caption) {
      $font1 = 5;
      $ifh1 = ImageFontHeight($font1);
      $ifw1 = ImageFontWidth($font1);
      
      $captionw = strlen($caption)*$ifw1;
      ImageString($im, $font1, ($width - $captionw)/2, 0, $caption, $black);
      ImageLine($im, ($width - $captionw)/2, $ifh1, ($width+$captionw)/2, $ifh1, $black);
      
      $charth -= $ifh1;
    }

    $xcaption = $imagedata["xCaption"];
    if ($xcaption) {
      $font2 = 4;
      $ifh2 = ImageFontHeight($font2);
      $ifw2 = ImageFontWidth($font2);
      
      $xcaptionw = strlen($xcaption)*$ifw2;
      ImageString($im, $font2, ($width - $xcaptionw)/2, $height-$ifh2, $xcaption, $black);
      
      $charty += $ifh2;
      $charth -= $ifh2;
    }
 
    $xscale = $imagedata["xScale"];
    if ($xscale) {
      $font4 = 3;
      $ifh4 = ImageFontHeight($font4);
      $ifw4 = ImageFontWidth($font4);
      
      $charty += $ifh4; 
      $charth -= $ifh4; 
    }  

    $ycaption = $imagedata["yCaption"];
    if ($ycaption) {
      $font3 = 4;
      $ifh3 = ImageFontHeight($font3);
      $ifw3 = ImageFontWidth($font3);
      
      $ycaptionh = strlen($ycaption)*$ifw3;
      ImageStringUp($im, $font3, $ifw3, ($height + $ycaptionh)/2, $ycaption, $black);
      
      $chartx += $ifh3+5;
      $chartw -= $ifh3+5;
      $scaleyx += $ifh3+7;
    }

    //  echo $chartw." ".$chartx." ".$chartw+$chartx."<br>";
   
    $yscale = $imagedata["yScale"];
    if ($yscale) {
      $font6 = 3;
      $ifh6 = ImageFontHeight($font6);
      $ifw6 = ImageFontWidth($font6);
      
      if ($imagedata["numberFormat"]) {
        $chartx += strlen(sprintf($imagedata["numberFormat"],$imagedata["yMax"]))*$ifw6; 
        $chartw -= strlen(sprintf($imagedata["numberFormat"],$imagedata["yMax"]))*$ifw6; 
      } else { 
        $chartx += strlen($imagedata["yMax"])*$ifw6; 
        $chartw -= strlen($imagedata["yMax"])*$ifw6; 
      }
    }  

    $ycount = $imagedata["yCount"];
    $format=$imagedata["numberFormat"];
    if ($ycount) {
      $yinc = $charth/$ycount;
      $yscaleinc = $imagedata["yMax"]/$ycount;
      $y=$charty;
      $yscaleval = 0;
      for ($i=0; $i<=$ycount;$i++) {
        ImageDashedLine($im, $chartx-2, $height-$y,$chartx+$chartw, $height-$y, $black); 
        if ($yscale) {
          if ($format) {
            $yscaleval = sprintf($imagedata["numberFormat"],$yscaleval);
          }
          ImageString($im, $font6, $scaleyx, $height-$y-$ifh6/2,$yscaleval,$black);
          $yscaleval += $yscaleinc;
        }
        $y += $yinc;
      }
    }
    
    $xval = $imagedata["xValues"];
    if ($xscale) {
      $font5 = 3;
      $ifh5 = ImageFontHeight($font5);
      $ifw5 = ImageFontWidth($font5);
    }  

    ImageLine($im, $chartx-2, $height-$charty,$chartx+$chartw, $height-$charty, $black); 
    ImageLine($im, $chartx, $height-$charty+2,$chartx, $height-$charty-$charth-2, $black); 

    $valuecount = $imagedata["valueCount"];
    if ($valuecount) {
      $xdelta=$chartw/($valuecount*4);
      for ($i=0; $i<$valuecount;$i++) {
        $xoff= $chartx+($i*4+1)*$xdelta;
        $ymax = $height-$charty-$charth*$imagedata["value".$i]/$imagedata["yMax"];
        ImageFilledRectangle($im, $xoff, $ymax, $xoff+2*$xdelta, $height-$charty, $blue);
        if ($xscale) {
          ImageString($im, $font4, $xoff+$xdelta-(strlen($imagedata["scale".$i])*$ifw4)/2,$height-$charty,$imagedata["scale".$i],$black); 
        }
        if ($xval) {
          ImageString($im, $font5, $xoff+$xdelta-(strlen($imagedata["value".$i])*$ifw5)/2,$ymax-$ifh5,$imagedata["value".$i],$black); 
        }
      }
    }
    ImagePNG($im);
    ImageDestroy($im);
  }
?>
