<?php
/******************************************************************************/
/*                                                                            */
/*                       __        ____                                       */
/*                 ___  / /  ___  / __/__  __ _____________ ___               */
/*                / _ \/ _ \/ _ \_\ \/ _ \/ // / __/ __/ -_|_-<               */
/*               / .__/_//_/ .__/___/\___/\_,_/_/  \__/\__/___/               */
/*              /_/       /_/                                                 */
/*                                                                            */
/*                                                                            */
/******************************************************************************/
/*                                                                            */
/* Titre          : (PHP5) Calculer le temps restant ou le temps ecoul       */
/*                                                                            */
/* URL            : http://www.phpsources.org/scripts457-PHP.htm              */
/* Auteur         : IlbeeNetwork                                              */
/* Date dition   : 09-09-2008                                                */
/* Website auteur : http://www.ilbee.net/                                     */
/*                                                                            */
/******************************************************************************/

function Date_ConvertSqlTab($date_sql) {
    $jour = substr($date_sql, 8, 2);
    $mois = substr($date_sql, 5, 2);
    $annee = substr($date_sql, 0, 4);
    $heure = substr($date_sql, 11, 2);
    $minute = substr($date_sql, 14, 2);
    $seconde = substr($date_sql, 17, 2);
    
    $key = array('annee', 'mois', 'jour', 'heure', 'minute', 'seconde');
    $value = array($annee, $mois, $jour, $heure, $minute, $seconde);
    
    $tab_retour = array_combine($key, $value);
    
    return $tab_retour;
}

function AuPluriel($chiffre) {
	if($chiffre>1) {
		return 's';
	};
}

function TimeToJourJ($date_sql) {
	$tab_date = Date_ConvertSqlTab($date_sql);
	$mkt_jourj = mktime($tab_date['heure'],
                    $tab_date['minute'],
                    $tab_date['seconde'],
                    $tab_date['mois'],
                    $tab_date['jour'],
                    $tab_date['annee']);

	$mkt_now = time();
	
	$diff = $mkt_jourj - $mkt_now;
	
	$unjour = 3600 * 24;
	
	if($diff>=$unjour) {
		// EN JOUR
		$calcul = $diff / $unjour;
		return 'Il reste <strong>'.ceil($calcul).' jour'.AuPluriel($calcul).'</strong>.';

	} elseif($diff<$unjour && $diff>=0 && $diff>=3600) {
		// EN HEURE
		$calcul = $diff / 3600;
		return 'Il reste <strong>'.ceil($calcul).' heure'.AuPluriel($calcul).'</strong>.';

	} elseif($diff<$unjour && $diff>=0 && $diff<3600) {
		// EN MINUTES
		$calcul = $diff / 60;
		return 'Il reste <strong>'.ceil($calcul).' minute'.AuPluriel($calcul).'</strong>.';

	} elseif($diff<0 && abs($diff)<3600) {
		// DEPUIS EN MINUTES
		$calcul = abs($diff) / 60;
		return 'Depuis <strong>'.ceil($calcul).' minute'.AuPluriel($calcul).'</strong>.';

	} elseif($diff<0 && abs($diff)<=3600) {
		// DEPUIS EN HEURES
		$calcul = abs($diff) / 3600;
		return 'Depuis <strong>'.ceil($calcul).' heure'.AuPluriel($calcul).'</strong>.';		

	} else {
		// DEPUIS EN JOUR
		$calcul = abs($diff) / $unjour;
		return 'Depuis <strong>'.ceil($calcul).' jour'.AuPluriel($calcul).'</strong>.';

	};
}

// EXEMPLE //
// Affiche le temps pass depuis le 28 juin 2008 a 14h //
// Le jour de mon mariage //
echo 'Temps depuis le 28 juin 2008  14 heures : ';
echo TimeToJourJ('2008-06-28 14:00:00');
echo '<br /><br />';

// EXEMPLE //
// Affiche le temps restant jusqu'au 01 janvier prochain //
$next_jourdelan = date('Y') + 1;
echo 'Temps restant jusqu\'au prochain jour de l\'an : ';
echo TimeToJourJ($next_jourdelan.'-01-01 00:00:00');
?>