class Gps {

    var $earth_radius = 6378137; // en mètres

    /**
     * Calcul de distance entre deux points selon distance spérique
     * @param float  $lat1  latitude du point origine
     * @param float  $lng1  longitude du point origine
     * @param float  $lat2  latitude du point destination
     * @param float  $lng2  longitude du point destination
     * @return int   distance en mètres séparant les coordonnées origine des coordonnées destination
     */
    public function distance($lat1, $lng1, $lat2, $lng2) {       
        $rlo1 = deg2rad($lng1);
        $rla1 = deg2rad($lat1);
        $rlo2 = deg2rad($lng2);
        $rla2 = deg2rad($lat2);
        $dlo = ($rlo2 - $rlo1) / 2;
        $dla = ($rla2 - $rla1) / 2;
        $a = (sin($dla) * sin($dla)) + cos($rla1) * cos($rla2) * (sin($dlo) * sin($dlo));
        $d = 2 * atan2(sqrt($a), sqrt(1 - $a));
        return round(($this->earth_radius * $d));
    }

}
