<?php
/******************************************************************************************************************************************************************************
****												DEVELOPPER PAR TOULISSE ERIC (2008)										      ***
*******************************************************************************************************************************************************************************
****												              VERSION 1.0 													      ***
/******************************************************************************************************************************************************************************
					  ***********************************************************************************************************************
					  **  --------------------------------------------------------------------------------------------------------------------------------          **
					  **  --------------------------------------------CLASS  OBJETS XHREF (GESTION GLOBALE)------------------------------        **
					  **  --------------------------------------------------------------------------------------------------------------------------------          **
					  ***********************************************************************************************************************
  *****************************************************************************************************************************************************************************/ 	 
  Class Objets_Xhref Extends Objets_PDF{
	private $ListeObjets=array();
	private $ListeToutesPositionObjet=array();
	private $NumObjetMax=0;
/*--------------------------------------------------------------------------------------------------------------------------------
  ----------------------------------------------CONSTRUCTUER---------------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
	public function __construct($Contenu){
		parent::__construct($Contenu);
	}
	
	
/*--------------------------------------------------------------------------------------------------------------------------------
  ----------------------------------------------POSITION DE L'OBJET------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 	
	public function Obtenir_Position_objet($Num,&$debut,&$fin){

		if ($Num<=$this->NumObjetMax){
			$debut=$this->ListeObjets[$Num][0];
			$fin=$this->Fichier_PDF->Obtenir_Taille();		
			for($i=0;$i<sizeof($this->ListeToutesPositionObjet);$i++){
				$pos=$this->ListeToutesPositionObjet[$i];
				
				if (intval($pos)>intval($debut)){
					if(intval($pos)<intval($fin)){
						$fin=$pos;
					}
				}
			}
			
		}else{
			$this-> _Remonter_Erreur(6,"L'objet n'existe pas : $Num ! ");
		}
		
	}
/*--------------------------------------------------------------------------------------------------------------------------------
  ----------------------------------------------VERSION DE L'OBJET------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 	
	public function Obtenir_Version_objet($Num){
		return $this->ListeObjets[$Num][1];
	}
/*--------------------------------------------------------------------------------------------------------------------------------
  ----------------------------------------------OBJET EXISTE------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
  public function Objet_Existe($Num){
	if(isset($this->ListeObjets[$Num][1])){
		$res=true;
	}else{
		$res=false;
	}
	return $res;
  }
 /*--------------------------------------------------------------------------------------------------------------------------------
  ----------------------------------------------NOMBRE D'OBJET------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
  public function Nombre_Objets(){
	return sizeof($this->ListeObjets);
  }
/*--------------------------------------------------------------------------------------------------------------------------------
  ----------------------------------------------LISTE LES OFFSET------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 		
	public function ListeOffset(){
		
		
		//On prend le retour a la ligne
		$RetourLigne="";
		$ListeDetections=array();
		$ListeDetections[0]="xref";
		$ListeDetections[1]="xhref";
		$i=0;
		$Detection=$ListeDetections[$i];
		while((strpos($this->ContenuObjet,$Detection)===false) && $i<sizeof($ListeDetections)){
			$i++;
			$Detection=$ListeDetections[$i];				
		}
		
		$pos=strlen($Detection);
		$Lettre=strtolower(substr($this->ContenuObjet,$pos,1));

		while (strpos("abcdefghijklmnopqrstuvwxyz0123456789",$Lettre)===false){
			$RetourLigne.=$Lettre;
			
			$pos++;
			$Lettre=strtolower(substr($this->ContenuObjet,$pos,1));
		}
		//On calcul la liste des lignes
		$pos=strpos($this->ContenuObjet,$RetourLigne,$pos)+strlen($RetourLigne);
		
		$ListeRef=substr($this->ContenuObjet,$pos,strlen($this->ContenuObjet)-$pos);
		
		$pos=0;
		
		while(!(strpos($ListeRef,$RetourLigne,$pos)===false)){
			
			$pos2=strpos($ListeRef,$RetourLigne,$pos);
		
			//ON ENLEVE LE RETOUR A LA LIGNE DU DEPART
			$Ajout=0;		
			while(substr($ListeRef,$pos+$Ajout,1)==chr(10) ||substr($ListeRef,$pos+$Ajout,1)==chr(13)){
				$Ajout++;
			}
			//ON PREND LA LIGNE
			$Offset=substr($ListeRef,$pos+$Ajout,$pos2-$pos-$Ajout);
			
			//ON RETIRE LA LIGNE DE RETOUR			
			while(substr($Offset,strlen($Offset),1)==chr(10) || substr($Offset,strlen($Offset),1)==chr(13)){
				$Offset=substr($Offset,0,strlen($Offset)-2);
			}
			
			//SI LA LIGNE INDIQUE UNE POSITION D UN OBJET
			if(strtolower(substr(trim($Offset),strlen(trim($Offset))-1,1))=="n"){	
					
				//ON TROUVE LA POSITION DE L'OBJET
					$Position_Objet=intval(substr($Offset,0,strpos($Offset," ")));
					
				//ON TROUVE LA VERSION DE L'OBJET
					$Position_Espace=strpos($Offset," ");
					while(! is_numeric(substr($Offset,$Position_Espace,1))){
						$Position_Espace++;
					}
					$Version_objet="";
					while(is_numeric(substr($Offset,$Position_Espace,1))){
						$Version_objet.=substr($Offset,$Position_Espace,1);
						$Position_Espace++;
					}
				//ON TROUVE L'OBJET DECRIS
				$NumObjet=intval($this->Fichier_PDF->Obtenir_Objet_A_Position($Position_Objet));
				
				if($this->NumObjetMax<$NumObjet){
					$this->NumObjetMax=$NumObjet;
				}
				
				//ON MEMORISE LES DONNERS DANS UN TABLEAU ASSOCIATIF
					$this->ListeObjets[$NumObjet]= array();
					$this->ListeObjets[$NumObjet][0]=$Position_Objet;				
					$this->ListeToutesPositionObjet[sizeof($this->ListeToutesPositionObjet)]=$Position_Objet;
					$this->ListeObjets[$NumObjet][1]=intval($Version_objet);
			}else{
				
			}
			$pos=$pos2+1;
		}
		
	}
	
	
	
  }
  
  
?>