<?php
/******************************************************************************************************************************************************************************
****												DEVELOPPER PAR TOULISSE ERIC (2008)										      ***
*******************************************************************************************************************************************************************************
****												              VERSION 1.0 													      ***
/******************************************************************************************************************************************************************************
					  ***********************************************************************************************************************
					  **  --------------------------------------------------------------------------------------------------------------------------------          **
					  **  --------------------------------------------CLASS DES OBJETS PDF (GESTION GLOBALE)------------------------------        **
					  **  --------------------------------------------------------------------------------------------------------------------------------          **
					  ***********************************************************************************************************************
  *****************************************************************************************************************************************************************************/ 
  
Class Objets_PDF{

	protected $Numero;
	protected $ContenuObjet;
	protected $TypeObjet;
	protected $OffsetObjet;
	protected $Fichier_PDF;
/*--------------------------------------------------------------------------------------------------------------------------------
  --------------------------------------------AFFICHE UNE ERREUR--------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
	protected function _Remonter_Erreur($Numero,$Erreur){
		echo "<br><u>Erreur n".$Numero."</u><br><b>".$Erreur."</b><br>";
		exit();
	}
/*--------------------------------------------------------------------------------------------------------------------------------
  --------------------------------------------CONSTRUCTUER ET DESTRUCTEUR--------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
 public function __construct($Contenu){
	$this->ContenuObjet=$Contenu;
	$this->AnalyseContenu();
 }
 public function __destruct(){
	$this->ContenuObjet="";
 }
 
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------ASSECEUR NUMERO----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
  public Function Set_Numero($val){
	$this->Numero=$val;
  }
  public Function Get_Numero(){
	return $this->Numero;
  }
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------ASSECEUR FICHIER----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
  public Function Set_Fichier_Pdf($val){
	$this->Fichier_PDF=$val;
  }
  public Function Get_Fichier_Pdf(){
	return $this->Fichier_PDF;
  }

/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------ASSECEUR CONTENU----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
  public Function Set_Contenu($val){
	$this->ContenuObjet=$val;
  }
  public Function Get_Contenu(){
	return $this->ContenuObjet;
  }

 /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------ASSECEUR TYPE-----------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
   public Function Set_Type($val){
		$this->TypeObjet=$val;
	}
	  public Function Get_Type(){
		return $this->TypeObjet;
	  }
  
  /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------ASSECEUR OFFSET----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
  public Function Set_Offset($val){
	$this->OffsetObjet=$val;
  }
  public Function Get_Offset(){
	return $this->OffsetObjet;
  }
  
  /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------OBTENIR UNE INFORMATION SUR L'OBJET----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
   public function Obtenir_Information_Simple($Balise){

	
	$Valeur="";
	if(!(strpos($this->ContenuObjet, $Balise)===false)){
		//POSITION DE LA BALISE
		$pos=strpos($this->ContenuObjet, $Balise);
		//PARCOUR D'ARRET
		$lettre="";
		$pos+=strlen($Balise);
		$lettre=substr($this->ContenuObjet,$pos,1);
		while($pos<strlen($this->ContenuObjet) && $lettre!=chr(10) && $lettre!=chr(13) && $lettre!="/"){			
			
			$Valeur.=$lettre;
			$pos++;
			$lettre=substr($this->ContenuObjet,$pos,1);
			
		}
		
	}
	return trim($Valeur);
  }
  
 /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------OBTENIR UNE INFORMATION COMPLEXE SUR L'OBJET-----------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
   public function Obtenir_Information_Complexe($Balise,$Ouverture="<<",$Fermeture=">>"){

	
	$Valeur="";
	if(!(strpos($this->ContenuObjet, $Balise)===false)){
		//POSITION DE LA BALISE
		$pos=strpos($this->ContenuObjet, $Balise);
		//PARCOUR D'ARRET
		$lettre="";
		$pos+=strlen($Balise);
		if(!(strpos($this->ContenuObjet, $Ouverture,$pos)===false)){
			$pos=strpos($this->ContenuObjet, $Ouverture,$pos);
			$pos+=strlen($Ouverture);
			$Nb=1;
			$lettre=substr($this->ContenuObjet,$pos,1);
			$TestFin=substr($this->ContenuObjet,$pos,strlen($Fermeture));
			$TestDebut=substr($this->ContenuObjet,$pos,strlen($Ouverture));
			while($pos+strlen($Fermeture)<strlen($this->ContenuObjet) && $Nb!=0){			
				
				//Autre ouverture
				if($TestDebut==$Ouverture){
					$Nb++;
				}
				if($TestFin==$Fermeture){
					$Nb--;
				}
				if($Nb!=0){
					$Valeur.=$lettre;
				}
				$pos++;
				$lettre=substr($this->ContenuObjet,$pos,1);
				$TestFin=substr($this->ContenuObjet,$pos,strlen($Fermeture));
				$TestDebut=substr($this->ContenuObjet,$pos,strlen($Ouverture));				
			}
		}
		
	}
	return trim($Valeur);
  }
  /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------GESTION DES CHAINES---------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
  protected function _ReFormater_Chaine($s){
	//Format a text string
	$s=substr($s,strpos($s,"(",0)+1,strlen($s)-strpos($s,"(",0)-1);
	
	$LastPos=0;
	while(!(strpos($s,")",$LastPos)===false)){
		$LastPos=strpos($s,")",$LastPos)+1;
	}

	$s=substr($s,0,$LastPos-1);
	$s=str_replace('%u2019',"'",$s);
$s=str_replace('%u20AC',"",$s);
	$s=str_replace('\\)',')',$s);
	$s=str_replace('\\(','(',$s);
	$s=str_replace('\\\\','\\',$s);
	return $s;
	
  }
   /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------FONCTIONS PRIVEES---------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
  private function AnalyseContenu(){
	$this->TypeObjet="Inconnu";
	$Detection="/Type";
	if(!(strpos($this->ContenuObjet,$Detection)===false)){
		
		$pos=strpos($this->ContenuObjet,$Detection);
		$pos+=strlen($Detection);
		//ON CHERCHE LE / QUI DETERMINE LE TYPE
		while(substr($this->ContenuObjet,$pos,1)!="/"){
			$pos++;
		}
		
		$pos++;
		$Lettre=substr($this->ContenuObjet,$pos,1);
		$this->TypeObjet="";
		
		while(!((strpos("abcdefghijklmnopqrstuvwxyz",strtolower($Lettre)))===false)){
			
			$this->TypeObjet.=$Lettre;
			$pos++;
			$Lettre=substr($this->ContenuObjet,$pos,1);
		}
	}
  }
  
  
}

//INCLUSION DES CLASSES FILS
include("Class_Objet_Trailer.php");
include("Class_Objet_Xhref.php");
include("Class_Objet_Infos.php");
?>