<?php
//NOTE LEXTRACTION COMMENCE PAGE 1
include_once("GestionPDF/Class_Fichier_Pdf.php");
include_once("Class_pdf_writer.php");


Class PDF_Generateur{
	
	private $Source;
	private	$Cible;
	private $DocumentEnCours;
	private $NumObjetListePages;
	private $NumObjetPage;
	private $Version;
	private $ListeConvertion=array();

/*--------------------------------------------------------------------------------------------------------------------------------
  --------------------------------------------AFFICHE UNE ERREUR--------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
	public function _Remonter_Erreur($Erreur,$Numero){
		echo "<br><u>Erreur n".$Numero."</u><br><b>".$Erreur."</b><br>";
		exit();
	}
	
/*--------------------------------------------------------------------------------------------------------------------------------
  --------------------------------------------CONSTRUCTUER ET DESTRUCTEUR--------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
	 public function __construct($DocumentSource,$FichierCible){
	 
		if (file_exists($FichierCible)){
			unlink($FichierCible);
		}
		$this->Cible= new PDF_writer($FichierCible);
		$this->Source=$FichierSource;
		
		$this->DocumentEnCours=$DocumentSource;

		
		$this->Cible->Set_Version($this->DocumentEnCours->Obtenir_Version());
	 }
	 
	 public function __destruct(){
		
		$this->Cible->__destruct();
	 }
 
 
 /*
  -------------------------------------------------------------------------------------------------------------------------------------
  --------------------------------------------EXTRAIRE UNE PAGE DU FICHIER SOURCE--------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------------
  */   
  public function Extraire_page($Num,$Auteur,$Titre,$Sujet,$MotsCle){
		//-------------------------------------------------------------CATALOGUE------------------------------------------
		$this->GenereCatalogue();
	//-------------------------------------------------------------LISTE DES PAGES------------------------------------------
		//ON RESERVE LA PLACE POUR LA PAGE
		$this->NumObjetPage=$this->Cible->Add_Objet();
			
		
		//ON GENERE LA LISTE DES PAGES
		$this->GenereListePages();
		
	//-------------------------------------------------------------PAGE------------------------------------------
		//ON PREND LA LISTE DES PAGES
		$ListePages=$this->DocumentEnCours->Obtenir_liste_pages();
		
		//GENERATION DE LA PAGE	
		if (sizeof($ListePages)>=($Num)){	
			$this->GenerePage($ListePages[$Num-1]);
		}else{
			$this->_Remonter_Erreur("Page Inexistante",1);
		}
		//GARBAGE COLLECTOR
		unset($ListePages);

	//-------------------------------------------------------------INFOS------------------------------------------
	$this->GenereINFO($Auteur,$Titre,$Sujet,$MotsCle);
	

	//-------------------------------------------------------------REFERENCE CROISE------------------------------------------
	
	
	//-------------------------------------------------------------ECRITURE DU PDF FINAL------------------------------------------
	$this->Cible->Ecrire_Pdf();

  }
  /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------GENERE LE CATALOGUE------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/
  private function GenereCatalogue(){
	
	//CREATION
	$Numero=$this->Cible->Add_Objet();
	//ON RESERVE LA PLACE POUR LA LISTE DES PAGES
	$this->NumObjetListePages=$this->Cible->Add_Objet();
	//GENERATION
	$code="<<".RetourLigne;	
	$code.='/Type /Catalog '.RetourLigne;
	$code.='/Pages '.$this->NumObjetListePages.' 0 R'.RetourLigne;
	$code.=">>".RetourLigne;
	$this->Cible->Set_Objet_Content($Numero,$code);
	$this->Cible->Set_Object_Root($Numero);
  }
  /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------GENERE LES INFORMATIONS------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/
  private function GenereINFO($Auteur,$Titre,$Sujet,$MotsCle){
	//GENERATION
	$code="<<".RetourLigne;
	$code.='/Producer '.$this->_FormatChaine('FPDF '.$this->Cible->Get_Version()).RetourLigne;
	if(!empty($Titre))
		$code.='/Title '.$this->_FormatChaine($Titre).RetourLigne;
	if(!empty($Sujet))
		$code.='/Subject '.$this->_FormatChaine($Sujet).RetourLigne;
	if(!empty($Auteur))
		$code.='/Author '.$this->_FormatChaine($Auteur).RetourLigne;
	if(!empty($MotsCle))
		$code.='/Keywords '.$this->_FormatChaine($MotsCle).RetourLigne;
				/*if(!empty($this->creator))
					$code.='/Creator '.$this->_FormatChaine($this->creator);*/
	$code.='/CreationDate '.$this->_FormatChaine('D:'.date('YmdHis')).RetourLigne;
	$code.=">>".RetourLigne;
	//CREATION
	$Numero=$this->Cible->Add_Objet();
	$this->Cible->Set_Objet_Content($Numero,$code);
	$this->Cible->Set_Object_Info($Numero);
  }
  /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------GENERE LA LISTE DES PAGES------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/
  private function GenereListePages(){
	//GENERATION
	$code="<<".RetourLigne;
	//$code="/Type /Pages ".RetourLigne;
	$code.="/Kids [ ".$this->NumObjetPage." 0 R ]".RetourLigne;
	$code.="/Type /Pages ".RetourLigne;
	$code.="/Count 1 ".RetourLigne;
	$code.=">>".RetourLigne;
	//CREATION
	$this->Cible->Set_Objet_Content($this->NumObjetListePages,$code);
	
  }
  
   /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------GENERE LA PAGE GRACE AU NUMERO OBJET SOURCE------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/
  private function GenerePage($Source){
	//GENERATION
	$code=$this->DocumentEnCours->Obtenir_Contenu_Objet($Source);
	//----------REMPLACEMENT
		//------LE PARENT
		$parent=$this->DocumentEnCours->Obtenir_Parent_De_Objet($Source);
		$Chaine_A_Remplacer="/Parent ".$parent." ".$this->DocumentEnCours->Obtenir_Version_Objet($parent)." R";
		$code=str_replace($Chaine_A_Remplacer,"/Parent ".$this->NumObjetListePages." 0 R",$code);
		$this->ListeConvertion[$parent]=$this->NumObjetListePages;
				
		//------LE CONTENU
		$bin=$this->DocumentEnCours->Obtenir_Objet_Content_De_Objet($Source);
		
		$i=0;
		$pos=strpos($code,"/Contents");
		while($i<sizeof($bin)){
			
			if(! isset($this->ListeConvertion[$bin[$i]])){
				$num=$this->Cible->Add_Objet();
				$Code_Objet=$this->DocumentEnCours->Obtenir_Contenu_Objet($bin[$i]);		
				$this->Rajoute_Objets_Necessaires($Code_Objet);			
				$this->Cible->Set_Objet_Content($num,$Code_Objet);		
				$this->ListeConvertion[$bin[$i]]=$num;
			}else{
				$num=$this->ListeConvertion[$bin[$i]];
			}
			//ON remplace
			$Recherche=$bin[$i]." ".$this->DocumentEnCours->Obtenir_Version_Objet($bin[$i])." R";
			$Remplace=$num." 0 R";
			
			$pos=strpos($code,$Recherche,$pos);
			if($pos===false){
				//ERREUR CRITIQUE				
			}else{
				while(is_numeric(substr($code,$pos-1,1)) && $pos!==false){
					$pos=strpos($code,$Recherche,$pos+1);
				}
				if ($pos!==false){
					$temp=substr($code,0,$pos).$Remplace.substr($code,$pos+strlen($Recherche),strlen($code)-($pos+strlen($Recherche)));
					$code=$temp;
				}else{
					//ERREUR CRITIQUE
				}
			}
			
			$pos++;
			
			$i++;
			
		}

		//----------LES RESSOURCES
		$bin=$this->DocumentEnCours->Obtenir_Objets_Ressources_De_Objet($Source);

		$i=0;
		$pos=strpos($code,"/Resources");
		while($i<sizeof($bin)){
			
			if(! isset($this->ListeConvertion[$bin[$i]])){
				$num=$this->Cible->Add_Objet();
				$Code_Objet=$this->DocumentEnCours->Obtenir_Contenu_Objet($bin[$i]);		
				$this->Rajoute_Objets_Necessaires($Code_Objet);			
				$this->Cible->Set_Objet_Content($num,$Code_Objet);		
				$this->ListeConvertion[$bin[$i]]=$num;
			}else{
				$num=$this->ListeConvertion[$bin[$i]];
			}
			//ON remplace
			$Recherche=$bin[$i]." ".$this->DocumentEnCours->Obtenir_Version_Objet($bin[$i])." R";
			$Remplace=$num." 0 R";
			$pos=strpos($code,$Recherche,$pos);
			if($pos===false){
				//ERREUR CRITIQUE
			}else{
				$temp=substr($code,0,$pos).$Remplace.substr($code,$pos+strlen($Recherche),strlen($code)-($pos+strlen($Recherche)));
				$code=$temp;
			}
			
			$pos++;
			
			$i++;
			
		}
		
			
	//AFFECTATION
	$this->Cible->Set_Objet_Content($this->NumObjetPage,$code);
  }
   /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------MET AU POINT UN OBJET------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/
   private function Rajoute_Objets_Necessaires(&$Code){
			//EXTRACTION DES OBJETS
				$Max=$this->DocumentEnCours->Obtenir_Max_Version_Objet();
				for($i=0;$i<=$Max;$i++){
					$Detection=" $i R";
					$pos=0;
					while(!(strpos($Code, $Detection, $pos)===false)){
						//on prend la valeurde l'objet
						$Position_debut=strpos($Code, $Detection, $pos);
						$pos=$Position_debut+strlen($Detection);
						$Position_debut--;
						$num="";
						while(!(strpos("0123456789",substr($Code,$Position_debut,1))===false) && $Position_debut>0){
							$num=substr($Code,$Position_debut,1).$num;
							$Position_debut--;
						}					
						$Numero=$this->Rajoute_Objet_From_Source($num);					
						$Code=str_replace($num." $i R",$Numero." 0 R",$Code );
						
					}
				}
				
   }
   
     /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------RAJOUTE l'oBJET de LA SOURCE------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/
   private function Rajoute_Objet_From_Source($ObjetSource){	
	
			if(! isset($this->ListeConvertion[$ObjetSource])){
				$Numero=$this->Cible->Add_Objet();
				$contenu=$this->DocumentEnCours->Obtenir_Contenu_Objet($ObjetSource);
				$this->Rajoute_Objets_Necessaires($contenu);
				$this->Cible->Set_Objet_Content($Numero,$contenu);		
				$this->ListeConvertion[$ObjetSource]=$Numero;
			}
			return $this->ListeConvertion[$ObjetSource];
   }
   

  /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------------RAJOUTE UNE CHAINE------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/
 private function _FormatChaine($s){
	//Format a text string
	return '('.str_replace(')','\\)',str_replace('(','\\(',str_replace('\\','\\\\',$s))).')';
}
 
}

?>