<?php
define("RetourLigne","\n");

Class PDF_writer{

	private $PDFVersion="1.4";
	private $FichierCible;
	private $NumObjet=1;
	private $Contenu;
	private $ListeObjet=Array();
	
	private $NumObjetRoot=1;
	private $NumObjetInfo=1;
	/*--------------------------------------------------------------------------------------------------------------------------------
  --------------------------------------------CONSTRUCTUER ET DESTRUCTEUR--------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
 public function __construct($FichierCible){
	$this->FichierCible=$FichierCible;
 }
 public function __destruct(){}

	/*--------------------------------------------------------------------------------------------------------------------------------
  --------------------------------------------VERSION--------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
  public function Get_Version(){
	return $this->PDFVersion;
  }
	/*--------------------------------------------------------------------------------------------------------------------------------
  --------------------------------------------GESTION DES OBJETS--------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
public function Add_Objet(){
	$this->ListeObjet[$this->NumObjet]="";
	$this->NumObjet++;
	return ($this->NumObjet-1);
}

public function Set_Objet_Content($num,$contenu){
	$this->ListeObjet[$num]=$contenu;
}
public function Get_Objet_Content($num){
	return $this->ListeObjet[$num];
}
public function Set_Object_Root($num){
	$this->NumObjetRoot=$num;
}
public function Set_Object_Info($num){
	$this->NumObjetInfo=$num;
}
	/*--------------------------------------------------------------------------------------------------------------------------------
  --------------------------------------------ECRITURE--------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
  public function Ecrire_Pdf(){
	$f=fopen($this->FichierCible,'wb');
	if(!$f){
		$this->Error('Impossible de crer le fichier : '.$this->Cible);
	}
	$this->GenereContenu();
	fwrite($f,$this->Contenu);
	fclose($f);
  }
  
  	/*--------------------------------------------------------------------------------------------------------------------------------
  --------------------------------------------GENERE LE CONTENU--------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
  private function GenereContenu(){
	$this->Contenu='';
	$PositionObjet=Array();
	//GENERATION DES OBJETS
	$this->AjouteContenu('%PDF-'.$this->PDFVersion);
	$this->AjouteContenu('%');
	for($i=1;$i<$this->NumObjet;$i++){
		$PositionObjet[$i]=strlen($this->Contenu);
		$this->AjouteContenu($i." 0 obj");
		$this->AjouteContenu($this->ListeObjet[$i]);
		$this->AjouteContenu("endobj");
	}
	//-------------REFERENCES CROISE---------------------------
		$PositionXhref=strlen($this->Contenu);
		$this->AjouteContenu("xref");
		$this->AjouteContenu('0 '.$this->NumObjet);
		$this->AjouteContenu('0000000000 65535 f ');
		for($i=1;$i<$this->NumObjet;$i++){
			$this->AjouteContenu(sprintf('%010d 00000 n ',$PositionObjet[$i]));
		}
	//-----------TRAILER------------
		$this->AjouteContenu("trailer");
		$this->AjouteContenu("<<");
		$this->AjouteContenu("/Size ".$this->NumObjet);
		$this->AjouteContenu("/Root ".$this->NumObjetRoot." 0 R");
		$this->AjouteContenu("/Info ".$this->NumObjetInfo." 0 R");
		$this->AjouteContenu(">>");
		$this->AjouteContenu('startxref');
		$this->AjouteContenu($PositionXhref);
	//FINALISATION
	$this->AjouteContenu("%%EOF");
  }
  
  	/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------AJOUTE AU CONTENU--------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
  private function AjouteContenu($Contenu){
	if (substr($Contenu,(-1)*strlen(RetourLigne))!=RetourLigne){
		$Contenu.=RetourLigne;
	}
	$this->Contenu.=$Contenu;
  }
 	/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------CHANGEMENT DE VERSION--------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
  public function Set_Version($Ver){
	$this->PDFVersion=$Ver;
  }
}
?>