<?php
    namespace DataBase;
    include_once("DataBase.php");

	class FileBase extends DataBase{

        private $basePath = "";
        private $delimiter = "";

		public function __construct($location = "./", $delimiter = ";"){
			$this->basePath = $location;
            $this->delimiter = $delimiter;
            if(is_dir($location) and !file_exists($location)){
                mkdir($location, 0755);
            }
		}

		public function createTable($name = "BDO_", $header){
            if(!file_exists($this->basePath."".$name)){
                $f = fopen($this->basePath."".$name, "w+");
                fwrite($f, implode($this->delimiter, $header)."\n");
                fclose($f);
                return true;
            }
            return false;
		}

        private function get_values_for_keys($mapping, $keys) {
            $output = array();
            foreach($keys as $index=>$key) {
                if(array_key_exists($key, $mapping)){
                    $output[$key] = $mapping[$key];
                }
            }
            return $output;
        }

        //because the original function return a boolean
        private function array_combine_($keys, $values) { 
            $combinedArray = array(); 
            for($i=0, $keyCount = count($keys); $i < $keyCount; $i++) { 
                 $combinedArray[$keys[$i]] = $values[$i]; 
            }
            return $combinedArray; 
        }

        private function array_uintersect_uassoc_($a, $call_keys){//pour tableaux 1D
            $res = array();
            foreach($call_keys as $key=>$value){//parcours le tableau
                if(array_key_exists($key, $a)){//si la cl existe dans l'autre on compare
                    $continue = true;
                    if(!is_array($call_keys[$key])){
                        $continue = ($a[$key] === $call_keys[$key]);
                    }else if(array_key_exists("name", $call_keys[$key]) and array_key_exists("args", $call_keys[$key])){
                        array_unshift($call_keys[$key]["args"], $a[$key]);
                        $continue = call_user_func_array($call_keys[$key]["name"], $call_keys[$key]["args"]);//apply function for the value and return a boolean
                        array_shift($call_keys[$key]["args"]);
                    }else{
                        $continue = false;
                    }
                    if(!$continue) return array();
                    else array_push($res, $key);
                }
            }
            return $res;
        }

		protected function send($query){
            if(isset($this->query["insert"])){
			    $title = $this->query["insert"];
                $values = $this->query["values"];
                $c = array_combine($title, $values);

                //get titles of the file
                $handle = fopen($this->basePath."".$this->base, "r");
                $contents = fread($handle, filesize($this->basePath."".$this->base));
                fclose($handle);

                $contents = current(explode("\n", $contents));
                $titles = explode($this->delimiter, $contents);
                //for each title check if in title array and add value if it's
                $titles = array_flip($titles);
                foreach($titles as $key => $value){
                    if(array_key_exists($key, $c)){
                        $titles[$key] = $c[$key];
                    }else{
                        $titles[$key] = "";
                    }
                }
                $f = fopen($this->basePath."".$this->base, "a");
                fwrite($f, implode($this->delimiter, $titles)."\n");
                fclose($f);
                return true;
            }else if(isset($this->query["select"])){
                $title = $this->query["select"];

                //read whole file
                $handle = fopen($this->basePath."".$this->query["from"], "r");
                $lines = fread($handle, filesize($this->basePath."".$this->query["from"]));
                fclose($handle);

                $lines = explode("\n", $lines);
                //remove last element in order to avoid a null line
                array_pop($lines);

                $res = array();
                $titles = array();
                $count = 0;
                foreach($lines as $key=>$line){
                    if($count == 0){
                        $titles = (explode($this->delimiter, $line));
                    }else{
                        $values = explode($this->delimiter, $line);
                        $c = $this->array_combine_($titles, $values);
                        if(isset($this->query["where"])){
                            $y = $this->array_uintersect_uassoc_($c, $this->query["where"]);
                            if(count($y)>0){
                                $intersect = $this->get_values_for_keys($c, $title);
                                if(count($intersect)>0){
                                    array_push($res, $intersect);
                                }
                            }
                        }else{
                            $intersect = $this->get_values_for_keys($c, $title);
                            if(count($intersect)>0){
                                array_push($res, $intersect);
                            }
                        }
                    }
                    $count++;
                }

                return $res;
            }

		}

        public function where($part){
            $this->query["where"] = $part;
            $this->query["where op"] = $part;
            return $this;
		}

        public static function between($v, $a, $b){
            if(is_string($a) and is_string($b) and is_string($v)){
                 return ((bool)(strcasecmp($v,$a)>=0 and strcasecmp($v,$b)<=0));
            }else{
                return ((bool)($v >= $a and $v <= $b));
            }
        }

		public function close(){
		}
	}
?>