<?php 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * 
 * Calendrier - floptwo :
 *   Il s'agit d'un script qui ralise un calendrier
 *    partir de la date du jour.
 *   Il est quiper de deux boutons de navigation pour 
 *   passer au mois suivant ou mois prcedent en tenant
 *   compte du changement d'anne.
 *   La date du jour et le mois en cours sont accentus.
 *   Il permet aussi d'accentuer une liste de dates
 *   contenues dans un tableau.
 *
 *   Script ralispar floptwo (floptwo@gmail.com)
 * * * * * * * * * * * * * * * * * * * * * * * * * * */

/* Je ne dcrirais pas la partie CSS car ce n'est pas
 * fondamental pour le script.
 
 * Les deux variables suivante indiques la date 
 *  partir de laquelle nous ferons le calendrier.
 * 
 * Si les variables mois et annee ne sont pas passes
 * par l'url on prend la date du jour (mois et anne)*/ 
if (!isset($_GET['mois']) && !isset($_GET['annee']))
{
	$calendrier_date_mois = date('n');
	$calendrier_date_annee = date('Y');
}
else
{
	$calendrier_date_mois = $_GET['mois'];
	$calendrier_date_annee = $_GET['annee'];
}

/* Ici on calcul le passage  l'anne prcdente. */
if ($calendrier_date_mois == '1')
{
	$calendrier_date_mois_precedent = '12';
	$calendrier_date_annee_precedente = $calendrier_date_annee - 1;
}
else 
{
	$calendrier_date_mois_precedent = $calendrier_date_mois - 1;
	$calendrier_date_annee_precedente = $calendrier_date_annee;
}

/* Et ici on calcul le passage  l'anne suivante. */
if ($calendrier_date_mois == '12')
{
	$calendrier_date_mois_suivant  = '1';
	$calendrier_date_annee_suivante  = $calendrier_date_annee + 1;
}
else 
{
	$calendrier_date_mois_suivant  = $calendrier_date_mois + 1;
	$calendrier_date_annee_suivante = $calendrier_date_annee;
}

/* Ici on declare la date du jour.
 * Elle permettera de mettre la date en valeur du jour. 
 * On l'crit jour_mois_annee pour ne la confondre avec aucune 
 * autre date*/
$calendrier_dateDuJour = date('j_n_Y'); 

/* Ici on dclare un tableau avec toutes les dates
 * importantes et que l'on souhaite accentuer.
 * Elles scrivent jours_mois_annee. */
$calendrier_dates_importantes = array(	'1_6_2006', 
										'5_6_2006', 
								       '15_8_2006',
									   '14_7_2006',
									   '20_7_2006',
									    '1_1_2007');

/* le mktime retourne les info d'une date donne */
$calendrier_mktime = mktime(0, 0, 0, $calendrier_date_mois, 1, $calendrier_date_annee);

/* $calendrier_date_mois_1erjour :  
 * 1er jour du moi, c'est  dire s'il s'agit d'un
 * lundi ou d'un mardi... 
 * Quand date retourne 0 c'est lundi, 1 c'est mardi...
 * jusqu'a 6 pour dimanche*/
$calendrier_date_mois_1erjour = date('w', $calendrier_mktime);

/* $calendrier_date_mois_nombrejour :
 * nombre de jours dans le mois. */
$calendrier_date_mois_nombrejour = date('t', $calendrier_mktime);

/* $calendrier_mois :
 * Tableau me permettant d'attribuer un nom en franais 
 *  chaque mois.
 * Il n'est pas ncessaire si les mois doivent tre en englais.
 * Il suffit de date('F', $calendrier_mktime); */
$calendrier_mois = array( '1' => 'Janvier',   '2' => 'Fvrier',   '3' => 'Mars', 
						  '4' => 'Avril',     '5' => 'Mai',       '6' => 'Juin',
						  '7' => 'Juillet',   '8' => 'Aot',      '9' => 'Septembre', 
					     '10' => 'Octobre',  '11' => 'Novembre', '12' => 'Dcembre');
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<STYLE type="text/css">	
	@IMPORT URL(css.css);	
</STYLE>

<title>Calendrier - floptwo</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
</head>

<body>
<?php 
/* On commence le tableau HTML.
 * Dans la premiere ligne on affiche le nom du
 * mois et l'anne. 
 *
 * Si le mois affich est le mois en cours on
 * utilisera le style : calendrier_mois_encours 
 * (voir CSS), sinon on utilise le style normal : 
 * calendrier_mois. */
if ($calendrier_date_mois.'_'.$calendrier_date_annee == date('n_Y'))
{
	$class_mois = 'calendrier_mois_encours';
}
else
{
	$class_mois = 'calendrier_mois';
}
?>
<table width="200" border="0" align="center" cellpadding="1" cellspacing="1">
  <tr align="center" valign="middle">
    <td><?php echo '<a href="?mois=' , $calendrier_date_mois_precedent , '&annee=' , $calendrier_date_annee_precedente , '" class="calendrier_mois">&lt;</a>'?></td>
    <td colspan="5" class="<?php echo $class_mois ?>"><?php echo $calendrier_mois[$calendrier_date_mois],' ',$calendrier_date_annee ?></td>
    <td><?php echo '<a href="?mois=' , $calendrier_date_mois_suivant , '&annee=' , $calendrier_date_annee_suivante , '" class="calendrier_mois">&gt;</a>'?></td>
  </tr>
  <tr> 
    <td class="calendrier_nom_des_jours">Lun</td>
    <td class="calendrier_nom_des_jours">Mar</td>
    <td class="calendrier_nom_des_jours">Mer</td>
    <td class="calendrier_nom_des_jours">Jeu</td>
    <td class="calendrier_nom_des_jours">Ven</td>
    <td class="calendrier_nom_des_jours">Sam</td>
    <td class="calendrier_nom_des_jours">Dim</td>
  </tr>
  <?php
/* On dclare  zro un compteur de jours. 
 * Il compte les jours et donc permet d'afficher
 * le numro du jour et permetra de controler le
 * nombre de jours  afficher (voir la suite). */
$calendrier_compteur_jours = 0;

/* Une boucle While (tant que) :
 * Tant que le compteur de jours n'a pas atteint
 * le nombre de jour total du mois on fait tout
 * ce qu'il y a a faire... */
while ($calendrier_compteur_jours <= $calendrier_date_mois_nombrejour)
{
 ?>
  <tr> 
    <?php 
		/* Une boucle For:
		 * On incrmente $i jusqu'a ce qu'il soit gal a 6
		 * De 0  6 il y a 7 chiffres, cette boucle correspond
		 *  l'affichage en ligne des 7 jours de la semaine. */
 		for ($i = 0 ; $i <= 6 ; $i++)
 		{
		 	/* Si $i est gale au jour de la semaine de la date
			 * selectionne on incrmente le compteur de jour.
			 * Cette condition permet de commencer  incrmenter 
			 * le compteur de jour que lorsque le 1er jour de moi
			 * correspond a jour de la semaine de la colonne
			 * Si date retourne 1 le premier jour du mois est un 
			 * mardi on va donc commencer a compter a partir de 
			 * la 2nde case de la ligne. */
			if ($i == date('w', mktime(0,0,0, $calendrier_date_mois, $calendrier_compteur_jours, $calendrier_date_annee)))
			{
				$calendrier_compteur_jours++;		
			}
				
			/* Si le jour auquel le compteur de jour est correspond
			 *  un jour dans le tableau de dates importantes 
			 * on dfini le style  afficher pour que la case de la
			 * date soit differente (voir CSS).
			 * Sinon c'est le style normal qui s'affiche. */
			if ($calendrier_compteur_jours.'_'.$calendrier_date_mois.'_'.$calendrier_date_annee == $calendrier_dateDuJour) 
			{
				$class_jour  = 'calendrier_dateDuJour';
			} 
			else 
			{	
				if (in_array($calendrier_compteur_jours.'_'.$calendrier_date_mois.'_'.$calendrier_date_annee, $calendrier_dates_importantes))
				{	
					$class_jour = 'calendrier_date_importante';
				}
				else
				{	
					$class_jour = 'calendrier_date';
				}
			}
?>
    <td class="<?php echo $class_jour ?>"> 
      <?php 
			/* Si le jour auquel le compteur de jour est
			 * n'est pas gal 0 (0 s'affiche tant le compteur
			 * de jours n'a pas commencer a etre incrment) et
			 * que le compteur de jour est plus petit ou gal au
			 * nombre de jour on affiche le jour (son numro). */
			if ($calendrier_compteur_jours != 0 && $calendrier_compteur_jours <= $calendrier_date_mois_nombrejour)
			{
				echo $calendrier_compteur_jours;
			}
			else 
			{
				echo '&nbsp;';
			}
			?>
    </td>
    <?php 		
 		}
?>
  </tr>
  <?php 
}
/* Apres quelques modifications vous pouvez
 * accentuer les dimanches ou jour fris...
 * A vous de jouer !
 * * * * * * * * * * * * * * * * * * * * * * * * * * * 
 * script ralis par floptwo (floptwo@gmail.com)
 * * * * * * * * * * * * * * * * * * * * * * * * * * */
?>
</table>
</body>
</html>
