<?php
/*- Licence - Début ----------------------------------------------------------*/
/* (c) Sébastien Adam - 2005~2008 - sebastien.adam.be@gmail.com               */
/*                                                                            */
/* This file is part of auth_admin.                                           */
/*                                                                            */
/*  This program is free software: you can redistribute it and/or modify      */
/*  it under the terms of the GNU General Public License as published by      */
/*  the Free Software Foundation version 3.                                   */
/*                                                                            */
/*  This program is distributed in the hope that it will be useful,           */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/*  GNU General Public License for more details.                              */
/*                                                                            */
/*  You should have received a copy of the GNU General Public License         */
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.     */
/*- Licence - Fin ------------------------------------------------------------*/

if(!defined("__INC_AUTH__"))
  {
  define("__INC_AUTH__", true);
  session_start();

/*- Variables - Début -------------------------------------------------------*/
require_once("auth_include_cfg.php");
/*- Variables - Fin ---------------------------------------------------------*/

/*- Fonctions - Début -------------------------------------------------------*/
  function auth_page_call($page)
    {
    global $path;
    if(empty($page))
      {
      header("Location: http://".$_SERVER["SERVER_NAME"].$path["auth_root"]."/".$path["auth_index"]);
      exit();
      }
    if(basename($_SERVER["REQUEST_URI"]) != basename($page))
      {
      if(preg_match("/^http\:\/\//", $page))
        header("Location: ".$page);
      elseif(preg_match("/^\//", $page))
        header("Location: http://".$_SERVER["SERVER_NAME"].$page);
      else
        header("Location: http://".$_SERVER["SERVER_NAME"].$path["auth_root"]."/".$page);
      exit();
      }
    } // fin function auth_page_call($page)

  function auth_securechk1()
    {
    if(isset($_REQUEST))
      $_input = $_REQUEST;
    else
      {
      global $HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_COOKIE_VARS, $HTTP_POST_FILES;
      $_input = @array_merge($HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_COOKIE_VARS, $HTTP_POST_FILES);
      }
    if(isset($_input["auth"]) || isset($_input["_SESSION"]))
      return false;
    return true;
    } // fin auth_securechk1()

  function auth_securechk2()
    {
    global $auth, $cfg, $path;
    if(empty($auth[$cfg["auth_realm"]]["remote_addr"]))
      return false;
    if($_SERVER["REMOTE_ADDR"] != $auth[$cfg["auth_realm"]]["remote_addr"])
      return false;
    if(empty($auth[$cfg["auth_realm"]]["server_name"]))
      return false;
    if($_SERVER["SERVER_NAME"] != $auth[$cfg["auth_realm"]]["server_name"])
      return false;
    return true;
    } // fin auth_securechk2()

  function user_access($grp)
    {
    global $auth, $cfg, $path;
    if($grp == $auth["grp"]["public"])
      return true;
    if(empty($auth[$cfg["auth_realm"]]))
      return false;
    if($auth[$cfg["auth_realm"]]["name"] == $auth["usr"]["root"])
      return true;
    if(@in_array($auth["grp"]["root"], $auth[$cfg["auth_realm"]]["grps"]))
      return true;
    if(@in_array($grp, $auth[$cfg["auth_realm"]]["grps"]))
      return true;
    return false;
    } // fin function user_access($grp)

  function user_logged()
    {
    global $auth, $cfg, $path;
    if(!empty($auth[$cfg["auth_realm"]]))
      {
      $return = $auth[$cfg["auth_realm"]];
      unset($return["grps"]);
      return $return;
      }
    return false;
    } // fin function user_logged()
/*- Fonctions - Fin ---------------------------------------------------------*/

  if(!auth_securechk1())
    auth_page_call($path["auth_logout"]);
  else
    {
    if($cfg["auth_init"])
      {
      if(!empty($_SESSION["auth"][$cfg["auth_realm"]]))
        {
        $auth[$cfg["auth_realm"]] = $_SESSION["auth"][$cfg["auth_realm"]];
        if(!auth_securechk2())
          auth_page_call($path["auth_logout"]);
        }
      }
    else
      if(!defined("__AUTH_ADMIN__")||empty($_REQUEST["a"])||$_REQUEST["a"]!="init")
        auth_page_call($path["auth_admin"]."?a=init");
    }
  }
?>
