<?php
/*- Licence - Début ----------------------------------------------------------*/
/* (c) Sébastien Adam - 2005~2008 - sebastien.adam.be@gmail.com               */
/*                                                                            */
/* This file is part of auth_admin.                                           */
/*                                                                            */
/*  This program is free software: you can redistribute it and/or modify      */
/*  it under the terms of the GNU General Public License as published by      */
/*  the Free Software Foundation version 3.                                   */
/*                                                                            */
/*  This program is distributed in the hope that it will be useful,           */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/*  GNU General Public License for more details.                              */
/*                                                                            */
/*  You should have received a copy of the GNU General Public License         */
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.     */
/*- Licence - Fin ------------------------------------------------------------*/

define("__AUTH_ADMIN__", true);

require_once("auth_include.php");
$_input = read_input();
if(!empty($_input["lang"]))
  $lang = $_input["lang"];
elseif(!empty($auth[$cfg["auth_realm"]][$db["tables"]["users"]["cols"]["lang"]["name"]]))
  $lang = $auth[$cfg["auth_realm"]][$db["tables"]["users"]["cols"]["lang"]["name"]];
else
  $lang = "fr";

if(file_exists("auth_pl_$lang.php"))
  require_once("auth_pl_$lang.php");
else
  require_once("auth_pl_fr.php");

/*- Variables - Début -------------------------------------------------------*/
require_once("auth_admin_cfg.php");
/*- Variables - Fin ---------------------------------------------------------*/

/*- Fonctions - Début -------------------------------------------------------*/
function encode($string)
  {
  global $cfg;
  $phrase = mb_convert_encoding($cfg["pswdphrase"], "ISO-8859-1", $cfg["pswdcharset"]);
  $phrase_len = strlen($phrase);
  if(empty($string))
    return $string;
  $coded = "";
  $stridx = (170 + ord($string[strlen($string)-1])) % $phrase_len;
  for($i = 0; isset($string[$i]); ++$i)
    {
    $coded .= $phrase[$stridx];
    $stridx = ($stridx + ord($string[$i])) % $phrase_len;
    }
  return mb_convert_encoding($coded, $cfg["pswdcharset"], "ISO-8859-1");
  } // fin function encode($string)

function group_add($group, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($DB) || empty($group[$db["tables"]["groups"]["cols"]["name"]["name"]]) || empty($group[$db["tables"]["groups"]["cols"]["parent"]["name"]]))
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]);
    return false;
    }
  if($group[$db["tables"]["groups"]["cols"]["parent"]["name"]] == $auth["grp"]["public"] || $group[$db["tables"]["groups"]["cols"]["parent"]["name"]] == $auth["grp"]["auth_admin"])
    {
    $cfg["error"] = str_replace(array("%func%", "%grp%"), array(__FUNCTION__,$group[$db["tables"]["groups"]["cols"]["parent"]["name"]]), $pl["E_FUNC_BADPARENT"]);
    return false;
    }
  if(group_get($group[$db["tables"]["groups"]["cols"]["name"]["name"]], $DB))
    {
    $cfg["error"] = str_replace(array("%func%", "%name%"), array("group_add", $group[$db["tables"]["groups"]["cols"]["name"]["name"]]), $pl["E_FUNC_NAMEXIST"]);
    return false;
    }
  if(!group_get($group[$db["tables"]["groups"]["cols"]["parent"]["name"]], $DB) && $group[$db["tables"]["groups"]["cols"]["parent"]["name"]] != $auth["grp"]["root"])
    {
    $cfg["error"] = str_replace(array("%func%", "%name%"), array("group_add", $group[$db["tables"]["groups"]["cols"]["name"]["name"]]), $pl["E_FUNC_UPGNEXIST"]);
    return false;
    }
  $query = "INSERT INTO ".$db["tables"]["groups"]["table"]["name"]." SET\n";
  foreach($db["tables"]["groups"]["cols"] as $col)
    {
    if(!empty($group[$col["name"]]))
      $query .= "  ".$col["name"]."='".$group[$col["name"]]."', ";
    }
  $query = preg_replace("/, $/", ";", $query);
  if(db_query($query, $DB))
    return true;
  else
    {
    $cfg["error"] = str_replace(array("%func%", "%name%"), array(__FUNCTION__, $group[$db["tables"]["groups"]["cols"]["name"]["name"]]), $pl["E_FUNC_ADD"])."\n".$cfg["error"];
    return false;
    }
  } // fin function group_add($group, $DB)

function group_add_printfrm($_input, $DB)
  {
  global $auth, $db, $pl;
  if(empty($DB))
    {
    $cfg["error"] = "";
    return print_errormsg(str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]));
    }
  $return = "";
  $return .= "<table align=\"center\" class=\"form\">\n";
  foreach($db["tables"]["groups"]["cols"] as $col)
    {
    $return .= "<tr><td align=\"right\" class=\"form\"><em>".$col["label"]."</em>&nbsp;:</td><td align=\"left\" class=\"form\">";
    if($col["name"] == $db["tables"]["groups"]["cols"]["parent"]["name"])
      {
      $groups = groups_get($DB);
      $return .= "<select name=\"".$col["name"]."\">\n";
      if(empty($_input[$col["name"]]))
        $_input[$col["name"]] = $auth["grp"]["root"];
      foreach($groups as $group)
        {
        if(in_array($group, $auth["grp"]) && $group != $auth["grp"]["root"])
          continue;
        if($group == $_input[$col["name"]])
          $return .= "<option value=\"$group\" selected>$group</option>\n";
        else
          $return .= "<option value=\"$group\">$group</option>\n";
        }
      $return .= "</select>\n";
      }
    elseif(empty($col["values"]))
      $return .= "<input type=\"text\" name=\"".$col["name"]."\" size=\"".$col["len"]."\" maxlength=\"".$col["len"]."\" value=\"".stripslashes(@$_input[$col["name"]])."\">";
    else
      {
      $return .= "<select name=\"".$col["name"]."\">";
      foreach($col["values"] as $key => $val)
        $return .= "<option value=\"$key\">$val</option>";
      $return .= "</select>\n";
      }
    $return .= "</td></tr>\n";
    $edits[] = $col["name"];
    }
  $return .= "<tr><td class=\"formbut\" colspan=\"2\"><input class=\"button\" type=\"submit\" value=\"".$pl["lab_send"]."\">&nbsp;&nbsp;&nbsp;<input type=\"button\" class=\"button\" value=\"".$pl["lab_cancel"]."\" onclick=\"javascript:location.href='".$path["auth_admin"]."?a=".$_input["a"]."'\"></td></tr>\n";
  $return .= "</table>\n";
  $return .= "</form>\n";
  foreach($_input as $key => $val)
    if(!in_array($key, $edits))
      $return = "<input type=\"hidden\" name=\"$key\" value=\"$val\">\n".$return;
  $return = "<form action=\"".$_SERVER["SCRIPT_NAME"]."\" method=\"post\">\n".$return;
  return $return;
  } // fin function group_add_printfrm($_input, $DB)

function group_del($name, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($name) || empty($DB))
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]);
    return false;
    }
  if(in_array($name, $auth["grp"]))
    {
    $cfg["error"] = str_replace(array("%func%", "%name%"), array(__FUNCTION__, $name), $pl["E_FUNC_NODELA"]);
    return false;
    }
  if($group = group_get($name, $DB))
    {
    if(!empty($group["users"]))
      {
      $query = "DELETE FROM ".$db["tables"]["links"]["table"]["name"]." WHERE ".$db["tables"]["links"]["cols"]["group"]["name"]."='".$name."';";
      if(!db_query($query, $DB))
        {
        $cfg["error"] = str_replace(array("%func%", "%grp%"), array(__FUNCTION__, $group), $pl["E_FUNC_NODELUG"])."\n".$cfg["error"];
        return false;
        }
      }
    if(group_getchilds($name, false, $DB))
      {
      $query = "UPDATE ".$db["tables"]["groups"]["table"]["name"]." SET ".$db["tables"]["groups"]["cols"]["parent"]["name"]."='".$group[$db["tables"]["groups"]["cols"]["parent"]["name"]]."' WHERE ".$db["tables"]["groups"]["cols"]["parent"]["name"]."='".$name."';";
      if(!db_query($query, $DB))
        {
        $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOUPGDOWN"])."\n".$cfg["error"];
        return false;
        }
      }
    $query = "DELETE FROM ".$db["tables"]["groups"]["table"]["name"]." WHERE ".$db["tables"]["groups"]["cols"]["name"]["name"]."='".$name."';";
    if(db_query($query, $DB))
      return true;
    else
      {
      $cfg["error"] = str_replace(array("%func%", "%name%"), array(__FUNCTION__, $name), $pl["E_FUNC_DEL"])."\n" . $cfg["error"];
      return false;
      }
    }
  else
    {
    $cfg["error"] = str_replace(array("%func%", "%name%"), array(__FUNCTION__, $name), $pl["E_FUNC_NAMNEXIST"]);
    return false;
    }
  } // fin function group_del($name, $DB)

function group_get($name, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($name) || empty($DB))
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]);
    return false;
    }
  $query = "SELECT * FROM ".$db["tables"]["groups"]["table"]["name"]." WHERE ".$db["tables"]["groups"]["cols"]["name"]["name"]."='".$name."';";
  if($result = db_query($query, $DB))
    {
    foreach($result[0] as $key => $val)
      {
      if(!empty($val))
        $group[$key] = $val;
      }
    $group["users"] = group_getusers($name, $DB);
    return $group;
    }
  else
    {
    $cfg["error"] = str_replace(array("%func%", "%query%"), array(__FUNCTION__, $query), $pl["E_FUNC_SQLNORES"])."\n".$cfg["error"];
    return false;
    }
  } // fin function group_get($name, $DB)

function group_getchilds($name, $recurs, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($name) || empty($DB))
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]);
    return false;
    }
  $query = "SELECT ".$db["tables"]["groups"]["cols"]["name"]["name"]." FROM ".$db["tables"]["groups"]["table"]["name"]." WHERE ".$db["tables"]["groups"]["cols"]["parent"]["name"]."='".$name."';";
  if($result = db_query($query, $DB))
    {
    foreach($result as $child)
      {
      if($child[$db["tables"]["groups"]["cols"]["name"]["name"]] == $name)
        continue;
      $childs[] = $child[$db["tables"]["groups"]["cols"]["name"]["name"]];
      if($recurs)
        {
        if($cchilds = group_getchilds($child[$db["tables"]["groups"]["cols"]["name"]["name"]], $recurs, $DB))
          $childs = array_merge(@$childs, $cchilds);
        }
      }
    if(empty($childs))
      return false;
    else
      {
      $childs = array_unique($childs);
      sort($childs);
      return $childs;
      }
    }
  else
    {
    $cfg["error"] = str_replace(array("%func%", "%query%"), array(__FUNCTION__, $query), $pl["E_FUNC_SQLNORES"])."\n".$cfg["error"];
    return false;
    }
  } // fin function group_getchilds($name, $recurs, $DB)

function group_getusers($name, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($name) || empty($DB))
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]);
    return false;
    }
  $users = array();
  $query = "SELECT DISTINCT ".$db["tables"]["links"]["cols"]["user"]["name"]." FROM ".$db["tables"]["links"]["table"]["name"]." WHERE ".$db["tables"]["links"]["cols"]["group"]["name"]."='".$name."' ORDER BY ".$db["tables"]["links"]["cols"]["user"]["name"];
  if($result = db_query($query, $DB))
    {
    foreach($result as $user)
      $users[] = $user[$db["tables"]["links"]["cols"]["user"]["name"]];
    sort($users);
    return $users;
    }
  else
    {
    $cfg["error"] = str_replace(array("%func%", "%query%"), array(__FUNCTION__, $query), $pl["E_FUNC_SQLNORES"])."\n".$cfg["error"];
    return false;
    }
  } // fin function group_getusers($name, $DB)

function group_getusersdiff($name, $DB)
  { // BEGIN function group_getusersdiff
  global $cfg, $pl;
  if(empty($name) || empty($DB))
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]);
    return false;
    }
  if($users = group_getusers($name, $DB))
    return array_diff(users_get($DB), $users);
  else
    return users_get($DB);
  } // END function group_getusersdiff

function group_print($group)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($group) || !is_array($group))
    {
    $cfg["error"] = "";
    return print_errormsg(str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]));
    }
  $return = "<table align=\"center\" class=\"form\">\n";
  foreach($db["tables"]["groups"]["cols"] as $col)
    {
    $return .= "<tr>";
    $return .= "<td align=\"right\" class=\"form\"><em>".$col["label"]."</em>&nbsp;:</td>";
    $return .= "<td align=\"justify\" class=\"form\">";
    if($col["name"] == $db["tables"]["groups"]["cols"]["parent"]["name"])
      $return .= "<a class=\"list\" href=\"".$path["auth_grpshw"]."&".$db["tables"]["groups"]["cols"]["name"]["name"]."=".$group[$col["name"]]."\">".$group[$col["name"]]."</a>";
    else
      $return .= $group[$col["name"]];
    $return .= "</td>";
    $return .= "</tr>\n";
    }
  $return .= "<tr><td colspan=\"2\" class=\"formlist\">";
  if(@$group["users"])
    {
    $return .= str_replace("%grp%",$group[$db["tables"]["groups"]["cols"]["name"]["name"]],$pl["grp_has_user"]).":\n";
    $return .= "<ul>\n";
    foreach($group["users"] as $usr)
      $return .= "<li><a class=\"list\" href=\"".$path["auth_usrshw"]."&".$db["tables"]["users"]["cols"]["login"]["name"]."=".$usr."\">".$usr."</a></li>\n";
    $return .= "</ul>\n";
    }
  else
    $return .= $pl["no_user_in_grp"];
  $return .= "</td></tr>\n";
  if(@$group["childs"])
    {
    $return .= "<tr><td colspan=\"2\" class=\"formlist\">";
    $return .= $pl["child_in_grp"].":\n";
    $return .= "<ul>\n";
    foreach($group["childs"] as $child)
      $return .= "<li><a class=\"list\" href=\"".$path["auth_grpshw"]."&".$db["tables"]["groups"]["cols"]["name"]["name"]."=".$child."\">".$child."</a></li>\n";
    $return .= "</ul>\n";
    $return .= "</td></tr>\n";
    }
  $return .= "</table>\n";
  return $return;
  } // fin function group_print($name, $DB)

function group_upd($group, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($group) || !is_array($group) || empty($group[$db["tables"]["groups"]["cols"]["name"]["name"]]) || empty($DB))
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]);
    return false;
    }
  if(!group_get($group[$db["tables"]["groups"]["cols"]["name"]["name"]], $DB))
    {
    $cfg["error"] = str_replace(array("%func%","%name%"), array(__FUNCTION__,$group[$db["tables"]["groups"]["cols"]["name"]["name"]]), $pl["E_FUNC_NAMNEXIST"]).".\n".$cfg["error"];
    return false;
    }
  if(in_array($group[$db["tables"]["groups"]["cols"]["name"]["name"]], $auth["grp"]) && $group[$db["tables"]["groups"]["cols"]["parent"]["name"]] != $auth["grp"]["root"])
    {
    $cfg["error"] = str_replace(array("%func%","%name%"), array(__FUNCTION__,$group[$db["tables"]["groups"]["cols"]["name"]["name"]]), $pl["E_FUNC_CANTMV"]);
    return false;
    }
  $query = "UPDATE ".$db["tables"]["groups"]["table"]["name"]." SET ";
  foreach($db["tables"]["groups"]["cols"] as $col)
    {
    if(empty($group[$col["name"]]))
      continue;
    if($col["name"] == $db["tables"]["groups"]["cols"]["parent"]["name"])
      {
      if(!group_get($group[$col["name"]], $DB))
        {
        $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_UPGNEXIST"]).".\n".$cfg["error"];
        return false;
        }
      if($childs = group_getchilds($group[$db["tables"]["groups"]["cols"]["name"]["name"]], true, $DB))
        {
        if(in_array($group[$col["name"]], $childs))
          {
          $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_MVDOWN"]).".\n";
          return false;
          }
        }
      if($group[$col["name"]] == $group[$db["tables"]["groups"]["cols"]["name"]["name"]] && $group[$db["tables"]["groups"]["cols"]["name"]["name"]] != $auth["grp"]["root"])
        {
        $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_MVDOWN"]);
        return false;
        }
      if($group[$col["name"]] == $auth["grp"]["public"] || $group[$col["name"]] == $auth["grp"]["auth_admin"])
        {
        $cfg["error"] = str_replace(array("%func%","%grp%"), array(__FUNCTION__,$group[$col["name"]]), $pl["E_FUNC_BADPARENT"]);
        return false;
        }
      }
    $query .= $col["name"]."='".$group[$col["name"]]."', ";
    }
  $query = preg_replace("/, $/", "", $query);
  $query .= " WHERE ".$db["tables"]["groups"]["cols"]["name"]["name"]."='".$group[$db["tables"]["groups"]["cols"]["name"]["name"]]."';";
  if(db_query($query, $DB))
    return true;
  else
    return false;
  } // fin function group_upd($group, $DB)

function group_upd_printfrm($_input, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($_input[$db["tables"]["groups"]["cols"]["name"]["name"]]) || empty($DB))
    {
    $cfg["error"] = "";
    return print_errormsg(str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]));
    }
  if($grp = group_get($_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $DB))
    {
    $return = "<form action=\"".$_SERVER["SCRIPT_NAME"]."\" method=\"post\">\n";
    $return .= "<table align=\"center\" class=\"form\">\n";
    foreach($db["tables"]["groups"]["cols"] as $col)
      {
      if($col["name"] == $db["tables"]["groups"]["cols"]["parent"]["name"])
        {
        $return .= "<tr><td class=\"form\" align=\"right\"><em>".$col["label"]."</em>&nbsp;:</td><td class=\"form\" align=\"left\">";
        $groups = groups_get($DB);
        $return .= "<select name=\"".$col["name"]."\">\n";
        if(empty($_input[$col["name"]]) || !in_array($_input[$col["name"]], $groups))
          $_input[$col["name"]] = $auth["grp"]["root"];
        foreach($groups as $group)
          {
          if($group == $grp[$db["tables"]["groups"]["cols"]["name"]["name"]] && $group != $auth["grp"]["root"])
            continue;
          if($group == $grp[$col["name"]])
            $return .= "<option value=\"$group\" selected>$group</option>\n";
          else
            $return .= "<option value=\"$group\">$group</option>\n";
          }
        $return .= "</select>\n";
        }
      elseif($col["name"] == $db["tables"]["groups"]["cols"]["name"]["name"])
        $return .= "<tr><td class=\"form\" align=\"right\"><em>".$col["label"]."</em>&nbsp;:</td><td align=\"left\"><input type=\"hidden\" name=\"".$col["name"]."\" value=\"".$grp[$col["name"]]."\">".$grp[$col["name"]]."</td></tr>\n";
      else
        {
        $return .= "<tr><td class=\"form\" align=\"right\"><em>".$col["label"]."</em>&nbsp;:</td><td align=\"left\">";
        if(empty($col["values"]))
          $return .= "<input type=\"text\" name=\"".$col["name"]."\" size=\"".$col["len"]."\" maxlength=\"".$col["len"]."\" value=\"".@$grp[$col["name"]]."\">";
        else
          {
          $return .= "<select name=\"".$col["name"]."\">";
          foreach($col["values"] as $key => $val)
            if($key == $grp[$col["name"]])
              $return .= "<option value=\"$key\" selected>$val</option>";
            else
              $return .= "<option value=\"$key\">$val</option>";
          $return .= "</select>\n";
          }
        $return .= "</td></tr>\n";
        }
      $form[] = $col["name"];
      }
    $return .= "<tr><td class=\"formbut\" align=\"center\" colspan=\"2\"><input class=\"button\" type=\"submit\" value=\"".$pl["lab_send"]."\"></td></tr>\n";
    $return .= "</table>\n";
    $return .="<input type=\"hidden\" name=\"conf\" value=\"yes\">\n";
    foreach($_input as $key => $val)
      {
      if(in_array($key, $form))
        continue;
      $return .="<input type=\"hidden\" name=\"$key\" value=\"$val\">\n";
      }
    $return .= "</form>";
    return $return;
    }
  else
    return print_errormsg(str_replace(array("%func%","%name%"), array(__FUNCTION__,$_input[$db["tables"]["groups"]["cols"]["name"]["name"]]), $pl["E_FUNC_NAMNEXIST"]));
  } // fin function group_upd_printfrm($_input, $DB)

function groups_get($DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($DB))
    {
    return print_errormsg(str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]));
    return false;
    }
  $query = "SELECT ".$db["tables"]["groups"]["cols"]["name"]["name"]." FROM ".$db["tables"]["groups"]["table"]["name"]." ORDER BY ".$db["tables"]["groups"]["cols"]["name"]["name"].";";
  if($results = db_query($query, $DB))
    {
    foreach($results as $result)
      $groups[] = $result[$db["tables"]["groups"]["cols"]["name"]["name"]];
    return $groups;
    }
  else
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_SQLNORES"])."\n".$cfg["error"];
    return false;
    }
  } // fin function groups_get($DB)

function groups_getwusers($DB)
  { // BEGIN function groups_getwusers
  global $auth, $cfg, $db, $path, $pl;
  if(empty($DB))
    {
    return print_errormsg(str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]));
    return false;
    }
  $query = "SELECT DISTINCT ".$db["tables"]["links"]["cols"]["group"]["name"]." FROM ".$db["tables"]["links"]["table"]["name"]." ORDER BY ".$db["tables"]["links"]["cols"]["group"]["name"].";";
  if($results = db_query($query, $DB))
    {
    foreach($results as $result)
      $groups[] = $result[$db["tables"]["links"]["cols"]["group"]["name"]];
    return $groups;
    }
  else
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_SQLNORES"])."\n".$cfg["error"];
    return false;
    }
  } // END function groups_getwusers

function groups_print($_input, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($DB))
    {
    $cfg["error"] = "";
    return print_errormsg(str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]));
    }
  if(!empty($_input["groups"]))
    $groups = $_input["groups"];
  else
    $groups = groups_get($DB);
  if(empty($groups))
    {
    $cfg["error"] = "";
    return print_errormsg(str_replace("%func%", __FUNCTION__, $pl["E_FUNC_SQLNORES"]));
    }
  else
    {
    $return = "<ul>\n";
    foreach($groups as $group)
      {
      $return .= "<li><a class=\"list\" href=\"".$path["auth_admin"]."?a=".$_input["a"];
      switch($_input["a"])
        {
        case "grp_add":
          $return .= "&".$db["tables"]["groups"]["cols"]["parent"]["name"]."=".$group;
          break;
        case "grp_upd":
          if(empty($_input[$db["tables"]["groups"]["cols"]["name"]["name"]]))
            $return .= "&".$db["tables"]["groups"]["cols"]["name"]["name"]."=".$group;
          else
            {
            $return .= "&".$db["tables"]["groups"]["cols"]["name"]["name"]."=".$_input[$db["tables"]["groups"]["cols"]["name"]["name"]];
            $return .= "&".$db["tables"]["groups"]["cols"]["parent"]["name"]."=".$group;
            }
          break;
        default:
          $return .= "&".$db["tables"]["groups"]["cols"]["name"]["name"]."=".$group;
        }
      if(!empty($_input[$db["tables"]["users"]["cols"]["login"]["name"]]))
        $return .= "&".$db["tables"]["users"]["cols"]["login"]["name"]."=".$_input[$db["tables"]["users"]["cols"]["login"]["name"]];
      if(!empty($_input["source"]))
        $return .= "&source=".$_input["source"];
      $return .= "\">".$group."</a></li>\n";
      }
    $return .= "</ul>\n";
    return $return;
    }
  } // fin function groups_print($_input, $DB)

function groups_printtree($_input, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($DB))
    {
    $cfg["error"] = "";
    return print_errormsg(str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]));
    }
  if(empty($_input["tree_root"]))
    $name = $auth["grp"]["root"];
  else
    $name = $_input["tree_root"];
  if(group_get($name, $DB))
    {
    if(empty($_input["a"]) || $_input["a"] == "grp_tre")
      $_input["a"] = "grp_shw";
    $return = "";
    $return .= "<ul class=\"grptree\">\n";
    $return .= "<li><a class=\"list\" href=\"".$path["auth_admin"]."?a=".$_input["a"];
    $return .= "&".$db["tables"]["groups"]["cols"]["name"]["name"]."=".$name;
    if(!empty($_input[$db["tables"]["groups"]["cols"]["parent"]["name"]]))
      $return .= "&".$db["tables"]["groups"]["cols"]["parent"]["name"]."=".$_input[$db["tables"]["groups"]["cols"]["name"]["name"]];
    if(!empty($_input[$db["tables"]["users"]["cols"]["login"]["name"]]))
      $return .= "&".$db["tables"]["users"]["cols"]["login"]["name"]."=".$_input[$db["tables"]["users"]["cols"]["login"]["name"]];
    if(!empty($_input["source"]))
      $return .= "&source=".$_input["source"];
    $return .= "\">".$name."</a></li>\n";
    if($childs = group_getchilds($name, false, $DB))
      {
      foreach($childs as $child)
        {
        $_input["tree_root"] = $child;
        $return .= groups_printtree($_input, $DB);
        }
      }
    $return .= "</ul>\n";
    return $return;
    }
  else
    {
    $cfg["error"] = "";
    return print_errormsg(str_replace(array("%func%", "%name%"), array(__FUNCTION__, $name), $pl["E_EUSR_GPT02"]));
    }
  } // fin function groups_printtree($name, $DB)

function init($_input, $DB)
  {
  global $auth, $cfg, $db, $lang, $path, $pl;
  $return = "";
  if(!is_writable($path["auth_init"]))
    {
    $cfg["error"] = "";
    return $return . print_errormsg(str_replace("%file%", $path["auth_init"], $pl["E_INIT_FILERO"]));
    }
  if(empty($DB))
    {
    $cfg["error"] = "";
    return $return . print_errormsg($pl["E_INIT_NOIN"]);
    }
  foreach($db["tables"] as $table)
    {
    $query = "DESCRIBE ".$table["table"]["name"];
    if(db_query($query, $DB))
      {
      if(empty($_input["init_force"]))
        {
        $return .= "<pre style=\"margin-top: 0pt; margin-bottom: 3pt;\">-&gt; ".str_replace("%table%", $table["table"]["name"], $pl["table_exists"])."</pre>\n";
        continue;
        }
      else
        {
        $query = "DROP TABLE ".$table["table"]["name"];
        if(!db_query($query, $DB))
          {
          $return .= print_errormsg(str_replace("%table%", $table["table"]["name"], $pl["E_FUNC_SQLFAIL"]));
          continue;
          }
        }
      }
    $query = "CREATE TABLE ".$table["table"]["name"]."(\n";
    foreach($table["cols"] as $col)
      {
      if(empty($col["name"]) || empty($col["type"]) || empty($col["len"]))
        continue;
      $query .= $col["name"]." ".$col["type"]."(".$col["len"].")";
      if(!empty($col["constr"]))
        $query .= " ".$col["constr"];
      $query .= ",\n";
      }
    if(empty($table["table"]["constr"]))
      $query = preg_replace("/,\n$/", "", $query);
    else
      $query .= $table["table"]["constr"];
    $query .= "\n);";
    if(db_query($query, $DB))
      $return .= "<pre style=\"margin-top: 0pt; margin-bottom: 3pt;\">-&gt; ".str_replace("%table%", $table["table"]["name"], $pl["table_create"])."</pre>\n";
    else
      return $return.print_errormsg(str_replace("%table%", $table["table"]["name"], $pl["table_create"]));
    }
  $return .= "<pre style=\"margin-top: 0pt; margin-bottom: 3pt;\">-&gt; ".$pl["chk_spcl_grp"]."</pre>\n";
  $descr[$auth["grp"]["root"]]       = $pl["grplab_root"];
  $descr[$auth["grp"]["auth_admin"]] = $pl["grplab_uadmin"];
  $descr[$auth["grp"]["public"]]     = $pl["grplab_public"];
  foreach($auth["grp"] as $authgrp)
    {
    if(group_get($authgrp, $DB))
      $return .= "<pre style=\"margin-top: 0pt; margin-bottom: 3pt;\">-&gt; ".str_replace("%name%", $authgrp, $pl["exists"])."</pre>\n";
    else
      {
      if(isvalid_grpname($authgrp))
        {
        $group[$db["tables"]["groups"]["cols"]["name"]["name"]]   = $authgrp;
        $group[$db["tables"]["groups"]["cols"]["parent"]["name"]] = $auth["grp"]["root"];
        $group[$db["tables"]["groups"]["cols"]["descr"]["name"]]  = @$descr[$authgrp];
        if(group_add($group, $DB))
          $return .= "<pre style=\"margin-top: 0pt; margin-bottom: 3pt;\">-&gt; ".str_replace("%grp%", $authgrp, $pl["grp_create"])."</pre>\n";
        else
          return $return . print_errormsg(str_replace("%grp%", $authgrp, $pl["E_INIT_GRPCREATE"]));
        }
      else
        return $return . print_errormsg(str_replace("%grp%", htmlentities($authgrp), $pl["E_INIT_GRPCREATE"]));
      }
    }
  if($root = user_get($auth["usr"]["root"], $DB))
    $return .= "<pre style=\"margin-top: 0pt; margin-bottom: 3pt;\">-&gt; ".str_replace("%user%", $auth["usr"]["root"], $pl["user_root_exist"])."</pre>\n";
  else
    {
    $askpswd = false;
    if(empty($_input["passwd1"]) && empty($_input["passwd2"]))
      $askpswd = true;
    elseif(@$_input["passwd1"] != @$_input["passwd2"])
      {
      $askpswd = true;
      $cfg["error"] = "";
      $return .= print_errormsg($pl["E_INIT_2PASSWD"]);
      }
    if($askpswd)
      {
      $return .= "<pre style=\"margin-top: 0pt; margin-bottom: 3pt;\">-&gt; ".$pl["user_root_pswd"]."&nbsp;:</pre>\n";
      $return .= "<form action=\"".$_SERVER["SCRIPT_NAME"]."\" method=\"post\">\n";
      $return .= "<input type=\"hidden\" name=\"conf\" value=\"yes\">";
      $return .= "<input type=\"hidden\" name=\"a\" value=\"init\">";
      $return .= "<center>\n";
      $return .= "<table class=\"form\" cellspacing=\"1\" cellpadding=\"1\">\n";
      $return .= "<tr class=\"form\"><td class=\"form\" align=\"right\">".$pl["lab_newpasswd"].":</td><td class=\"form\" align=\"right\"><input type=\"password\" name=\"passwd1\" size=\"".$db["tables"]["users"]["cols"]["password"]["len"]."\" maxlength=\"".$db["tables"]["users"]["cols"]["password"]["len"]."\"></td></tr>\n";
      $return .= "<tr class=\"form\"><td  class=\"form\"align=\"right\">".$pl["lab_confpasswd"]."&nbsp;:</td><td class=\"form\" align=\"right\"><input type=\"password\" name=\"passwd2\" size=\"".$db["tables"]["users"]["cols"]["password"]["len"]."\" maxlength=\"".$db["tables"]["users"]["cols"]["password"]["len"]."\"></td></tr>\n";
      $return .= "<tr class=\"form\"><td class=\"formbut\" align=\"center\" colspan=\"2\"><input class=\"button\" type=\"submit\" value=\"".$pl["lab_send"]."\"></td></tr>\n";
      $return .= "</table>\n";
      $return .= "</center>\n";
      $return .= "</form>\n";
      return $return;
      }
    else
      {
      $root[$db["tables"]["users"]["cols"]["login"]["name"]]      = $auth["usr"]["root"];
      $root[$db["tables"]["users"]["cols"]["name"]["name"]]       = $pl["grplab_root"];
      if($cfg["pswdencode"])
        $root[$db["tables"]["users"]["cols"]["password"]["name"]] = encode($_input["passwd1"]);
      else
        $root[$db["tables"]["users"]["cols"]["password"]["name"]] = $_input["passwd1"];
      $root[$db["tables"]["users"]["cols"]["status"]["name"]]     = $cfg["status"]["enable"];
      $root[$db["tables"]["users"]["cols"]["lang"]["name"]]      = $lang;
      if(user_add($root, $DB))
        $return .= "<pre style=\"margin-top: 0pt; margin-bottom: 3pt;\">-&gt; ".str_replace("%user%", $auth["usr"]["root"], $pl["user_root_create"])."</pre>\n";
      else
        return $return . print_errormsg(str_replace("%user%", $auth["usr"]["root"], $pl["E_INIT_USRCREATE"]))."\n<pre>".var_export($root, true)."</pre>\n";
      }
    }
  if(!@in_array($auth["grp"]["root"], $root["grps"]))
    {
    $link[$db["tables"]["links"]["cols"]["user"]["name"]]  = $root[$db["tables"]["users"]["cols"]["login"]["name"]];
    $link[$db["tables"]["links"]["cols"]["group"]["name"]] = $auth["grp"]["root"];
    if(link_add($link, $DB))
      $return .= "<pre style=\"margin-top: 0pt; margin-bottom: 3pt;\">-&gt; ".str_replace(array("%user%","%grp%"), array($root[$db["tables"]["users"]["cols"]["login"]["name"]],$auth["grp"]["root"]), $pl["add_u2g_root"])."</pre>\n";
    else
      return $return . print_errormsg($pl["E_INIT_U2G_ROOT"]);
    }
  else
    $return .= "<pre style=\"margin-top: 0pt; margin-bottom: 3pt;\">-&gt; ".str_replace(array("%user%","%grp%"), array($root[$db["tables"]["users"]["cols"]["login"]["name"]],$auth["grp"]["root"]), $pl["uroot_in_groot"])."</pre>\n";
  if(!$FINIT = fopen($path["auth_init"], "rb"))
    {
    $cfg["error"] = "";
    return $return.print_errormsg(str_replace("%file%",$path["auth_init"],$pl["E_INIT_FILEOPENR"]));
    }
  $filecontent = fread($FINIT, filesize($path["auth_init"]));
  fclose ($FINIT);
  $filecontent = preg_replace('/\$cfg\["auth_init"\]\s*=\s*\w+?;/m',"\$cfg[\"auth_init\"] = true;",$filecontent,-1);
  if(!$FINIT = fopen($path["auth_init"], "wb"))
    {
    $cfg["error"] = "";
    return $return.print_errormsg(str_replace("%file%",$path["auth_init"],$pl["E_INIT_FILERO"]));
    }
  if(!fwrite($FINIT, $filecontent))
    {
    fclose ($FINIT);
    $cfg["error"] = "";
    return $return.print_errormsg(str_replace("%file%",$path["auth_init"],$pl["E_INIT_FILEWRITE"]));
    }
  fclose ($FINIT);
  return $return;
  } // function init($_input, $DB)

function isvalid_grpname($name)
  { // BEGIN function isvalid_grpname
  global $cfg, $pl;
  if(preg_match("/^[\w \.\-]+$/", $name))
    return true;
  else
    {
    $cfg["error"] = str_replace(array("%func%","%name"), array(__FUNCTION__,htmlentities($name)), $pl["E_FUNC_NAMEINVAL"]);
    return false;
    }
  } // END function isvalid_grpname

function isvalid_username($name)
  { // BEGIN function isvalid_username
  global $cfg, $pl;
  if(preg_match("/^[\w \.\-]+$/", $name))
    return true;
  else
    {
    $cfg["error"] = str_replace(array("%func%","%name"), array(__FUNCTION__,htmlentities($name)), $pl["E_FUNC_NAMEINVAL"]);
    return false;
    }
  } // END function isvalid_username

function link_add($link, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($link) || empty($DB) || empty($link[$db["tables"]["links"]["cols"]["user"]["name"]]) || empty($link[$db["tables"]["links"]["cols"]["group"]["name"]]))
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]);
    return false;
    }
  if(!user_get($link[$db["tables"]["links"]["cols"]["user"]["name"]], $DB))
    {
    $cfg["error"] = str_replace(array("%func%", "%name%"), array(__FUNCTION__, $link[$db["tables"]["links"]["cols"]["user"]["name"]]), $pl["E_FUNC_NAMNEXIST"]);
    return false;
    }
  if(!group_get($link[$db["tables"]["links"]["cols"]["group"]["name"]], $DB))
    {
    $cfg["error"] = str_replace(array("%func%", "%name%"), array(__FUNCTION__, $link[$db["tables"]["links"]["cols"]["group"]["name"]]), $pl["E_FUNC_NAMNEXIST"]);
    return false;
    }
  $query = "INSERT INTO ".$db["tables"]["links"]["table"]["name"]." SET\n";
  foreach($db["tables"]["links"]["cols"] as $col)
    {
    if(!empty($link[$col["name"]]))
      $query .= " ".$col["name"]."='".$link[$col["name"]]."',\n";
    }
  $query = preg_replace("/,\n$/", "", $query);
  if(db_query($query, $DB))
    return true;
  else
    {
    $cfg["error"] = str_replace(array("%func%", "%query%"), array(__FUNCTION__, $query), $pl["E_FUNC_SQLFAIL"])."\n".$cfg["error"];
    return false;
    }
  } // fin function link_add($usrn, $grpn, $DB)

function link_del($link, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($link) || empty($link[$db["tables"]["links"]["cols"]["user"]["name"]]) || empty($link[$db["tables"]["links"]["cols"]["group"]["name"]]) || empty($DB))
    {
    $cfg["error"] = str_replace("%func%", "link_del", $pl["E_FUNC_NOIN"]);
    return false;
    }
  if($link[$db["tables"]["links"]["cols"]["user"]["name"]] == $auth["usr"]["root"] && $link[$db["tables"]["links"]["cols"]["group"]["name"]] == $auth["grp"]["root"])
    {
    $cfg["error"] = str_replace("%func%", "link_del", $pl["E_FUNC_DELUGROOT"]);
    return false;
    }
  $query = "DELETE FROM ".$db["tables"]["links"]["table"]["name"]." WHERE ".$db["tables"]["links"]["cols"]["user"]["name"]."='".$link[$db["tables"]["links"]["cols"]["user"]["name"]]."' AND ".$db["tables"]["links"]["cols"]["group"]["name"]."='".$link[$db["tables"]["links"]["cols"]["group"]["name"]]."';";
  if(db_query($query, $DB))
    return true;
  else
    {
    $cfg["error"] = str_replace(array("%func%", "%query%"), array("link_del", $query)."\n".$cfg["error"]);
    return false;
    }
  } // fin function link_del($link, $DB)

function login($name, $pswd, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($name) || empty($pswd) || empty($DB))
    {
    $cfg["error"] = str_replace("%func%", "login", $pl["E_FUNC_NOIN"]);
    return false;
    }
  if($user = user_get($name, $DB))
    {
    if($user[$db["tables"]["users"]["cols"]["status"]["name"]] == $cfg["status"]["enable"])
      {
      if($user[$db["tables"]["users"]["cols"]["password"]["name"]] == $pswd)
        {
        if(!empty($auth[$cfg["auth_realm"]]))
          unset($auth[$cfg["auth_realm"]]);
        unset($user[$db["tables"]["users"]["cols"]["password"]["name"]]);
        $auth[$cfg["auth_realm"]] = $user;
        if(!empty($auth[$cfg["auth_realm"]]["grps"]))
          {
          $childs = array();
          foreach($auth[$cfg["auth_realm"]]["grps"] as $group)
            {
            $founds = group_getchilds($group, true, $DB);
            if(!empty($founds))
              $childs = array_merge(@$childs, $founds);
            }
          foreach($childs as $child)
            if(!empty($child))
              $auth[$cfg["auth_realm"]]["grps"][] = $child;
          $auth[$cfg["auth_realm"]]["grps"] = array_unique($auth[$cfg["auth_realm"]]["grps"]);
          }
        $auth[$cfg["auth_realm"]]["remote_addr"] = $_SERVER["REMOTE_ADDR"];
        $auth[$cfg["auth_realm"]]["server_name"] = $_SERVER["SERVER_NAME"];
        if(!empty($_SESSION["auth"]["referer"]))
          $auth[$cfg["auth_realm"]]["referer"]   = $_SESSION["auth"]["referer"];
        $_SESSION["auth"][$cfg["auth_realm"]]    = $auth[$cfg["auth_realm"]];
        return true;
        }
      else
        {
        $cfg["error"] = str_replace("%func%", "login", $pl["E_FUNC_WRONGPSWD"]);
        return false;
        }
      }
    else
      {
      $cfg["error"] = str_replace(array("%func%","%name%"), array("login",$name), $pl["E_FUNC_DISACC"]);
      return false;
      }
    }
  else
    {
    $cfg["error"] = str_replace(array("%func%","%name%"), array("login",$name), $pl["E_FUNC_NAMNEXIST"]);
    return false;
    }
  } // fin function login($name, $pswd, $DB)

function login_printfrm($_input)
  {
  global $auth, $db, $path, $pl;
  $return .= "<form action=\"".$_SERVER["SCRIPT_NAME"]."\" method=\"post\">\n";
  foreach($_input as $key => $val)
    if($key != $db["tables"]["users"]["cols"]["login"]["name"] && $key != $db["tables"]["users"]["cols"]["password"]["name"])
      $return .= "<input type=\"hidden\" name=\"$key\" value=\"$val\">\n";
  $return .= "<center>\n";
  $return .= "<table class=\"form\">\n";
  $return .= "<tr><td align=\"right\" class=\"form\">".$db["tables"]["users"]["cols"]["login"]["label"]."&nbsp;:</td><td align=\"left\" class=\"form\"><input type=\"text\" name=\"".$db["tables"]["users"]["cols"]["login"]["name"]."\" value=\"".@$_input[$db["tables"]["users"]["cols"]["login"]["name"]]."\" lenght=\"".$db["tables"]["users"]["cols"]["login"]["len"]."\"></td></tr>\n";
  $return .= "<tr><td align=\"right\" class=\"form\">".$db["tables"]["users"]["cols"]["password"]["label"]."&nbsp;:</td><td align=\"left\" class=\"form\"><input type=\"password\" name=\"".$db["tables"]["users"]["cols"]["password"]["name"]."\" value=\"\" lenght=\"".$db["tables"]["users"]["cols"]["password"]["len"]."\"></td></tr>\n";
  $return .= "<tr><td colspan=\"2\" align=\"center\" class=\"formbut\"><input type=\"submit\" value=\"".$pl["lab_send"]."\" class=\"button\"></td></tr>\n";
  $return .= "</table>\n";
  $return .= "</form>\n";
  return $return;
  } // fin function login_printfrm($_input)

function logout()
  {
  global $cfg;
  unset($GLOBALS["auth"]);
  unset($_SESSION["auth"][$cfg["auth_realm"]]);
  } // fin function logout()

function menu_create($menu)
  {
  if(empty($menu) or !is_array($menu))
    return "";
  $return = "<table class=\"menu\" cellspacing=\"0\" cellpadding=\"0\">\n";
  foreach($menu as $item)
    {
    switch($item["type"])
      {
      case "entry":
        $return .= "<tr><td class=\"menuentry\"><a class=\"menu\" href=\"".$item["link"]."\">".$item["text"]."</a></td></tr>\n";
        break;
      case "entrybold":
        $return .= "<tr><td class=\"menuentry\"><a class=\"menu\" href=\"".$item["link"]."\"><b>".$item["text"]."</b></a></td></tr>\n";
        break;
      case "entrywarning":
        $return .= "<tr><td class=\"menuentry\"><a class=\"menu\" style=\"color:red;\" href=\"".$item["link"]."\"><b>".$item["text"]."</b></a></td></tr>\n";
        break;
      case "head":
        $return .= "<tr><td class=\"menuhead\">".$item["text"]."</td></tr>\n";
        break;
      case "break":
        $return .= "<tr><td class=\"menubreak\">&nbsp;</td></tr>\n";
        break;
      };
    }
  $return .= "</table>\n";
  return $return;
  } // fin menu_create($menu)

function print_errormsg($msg)
  {
  global $cfg;
  $string = "<p class=\"errmsg\" style=\"font-style: italic;\">$msg.</p>\n";
  if(!empty($cfg["error"]))
    $string .= "<pre class=\"errmsg\">$cfg[error]</pre>";
  $cfg["error"] = "";
  return $string;
  } // fin function print_errormsg($msg)

function printfrm_conf($text, $_input)
  {
  global $path, $pl;
  $return = "<form action=\"".$_SERVER["SCRIPT_NAME"]."\" method=\"post\">\n";
  if(is_array($_input))
    {
    foreach($_input as $key => $val)
      $return .= "<input type=\"hidden\" name=\"$key\" value=\"$val\">\n";
    }
  $return .= "<input type=\"hidden\" name=\"conf\" value=\"yes\">\n";
  $return .= "<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\" class=\"form\" align=\"center\">\n";
  $return .= "<tr><td align=\"justify\" class=\"form\">".$text.". ".$pl["ask_confirm"]."</td></tr>\n";
  $return .= "<tr>";
  $return .= "<td align=\"center\" class=\"formbut\">";
  $return .= "<input class=\"button\" type=\"submit\" value=\"".$pl["lab_accept"]."\">";
  $return .= "&nbsp;&nbsp;&nbsp;";
  $return .= "<input class=\"button\" type=\"button\" onclick=\"javascript:location.href='".$path["auth_admin"]."?a=".$_input["a"]."'\" value=\"".$pl["lab_reject"]."\">";
  $return .= "</td>";
  $return .= "</tr>\n";
  $return .= "</table>\n";
  $return .= "</form>\n";
  return $return;
  } // fin function printfrm_conf($text, $_input)

function read_input()
  {
  if(isset($_REQUEST))
    return $_REQUEST;
  global $HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_COOKIE_VARS, $HTTP_POST_FILES;
  return @array_merge($HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_COOKIE_VARS, $HTTP_POST_FILES);
  } // fin function read_input()

function user_add($user, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($user) || empty($DB) || empty($user[$db["tables"]["users"]["cols"]["login"]["name"]]) || empty($user[$db["tables"]["users"]["cols"]["password"]["name"]]))
    {
    $cfg["error"] = str_replace("%func%", "user_add", $pl["E_FUNC_NOIN"]);
    return false;
    }
  $query = "SELECT ".$db["tables"]["users"]["cols"]["login"]["name"]." FROM ".$db["tables"]["users"]["table"]["name"]." WHERE ".$db["tables"]["users"]["cols"]["login"]["name"]."='".$user[$db["tables"]["users"]["cols"]["login"]["name"]]."';";
  if(db_query($query, $DB))
    {
    $cfg["error"] = str_replace(array("%func%","%name%"), array("user_add",$user[$db["tables"]["users"]["cols"]["login"]["name"]]), $pl["E_FUNC_NAMEXIST"])."\n".$cfg["error"];
    return false;
    }
  $query = "INSERT INTO ".$db["tables"]["users"]["table"]["name"]." SET\n";
  foreach($db["tables"]["users"]["cols"] as $col)
    $query .= " ".$col["name"]."='".$user[$col["name"]]."',";
  $query = preg_replace("/,$/", ";", $query);
  if(db_query($query, $DB))
    return true;
  else
    {
    $cfg["error"] = str_replace(array("%func%","%name%"), array("user_add",$user[$db["tables"]["users"]["cols"]["login"]["name"]]), $pl["E_FUNC_ADD"])."\n".$cfg["error"];
    return false;
    }
  } // function user_add($user, $DB)

function user_add_printfrm($_input)
  {
  global $auth, $db, $pl;
  $return = "";
  $return .= "<table class=\"form\" align=\"center\">\n";
  foreach($db["tables"]["users"]["cols"] as $col)
    {
    if($col["name"] == $db["tables"]["users"]["cols"]["password"]["name"])
      {
      $return .= "<tr><td align=\"right\" class=\"form\">".$pl["lab_passwd"]."&nbsp;:</td><td align=\"left\" class=\"form\"><input type=\"password\" name=\"passwd1\" size=\"".$col["len"]."\" maxlength=\"".$col["len"]."\" value=\"\"></td></tr>\n";
      $return .= "<tr><td align=\"right\" class=\"form\">".$pl["lab_confpasswd"]."&nbsp;:</td><td align=\"left\" class=\"form\"><input type=\"password\" name=\"passwd2\" size=\"".$col["len"]."\" maxlength=\"".$col["len"]."\" value=\"\"></td></tr>\n";
      $edits[] = "passwd1";
      $edits[] = "passwd2";
      }
    else
      {
      $return .= "<tr><td align=\"right\" class=\"form\">".$col["label"]."&nbsp;:</td><td align=\"left\" class=\"form\">";
      if(empty($col["values"]))
        $return .= "<input type=\"text\" name=\"".$col["name"]."\" size=\"".$col["len"]."\" maxlength=\"".$col["len"]."\" value=\"".@$_input[$col["name"]]."\">";
      else
        {
        $return .= "<select name=\"".$col["name"]."\">";
        foreach($col["values"] as $key => $val)
          $return .= "<option value=\"$key\">$val</option>";
        $return .= "</select>\n";
        }
      $return .= "</td></tr>\n";
      }
    $edits[] = $col["name"];
    }
  $return .= "<tr><td colspan=\"2\" class=\"formbut\"><input type=\"submit\" value=\"".$pl["lab_send"]."\" class=\"button\"></td></tr>\n";
  $return .= "</table>\n";
  $return .= "</form>\n";
  foreach($_input as $key => $val)
    if(!in_array($key, $edits))
      $return = "<input type=\"hidden\" name=\"$key\" value=\"$val\">\n".$return;
  $return = "<form action=\"".$_SERVER["SCRIPT_NAME"]."\" method=\"post\">\n".$return;
  return $return;
  } // fin function user_add_printfrm($_input)

function user_del($login, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($login) || empty($DB))
    {
    $cfg["error"] = str_replace("%func%", "user_del", $pl["E_FUNC_NOIN"]);
    return false;
    }
  if($login == $auth["usr"]["root"])
    {
    $cfg["error"] = str_replace(array("%func%", "%name%"), array("user_del", $login), $pl["E_FUNC_NODELA"]);
    return false;
    }
  if($user = user_get($login, $DB))
    {
    if(!empty($user["grps"]))
      {
      $query = "DELETE FROM ".$db["tables"]["links"]["table"]["name"]." WHERE ".$db["tables"]["links"]["cols"]["user"]["name"]."='".$login."';";
      if(!db_query($query, $DB))
        {
        $cfg["error"] = str_replace(array("%func%", "%name%"), array("user_del", $login), $pl["E_FUNC_NODELGU"]);
        return false;
        }
      }
    $query = "DELETE FROM ".$db["tables"]["users"]["table"]["name"]." WHERE ".$db["tables"]["users"]["cols"]["login"]["name"]."='".$login."';";
    if(db_query($query, $DB))
      return true;
    else
      {
      $cfg["error"] = str_replace(array("%func%", "%query%"), array("user_del", $query), $pl["E_FUNC_SQLFAIL"])."\n".$cfg["error"];
      return false;
      }
    }
  else
    {
    $cfg["error"] = str_replace(array("%func%", "%name%"), array("user_del", $login), $pl["E_FUNC_NAMNEXIST"]);
    return false;
    }
  } // fin function user_del($login, $DB)

function user_get($login, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($login) || empty($DB))
    {
    $cfg["error"] = str_replace("%func%", "user_get", $pl["E_FUNC_NOIN"]);
    return false;
    }
  $query = "SELECT * FROM ".$db["tables"]["users"]["table"]["name"]." WHERE ".$db["tables"]["users"]["cols"]["login"]["name"]."='".$login."';";
  if($result = db_query($query, $DB))
    {
    foreach($result[0] as $key => $val)
      $user[$key] = $val;
    $user["grps"] = user_getgroups($login, $DB);
    return $user;
    }
  else
    {
    $cfg["error"] = str_replace(array("%func%", "%query%"), array("user_get", $query), $pl["E_FUNC_SQLFAIL"])."\n".$cfg["error"];
    return false;
    }
  } // fin function user_get($login, $DB)

function user_getgroups($login, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($login) || empty($DB))
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]);
    return false;
    }
  $users = array();
  $query = "SELECT ".$db["tables"]["links"]["cols"]["group"]["name"]." FROM ".$db["tables"]["links"]["table"]["name"]." WHERE ".$db["tables"]["links"]["cols"]["user"]["name"]."='".$login."';";
  if($result = db_query($query, $DB))
    {
    foreach($result as $group)
      $users[] = $group[$db["tables"]["links"]["cols"]["group"]["name"]];
    return $users;
    }
  else
    {
    $cfg["error"] = str_replace(array("%func%", "%query%"), array(__FUNCTION__, $query), $pl["E_FUNC_SQLFAIL"])."\n".$cfg["error"];
    return false;
    }
  } // fin function user_getgroups($login, $DB)

function user_getgroupsdiff($login, $DB)
  { // BEGIN function user_getgroupsdiff
  if(empty($login) || empty($DB))
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]);
    return false;
    }
  if($grps = user_getgroups($login, $DB))
    return array_diff(groups_get($DB), $grps);
  else
    return groups_get($DB);
  } // END function user_getgroupsdiff

function user_print($user)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($user))
    {
    $cfg["error"] = "";
    return print_errormsg(str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]));
    }
  $return = "";
  $return .= "<table align=\"center\" class=\"form\">\n";
  foreach($db["tables"]["users"]["cols"] as $key => $col)
    {
    if($key == "password")
      continue;
    $return .= "<tr><td align=\"right\" class=\"form\"><em>".$col["label"]."</em>&nbsp;:</td><td align=\"justify\" class=\"form\">";
    if(empty($col["values"]))
      $return .= $user[$col["name"]];
    else
      $return .= $col["values"][$user[$col["name"]]];
    $return .= "</td></tr>\n";
    }
  $return .= "<tr>\n<td class=\"formlist\" colspan=\"2\">\n";
  if(empty($user["grps"]))
    $return .= "<p class=\"justify\" style=\"text-indent: 0;\">".str_replace("%user%",$user[$db["tables"]["users"]["cols"]["login"]["name"]],$pl["user_in_nogrp"]).".<p>\n";
  else
    {
    $return .= "<p class=\"justify\" style=\"text-indent: 0;\">".str_replace("%user%",$user[$db["tables"]["users"]["cols"]["login"]["name"]],$pl["user_in_grp"]).":\n";
    $return .= "<ul>\n";
    foreach($user["grps"] as $grp)
      {
      if(user_access($auth["grp"]["auth_admin"]))
        $return .= "<li><a class=\"list\" href=\"".$path["auth_grpshw"]."&".$db["tables"]["groups"]["cols"]["name"]["name"] ."=".$grp."\">".$grp."</a></li>\n";
      else
        $return .= "<li>".$grp."</li>\n";
      }
    $return .= "</ul>\n";
    $return .= "<p>\n";
    }
  $return .= "</td>\n</tr>\n</table>\n";
  return $return;
  } // fin function user_print($user)

function user_upd($user, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($user[$db["tables"]["users"]["cols"]["login"]["name"]]) || empty($DB))
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]);
    return false;
    }
  if(!user_get($user[$db["tables"]["users"]["cols"]["login"]["name"]], $DB))
    {
    $cfg["error"] = str_replace(array("%func%","%name%"), array(__FUNCTION__,$user[$db["tables"]["users"]["cols"]["login"]["name"]]), $pl["E_FUNC_NAMNEXIST"]);
    return false;
    }
  if($user[$db["tables"]["users"]["cols"]["login"]["name"]] == $auth["usr"]["root"])
    {
    $logged = user_logged();
    if($logged[$db["tables"]["users"]["cols"]["login"]["name"]] != $auth["usr"]["root"])
      {
      $cfg["error"] = str_replace(array("%func%","%name%"), array(__FUNCTION__,$auth["usr"]["root"]), $pl["E_FUNC_CANTUPD"]);
      return false;
      }
    }
  foreach($db["tables"]["users"]["cols"] as $col)
    {
    if($col["name"] == $db["tables"]["users"]["cols"]["login"]["name"])
      continue;
    if($col["name"] == $db["tables"]["users"]["cols"]["status"]["name"] && $user[$db["tables"]["users"]["cols"]["login"]["name"]] == $auth["usr"]["root"])
      {
      $updt[$col["name"]] == $cfg["status"]["enable"];
      continue;
      }
    if(!empty($user[$col["name"]]))
      $updt[$col["name"]] = $user[$col["name"]];
    }
  $query = "UPDATE ".$db["tables"]["users"]["table"]["name"]." SET ";
  foreach($updt as $key => $val)
    $query .= "$key='$val', ";
  $query = preg_replace("/, $/", "", $query);
  $query .= " WHERE ".$db["tables"]["users"]["cols"]["login"]["name"]."='".$user[$db["tables"]["users"]["cols"]["login"]["name"]]."';";
  if(db_query($query, $DB))
    return true;
  else
    {
    $cfg["error"] = str_replace(array("%func%", "%query%"), array(__FUNCTION__, $query), $pl["E_FUNC_SQLFAIL"])."\n".$cfg["error"];
    return false;
    }
  } // fin function user_upd($user, $DB)

function user_upd_printfrm($_input, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($_input[$db["tables"]["users"]["cols"]["login"]["name"]]) || empty($DB))
    {
    $cfg["error"] = "";
    return print_errormsg(str_replace("%func%", "user_upd_printfrm", $pl["E_FUNC_NOIN"]));
    }
  if($user = user_get($_input[$db["tables"]["users"]["cols"]["login"]["name"]], $DB))
    {
    $return = "";
    $return .= "<table class=\"form\" align=\"center\">\n";
    foreach($db["tables"]["users"]["cols"] as $col)
      {
      if($col["name"] == $db["tables"]["users"]["cols"]["password"]["name"])
        {
        $return .= "<tr><td align=\"right\" class=\"form\">".$pl["lab_passwd"]."&nbsp;:</td><td align=\"left\" class=\"form\"><input type=\"password\" name=\"passwd1\" size=\"".$col["len"]."\" maxlength=\"".$col["len"]."\" value=\"\"></td></tr>\n";
        $return .= "<tr><td align=\"right\" class=\"form\">".$pl["lab_confpasswd"]."&nbsp;:</td><td align=\"left\" class=\"form\"><input type=\"password\" name=\"passwd2\" size=\"".$col["len"]."\" maxlength=\"".$col["len"]."\" value=\"\"></td></tr>\n";
        if(isset($_input["passwd1"]))
          unset($_input["passwd1"]);
        if(isset($_input["passwd2"]))
          unset($_input["passwd2"]);
        }
      elseif($col["name"] == $db["tables"]["users"]["cols"]["login"]["name"])
        $return .= "<tr><td align=\"right\" class=\"form\">".$col["label"]."&nbsp;:</td><td align=\"left\" class=\"form\"><input type=\"hidden\" name=\"".$col["name"]."\" value=\"".$user[$col["name"]]."\">".$user[$col["name"]]."</td></tr>\n";
      else
        {
        $return .= "<tr><td align=\"right\" class=\"form\">".$col["label"]."&nbsp;:</td><td align=\"left\" class=\"form\">";
        if(empty($col["values"]))
          $return .= "<input type=\"text\" name=\"".$col["name"]."\" size=\"".$col["len"]."\" maxlength=\"".$col["len"]."\" value=\"".@$user[$col["name"]]."\">";
        else
          {
          $return .= "<select name=\"".$col["name"]."\">";
          foreach($col["values"] as $key => $val)
            if($user[$col["name"]] == $key)
              $return .= "<option value=\"$key\" selected>$val</option>";
            else
              $return .= "<option value=\"$key\">$val</option>";
          $return .= "</select>\n";
          }
        $return .= "</td></tr>\n";
        }
      if(isset($_input[$col["name"]]))
        unset($_input[$col["name"]]);
      }
    $return .= "<tr><td align=\"center\" colspan=\"2\" class=\"formbut\"><input class=\"button\" type=\"submit\" value=\"".$pl["lab_send"]."\"></td></tr>\n";
    $return .= "</table>\n";
    $return .= "</form>";
    $return ="<input type=\"hidden\" name=\"conf\" value=\"yes\">\n".$return;
    foreach($_input as $key => $val)
      $return ="<input type=\"hidden\" name=\"$key\" value=\"$val\">\n".$return;
    $return = "<form action=\"".$_SERVER["SCRIPT_NAME"]."\" method=\"post\">\n".$return;
    return $return;
    }
  else
    return print_errormsg(str_replace(array("%func%", "%name%"), array("user_upd_printfrm", $_input[$db["tables"]["users"]["cols"]["login"]["name"]]), $pl["E_FUNC_NAMNEXIST"]));
  } // fin function user_upd_printfrm($_input, $DB)

function users_get($DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($DB))
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]);
    return false;
    }
  $query = "SELECT ".$db["tables"]["users"]["cols"]["login"]["name"]." FROM ".$db["tables"]["users"]["table"]["name"]." ORDER BY ".$db["tables"]["users"]["cols"]["login"]["name"].";";
  if($results = db_query($query, $DB))
    {
    foreach($results as $result)
      $users[] = $result[$db["tables"]["users"]["cols"]["login"]["name"]];
    return $users;
    }
  else
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOUSER"])."\n".$cfg["error"];
    return false;
    }
  } // fin function users_get($DB)

function users_getigroups($DB)
  { // BEGIN function users_getigroups
  global $auth, $cfg, $db, $path, $pl;
  if(empty($DB))
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]);
    return false;
    }
  $query = "SELECT DISTINCT ".$db["tables"]["links"]["cols"]["user"]["name"]." FROM ".$db["tables"]["links"]["table"]["name"]." ORDER BY ".$db["tables"]["links"]["cols"]["user"]["name"].";";
  if($results = db_query($query, $DB))
    {
    foreach($results as $result)
      $users[] = $result[$db["tables"]["links"]["cols"]["user"]["name"]];
    return $users;
    }
  else
    {
    $cfg["error"] = str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOUSER"])."\n".$cfg["error"];
    return false;
    }
  } // END function users_getigroups

function users_print($_input, $DB)
  {
  global $auth, $cfg, $db, $path, $pl;
  if(empty($DB))
    {
    $cfg["error"] = "";
    return print_errormsg(str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOIN"]));
    }
  $return = "";
  if(empty($_input["users"]))
    $users = users_get($DB);
  else
    $users = $_input["users"];
  if(empty($users))
    return print_errormsg(str_replace("%func%", __FUNCTION__, $pl["E_FUNC_NOUSER"]));
  else
    {
    $return .= "<ul>\n";
    foreach($users as $user)
      {
      $return .= "<li><a class=\"list\" href=\"".$path["auth_admin"]."?a=".$_input["a"]."&".$db["tables"]["users"]["cols"]["login"]["name"]."=".$user;
      if(!empty($_input[$db["tables"]["groups"]["cols"]["name"]["name"]]))
        $return .= "&".$db["tables"]["groups"]["cols"]["name"]["name"]."=".$_input[$db["tables"]["groups"]["cols"]["name"]["name"]];
      if(!empty($_input["source"]))
        $return .= "&source=".$_input["source"];
      $return .= "\">".$user;
      if($userd = user_get($user, $DB))
        {
        if(!empty($userd[$db["tables"]["users"]["cols"]["name"]["name"]]))
          $return .= " (".$userd[$db["tables"]["users"]["cols"]["name"]["name"]].")";
        }
      $return .= "</a></li>\n";
      }
    $return .= "</ul>\n";
    return $return;
    }
  } // fin function users_print($_input, $DB)
/*- Fonctions - Fin ---------------------------------------------------------*/

/*- Formatage de la page - Début --------------------------------------------*/
$title_page = ":: ".$html["title_default"]." ::";
$html["top"]  = "<html>\n";
$html["top"] .= "<head>\n";
$html["top"] .= "<title>". strip_tags($title_page) . "</title>\n";
$html["top"] .= "<link rel=\"stylesheet\" href=\"$path[auth_css]\" />\n";
$html["top"] .= "<meta content=\"text/html; charset=UTF-8\" http-equiv=\"Content-Type\" />\n";
$html["top"] .= "</head>\n";
$html["top"] .= "<body>\n";
$html["top"] .= "<h1>$title_page</h1>\n";

$html["body"] = "";

$html["bottom"]  = "<hr>\n";
$html["bottom"] .= "<p class=\"copy\">:: &copy; ".$html["copy"]." :: version ".$html["version"]." ::</p>";
$html["bottom"] .= "</body>\n</html>\n";
/*- Formatage de la page - Fin ----------------------------------------------*/

/*- Programme principal - Début ---------------------------------------------*/
/*~ Debug ~ Début ~*/
// $html["body"] .= "<pre>\$_input = ".var_export($_input, true)."</pre>\n";
/*~ Debug ~ Fin ~*/

if(!empty($_input["a"]))
  {
  require_once("db_include.php");
  if($DB_auth = db_connect($db["connect"]["server"], $db["connect"]["login"], $db["connect"]["password"], $db["connect"]["db"]))
    {
    switch($_input["a"])
      {
      case "grp_add":
        if(user_access($auth["grp"]["auth_admin"]))
          {
          $html["body"] .= "<H2>:: ".$pl["head_grpcreate"]." ::</H2>\n";
          if(!empty($_input[$db["tables"]["groups"]["cols"]["name"]["name"]]))
            {
            if(isvalid_grpname($_input[$db["tables"]["groups"]["cols"]["name"]["name"]]))
              {
              if(group_add($_input, $DB_auth))
                $html["body"] .= "<p class=\"justify\">".str_replace("%name%", $_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $pl["create_success"]).".</p>\n";
              else
                $html["body"] .= print_errormsg(str_replace("%name%", $_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $pl["create_failed"]));
              }
            else
              $html["body"] .= print_errormsg($pl["invalidname"]);
            }
          $html["body"] .= "<h3>".$pl["datagrp2bcreate"]."</h3>\n";
          $html["body"] .= group_add_printfrm($_input, $DB_auth);
          $html["body"] .= "<h3>".$pl["lab_tree"]."</h3>\n";
          $html["body"] .= groups_printtree($_input, $DB_auth);
          }
        else
          $html["body"] .= print_errormsg(str_replace("%action%",htmlentities($_input["a"]),$pl["action_dont_exis"]));
        break; // case "grp_add":
      case "grp_del":
        if(user_access($auth["grp"]["auth_admin"]))
          {
          $html["body"] .= "<h2>:: ".$pl["head_grpdelete"]." ::</h2>\n";
          if(!empty($_input[$db["tables"]["groups"]["cols"]["name"]["name"]]))
            {
            if(isvalid_grpname($_input[$db["tables"]["groups"]["cols"]["name"]["name"]]))
              {
              if(empty($_input["conf"]))
                {
                $html["body"] .= "<h3>".$pl["delete_confifm"]."</h3>\n";
                $html["body"] .= printfrm_conf(str_replace("%name%", $_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $pl["ask_delete"]), $_input);
                }
              else
                {
                if(group_del($_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $DB_auth))
                  {
                  $html["body"] .= "<p class=\"justify\">".str_replace("%name%", $_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $pl["delete_success"]).".</p>\n";
                  unset($_input[$db["tables"]["groups"]["cols"]["name"]["name"]]);
                  }
                else
                  $html["body"] .= print_errormsg(str_replace("%name%", $_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $pl["delete_failed"]));
                }
              }
            else
              $html["body"] .= print_errormsg($pl["invalidname"]);
            }
          $html["body"] .= "<h3>".$pl["selectgrp2bdel"]."</h3>\n";
          $html["body"] .= groups_printtree($_input, $DB_auth);
          }
        else
          $html["body"] .= print_errormsg(str_replace("%action%",htmlentities($_input["a"]),$pl["action_dont_exis"]));
        break; // fin case "grp_del":
      case "grp_shw":
        if(user_access($auth["grp"]["auth_admin"]))
          {
          $html["body"] .= "<h2>:: ".$pl["head_viewgrpdata"]." ::</h2>\n";
          if(!empty($_input[$db["tables"]["groups"]["cols"]["name"]["name"]]))
            {
            if(isvalid_grpname($_input[$db["tables"]["groups"]["cols"]["name"]["name"]]))
              {
              $html["body"] .= "<h3>".str_replace("%name%", $_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $pl["details"])."</h3>\n";
              $group = group_get($_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $DB_auth);
              $group["childs"] = group_getchilds($_input[$db["tables"]["groups"]["cols"]["name"]["name"]], false, $DB_auth);
              $html["body"] .= group_print($group);
              }
            else
              $html["body"] .= print_errormsg($pl["invalidname"]);
            }
          $html["body"] .= "<h3>".$pl["grp_list"]."</h3>\n";
          $html["body"] .= groups_printtree($_input, $DB_auth);
          }
        else
          $html["body"] .= print_errormsg(str_replace("%action%",htmlentities($_input["a"]),$pl["action_dont_exis"]));
        break; // fin case "grp_shw":
      case "grp_upd":
        if(user_access($auth["grp"]["auth_admin"]))
          {
          $html["body"] .= "<h2>:: ".$pl["head_grpmodify"]." ::</h2>\n";
          if(!empty($_input[$db["tables"]["groups"]["cols"]["name"]["name"]]))
            {
            if(group_get($_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $DB_auth))
              {
              if(!empty($_input[$db["tables"]["groups"]["cols"]["parent"]["name"]]))
                {
                if(!group_get($_input[$db["tables"]["groups"]["cols"]["parent"]["name"]], $DB_auth))
                  {
                  $html["body"] .= print_errormsg(str_replace("%grp%", $_input[$db["tables"]["groups"]["cols"]["parent"]["name"]], $pl["upgrp_dontexist"]));
                  unset($_input["conf"]);
                  }
                }
              if(empty($_input["conf"]))
                {
                $html["body"] .= "<h3>".$pl["datagrp2bupdate"]."</h3>\n";
                $html["body"] .= group_upd_printfrm($_input, $DB_auth);
                }
              else
                {
                if(group_upd($_input, $DB_auth))
                  {
                  $html["body"] .= "<p>".str_replace("%name%", $_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $pl["update_success"])."</p>\n";
                  $html["body"] .= "<h3>".$pl["new_data_version"]."</h3>\n";
                  $group = group_get($_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $DB_auth);
                  $group["childs"] = group_getchilds($_input[$db["tables"]["groups"]["cols"]["name"]["name"]], false, $DB_auth);
                  $html["body"] .= group_print($group);
                  }
                else
                  {
                  $html["body"] .= print_errormsg(str_replace("%name%", $_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $pl["update_failed"]));
                  $html["body"] .= "<h3>".$pl["datagrp2bupdate"]."</h3>\n";
                  $html["body"] .= group_upd_printfrm($_input, $DB_auth);
                  }
                }
              }
            else
              $html["body"] .= print_errormsg(str_replace("%name%", $_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $pl["dont_exists"]));
            }
          $html["body"] .= "<h3>".$pl["selectgrp2bmod"]."</h3>\n";
          $html["body"] .= groups_printtree($_input, $DB_auth);
          }
        else
          $html["body"] .= print_errormsg(str_replace("%action%",htmlentities($_input["a"]),$pl["action_dont_exis"]));
        break; // fin case "grp_upd"
      case "init":
        if(user_access($auth["grp"]["root"]))
          {
          $html["body"] .= "<h2>:: ".$pl["head_init"]." ::</h2>\n";
          if(empty($_input["conf"]))
            $html["body"] .= printfrm_conf("<font color=\"red\"><b>".$pl["init_again"]."</b></font>", $_input);
          else
            {
            $_input["init_force"] = true;
            $html["body"] .= init($_input, $DB_auth);
            }
          }
        else
          {
          if($cfg["auth_init"])
            $html["body"] .= print_errormsg(str_replace("%action%",htmlentities($_input["a"]),$pl["action_dont_exis"]));
          else
            $html["body"] .= init($_input, $DB_auth);
          }
        break; // fin case "init":
      case "lnk_add":
        if(user_access($auth["grp"]["auth_admin"]))
          {
          $html["body"] .= "<h2>:: ".$pl["head_addusringrp"]." ::</h2>\n";
          $user  = user_get(@$_input[$db["tables"]["users"]["cols"]["login"]["name"]], $DB_auth);
          $group = group_get(@$_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $DB_auth);
          if($user && $group)
            {
            $link[$db["tables"]["links"]["cols"]["user"]["name"]] = $user[$db["tables"]["users"]["cols"]["login"]["name"]];
            $link[$db["tables"]["links"]["cols"]["group"]["name"]] = $group[$db["tables"]["groups"]["cols"]["name"]["name"]];
            if(link_add($link, $DB_auth))
              $html["body"] .= "<p class=\"justify\">".str_replace(array("%user%","%grp%"),array($user[$db["tables"]["users"]["cols"]["login"]["name"]],$group[$db["tables"]["groups"]["cols"]["name"]["name"]]), $pl["add_u2g_success"]).".</p>\n";
            else
              $html["body"] .= print_errormsg(str_replace(array("%user%","%grp%"), array($_input[$db["tables"]["users"]["cols"]["login"]["name"]],$_input[$db["tables"]["groups"]["cols"]["name"]["name"]]), $pl["add_u2g_failed"]));
            }
          if(@$_input["source"] == "users")
            {
            if($user = user_get($user[$db["tables"]["users"]["cols"]["login"]["name"]], $DB_auth))
              {
              $html["body"] .= "<h3>".$pl["datausr2bupdate"]."</h3>\n";
              $html["body"] .= user_print($user);
              $_input["groups"] = user_getgroupsdiff($user[$db["tables"]["users"]["cols"]["login"]["name"]],$DB_auth);
              $html["body"] .= "<h3>".$pl["selectgrp2aau"]."</h3>";
              if($_input["groups"])
                $html["body"] .= groups_print($_input, $DB_auth);
              else
                $html["body"] .= "<p>".str_replace("%user%", $user[$db["tables"]["users"]["cols"]["login"]["name"]], $pl["user_in_allgrp"])."</p>\n";
              }
            else
              {
              $html["body"] .= "<h3>".$pl["selectusr2baiag"]."</h3>";
              $_input["users"] = users_get($DB_auth);
              $html["body"] .= users_print($_input, $DB_auth);
              }
            }
          elseif(@$_input["source"] == "grps")
            {
            if($group = group_get($group[$db["tables"]["groups"]["cols"]["name"]["name"]], $DB_auth))
              {
              $html["body"] .= "<h3>".$pl["datagrp2bupdate"]."</h3>\n";
              $html["body"] .= group_print($group);
              $_input["users"] = group_getusersdiff($group[$db["tables"]["groups"]["cols"]["name"]["name"]],$DB_auth);
              $html["body"] .= "<h3>".$pl["selectusr2baiag"]."</h3>";
              if($_input["users"])
                $html["body"] .= users_print($_input, $DB_auth);
              else
                $html["body"] .= "<p>".str_replace("%grp%",$_input[$db["tables"]["groups"]["cols"]["name"]["name"]],$pl["grp_has_allusr"])."</p>\n";
              }
            else
              {
              $html["body"] .= "<h3>".$pl["selectgrp2aau"]."</h3>";
              $_input["users"] = groups_get($DB_auth);
              $html["body"] .= groups_print($_input, $DB_auth);
              }
            }
          }
        else
          $html["body"] .= print_errormsg(str_replace("%action%",htmlentities($_input["a"]),$pl["action_dont_exis"]));
        break; // fin case "lnk_add":
      case "lnk_del":
        if(user_access($auth["grp"]["auth_admin"]))
          {
          $html["body"] .= "<h2>:: ".$pl["head_rmusergrp"]." ::</h2>\n";
          $user  = user_get(@$_input[$db["tables"]["users"]["cols"]["login"]["name"]], $DB_auth);
          $group = group_get(@$_input[$db["tables"]["groups"]["cols"]["name"]["name"]], $DB_auth);
          if($user && $group)
            {
            $link[$db["tables"]["links"]["cols"]["user"]["name"]]  = $user[$db["tables"]["users"]["cols"]["login"]["name"]];
            $link[$db["tables"]["links"]["cols"]["group"]["name"]] = $group[$db["tables"]["groups"]["cols"]["name"]["name"]];
            if(link_del($link, $DB_auth))
              $html["body"] .= "<p class=\"justify\">".str_replace(array("%user%","%grp%"),array($user[$db["tables"]["users"]["cols"]["login"]["name"]],$group[$db["tables"]["groups"]["cols"]["name"]["name"]]),$pl["rmv_ufg_success"]).".</p>\n";
            else
              $html["body"] .= print_errormsg(str_replace(array("%user%","%grp%"),array($user[$db["tables"]["users"]["cols"]["login"]["name"]],$group[$db["tables"]["groups"]["cols"]["name"]["name"]]),$pl["rmv_ufg_failed"]));
            }
          if(@$_input["source"] == "users")
            {
            if($user = user_get($user[$db["tables"]["users"]["cols"]["login"]["name"]], $DB_auth))
              {
              $html["body"] .= "<h3>".$pl["datausr2bupdate"]."</h3>\n";
              $html["body"] .= user_print($user);
              $_input["groups"] = $user["grps"];
              $html["body"] .= "<h3>".str_replace("%user%",$user[$db["tables"]["users"]["cols"]["login"]["name"]],$pl["selectgrp2rtu"])."</h3>";
              if($_input["groups"])
                $html["body"] .= groups_print($_input, $DB_auth);
              else
                $html["body"] .= "<p>".str_replace("%user%", $user[$db["tables"]["users"]["cols"]["login"]["name"]], $pl["user_in_nogrp"])."</p>\n";
              }
            else
              {
              $html["body"] .= "<h3>".$pl["selectusr2brfag"].":</h3>";
              $_input["users"] = users_getigroups($DB_auth);
              if($_input["users"])
                $html["body"] .= users_print($_input, $DB_auth);
              else
                $html["body"] .= print_errormsg($pl["msg_undef"]);
              }
            }
          elseif(@$_input["source"] == "grps")
            {
            if($group = group_get($group[$db["tables"]["groups"]["cols"]["name"]["name"]], $DB_auth))
              {
              $html["body"] .= "<h3>".$pl["datagrp2bupdate"]."</h3>\n";
              $html["body"] .= group_print($group);
              $_input["users"] = $group["users"];
              $html["body"] .= "<h3>".str_replace("%grp%",$group[$db["tables"]["groups"]["cols"]["name"]["name"]],$pl["selectusr2brftg"]).":</h3>";
              if($_input["users"])
                $html["body"] .= users_print($_input, $DB_auth);
              else
                $html["body"] .= "<p>".str_replace("%grp%", $group[$db["tables"]["groups"]["cols"]["name"]["name"]], $pl["grp_has_nousr"])."</p>\n";
              }
            else
              {
              $html["body"] .= "<h3>".$pl["selectgrp2rau"].":</h3>";
              $_input["groups"] = groups_getwusers($DB_auth);
              if($_input["groups"])
                $html["body"] .= groups_print($_input, $DB_auth);
              else
                $html["body"] .= print_errormsg($pl["msg_undef"]);
              }
            }
          }
        else
          $html["body"] .= print_errormsg(str_replace("%action%",htmlentities($_input["a"]),$pl["action_dont_exis"]));
        break; // fin case "lnk_del":
      case "login":
        if(empty($_SESSION["auth"]["referer"]))
          $_SESSION["auth"]["referer"] = $_SERVER["HTTP_REFERER"];
        if(!empty($_input["redir"]))
          $path["auth_login_redir"] = $_input["redir"];
        $html["body"] .= "<h2>:: ".$pl["head_login"]." ::</h2>\n";
        if(empty($_input[$db["tables"]["users"]["cols"]["login"]["name"]]) || empty($_input[$db["tables"]["users"]["cols"]["password"]["name"]]))
          $html["body"] .= login_printfrm($_input);
        else
          {
          if($cfg["pswdencode"])
            $pswd = encode($_input[$db["tables"]["users"]["cols"]["password"]["name"]]);
          else
            $pswd = $_input[$db["tables"]["users"]["cols"]["password"]["name"]];
          if(login($_input[$db["tables"]["users"]["cols"]["login"]["name"]], $pswd, $DB_auth))
            {
            if(empty($path["auth_login_redir"]))
              {
              $user = user_logged();
              $html["body"] .= "<p class=\"justify\">".str_replace("%name%",$user[$db["tables"]["users"]["cols"]["name"]["name"]],$pl["hello"])."</p>\n";
              $html["body"] .= "<p class=\"center\"><a href=\"".$_SESSION["auth"]["referer"]."\">".$pl["return_site"]."</A></P>\n";
              unset($_SESSION["auth"]["referer"]);
              }
            else
              {
              unset($_SESSION["auth"]["referer"]);
              auth_page_call($path["auth_login_redir"]);
              }
            }
          else
            {
            $html["body"] .= print_errormsg($pl["auth_failed"]);
            $html["body"] .= login_printfrm($_input);
            }
          }
        break; // fin case "login":
      case "logout":
        if(!empty($_input["redir"]))
          $path["auth_logout_redir"] = $_input["redir"];
        logout();
        if(empty($path["auth_logout_redir"]))
          {
          $html["body"] .= "<h2>:: ".$pl["head_logout"]." ::</h2>\n";
          $html["body"] .= "<p class=\"justify\">".$pl["logged_out"]."</p>\n";
          $html["body"] .= "<p class=\"center\"><a href=\"".$path["index"]."\">".$pl["return_site"]."</a></p>\n";
          }
        else
          auth_page_call($path["auth_logout_redir"]);
        break; // fin case "logout":
      case "usr_add":
        if(user_access($auth["grp"]["auth_admin"]))
          {
          $html["body"] .= "<h2>:: ".$pl["head_usercreate"]." ::</h2>\n";
          if(!empty($_input[$db["tables"]["users"]["cols"]["login"]["name"]]) && !empty($_input["passwd1"]) && !empty($_input["passwd2"]))
            {
            if($_input["passwd1"] == $_input["passwd2"])
              {
              if($cfg["pswdencode"])
                $_input[$db["tables"]["users"]["cols"]["password"]["name"]] = encode($_input["passwd1"]);
              else
                $_input[$db["tables"]["users"]["cols"]["password"]["name"]] = $_input["passwd1"];
              unset($_input["passwd1"]);
              unset($_input["passwd2"]);
              if(user_add($_input, $DB_auth))
                {
                $html["body"] .= "<p class=\"justify\">".str_replace("%name%",$_input[$db["tables"]["users"]["cols"]["login"]["name"]],$pl["create_success"]).".</p>\n";
                $html["body"] .= "<h3>".str_replace("%name%", $_input[$db["tables"]["users"]["cols"]["login"]["name"]], $pl["details"])."</h3>\n";
                $html["body"] .= user_print(user_get($_input[$db["tables"]["users"]["cols"]["login"]["name"]],$DB_auth));
                }
              else
                $html["body"] .= print_errormsg(str_replace("%name%",$_input[$db["tables"]["users"]["cols"]["login"]["name"]],$pl["create_failed"]));
              }
            else
              print_errormsg($pl["passwd_mismatch"]);
            }
          $html["body"] .= "<h3>".$pl["datausr2bcreate"]."</h3>\n";
          $html["body"] .= user_add_printfrm($_input);
          $html["body"] .= "<h3>".$pl["users_list"]."</h3>\n";
          $html["body"] .= users_print($_input, $DB_auth);
          }
        else
          $html["body"] .= print_errormsg(str_replace("%action%",htmlentities($_input["a"]),$pl["action_dont_exis"]));
        break; // fin case "usr_add":
      case "usr_del":
        if(user_access($auth["grp"]["auth_admin"]))
          {
          $html["body"] .= "<h2>:: ".$pl["head_userdelete"]." ::</h2>\n";
          if(!empty($_input[$db["tables"]["users"]["cols"]["login"]["name"]]))
            {
            if(empty($_input["conf"]))
              {
              $html["body"] .= "<h3>".$pl["delete_confifm"]."</h3>\n";
              $html["body"] .= printfrm_conf(str_replace("%name%",$_input[$db["tables"]["users"]["cols"]["login"]["name"]],$pl["ask_delete"]), $_input);
              }
            else
              {
              if(user_del($_input[$db["tables"]["users"]["cols"]["login"]["name"]], $DB_auth))
                {
                $html["body"] .= "<p class=\"justify\">".str_replace("%name%",$_input[$db["tables"]["users"]["cols"]["login"]["name"]],$pl["delete_success"])."</p>\n";
                unset($_input[$db["tables"]["users"]["cols"]["login"]["name"]]);
                }
              else
                $html["body"] .= print_errormsg(str_replace("%name%",$_input[$db["tables"]["users"]["cols"]["login"]["name"]],$pl["delete_failed"]));
              }
            }
          $html["body"] .= "<h3>".$pl["selectusr2bdel"]."</h3>\n";
          $html["body"] .= users_print($_input, $DB_auth);
          }
        else
          $html["body"] .= print_errormsg(str_replace("%action%",htmlentities($_input["a"]),$pl["action_dont_exis"]));
        break; // fin case "usr_del":
      case "usr_shw":
        if($user = user_logged())
          {
          $html["body"] .= "<h2>:: ".$pl["head_viewusrdata"]." ::</h2>\n";
          if(!user_access($auth["grp"]["auth_admin"]))
            $_input[$db["tables"]["users"]["cols"]["login"]["name"]] = $user[$db["tables"]["users"]["cols"]["login"]["name"]];
          if(!empty($_input[$db["tables"]["users"]["cols"]["login"]["name"]]))
            {
            $html["body"] .= "<h3>".str_replace("%name%", $_input[$db["tables"]["users"]["cols"]["login"]["name"]], $pl["details"])."</h3>\n";
            $html["body"] .= user_print(user_get($_input[$db["tables"]["users"]["cols"]["login"]["name"]], $DB_auth));
            }
          if(user_access($auth["grp"]["auth_admin"]))
            {
            $html["body"] .= "<h3>".$pl["users_list"]."</h3>\n";
            $html["body"] .= users_print($_input, $DB_auth);
            }
          }
        else
          $html["body"] .= print_errormsg(str_replace("%action%",htmlentities($_input["a"]),$pl["action_dont_exis"]));
        break; // fin case "usr_shw":
      case "usr_upd":
        if($user = user_logged())
          {
          $html["body"] .= "<h2>:: ".$pl["head_usermodify"]." ::</h2>\n";
          if(!user_access($auth["grp"]["auth_admin"]))
            $_input[$db["tables"]["users"]["cols"]["login"]["name"]] = $user[$db["tables"]["users"]["cols"]["login"]["name"]];
          if(!empty($_input[$db["tables"]["users"]["cols"]["login"]["name"]]))
            {
            if(empty($_input["conf"]))
              {
              $html["body"] .= "<h3>".$pl["datausr2bupdate"]."</h3>\n";
              $html["body"] .= user_upd_printfrm($_input, $DB_auth);
              }
            else
              {
              if($_input["passwd1"] == $_input["passwd1"])
                {
                if($cfg["pswdencode"])
                  $_input[$db["tables"]["users"]["cols"]["password"]["name"]] = encode($_input["passwd1"]);
                else
                  $_input[$db["tables"]["users"]["cols"]["password"]["name"]] = $_input["passwd1"];
                unset($_input["passwd1"]);
                unset($_input["passwd2"]);
                if(user_upd($_input, $DB_auth))
                  {
                  $html["body"] .= "<p class=\"justify\">".str_replace("%name%",$_input[$db["tables"]["users"]["cols"]["login"]["name"]],$pl["update_success"])."</p>\n";
                  $html["body"] .= "<h3>".$pl["new_data_version"].":</h3>\n";
                  $html["body"] .= user_print(user_get($_input[$db["tables"]["users"]["cols"]["login"]["name"]], $DB_auth));
                  }
                else
                  {
                  $html["body"] .= print_errormsg(str_replace("%name%",$_input[$db["tables"]["users"]["cols"]["login"]["name"]],$pl["update_failed"]));
                  $html["body"] .= "<h3>".$pl["datausr2bupdate"]."</h3>\n";
                  $html["body"] .= user_upd_printfrm($_input, $DB_auth);
                  }
                }
              else
                print_errormsg($pl["passwd_mismatch"]);
              }
            }
          if(user_access($auth["grp"]["auth_admin"]))
            {
            $html["body"] .= "<h3>".$pl["selectusr2bmod"]."</h3>\n";
            $html["body"] .= users_print($_input, $DB_auth);
            }
          }
        else
            $html["body"] .= print_errormsg(str_replace("%action%",htmlentities($_input["a"]),$pl["action_dont_exis"]));
        break; // fin case "usr_upd":
      default:
        $html["body"] .= print_errormsg(str_replace("%action%",htmlentities($_input["a"]),$pl["action_dont_exis"]));
      }
    db_close($DB_auth);
    }
  else
    $html["body"] .= print_errormsg($pl["db_connect_fail"]);
  }
/*- Programme principal - Fin -----------------------------------------------*/

/*- Création du menu - Début ------------------------------------------------*/
$html["menu"] = "";
unset($menu);
$i=0;
$menu[$i]["type"] = "entrybold";
$menu[$i]["text"] = $pl["lab_index"];
$menu[$i]["link"] = $path["index"];
$i++;
$menu[$i]["type"] = "break";
$i++;
$menu[$i]["type"] = "entry";
$menu[$i]["text"] = $pl["lab_uadmin"];
$menu[$i]["link"] = $path["auth_admin"];
if($user = user_logged())
  {
  $i++;
  $menu[$i]["type"] = "break";
  $i++;
  $menu[$i]["type"] = "head";
  $menu[$i]["text"] = $pl["lab_users"];
  $i++;
  $menu[$i]["type"] = "entry";
  $menu[$i]["text"] = $pl["lab_show"];
  $menu[$i]["link"] = $path["auth_usrshw"];
  if(user_access($auth["grp"]["auth_admin"]))
    {
    $i++;
    $menu[$i]["type"] = "entry";
    $menu[$i]["text"] = $pl["lab_create"];
    $menu[$i]["link"] = $path["auth_usradd"];
    }
  $i++;
  $menu[$i]["type"] = "entry";
  $menu[$i]["text"] = $pl["lab_modify"];
  $menu[$i]["link"] = $path["auth_usrupd"];
  if(!empty($_input[$db["tables"]["users"]["cols"]["login"]["name"]]))
    $menu[$i]["link"] .= "&".$db["tables"]["users"]["cols"]["login"]["name"]."=".$_input[$db["tables"]["users"]["cols"]["login"]["name"]];
  if(user_access($auth["grp"]["auth_admin"]))
    {
    $i++;
    $menu[$i]["type"] = "entry";
    $menu[$i]["text"] = $pl["lab_delete"];
    $menu[$i]["link"] = $path["auth_usrdel"];
    if(!empty($_input[$db["tables"]["users"]["cols"]["login"]["name"]]))
      $menu[$i]["link"] .= "&".$db["tables"]["users"]["cols"]["login"]["name"]."=".$_input[$db["tables"]["users"]["cols"]["login"]["name"]];
    $i++;
    $menu[$i]["type"] = "entry";
    $menu[$i]["text"] = $pl["lab_addgrp"];
    $menu[$i]["link"] = $path["auth_lnkadd"];
    if(!empty($_input[$db["tables"]["users"]["cols"]["login"]["name"]]))
      $menu[$i]["link"] .= "&".$db["tables"]["users"]["cols"]["login"]["name"]."=".$_input[$db["tables"]["users"]["cols"]["login"]["name"]];
    $menu[$i]["link"] .= "&source=users";
    $i++;
    $menu[$i]["type"] = "entry";
    $menu[$i]["text"] = $pl["lab_delgrp"];
    $menu[$i]["link"] = $path["auth_lnkdel"];
    if(!empty($_input[$db["tables"]["users"]["cols"]["login"]["name"]]))
      $menu[$i]["link"] .= "&".$db["tables"]["users"]["cols"]["login"]["name"]."=".$_input[$db["tables"]["users"]["cols"]["login"]["name"]];
    $menu[$i]["link"] .= "&source=users";
    $i++;
    $menu[$i]["type"] = "break";
    $i++;
    $menu[$i]["type"] = "head";
    $menu[$i]["text"] = $pl["lab_grps"];
    $i++;
    $menu[$i]["type"] = "entry";
    $menu[$i]["text"] = $pl["lab_show"];
    $menu[$i]["link"] = $path["auth_grpshw"];
    $i++;
    $menu[$i]["type"] = "entry";
    $menu[$i]["text"] = $pl["lab_create"];
    $menu[$i]["link"] = $path["auth_grpadd"];
    $i++;
    $menu[$i]["type"] = "entry";
    $menu[$i]["text"] = $pl["lab_modify"];
    $menu[$i]["link"] = $path["auth_grpupd"];
    if(!empty($_input[$db["tables"]["groups"]["cols"]["name"]["name"]]))
      $menu[$i]["link"] .= "&".$db["tables"]["groups"]["cols"]["name"]["name"]."=".$_input[$db["tables"]["groups"]["cols"]["name"]["name"]];
    $i++;
    $menu[$i]["type"] = "entry";
    $menu[$i]["text"] = $pl["lab_delete"];
    $menu[$i]["link"] = $path["auth_grpdel"];
    if(!empty($_input[$db["tables"]["groups"]["cols"]["name"]["name"]]))
      $menu[$i]["link"] .= "&".$db["tables"]["groups"]["cols"]["name"]["name"]."=".$_input[$db["tables"]["groups"]["cols"]["name"]["name"]];
    $i++;
    $menu[$i]["type"] = "entry";
    $menu[$i]["text"] = $pl["lab_adduser"];
    $menu[$i]["link"] = $path["auth_lnkadd"];
    if(!empty($_input[$db["tables"]["groups"]["cols"]["name"]["name"]]))
      $menu[$i]["link"] .= "&".$db["tables"]["groups"]["cols"]["name"]["name"]."=".$_input[$db["tables"]["groups"]["cols"]["name"]["name"]];
    $menu[$i]["link"] .= "&source=grps";
    $i++;
    $menu[$i]["type"] = "entry";
    $menu[$i]["text"] = $pl["lab_deluser"];
    $menu[$i]["link"] = $path["auth_lnkdel"];
    if(!empty($_input[$db["tables"]["groups"]["cols"]["name"]["name"]]))
      $menu[$i]["link"] .= "&".$db["tables"]["groups"]["cols"]["name"]["name"]."=".$_input[$db["tables"]["groups"]["cols"]["name"]["name"]];
    $menu[$i]["link"] .= "&source=grps";
    }
  $i++;
  $menu[$i]["type"] = "break";
  if(user_access($auth["grp"]["root"]))
    {
    $i++;
    $menu[$i]["type"] = "entrywarning";
    $menu[$i]["text"] = $pl["lab_init"];
    $menu[$i]["link"] = $path["auth_admin"]."?a=init";
    $i++;
    $menu[$i]["type"] = "break";
    }
  $i++;
  $menu[$i]["type"] = "head";
  $menu[$i]["text"] = $pl["lab_logged"];
  $i++;
  $menu[$i]["type"] = "entry";
  $menu[$i]["text"] = $user[$db["tables"]["users"]["cols"]["name"]["name"]];
  $menu[$i]["link"] = $path["auth_usrshw"]."&".$db["tables"]["users"]["cols"]["login"]["name"]."=".$user[$db["tables"]["users"]["cols"]["login"]["name"]];
  $i++;
  $menu[$i]["type"] = "break";
  $i++;
  $menu[$i]["type"] = "entry";
  $menu[$i]["text"] = $pl["lab_logout"];
  $menu[$i]["link"] = $path["logout"];
  }
else
  {
  $i++;
  $menu[$i]["type"] = "entry";
  $menu[$i]["text"] = $pl["lab_login"];
  $menu[$i]["link"] = $path["login"];
  }

if(isset($menu))
  {
  $html["menu"] .= menu_create($menu);
  $html["top"] .= "<table width=\"100%\">\n<tr>\n<td valign=\"top\">\n".$html["menu"]."</td>\n<td valign=\"top\" width=\"100%\">\n";
  $html["bottom"] = "</td>\n</tr>\n</table>\n" . $html["bottom"];
  }
/*- Création du menu - Fin --------------------------------------------------*/

/*- Affichage page - Début --------------------------------------------------*/
echo $html["top"];
echo $html["body"];
echo $html["bottom"];
/*- Affichage page - Fin ----------------------------------------------------*/
?>
