<?php
/**
 * Securimage Test Script
 * Version 3.1 - 2012-04-06
 *
 * Envoyez ce script PHP sur votre serveur web et affichez le dans votre navigateur.
 * Ce script vous montre si vous avez la configuration ncessaire pour faire fonctionner Securimage.
 * Il vrifie aussi les problmes existant avec les sessions PHP qui pourrait empcher Securimage de fonctionner correctement.
 *
 * http://www.phpcaptcha.org
 *
 * traduit et amlior par aventurier19 - 2012-06-14
 */

$error_php = rand(4,9);
$error_session = rand(4,9);
 
if (version_compare(PHP_VERSION, '4.3.0', '>=') && version_compare(PHP_VERSION, '5.2.0', '<'))
	$error_php = 1;
elseif (version_compare(PHP_VERSION, '4.3.0', '<'))
	$error_php = 2;

$GLOBALS['session_start_error'] = null;

$level = error_reporting(0);
set_error_handler('session_error_handler', E_ALL);

session_name('securimage_test');
$sessionStarted = @session_start();

restore_error_handler();

session_test();


if (isset($_GET['testimage']) && $_GET['testimage'] == '1') {
    $im    = imagecreate(225, 225);
    $white = imagecolorallocate($im, 255, 255, 255);
    $black = imagecolorallocate($im,   0,   0,   0);
    $red   = imagecolorallocate($im, 255,   0,   0);
    $green = imagecolorallocate($im,   0, 255,   0);
    $blue  = imagecolorallocate($im,   0,   0, 255);

    // dessin de la tte
    imagearc($im, 100, 120, 200, 200,  0, 360, $black);

    // bouche
    imagearc($im, 100, 120, 150, 150, 25, 155, $red);

    // oeil gauche et aprs oeil droit
    imagearc($im,  60,  95,  50,  50,  0, 360, $green);
    imagearc($im, 140,  95,  50,  50,  0, 360, $blue);
    imagestring($im, 5, 1, 1, 'Securimage fonctionnera', $blue);
    imagestring($im, 5, 1, 3, '________ ______________', $blue);
    imagestring($im, 2, 5, 20, ':) :) :)', $black);
    imagestring($im, 2, 5, 30, ':) :)', $black);
    imagestring($im, 2, 5, 40, ':)', $black);
    imagestring($im, 2, 150, 20, '(: (: (:', $black);
    imagestring($im, 2, 168, 30, '(: (:', $black);
    imagestring($im, 2, 186, 40, '(:', $black);
    
    header('Content-type: image/png');
    imagepng($im, null, 3);
    exit;
}

function session_test()
{
	if (!isset($_GET['testimage'])) {
		if (isset($_GET['tested'])) {
			if (!isset($_SESSION['securimage_test_value'])) {
				$GLOBALS['session_start_error'] = 
					'La session a &eacute;t&eacute; d&eacute;marr&eacute;e avec succ&egrave;s, mais la valeur de test '
				   .'n\'a pas &eacute;t&eacute; trouv&eacute;e<br />Assurez-vous que les cookies sont autoris&eacute;s '
				   .'dans votre navigateur.<br />Cliquez <a href="securimage_test.php" target="_self">ici</a> pour refaire le test.<br /><br />';
			}
		}
		else {
			if ($GLOBALS['session_start_error'] != null)
				$error_session = 2;
			
			$_SESSION['securimage_test_value'] = 'test';
			header('Location: ' . $_SERVER['PHP_SELF'] . '?tested=1');
		}
	}
}

function print_status($supported)
{
    if ($supported) {
         echo "<span style=\"color: #00f\">Oui !</span>";
    } else {
        echo "<span style=\"color: #f00; font-weight: bold\">Non</span>";
    }
}

function session_error_handler($errno, $errstr, $errfile, $errline)
{
	$GLOBALS['session_start_error'] = $errstr;
	return true;
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Script de test Securimage</title>
<style type="text/css">
	<!--
	a {
		color:#000;
	}
	-->
</style>
</head>
<body>
<h2>Bilan du script de test Securimage</h2>
<p>Ce script va tester la configuration de votre installation PHP pour voir si Securimage peut fonctionner sur votre serveur.</p>
<ul>
<li><strong>Version de PHP :</strong>
<?php print_status(version_compare(PHP_VERSION, '4.3.0', '>=')) ?>
<?php if (version_compare(PHP_VERSION, '5.2.0', '<')): ?>
<br /><span style="color: #f00">Il serait souhaitable de mettre &agrave; jour vers une version 5.2.0 ou plus de PHP.</span>
<br />
<?php endif; ?></li>
<li><strong>Test des Sessions :</strong>
<?php print_status($GLOBALS['session_start_error'] == null); ?>
<?php if ($GLOBALS['session_start_error'] != null) {
	$error_session = 1;
	echo '<br /><span style="color: #f00">Il peut y avoir un probl&egrave;me avec le support de session.</span><br />';
} ?></li>
<li><strong>Support de la librairie graphique GD :</strong>
<?php print_status($gd_support = extension_loaded('gd')); ?>
</li>
<?php if ($gd_support) $gd_info = gd_info(); else $gd_info = array(); ?>
<?php if ($gd_support): ?>
<li><strong>Version de la librairie graphique GD :</strong>
<?php echo "<span style=\"color: #00f\">".$gd_info['GD Version']."</span>"; ?></li>
<?php endif; ?>
<li><strong>Fonction imageftbbox :</strong>
<?php print_status(function_exists('imageftbbox')); ?>
<?php if (function_exists('imageftbbox') == false): ?>
<br />La fonction <a href="http://php.net/imageftbbox" target="_new">imageftbbox()</a> n'est pas incluse dans votre librairie gd.  Cette fonction est n&eacute;cessaire.
<?php endif; ?></li>
<li><strong>Support TTF(FreeType):</strong>
<?php print_status($gd_support && $gd_info['FreeType Support']); ?>
<?php if ($gd_support && $gd_info['FreeType Support'] == false): ?>
<br />Pas de support FreeType.  Vous ne pouvez pas utiliser Securimage 3.0, mais la version 2.0 avec les polices gd.
<?php endif; ?></li>
<li><strong>Support JPEG :</strong>
<?php print_status($gd_support && ((isset($gd_info['JPG Support']) || isset($gd_info['JPEG Support'])))); ?></li>
<li><strong>Support PNG :</strong>
<?php print_status($gd_support && $gd_info['PNG Support']); ?></li>
<li><strong>Support de la lecture de GIF :</strong>
<?php print_status($gd_support && $gd_info['GIF Read Support']); ?></li>
<li><strong>Support de la cr&eacute;ation de GIF :</strong>
<?php print_status($gd_support && $gd_info['GIF Create Support']); ?></li>
<li><strong>Support SQLite:</strong>
<?php print_status(function_exists('sqlite_open')); ?><br />
<span style="color: #00f">
<?php if (function_exists('sqlite_open')): ?>
SQLite est disponible.  Si vous choisissez de l'utiliser, Securimage autorisera les utilisateurs qui n'accepte pas les cookies.
<?php else: ?>
Pas de support SQLite. Securimage fonctionnera mais vos visiteurs devront accepter les cookies.
<?php endif; ?>
</span>
</li>
</ul>

<?php if ($gd_support && function_exists('imageftbbox')): ?>
<?php if ($GLOBALS['session_start_error'] != null): ?>
<span style="color: #f73"><b>Il s'agit d'un avertissement, cependant vous r&eacute;pondez aux exigences pour l'utilisation de Securimage.</b></span>
<?php else: ?>
<span style="color: #f73"><b>Votre serveur poss&egrave;de la configuration n&eacute;cessaire au bon fonctionnement de Securimage !</b></span>
<?php endif; ?>
<br /><br />
<img src="<?php echo $_SERVER['PHP_SELF']; ?>?testimage=1" alt="Test Image" align="bottom" />
<?php else: ?>
<span style="color: #f73"><b>Sur la base des exigences, vous n'avez pas ce qu'il faut pour excuter Securimage :(</b></span>
<?php endif; ?>
<hr />
<u><b>Remarque<?php if (($error_php == 1 || $error_php == 2) && ($error_session == 1 || $error_session == 2)) echo "s :"; else echo " :"; ?></b></u><br />

<?php
if ($error_php + $error_session < 8) {
	if ($error_php == 1)
		echo 'Il est conseill&eacute; d\'utiliser PHP 5.2.0 ou plus pour faire fonctionner Securimage de fa&ccedil;on '
			.'optimale. Vous utilisez la version ' . PHP_VERSION . ' qui est trop ancienne.<br />Essayez de mettre '
			.'&agrave; jour dans une version plus r&eacute;cente, une version plus s&eacute;curis&eacute;e de PHP.<br />'
			.'Sinon vous pouvez utiliser Securimage 2.0 (<a href="http://www.phpcaptcha.org/securimage-2.0.2.zip">zip'
			.'</a> - <a href="http://www.phpcaptcha.org/securimage-2.0.2.tar.gz">tar.gz</a>), mais aucune maintenance '
			.'ne sera faite pour cette version.<br /><br />';
	elseif ($error_php == 2)
		echo 'Securimage requiert PHP 5.2.0 ou plus pour fonctionner. Vous utilisez '
			.'la version' . PHP_VERSION . ' qui est trop ancienne.  Essayez de mettre &agrave; '
			.'jour dans une version plus r&eacute;cente, une version plus s&eacute;curis&eacute;e de PHP.<br /<br />'
			.'Sinon vous pouvez utiliser Securimage 2.0 (<a href="http://www.phpcaptcha.org/securimage-2.0.2.zip">zip'
			.'</a> - <a href="http://www.phpcaptcha.org/securimage-2.0.2.tar.gz">tar.gz</a>), mais aucune maintenance '
			.'ne sera faite pour cette version.<br /><br />';
	if ($error_session == 1)
		echo $GLOBALS['session_start_error'];
	elseif ($error_session == 2)
		echo '<strong>Impossible de d&eacutemarrer une session PHP.</strong><br /><br />'
			.'La <a href="http://php.net/sessions" target="_blank">session</a>'
			.' n\'a pas d&eacute;marr&eacute; correctement.  Cela peut indiquer un probl&egrave;me dans '
			.'la configuration PHP sur le serveur.<br /><br />'
			.'L\'erreur suivante s\'est produite lors de la tentative d\'appeler <i>session_start()</i>:<br />'
			.'<pre style="margin: 25px">' . htmlspecialchars($GLOBALS['session_start_error']) . '</pre>'
			.'<span style="color: #f00">Pour que Securimage fonctionne, vous '
			.'devez corriger cette erreur.</span><br /><br />'
			.'Si apr&egrave;s avoir rechercher sur <a href="http://www.google.fr" target="_blank">Google</a> '
			.'et <a href="http://stackoverflow.com/search" target="_blank">StackOverflow</a> '
			.'pour r&eacute;parer le probl&egrave;me, vous avez toujours l\'erreur contactez '
			.'<a href="http://phpcaptcha.org/contact" target="_blank">les developpeurs</a> '
			.'de Securimage pour une assistance (en anglais).<br />Fournissez autant d\'information que possible sur le probl&egraveme '
			.' et l\'erreur, pour que nous puissions vous aider &agrave; le r&eacute;soudre.';
}
else 
	echo "Aucune remarque &agrave; ajouter";
?>
<div align="center"> Traduit et mis en page par <strong>aventurier19</strong></div>
</body>
</html>
