<?php

$nbdatabits = array(
1=>array('L'=>152,'M'=>128,'Q'=>104,'H'=>72),
2=>array('L'=>272,'M'=>224,'Q'=>176,'H'=>128),
3=>array('L'=>440,'M'=>352,'Q'=>272,'H'=>208),
4=>array('L'=>640,'M'=>512,'Q'=>384,'H'=>288),
5=>array('L'=>864,'M'=>688,'Q'=>496,'H'=>368),
6=>array('L'=>1088,'M'=>864,'Q'=>608,'H'=>480),
7=>array('L'=>1248,'M'=>992,'Q'=>704,'H'=>528),
8=>array('L'=>1552,'M'=>1232,'Q'=>880,'H'=>688),
9=>array('L'=>1856,'M'=>1456,'Q'=>1056,'H'=>800),
10=>array('L'=>2192,'M'=>1728,'Q'=>1232,'H'=>976),
11=>array('L'=>2592,'M'=>2032,'Q'=>1440,'H'=>1120),
12=>array('L'=>2960,'M'=>2320,'Q'=>1648,'H'=>1264),
13=>array('L'=>3424,'M'=>2672,'Q'=>1952,'H'=>1440),
14=>array('L'=>3688,'M'=>2920,'Q'=>2088,'H'=>1576),
15=>array('L'=>4184,'M'=>3320,'Q'=>2360,'H'=>1784),
16=>array('L'=>4712,'M'=>3624,'Q'=>2600,'H'=>2024),
17=>array('L'=>5176,'M'=>4056,'Q'=>2936,'H'=>2264),
18=>array('L'=>5768,'M'=>4504,'Q'=>3176,'H'=>2504),
19=>array('L'=>6360,'M'=>5016,'Q'=>3560,'H'=>2728),
20=>array('L'=>6888,'M'=>5352,'Q'=>3880,'H'=>3080),
21=>array('L'=>7456,'M'=>5712,'Q'=>4096,'H'=>3248),
22=>array('L'=>8048,'M'=>6256,'Q'=>4544,'H'=>3536),
23=>array('L'=>8752,'M'=>6880,'Q'=>4912,'H'=>3712),
24=>array('L'=>9392,'M'=>7312,'Q'=>5312,'H'=>4112),
25=>array('L'=>10208,'M'=>8000,'Q'=>5744,'H'=>4304),
26=>array('L'=>10960,'M'=>8496,'Q'=>6032,'H'=>4768),
27=>array('L'=>11744,'M'=>9024,'Q'=>6464,'H'=>5024),
28=>array('L'=>12248,'M'=>9544,'Q'=>6968,'H'=>5288),
29=>array('L'=>13048,'M'=>10136,'Q'=>7288,'H'=>5608),
30=>array('L'=>13880,'M'=>10984,'Q'=>7880,'H'=>5960),
31=>array('L'=>14744,'M'=>11640,'Q'=>8264,'H'=>6344),
32=>array('L'=>15640,'M'=>12328,'Q'=>8920,'H'=>6760),
33=>array('L'=>16568,'M'=>13048,'Q'=>9368,'H'=>7208),
34=>array('L'=>17528,'M'=>13800,'Q'=>9848,'H'=>7688),
35=>array('L'=>18448,'M'=>14496,'Q'=>10288,'H'=>7888),
36=>array('L'=>19472,'M'=>15312,'Q'=>10832,'H'=>8432),
37=>array('L'=>20528,'M'=>15936,'Q'=>11408,'H'=>8768),
38=>array('L'=>21616,'M'=>16816,'Q'=>12016,'H'=>9136),
39=>array('L'=>22496,'M'=>17728,'Q'=>12656,'H'=>9776),
40=>array('L'=>23648,'M'=>18672,'Q'=>13328,'H'=>10208)
);

echo '<pre>';
print_r($nbdatabits);
echo '</pre>';
exit();

$qr['version'] = 1;
$qr['mode'] = 2;
$cci_size = 0;

 


//Mode Indicator :  1 Numeric, 2 Alphanumeric, 4 Byte, 8 Kanji
function Set_mode(){
	global $qr;
	global $cci_size;

	if(!isset($qr['mode'])){
		$qr['mode'] = 1;
	}
	if ($qr['mode'] == 1){
		$data_mode = "0001";
		if ($qr['version'] >= 1 and $qr['version'] <= 9){
			$cci_size = 10;
		}elseif ($qr['version'] >= 10 and $qr['version'] <= 26){
			$cci_size = 12;
		}elseif ($qr['version'] >= 27 and $qr['version'] <= 40){
			$cci_size = 14;
		}	
	}elseif ($qr['mode'] == 2){
		$data_mode = "0010";
		if ($qr['version'] >= 1 and $qr['version'] <= 9){
			$cci_size = 9;
		}elseif ($qr['version'] >= 10 and $qr['version'] <= 26){
			$cci_size = 11;
		}elseif ($qr['version'] >= 27 and $qr['version'] <= 40){
			$cci_size = 13;
		}
	}elseif ($qr['mode'] == 4){
		$data_mode = "0100";
		if ($qr['version'] >= 1 and $qr['version'] <= 9){
			$cci_size = 8;
		}elseif ($qr['version'] >= 10 and $qr['version'] <= 26){
			$cci_size = 16;
		}elseif ($qr['version'] >= 27 and $qr['version'] <= 40){
			$cci_size = 16;
		}
	}elseif ($qr['mode'] == 8){
		$data_mode = "1000";
		if ($qr['version'] >= 1 and $qr['version'] <= 9){
			$cci_size = 8;
		}elseif ($qr['version'] >= 10 and $qr['version'] <= 26){
			$cci_size = 10;
		}elseif ($qr['version'] >= 27 and $qr['version'] <= 40){
			$cci_size = 12;
		}	
	}
}

$x = 1;
for($z=0; $z< count($nbdatabits);$z++){
	
	$data = $nbdatabits[$z];
	
	// Numeric
	$qr['mode'] = 1;
	Set_mode();
	
	$numeric = $data - 4 - $cci_size;
	$numeric = (int)(($numeric / 10)* 3);

	echo $cci_size .' numeric '. $numeric .' - ';

	// Alphanumeric
	$qr['mode'] = 2;
	Set_mode();
	
	$alphanumeric = $data - 4 - $cci_size;
	$alphanumeric = (int)(($alphanumeric / 11)* 2);

	echo $cci_size .' alphanumeric '. $alphanumeric .' - ';

	// 8-bit Byte
	$qr['mode'] = 4;
	Set_mode();
	
	$byte = $data - 4 - $cci_size;
	$byte = (int)($byte / 8);

	echo $cci_size .' byte '. $byte .' - ';

	// Kanji
	$qr['mode'] = 8;
	Set_mode();
	
	$kanji = $data - 4 - $cci_size;
	$kanji = (int)($kanji / 13);

	echo $cci_size .' kanji '. $kanji .'<br/>';
	$x++;
	if ($x > 4 ){
		$x = 1;
		echo 'version '. $qr['version'] .'<br/>'.'<br/>';
		$qr['version']++;
	}
	
}
?>