<?php

$nbdatabits_table = array(
1=>array('L'=>152,'M'=>128,'Q'=>104,'H'=>72),
2=>array('L'=>272,'M'=>224,'Q'=>176,'H'=>128),
3=>array('L'=>440,'M'=>352,'Q'=>272,'H'=>208),
4=>array('L'=>640,'M'=>512,'Q'=>384,'H'=>288),
5=>array('L'=>864,'M'=>688,'Q'=>496,'H'=>368),
6=>array('L'=>1088,'M'=>864,'Q'=>608,'H'=>480),
7=>array('L'=>1248,'M'=>992,'Q'=>704,'H'=>528),
8=>array('L'=>1552,'M'=>1232,'Q'=>880,'H'=>688),
9=>array('L'=>1856,'M'=>1456,'Q'=>1056,'H'=>800),
10=>array('L'=>2192,'M'=>1728,'Q'=>1232,'H'=>976),
11=>array('L'=>2592,'M'=>2032,'Q'=>1440,'H'=>1120),
12=>array('L'=>2960,'M'=>2320,'Q'=>1648,'H'=>1264),
13=>array('L'=>3424,'M'=>2672,'Q'=>1952,'H'=>1440),
14=>array('L'=>3688,'M'=>2920,'Q'=>2088,'H'=>1576),
15=>array('L'=>4184,'M'=>3320,'Q'=>2360,'H'=>1784),
16=>array('L'=>4712,'M'=>3624,'Q'=>2600,'H'=>2024),
17=>array('L'=>5176,'M'=>4056,'Q'=>2936,'H'=>2264),
18=>array('L'=>5768,'M'=>4504,'Q'=>3176,'H'=>2504),
19=>array('L'=>6360,'M'=>5016,'Q'=>3560,'H'=>2728),
20=>array('L'=>6888,'M'=>5352,'Q'=>3880,'H'=>3080),
21=>array('L'=>7456,'M'=>5712,'Q'=>4096,'H'=>3248),
22=>array('L'=>8048,'M'=>6256,'Q'=>4544,'H'=>3536),
23=>array('L'=>8752,'M'=>6880,'Q'=>4912,'H'=>3712),
24=>array('L'=>9392,'M'=>7312,'Q'=>5312,'H'=>4112),
25=>array('L'=>10208,'M'=>8000,'Q'=>5744,'H'=>4304),
26=>array('L'=>10960,'M'=>8496,'Q'=>6032,'H'=>4768),
27=>array('L'=>11744,'M'=>9024,'Q'=>6464,'H'=>5024),
28=>array('L'=>12248,'M'=>9544,'Q'=>6968,'H'=>5288),
29=>array('L'=>13048,'M'=>10136,'Q'=>7288,'H'=>5608),
30=>array('L'=>13880,'M'=>10984,'Q'=>7880,'H'=>5960),
31=>array('L'=>14744,'M'=>11640,'Q'=>8264,'H'=>6344),
32=>array('L'=>15640,'M'=>12328,'Q'=>8920,'H'=>6760),
33=>array('L'=>16568,'M'=>13048,'Q'=>9368,'H'=>7208),
34=>array('L'=>17528,'M'=>13800,'Q'=>9848,'H'=>7688),
35=>array('L'=>18448,'M'=>14496,'Q'=>10288,'H'=>7888),
36=>array('L'=>19472,'M'=>15312,'Q'=>10832,'H'=>8432),
37=>array('L'=>20528,'M'=>15936,'Q'=>11408,'H'=>8768),
38=>array('L'=>21616,'M'=>16816,'Q'=>12016,'H'=>9136),
39=>array('L'=>22496,'M'=>17728,'Q'=>12656,'H'=>9776),
40=>array('L'=>23648,'M'=>18672,'Q'=>13328,'H'=>10208)
);

$nbECCbytes_table = array(
1=>array('L'=>7,'M'=>10,'Q'=>13,'H'=>17),
2=>array('L'=>10,'M'=>16,'Q'=>22,'H'=>28),
3=>array('L'=>15,'M'=>26,'Q'=>18,'H'=>22),
4=>array('L'=>20,'M'=>18,'Q'=>26,'H'=>16),
5=>array('L'=>26,'M'=>24,'Q'=>18,'H'=>22),
6=>array('L'=>18,'M'=>16,'Q'=>24,'H'=>28),
7=>array('L'=>20,'M'=>18,'Q'=>18,'H'=>26),
8=>array('L'=>24,'M'=>22,'Q'=>22,'H'=>26),
9=>array('L'=>30,'M'=>22,'Q'=>20,'H'=>24),
10=>array('L'=>18,'M'=>26,'Q'=>24,'H'=>28),
11=>array('L'=>20,'M'=>30,'Q'=>28,'H'=>24),
12=>array('L'=>24,'M'=>22,'Q'=>26,'H'=>28),
13=>array('L'=>26,'M'=>22,'Q'=>24,'H'=>22),
14=>array('L'=>30,'M'=>24,'Q'=>20,'H'=>24),
15=>array('L'=>22,'M'=>24,'Q'=>30,'H'=>24),
16=>array('L'=>24,'M'=>28,'Q'=>24,'H'=>30),
17=>array('L'=>28,'M'=>28,'Q'=>28,'H'=>28),
18=>array('L'=>30,'M'=>26,'Q'=>28,'H'=>28),
19=>array('L'=>28,'M'=>26,'Q'=>26,'H'=>26),
20=>array('L'=>28,'M'=>26,'Q'=>30,'H'=>28),
21=>array('L'=>28,'M'=>26,'Q'=>28,'H'=>30),
22=>array('L'=>28,'M'=>28,'Q'=>30,'H'=>24),
23=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30),
24=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30),
25=>array('L'=>26,'M'=>28,'Q'=>30,'H'=>30),
26=>array('L'=>28,'M'=>28,'Q'=>28,'H'=>30),
27=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30),
28=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30),
29=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30),
30=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30),
31=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30),
32=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30),
33=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30),
34=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30),
35=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30),
36=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30),
37=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30),
38=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30),
39=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30),
40=>array('L'=>30,'M'=>28,'Q'=>30,'H'=>30)
);

$alphanum_table = array(
'0' => 0, '1' => 1, '2' => 2, '3' => 3, '4' => 4, '5' => 5,
'6' => 6, '7' => 7, '8' => 8, '9' => 9, 'A' => 10,'B' => 11,
'C' => 12,'D' => 13,'E' => 14,'F' => 15,'G' => 16,'H' => 17,
'I' => 18,'J' => 19,'K' => 20,'L' => 21,'M' => 22,'N' => 23,
'O' => 24,'P' => 25,'Q' => 26,'R' => 27,'S' => 28,'T' => 29,
'U' => 30,'V' => 31,'W' => 32,'X' => 33,'Y' => 34,'Z' => 35,
' ' => 36,'$' => 37,'%' => 38,'*' => 39,'+' => 40,'-' => 41,
'.' => 42,'/' => 43,':' => 44);

if(!isset($qr['version'])){
	$qr['version'] = '1';
}
if(!isset($qr['eccLevel'])){
	$qr['eccLevel'] = 'M';
}

if ($qr['version'] >= 1 and $qr['version'] <= 9){
	$cci_size = 9;
}elseif ($qr['version'] >= 10 and $qr['version'] <= 26){
	$cci_size = 11;
}elseif ($qr['version'] >= 27 and $qr['version'] <= 40){
	$cci_size = 13;
}

$nbdatabits = $nbdatabits_table[$qr['version']][$qr['eccLevel']];
$datacapacity =	$nbdatabits - 4 - $cci_size;
$datacapacity = (int)(($datacapacity / 11)* 2);

//Data
$data_text = 'HELLO WORLD';

if(strlen($data_text) <= $datacapacity){

	$datavals = array();
	$z = 1;
	for ($pos = 0; $pos < strlen($data_text); $pos++){
		$temp = @$alphanum_table[substr($data_text, $pos, 1)];
		if($temp != ''){
			$datavals[$z] = $temp;
			$z++;
		}
	}
	$data_size = count($datavals);
	$cci = str_pad(decbin($data_size), $cci_size, '0', STR_PAD_LEFT);

	$data_binary = '';
	for ($z = 1; $z < $data_size; $z+=2){
		$data_binary .= str_pad(decbin($datavals[$z] * 45 + $datavals[$z+1]), 11, '0', STR_PAD_LEFT);
	}
	if($data_size %2 == 1){
		$data_binary .= str_pad(decbin($datavals[$data_size]), 6, '0', STR_PAD_LEFT);
	}
	$data_binary = '0010' . $cci . $data_binary;

	if(strlen($data_binary) < ($nbdatabits-4)){
		$data_binary = $data_binary .'0000';
		$data_binary = str_pad($data_binary, strlen($data_binary) + (8-(strlen($data_binary) % 8)), '0', STR_PAD_RIGHT);
		
		$data_size = strlen($data_binary);
		for($z = 1; $z <= (($nbdatabits - $data_size) / 8); $z++){
			if($z%2 == '0'){
				$data_binary = $data_binary .'00010001';
			}else{
				$data_binary = $data_binary .'11101100';
			}
		}		
	}else{
		$data_binary = str_pad($data_binary, $nbdatabits, '0', STR_PAD_RIGHT);
	}
	echo 'QRcode '. $qr['version'].$qr['eccLevel'] .' ('. strlen($data_text) .'  caractres / '. $datacapacity .' max)<br/>';
	
	echo $data_binary.'<br/>';
	
	//REED SOLOMON
	$datavals = array();

	$blocID = 1;
	for($z=0; $z < strlen($data_binary); $z+=8){
		$datavals[$blocID] = substr($data_binary, $z, 8);
		$datavals[$blocID] = bindec($datavals[$blocID]);
		$blocID++;
	} 

	// error correction code words you need to generate
	$nbECCbytes = $nbECCbytes_table[$qr['version']][$qr['eccLevel']];;
	
	$nbdatabloc = count($datavals);
	$firstexp = ($nbdatabloc + $nbECCbytes) - 1;

	for($z=1; $z<=$nbdatabloc; $z++){
		echo $datavals[$z] .' ';
	}
	echo '<br/><br/>';


	// Create your message polynomial
	$exp = $firstexp;
	for($z=1; $z<=$nbdatabloc; $z++){
		$msg_pln[$z] = array('coef'=>$datavals[$z],'exp'=>$exp);
		echo $msg_pln[$z]['coef'] .'x<sup>'. $msg_pln[$z]['exp'] .'</sup>+';	
		$exp--;
	}
	echo '<br/><br/>';

	
	// Create your generator polynomial
	$alog_table = array(1,2,4,8,16,32,64,128,29,58,116,232,205,135,19,38,76,152,45,90,180,117,234,201,143,3,6,12,24,48,96,192,157,39,78,156,37,74,148,53,106,212,181,119,238,193,159,35,70,140,5,10,20,40,80,160,93,186,105,210,185,111,222,161,95,190,97,194,153,47,94,188,101,202,137,15,30,60,120,240,253,231,211,187,107,214,177,127,254,225,223,163,91,182,113,226,217,175,67,134,17,34,68,136,13,26,52,104,208,189,103,206,129,31,62,124,248,237,199,147,59,118,236,197,151,51,102,204,133,23,46,92,184,109,218,169,79,158,33,66,132,21,42,84,168,77,154,41,82,164,85,170,73,146,57,114,228,213,183,115,230,209,191,99,198,145,63,126,252,229,215,179,123,246,241,255,227,219,171,75,150,49,98,196,149,55,110,220,165,87,174,65,130,25,50,100,200,141,7,14,28,56,112,224,221,167,83,166,81,162,89,178,121,242,249,239,195,155,43,86,172,69,138,9,18,36,72,144,61,122,244,245,247,243,251,235,203,139,11,22,44,88,176,125,250,233,207,131,27,54,108,216,173,71,142,1);

	$log_table = array('',0,1,25,2,50,26,198,3,223,51,238,27,104,199,75,4,100,224,14,52,141,239,129,28,193,105,248,200,8,76,113,5,138,101,47,225,36,15,33,53,147,142,218,240,18,130,69,29,181,194,125,106,39,249,185,201,154,9,120,77,228,114,166,6,191,139,98,102,221,48,253,226,152,37,179,16,145,34,136,54,208,148,206,143,150,219,189,241,210,19,92,131,56,70,64,30,66,182,163,195,72,126,110,107,58,40,84,250,133,186,61,202,94,155,159,10,21,121,43,78,212,229,172,115,243,167,87,7,112,192,247,140,128,99,13,103,74,222,237,49,197,254,24,227,165,153,119,38,184,180,124,17,68,146,217,35,32,137,46,55,63,209,91,149,188,207,205,144,135,151,178,220,252,190,97,242,86,211,171,20,42,93,158,132,60,57,83,71,109,65,162,31,45,67,216,183,123,164,118,196,23,73,236,127,12,111,246,108,161,59,82,41,157,85,170,251,96,134,177,187,204,62,90,203,89,95,176,156,169,160,81,11,245,22,235,122,117,44,215,79,174,213,233,230,231,173,232,116,214,244,234,168,80,88,175);

	$cur_pln[0] = array('coef'=>'0','exp'=>'1');
	$cur_pln[1] = array('coef'=>'0','exp'=>'0');

	for($j = 1; $j < $nbECCbytes; $j++){

		$gen_pln[0] = array('coef'=>'0','exp'=>'1');
		$gen_pln[1] = array('coef'=>$j,'exp'=>'0');
		
		$temp_pln = array();
		for ($x=0; $x < count($gen_pln); $x++){
			for ($y=0; $y < count($cur_pln); $y++){
				$coef = (($cur_pln[$y]['coef'] + $gen_pln[$x]['coef']) %256) + floor(($cur_pln[$y]['coef'] + $gen_pln[$x]['coef']) / 256);
				$exp =  (($cur_pln[$y]['exp'] + $gen_pln[$x]['exp']) %256) + floor(($cur_pln[$y]['exp'] + $gen_pln[$x]['exp']) / 256);
				$temp_pln[] = array('coef'=>$coef, 'exp'=>$exp);
			}
		}
		
		$cur_pln = array();
		for($z=$j+1; $z >= 0; $z--){
		
			$combine = array();
			for($term=0; $term < count($temp_pln); $term++){
				if($temp_pln[$term]['exp'] == $z){
					$combine[] = $temp_pln[$term]['coef'];
				}	
			}
			if(count($combine) > 1){
				$w = '';
				for ($term=0; $term < count($combine); $term++){
					$w = $w ^ $alog_table[$combine[$term]];	
				}
				$cur_pln[] = array('coef'=>$log_table[$w],'exp'=>$z);
			}else{
				$cur_pln[] = array('coef'=>$combine[0],'exp'=>$z);
			}
		}
		
		for($term = 0; $term < count($cur_pln); $term++){
			$coef = $cur_pln[$term]['coef'];
			$exp =  $cur_pln[$term]['exp'];
			echo 'a<sup>'. $coef .'</sup>x<sup>'. $exp .'</sup>+';
		}
		echo '<br/>';
	}
	
}else{
	echo 'La taille du texte est trop longue pour un QRcode '. $qr['version'].$qr['eccLevel'] .' ('. strlen($data_text) .'  caractres / '. $datacapacity .' max)';
}



?>