<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Gnrateur de code QR</title>
		<link rel="shortcut icon" type="image/x-icon" href="images/favicon.ico"/>
		<link rel="stylesheet" type="text/css" href="style.css"/>
	</head>
	<body>
		<div id="content">
			<div id="title">Gnrateur de code QR</div>
<?php

//QRcode 
$qr['version'] = '1';
$qr['eccLevel'] = 'L';
$qr['mask'] = '0';
$qr['size'] = 17 + $qr['version'] * 4;
$qr['map'] = array();

function QR_clean_map(){
	global $qr;
	
	for($y= -3; $y <= $qr['size']+4; $y++){
		for($x= -3; $x <= $qr['size']+4; $x++){
			if($y<1 or $y> $qr['size'] or $x<1 or $x> $qr['size']){
				$qr['map'][$x][$y] = '0';
			}else{
				$qr['map'][$x][$y] = '2';
			}
		}
	}
}

function QR_multi_detectionpattern(){
	global $qr;
	
	QR_add_detectionpattern(0,0);
	QR_add_detectionpattern($qr['size']-7,0);
	QR_add_detectionpattern(0,$qr['size']-7);
}

function QR_add_detectionpattern($posx,$posy){
	global $qr;
	
	for($z=0; $z <= 3; $z++){
		for($y= $posy + $z; $y <= $posy + (8 - $z); $y++){
			for($x= $posx + $z; $x <= $posx + (8 - $z); $x++){
				if($z%2 == '0'){
					$qr['map'][$x][$y] = '0';
				}else{
					$qr['map'][$x][$y] = '1';
				}
			}
		}
	}
}

function QR_multi_adjustmentpattern(){
	global $qr;
	
	if($qr['version']>1){
		$Position_adjustment = array();
		switch($qr['version']){
			case '2': $Position_adjustment = array('6','18'); break;
			case '3': $Position_adjustment = array('6','22'); break;
			case '4': $Position_adjustment = array('6','26'); break;
			case '5': $Position_adjustment = array('6','30'); break;
			case '6': $Position_adjustment = array('6','34'); break;
			case '7': $Position_adjustment = array('6','22','38'); break;
			case '8': $Position_adjustment = array('6','24','42'); break;
			case '9': $Position_adjustment = array('6','26','46'); break;
			case '10': $Position_adjustment = array('6','28','50'); break;
			case '11': $Position_adjustment = array('6','30','54'); break;
			case '12': $Position_adjustment = array('6','32','58'); break;
			case '13': $Position_adjustment = array('6','34','62'); break;
			case '14': $Position_adjustment = array('6','26','46','66'); break;
			case '15': $Position_adjustment = array('6','26','48','70'); break;
			case '16': $Position_adjustment = array('6','26','50','74'); break;
			case '17': $Position_adjustment = array('6','30','54','78'); break; 
			case '18': $Position_adjustment = array('6','30','56','82'); break; 
			case '19': $Position_adjustment = array('6','30','58','86'); break; 
			case '20': $Position_adjustment = array('6','34','62','90'); break; 
			case '21': $Position_adjustment = array('6','28','50','72','94');  break;
			case '22': $Position_adjustment = array('6','26','50','74','98'); break;
			case '23': $Position_adjustment = array('6','30','54','78','102'); break;
			case '24': $Position_adjustment = array('6','28','54','80','106'); break; 
			case '25': $Position_adjustment = array('6','32','58','84','110'); break; 
			case '26': $Position_adjustment = array('6','30','58','86','114'); break;
			case '27': $Position_adjustment = array('6','34','62','90','118'); break; 
			case '28': $Position_adjustment = array('6','26','50','74','98','122'); break;
			case '29': $Position_adjustment = array('6','30','54','78','102','126'); break;
			case '30': $Position_adjustment = array('6','26','52','78','104','130'); break;
			case '31': $Position_adjustment = array('6','30','56','82','108','134'); break; 
			case '32': $Position_adjustment = array('6','34','60','86','112','138'); break; 
			case '33': $Position_adjustment = array('6','30','58','86','114','142'); break; 
			case '34': $Position_adjustment = array('6','34','62','90','118','146'); break;
			case '35': $Position_adjustment = array('6','30','54','78','102','126','150'); break;
			case '36': $Position_adjustment = array('6','24','50','76','102','128','154'); break;
			case '37': $Position_adjustment = array('6','28','54','80','106','132','158'); break;
			case '38': $Position_adjustment = array('6','32','58','84','110','136','162'); break;
			case '39': $Position_adjustment = array('6','26','54','82','110','138','166'); break;
			case '40': $Position_adjustment = array('6','30','58','86','114','142','170'); break;
		}
		$z = count($Position_adjustment);
		for($y= 0; $y<$z; $y++){
			for($x= 0; $x<$z; $x++){
				QR_add_adjustmentpattern($Position_adjustment[$x], $Position_adjustment[$y]);
			}
		}
	}
}

function QR_add_adjustmentpattern($posx,$posy){
	global $qr;
	
	if($qr['map'][$posx][$posy] == '2'){
		for($z= -1; $z <= 1; $z++){
			for($y=$posy + $z; $y <= $posy + (2 - $z); $y++){
				for($x=$posx + $z; $x <= $posx + (2 - $z); $x++){
					if($z%2 == '0'){
						$qr['map'][$x][$y] = '0';
					}else{
						$qr['map'][$x][$y] = '1';
					}
				}
			}
		}
	}
}

function QR_add_timingpattern(){
	global $qr;
	
	for ($y= 1; $y <= $qr['size']; $y++){
		if($qr['map'][7][$y] == '2'){
			if($y%2 == '0'){
				$qr['map'][7][$y] = '0';
			}else{
				$qr['map'][7][$y] = '1';
			}
		}
	}
	for ($x= 1; $x <= $qr['size']; $x++){
		if($qr['map'][$x][7] == '2'){
			if($x%2 == '0'){
				$qr['map'][$x][7] = '0';
			}else{
				$qr['map'][$x][7] = '1';
			}
		}
	}
}

function QR_add_format(){
	global $qr;
	
	$Format_Information = array();
	switch($qr['eccLevel']){
		case 'L': $Format_Information = array('111011111000100','111001011110011','111110110101010','111100010011101','110011000101111','110001100011000','110110001000001','110100101110110'); break;
		case 'M': $Format_Information = array('101010000010010','101000100100101','101111001111100','101101101001011','100010111111001','100000011001110','100111110010111','100101010100000'); break;
		case 'Q': $Format_Information = array('011010101011111','011000001101000','011111100110001','011101000000110','010010010110100','010000110000011','010111011011010','010101111101101'); break;
		case 'H': $Format_Information = array('001011010001001','001001110111110','001110011100111','001100111010000','000011101100010','000001001010101','000110100001100','000100000111011'); break;

		//case 'L': $Format_Information = array('001000111110111','110011110100111','010101011011111','101110010001111','111101000110011','000110001100011','100000100011011','011011101001011'); break;
		//case 'M': $Format_Information = array('010010000010101','101001001000101','001111100111101','110100101101101','100111111010001','011100110000001','111010011111001','000001010101001'); break;
		//case 'Q': $Format_Information = array('111110101010110','000101100000110','100011001111110','011000000101110','001011010010010','110000011000010','010110110111010','101101111101010'); break;
		//case 'H': $Format_Information = array('100100010110100','011111011100100','111001110011100','000010111001100','010001101110000','101010100100000','001100001011000','110111000001000'); break;
	}
	$z = 0;
	for ($y= $qr['size']; $y >= $qr['size']-6; $y--){
		if($qr['map'][9][$y] == '2'){
			$qr['map'][9][$y] = substr($Format_Information[$qr['mask']],$z,1);
			$z++;
		}
	}
	for ($y= 9; $y >= 1; $y--){
		if($qr['map'][9][$y] == '2'){
			$qr['map'][9][$y] = substr($Format_Information[$qr['mask']],$z,1);
			$z++;
		}
	}
	$z = 0;
	for ($x= 1; $x <= 8; $x++){
		if($qr['map'][$x][9] == '2'){
			$qr['map'][$x][9] = substr($Format_Information[$qr['mask']],$z,1);
			$z++;
		}
	}
	for ($x= $qr['size']-7; $x <= $qr['size']; $x++){
		if($qr['map'][$x][9] == '2'){
			$qr['map'][$x][9] = substr($Format_Information[$qr['mask']],$z,1);
			$z++;
		}
	}
}

function QR_add_version(){
	global $qr;
	
	if($qr['version']>=7){
		$Version_Information = '';
		switch($qr['version']){		
			case '7': $Version_Information = '000111110010010100'; break;
			case '8': $Version_Information = '001000010110111100'; break;
			case '9': $Version_Information = '001001101010011001'; break;
			case '10': $Version_Information = '001010010011010011'; break;
			case '11': $Version_Information = '001011101111110110'; break;
			case '12': $Version_Information = '001100011101100010'; break;
			case '13': $Version_Information = '001101100001000111'; break;
			case '14': $Version_Information = '001110011000001101'; break;
			case '15': $Version_Information = '001111100100101000'; break;
			case '16': $Version_Information = '010000101101111000'; break;
			case '17': $Version_Information = '010001010001011101'; break;
			case '18': $Version_Information = '010010101000010111'; break;
			case '19': $Version_Information = '010011010100110010'; break;
			case '20': $Version_Information = '010100100110100110'; break;
			case '21': $Version_Information = '010101011010000011'; break;
			case '22': $Version_Information = '010110100011001001'; break;
			case '23': $Version_Information = '010111011111101100'; break;
			case '24': $Version_Information = '011000111011000100'; break;
			case '25': $Version_Information = '011001000111100001'; break;
			case '26': $Version_Information = '011010111110101011'; break;
			case '27': $Version_Information = '011011000010001110'; break;
			case '28': $Version_Information = '011100110000011010'; break;
			case '29': $Version_Information = '011101001100111111'; break;
			case '30': $Version_Information = '011110110101110101'; break;
			case '31': $Version_Information = '011111001001010000'; break;
			case '32': $Version_Information = '100000100111010101'; break;
			case '33': $Version_Information = '100001011011110000'; break;
			case '34': $Version_Information = '100010100010111010'; break;
			case '35': $Version_Information = '100011011110011111'; break;
			case '36': $Version_Information = '100100101100001011'; break;
			case '37': $Version_Information = '100101010000101110'; break;
			case '38': $Version_Information = '100110101001100100'; break;
			case '39': $Version_Information = '100111010101000001'; break;
			case '40': $Version_Information = '101000110001101001'; break;
		}
		$z = 0;		
		for($x= 6; $x > 0; $x--){
			for($y= 3; $y > 0; $y--){
				$qr['map'][0 + $x][$qr['size']-11 + $y] = substr($Version_Information,$z,1);
				$z++;
			}
		}
		$z = 0;
		for($y= 6; $y > 0; $y--){
			for($x=3;$x>0;$x--){
				$qr['map'][$qr['size']-11 + $x][0 + $y] = substr($Version_Information,$z,1);
				$z++;
			}
		}
	}
}

function QR_init(){
	global $qr;
	
	if($qr['version']<1){
		$qr['version'] = '1';
	}elseif($qr['version']>40){
		$qr['version'] = '40';
	}

	if($qr['eccLevel'] != 'L' and $qr['eccLevel'] != 'M' and $qr['eccLevel'] != 'Q' and $qr['eccLevel'] != 'H'){
		$qr['eccLevel'] = 'L';
	}

	if($qr['mask']<0){
		$qr['mask'] = '0';
	}elseif($qr['mask']>7){
		$qr['mask'] = '7';
	}

	$qr['size'] = 17 + $qr['version'] * 4;
	$qr['map'] = array();
	
	QR_clean_map();
	
	//Set detection pattern
	QR_multi_detectionpattern();

	//Set adjustment pattern (if version > 1)
	QR_multi_adjustmentpattern();
		
	//Set timing pattern
	QR_add_timingpattern();
	
	//Set black pixel
	$qr['map'][9][$qr['size']-7]= '1';
	
	QR_add_format();
	QR_add_version();
}

function QR_masking($j, $i, $bit){
	global $qr;

	$j-=1; $i-=1;
	$value = 2;
	switch($qr['mask']){
		case '0':
			if(($i + $j) %2 == 0){
				$value = ($bit+1)%2;
			}else{
				$value = $bit;
			}
			break;
		case '1':
			if($i %2 == 0){
				$value = ($bit+1)%2;
			}else{
				$value = $bit;
			}
			break;
		case '2':
			if($j %3 == 0){
				$value = ($bit+1)%2;
			}else{
				$value = $bit;
			}
			break;
		case '3':
			if(($i + $j) %3 == 0){
				$value = ($bit+1)%2;
			}else{
				$value = $bit;
			}
			break;
		case '4':
			if(((int)($i / 2)+(int)($j / 3)) %2 == 0){
				$value = ($bit+1)%2;
			}else{
				$value = $bit;
			}
			break;
		case '5':
			if((($i * $j) %2)+(($i * $j) %3) == 0){
				$value = ($bit+1)%2;
			}else{
				$value = $bit;
			}
			break;
		case '6':
			if(((($i * $j) %2)+(($i * $j) %3)) %2 == 0){
				$value = ($bit+1)%2;
			}else{
				$value = $bit;
			}
			break;
		case '7':
			if(((($i * $j) %3)+(($i + $j) %2)) %2 == 0){
				$value = ($bit+1)%2;
			}else{
				$value = $bit;
			}
			break;
	}
	return $value;
}

function QR_push(){
	global $qr;
	
	$count = 3;
	$block = 0;
	$x = $qr['size'];
	$y = $qr['size'];
	$yup = true;
	while ($x > 0 ){
		if($qr['map'][$x][$y] == '2'){
			$qr['map'][$x][$y] = $count;
			//$qr['map'][$x][$y] = QR_masking($x,$y, 0);
			
			$block++;
			if ($block == 8){
				$block = 0;
				$count++;
				if ($count > 6){
					$count = 3;
				}
			}
		}
		if($qr['map'][$x-1][$y] == '2'){
			$qr['map'][$x-1][$y] = $count;
			//$qr['map'][$x-1][$y] = QR_masking($x-1,$y, 0);
			
			$block++;
			if ($block == 8){
				$block = 0;
				$count++;
				if ($count > 6){
					$count = 3;
				}
			}
		}
		
		//Move pointer
		if($yup == true){
			$y--;
			if($y == 0){
				$x = $x - 2;
				$yup = false;
				if ($x == 7 ) $x = 6;
			}			
		}
		if($yup == false){
			$y++;
			if($y == $qr['size']+1){
				$x = $x - 2;
				$yup = true;
				if ($x == 7 ) $x = 6;
			}
		}
	}
}

function QR_draw(){
	global $qr;
	
	echo '<div id="qrc">';
	for($y=-3 ; $y <= $qr['size'] +4; $y++){
		for($x=-3 ; $x <= $qr['size'] +4; $x++){
			echo '<img class="b'. $qr['map'][$x][$y] .'" src="images/5x5.gif" />';
		}
		echo '<br/>';
	}
	echo '</div>';

	// CodeInformations
	echo 'Ver '. $qr['version'] .' ('. $qr['size'] .'x'. $qr['size'] .') Ecc '. $qr['eccLevel'] .' Mask '. $qr['mask'] .'<br/>';
}

function QR_draw_GD(){
	global $qr;

	$fnt = 5;
	$taille = ($qr['size'] + 8) * $fnt;
	$im = @imagecreate($taille, $taille)
		or die("Impossible d'initialiser la bibliothque GD");

	$col0 = imagecolorallocate($im, 255, 255, 255);
	$col1 = imagecolorallocate($im, 0, 0, 0);
	$col2 = imagecolorallocate($im, 111, 49, 152);
	$col3 = imagecolorallocate($im, 0, 183, 239);
	$col4 = imagecolorallocate($im, 168, 230, 29);
	$col5 = imagecolorallocate($im, 255, 242, 0);
	$col6 = imagecolorallocate($im, 237, 28, 36);
	
	for($y=-3 ; $y <= $qr['size'] +4; $y++){
		for($x=-3 ; $x <= $qr['size'] +4; $x++){
			
			$px1 = ($x+3) * $fnt;
			$py1 = ($y+3) * $fnt;
			$px2 = $px1 + $fnt;
			$py2 = $py1 + $fnt;
			switch($qr['map'][$x][$y]){
				case 0:
					imagefilledrectangle ($im, $px1, $py1, $px2, $py2, $col0);
					break;
				case 1:
					imagefilledrectangle ($im, $px1, $py1, $px2, $py2, $col1);
					break;
				case 2:
					imagefilledrectangle ($im, $px1, $py1, $px2, $py2, $col2);
					break;
				case 3:
					imagefilledrectangle ($im, $px1, $py1, $px2, $py2, $col3);
					break;
				case 4:
					imagefilledrectangle ($im, $px1, $py1, $px2, $py2, $col4);
					break;
				case 5:
					imagefilledrectangle ($im, $px1, $py1, $px2, $py2, $col5);
					break;
				case 6:
					imagefilledrectangle ($im, $px1, $py1, $px2, $py2, $col6);
					break;
			}
		}
	}

	$dossier = 'saved';
	$name = 'QRcode-'. date('dmy-H\hi-su');
	$extension = 'gif';
				
	//Nouveau nom du fichier avatar
	$filename = '';
	$nb=-1;
	do{
		$nb++;
		$filename = $name.'~'.$nb.'.'.$extension;
	}while (file_exists($dossier.'/'.$filename));
	
	imagegif($im, 'saved/'.$filename);
	imagedestroy($im);
}

$qr['version'] = '5';
$qr['eccLevel'] = 'H';
for($qr['mask'] = 0; $qr['mask'] <= 7; $qr['mask']++){
	QR_init();
	QR_push();
	QR_draw();
	QR_draw_GD();
}

?>
			</div>
		</div>
	</body>
</html>
