<?php // $Id: minical.php,v 1.23 2009/11/22 16:47:45 bbannon Exp $
/**
 * Description:
 * This script is intended to be used inside an IFRAME on another website
 * It can be embedded like so
 * <iframe name="minical" frameborder="0" height="190" width="250"
 *   src="http://cal/minical.php";>
 *
 * You must have public access enabled in System Settings to use this page
 * (unless you modify the $public_must_be_enabled setting below in this file).
 *
 * By default (if you do not edit this file),
 * events for the public calendar will be used.
 *
 * Input parameters:
 * You can override settings by changing the URL parameters:
 *   - cat_id: specify a category id to filter on
 *   - user: login name of calendar to display (instead of public user),
 *           if allowed by System Settings.
 *           Only NUC Calendar that are marked PUBLIC can be specified.
 *
 * Security:
 * $PUBLISH_ENABLED must be set true
 */
include_once 'includes/init.php';

load_global_settings();

// These values will be used by styles.php to customize the size of this calendar.
$DISPLAY_WEEKENDS = true;
$MINICALFONT = '11px';
$MINICALWIDTH = '160px';

if ( empty ( $PUBLISH_ENABLED ) || $PUBLISH_ENABLED != 'Y' ) {
  header ( 'Content-Type: text/plain' );
  echo print_not_auth();
  exit;
}

/* Configurable settings for this file. You may change the settings below to
 * change the default settings. These settings will likely move into the
 * System Settings in the web admin interface in a future release.
 */

// The HTML target window to use when clicking on the minical. You should be
// able to set this to the desired frame or window to receive the results.
$MINI_TARGET = '_blank';

// Change this to false if you still want to access this page
// even though you do not have public access enabled.
$public_must_be_enabled = true;

// Login of calendar user to use.
// '__public__' is the login name for the public user.
$user = ( empty ( $user ) ? '__public__' : $user );

// Allow the URL to override the user setting such as
// "minical.php?user=_NUC_training".
// If false, __public_ will always be used.
$allow_user_override = false;

// Load just a specified category (by its id).
// Leave blank to not filter on category (unless specified in URL).
// Can override in URL with "minical.php?cat_id=4"
$cat_id = ( empty ( $cat_id ) ? '' : $cat_id );

// End configurable settings...

// Set for use elsewhere as a global.
$login = $user;

if ( $public_must_be_enabled && $PUBLIC_ACCESS != 'Y' )
  $error = print_not_auth();

if ( $allow_user_override ) {
  $u = getValue ( 'user', '[A-Za-z0-9_\.=@,\-]+', true );
  if ( ! empty ( $u ) )
    $login = $user = $u;
  // We also set $login since some functions assume that it is set.
}

load_user_preferences();

user_load_variables ( $login, 'minical_' );

if ( $user != '__public__' && ! nonuser_load_variables ( $login, 'minica_' ) )
  die_miserable_death (
    str_replace ( 'XXX', $login,
      translate ( 'No such nonuser calendar XXX.' ) ) );

if ( $user != '__public__' &&
  ( empty ( $minical_is_public ) || $minical_is_public != 'Y' ) )
  die_miserable_death ( translate ( 'This Calendar is not Public.' ) );

$next = mktime ( 0, 0, 0, $thismonth + 1, 1, $thisyear );
$nextmonth = date ( 'm', $next );
$nextyear = date ( 'Y', $next );

$prev = mktime ( 0, 0, 0, $thismonth - 1, 1, $thisyear );
$prevmonth = date ( 'm', $prev );
$prevyear = date ( 'Y', $prev );

$boldDays = true;
$startdate = mktime ( 0, 0, 0, $thismonth, 1, $thisyear );
$enddate = mktime ( 23, 59, 59, $thismonth + 1, 0, $thisyear );

// Don't display custom header.
print_header ( '', generate_refresh_meta(), '', true );

/* Pre-Load the repeated events for quicker access. */
$repeated_events = read_repeated_events ( $user, $startdate, $enddate, $cat_id );

/* Pre-load the non-repeating events for quicker access. */
$events = read_events ( $user, $startdate, $enddate, $cat_id );

echo display_small_month ( $thismonth, $thisyear, true, false );

// Reset...just in case.
$login = '';

?>
  </body>
</html>
