<?php

$url_rewritting = true;  //mettre false pour dsactiver l'url rewritting

$langue = 'fr_FR';  //affiche les dates en franais
if (setlocale(LC_TIME, $langue) == '') {
	setlocale(LC_TIME, 'FRA');  //correction problme pour windows
	$format_jour = '%#d';
} else {
	$format_jour = '%e';
}

// include contenant les fonctions de manipulation de date et d'affichage du calendrier
include('calendrier.php');

// include contenant la dtermination des jours fris
// il est optionnel et ncessite une base de donnes contenant la table definition_jours_feries
include('jours_feries.php');

if (function_exists('JourFerie')) {
	//donnes pour la connexion  la base de donnes
	$db_server = 'votre-serveur-db.fr'; //adresse du serveur MySQL ou localhost
	$db_name = 'nom_db'; //nom de la base de donnes
	$db_user_login = 'user_db'; //nom d'utilisateur pour la BD
	$db_user_pass = 'mot_pass_db'; //mot de passe pour la BD

	// connection  la base de donnes
	my_mysql_select_db($db_server, $db_user_login, $db_user_pass, $db_name);
}

// contrle des paramtres
if (isset($_GET['mois'])) {
	$mois = $_GET['mois'];
	if (ereg('([0-9]{4})-([0-9]{2})', $mois, $regs)) {
		if (checkdate($regs[2], 1, $regs[1])) {
			//La date est correct
			$annee_param = $regs[1];
			$mois_param = $regs[2];
			$jour_param = mktime(0, 0, 0, $regs[2], 1, $regs[1]);
		} else {
			$url_complete = cal_get_url('', '');
			header("Status: 301 Moved Permanently", false, 301);
			header("Location: $url_complete");
			exit;
		}
	} else {
		$url_complete = cal_get_url('', '');
		header("Status: 301 Moved Permanently", false, 301);
		header("Location: $url_complete");
		exit;
	}
} else {
	$annee_param = date("Y");
	$mois_param = date("m");
	$jour_param = mktime(0, 0, 0);
}

if (isset($_GET['jour'])) {
	$jour = $_GET['jour'];
	if (ereg('([0-9]{4})-([0-9]{2})-([0-9]{2})', $jour, $regs)) {
		if (checkdate($regs[2], $regs[3], $regs[1])) {
			//La date est correct
			$jour_param = mktime(0, 0, 0, $regs[2], $regs[3], $regs[1]);
		}
	}
}

$rewrite_url = cal_get_url("$annee_param-$mois_param", date("Y-m-d", $jour_param));

$url_complete = get_complete_url();
if ($rewrite_url <> $url_complete) {
	header("Status: 301 Moved Permanently", false, 301);
	header("Location: $rewrite_url");
	exit;
}

// cette fonction permet de ne donner accs qu' certains mois
// elle est bien videment  modifer pour s'adapter au besoin spcifiques
function calendrier_check_mois($date_courante) {
	global $annee_param, $mois_param;
	
	$mois_courant = date("m");
	$annee_courante = date("Y");
	$annee_mois_param = $annee_param . '-' . $mois_param;
	// autorise toujours le mois en paramtre
	if (date("Y-m", $date_courante) == $annee_mois_param) { 
		return true;
	}
	// autorise seulement trois mois en arrire et un an en avant
	if (($date_courante < mktime(0, 0, 0, $mois_courant - 3, 1, $annee_courante)) ||
	    ($date_courante > mktime(0, 0, 0, $mois_courant, 1, $annee_courante + 1))) {
		return false;
	} else {
		return true;
	}
}

// cette fonction retourne un tableau contenant ce qu'il faut afficher pour un jour et un suffixe pour la classe CSS
// elle est bien videment  modifer pour s'adapter au besoin spcifiques
function calendrier_get_info_date($date_courante) {
	global $annee_param;
	global $mois_param;
	global $jour_param;
	global $mois;
	
	$premier_jour_mois = mktime(0, 0, 0, $mois_param, 1, $annee_param);
	$nb_jour = date("t", $premier_jour_mois);
	$dernier_jour_mois = mktime(0, 0, 0, $mois_param, $nb_jour, $annee_param);
	$jour_texte = date("j", $date_courante);
	$date_texte = date("Y-m-d", $date_courante);
	$suffix_class = '';
	if ($date_courante == $jour_param) { // si jour en paramtre
		$suffix_class .= " current_day";
		if ($jour_texte == 15) {
			$suffix_class .= " event";
		} elseif ($jour_texte == 20) {
			$suffix_class .= " reservation";
		}
	} else {
		$select_url = cal_get_url(isset($mois) ? $mois : '', $date_texte);
		if ($jour_texte == 15) {
			$suffix_class .= " event";
			$jour_texte = "<a href=\"$select_url\" title=\"Ev&egrave;nement du $jour_texte\">$jour_texte</a>";
		} elseif ($jour_texte == 20) {
			$suffix_class .= " reservation";
			$jour_texte = "<a href=\"$select_url\" title=\"R&eacute;servation du $jour_texte\">$jour_texte</a>";
		} else {
			$jour_texte = "<a href=\"$select_url\" title=\"D&eacute;tail pour la journ&eacute;e\">$jour_texte</a>";
		}
	}
	// Si jour calendrier dans le mois prcdent ou suivant met en italique
	if (($date_courante < $premier_jour_mois) || 	($date_courante > $dernier_jour_mois)) {
		$suffix_class .= " other_month";
	}
	return array($jour_texte, $suffix_class);
}

// cette fonction retourne les informations du jour courant
// elle est bien videment  modifer pour s'adapter au besoin spcifiques
function get_information($date_courante) {
	global $format_jour;
	
	$resultat = '';
	$annee = date("Y", $date_courante);
	$premier_juin = mktime(0, 0, 0, 6, 1, $annee);
	$trente_septembre = mktime(0, 0, 0, 9, 30, $annee);
	if (!function_exists('JourFerie') || (($JourFerie = JourFerie($date_courante)) === false)) {
		$resultat .= "\t<h2>" . strftime("%A $format_jour %B %Y", $date_courante) . "</h2>\n";
	} else {
		$resultat .= "\t<h2>" . strftime("%A $format_jour %B %Y", $date_courante) . " : $JourFerie</h2>\n";
	}
	$jour_texte = date("j", $date_courante);
	if ($jour_texte == 15) {
		$resultat .= "\t<p>Evnement tous les 15 du mois</p>\n";
	} elseif ($jour_texte == 20) {
		$resultat .= "\t<p>Rservation tous les 20 du mois</p>\n";
	} else {
		$resultat .= "\t<p>RAS</p>\n";
	}
	if ($date_courante > mktime(0, 0, 0)) {
		$resultat .= "\t<p><strong>Les informations futures peuvent changer &agrave; tout moment. Pensez &agrave; v&eacute;rifier le jour m&ecirc;me.</strong></p>\n";
	}
	return $resultat;
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<title>Calendrier : <?php 
if (!function_exists('JourFerie') || (($JourFerie = JourFerie($jour_param)) === false)) {
	echo strftime("%A $format_jour %B %Y", $jour_param);
} else {
	echo strftime("%A $format_jour %B %Y", $jour_param) . " ($JourFerie)";
}
?></title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="shortcut icon" href="favicon.ico">
<meta name="robots" content="index, nofollow">
<link rel="stylesheet" type="text/css" media="all" href="calendrier.css">
</head>
<body>
<?php
echo showCalendar($annee_param, $mois_param);
?>
<div id="informations">
<?php
	echo get_information($jour_param);
?>
</div>
<?php
if (function_exists('JourFerie')) {
	//fin de la connexion  la base de donnes
	mysql_close($lk);	
}
?>
<?php
echo showCalendar($annee_param, $mois_param, 'calendrier2', 0);
?>
<h1>Explications</h1>
<p>Voici un petit exemple d'utilisation du calendrier.</p>
<p>Sur le calendrier du haut, il est seulement possible de voir trois mois en arrire et un an en avant. Tous les 15 du mois on peut voir un vnement (case encadre de rouge) et tous les 20 du mois une rservation (case grise). Cliquez sur un jour pour voir le dtail. </p>
<p>Sur le calendrier du bas, aucun jour n'est cliquable et le calendrier commence au dimanche. Aucune fonction de "callback" n'est utilis&eacute;e.</p>
</body>
</html>