<?php

// fonction de calcul de date + ou - un interval
function DateAdd($interval, $number, $date) {
	$date_time_array = getdate($date);
	$hours = $date_time_array['hours'];
	$minutes = $date_time_array['minutes'];
	$seconds = $date_time_array['seconds'];
	$month = $date_time_array['mon'];
	$day = $date_time_array['mday'];
	$year = $date_time_array['year'];
	switch ($interval) { 
		case 'y':
			$year+=$number;
			break;
		case 'm':
			$month+=$number;
			break;
		case 'w':
			$day+=($number*7);
			break;
		case 'd':
			$day+=$number;
			break;
		case 'h':
			$hours+=$number;
			break;
		case 'i':
			$minutes+=$number;
			break;
		case 's':
			$seconds+=$number; 
			break;
	}
	return mktime($hours,$minutes,$seconds,$month,$day,$year);
}

// fonction de calcul un jour de la semaine avant une date
function GetBefore($MaDate, $JourSemaine) {
	$UnJourSemaine = date("w", $MaDate);
	if ($UnJourSemaine == $JourSemaine) {
	return $MaDate;
	} elseif ($UnJourSemaine < $JourSemaine) {
		return DateAdd("d", $JourSemaine - $UnJourSemaine - 7, $MaDate);
	} else {
		return DateAdd("d", $JourSemaine - $UnJourSemaine, $MaDate);
	}
}

// fonction de calcul un jour de la semaine aprs une date 
function GetAfter($MaDate, $JourSemaine) {
	$UnJourSemaine = date("w", $MaDate);
	If ($UnJourSemaine == $JourSemaine) {
		return $MaDate;
	} elseif ($UnJourSemaine < $JourSemaine) {
		return DateAdd("d", $JourSemaine - $UnJourSemaine, $MaDate);
	} else {
		return DateAdd("d", $JourSemaine - $UnJourSemaine + 7, $MaDate);
	}
}

// fonction d'affichage du calendrier
function showCalendar($annee, $mois, $nom = "calendrier", $premier_jour = 1) {
	$leCalendrier = "";
	$get_info_date = $nom . '_get_info_date';  //nom de la fonction permettant de dterminer ce qui est affich pour un jour
	$check_mois = $nom . '_check_mois';  //nom de la fonction permettant de dterminer si un mois est "affichable"
	// Tableau des valeurs possibles pour un nom de jour dans la semaine
	$jours_semaine = array("dim", "lun", "mar", "Mer", "jeu", "ven", "sam");
	$mois_annee = array("Janvier", "F&eacute;vrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "Ao&ucirc;t", "Septembre", "Octobre", "Novembre", "D&eacute;cembre");
	$premier_jour_mois = mktime(0, 0, 0, $mois, 1, $annee);
	$nb_jour = date("t", $premier_jour_mois);
	$dernier_jour_mois = mktime(0, 0, 0, $mois, $nb_jour, $annee);
	$premier_lundi = GetBefore($premier_jour_mois, $premier_jour);
	$dernier_jour = ($premier_jour + 6) % 7;
	$dernier_dimanche = GetAfter($dernier_jour_mois, $dernier_jour);
	for($i=0; $i<=6; $i++) {
		$jours_semaine[$i] = strftime("%a", GetBefore($premier_jour_mois, $i)); 
	}
	for($i=1; $i<=12; $i++) {
		$mois_annee[$i] = strftime("%B", mktime(0, 0, 0, $i, 1, $annee)); 
		if ($i == $mois) {
			$nom_mois = $mois_annee[$i];
		}
	}
	$leCalendrier .= "<div id=\"$nom\">\n";
	$chemin = get_path();
	// Affiche les menus droulant pour mois et anne
	$leCalendrier .= "\t<div id=\"$nom" . "_menu\">\n";
	$leCalendrier .= "\t\t<ul>\n";
	$leCalendrier .= "\t\t\t<li class=\"$nom" . "_menu_mois\">\n";
	$leCalendrier .= "\t\t\t\t<form action=\"$chemin\" method=\"get\" name=\"menu_mois\">\n";
	$leCalendrier .= "\t\t\t\t\t<select name=\"mois\" size=\"1\" onchange=\"javascript:this.form.submit();\">\n";
	for ($i=1; $i<=12;$i++) {
		$mois_tmp = mktime(0, 0, 0, $i, 1, $annee);
		if (!function_exists($check_mois) || $check_mois($mois_tmp)) {
			$mois_tmp_text = $mois_annee[$i];
			if ($i == $mois) {
				$selectionne = " selected";
			} else {
				$selectionne = "";
			}
			$leCalendrier .= "\t\t\t\t\t\t<option value=\"" . date("Y-m", $mois_tmp) . "\" label=\"$i\"$selectionne>$mois_tmp_text</option>\n";
		}
	}
	$leCalendrier .= "\t\t\t\t\t</select>\n";
	$leCalendrier .= "\t\t\t\t</form>\n";
	$leCalendrier .= "\t\t\t</li>\n";
	$leCalendrier .= "\t\t\t<li class=\"$nom" . "_menu_annee\">\n";
	$leCalendrier .= "\t\t\t\t<form action=\"$chemin\" method=\"get\" name=\"menu_annee\">\n";
	$leCalendrier .= "\t\t\t\t\t<select name=\"mois\" size=\"1\" onchange=\"javascript:this.form.submit();\">\n";
	for ($i=($annee-5); $i<=($annee+5);$i++) {
		$mois_tmp = mktime(0, 0, 0, $mois, 1, $i);
		if (!function_exists($check_mois) || $check_mois($mois_tmp)) {
			if ($i == $annee) {
				$selectionne = " selected";
			} else {
				$selectionne = "";
			}
			$leCalendrier .= "\t\t\t\t\t\t<option value=\"" . date("Y-m", $mois_tmp) . "\" label=\"" . date("y", $mois_tmp) . "\"$selectionne>$i</option>\n";
		}
	}
	$leCalendrier .= "\t\t\t\t\t</select>\n";
	$leCalendrier .= "\t\t\t\t</form>\n";
	$leCalendrier .= "\t\t\t</li>\n\t\t</ul>\n\t</div>\n";
	// Affichage des jours de la semaine
	$leCalendrier .= "\t<div id=\"$nom" . "_jours\">\n\t\t<ul>\n";
	$jour_semaine = $premier_jour;
	for($i=0; $i<=6; $i++) {
		$leCalendrier .= "\t\t\t<li class=\"$nom" . "_jour_semaine\">" . $jours_semaine[$jour_semaine] . "</li>\n";
		$jour_semaine = ($jour_semaine + 1) % 7;
	}
	$leCalendrier .= "\t\t</ul>\n\t</div>\n";
	// Tant que l'on n'a pas affect tous les jours du mois trait
	for($date_courante=$premier_lundi; $date_courante<=$dernier_dimanche;$date_courante=DateAdd("d", 1, $date_courante)) {
		$jour_semaine = date("w", $date_courante);
		if ($jour_semaine == $premier_jour) {
			$leCalendrier .= "\t<div class=\"$nom" . "_semaine\">\n\t\t<ul>\n";
		}
		if (function_exists($get_info_date)) {
			list($jour_texte, $suffix_class) = $get_info_date($date_courante);
		} else {
			$jour_texte = date("d", $date_courante);
			$suffix_class = '';
		}
		// Ajout de la case avec la date
		$leCalendrier .= "\t\t\t<li class=\"$nom" . "_jour$suffix_class\">$jour_texte</li>\n";
		if ($jour_semaine == $dernier_jour) {
			$leCalendrier .= "\t\t</ul>\n\t</div>\n"; 
		}
	}
	// affichage des boutons de navigation
	$leCalendrier .= "\t<div id=\"$nom" . "_navi\">\n";
	$leCalendrier .= "\t\t<ul>\n";
	// Anne prcdente
	$annee_prec = mktime(0, 0, 0, $mois + 1, 0, $annee - 1);
	if (!function_exists($check_mois) || $check_mois($annee_prec)) {
		$annee_prec_texte = "<a href=\"" . cal_get_url(date("Y-m", $annee_prec), "") . "\"><img src=\"py.gif\" alt=\"Ann&eacute;e pr&eacute;c&eacute;dente\"></a>";
	} else {
		$annee_prec_texte = "&nbsp;";
	}
	$leCalendrier .= "\t\t\t<li class=\"$nom" . "_annee_prec\">$annee_prec_texte</li>\n";
	// Mois prcdent
	$mois_prec = mktime(0, 0, 0, $mois, 0, $annee);
	if (!function_exists($check_mois) || $check_mois($mois_prec)) {
		$mois_prec_texte = "<a href=\"" . cal_get_url(date("Y-m", $mois_prec), "") . "\"><img src=\"pm.gif\" alt=\"Mois pr&eacute;c&eacute;dent\"></a>";
	} else {
		$mois_prec_texte = "&nbsp;";
	}
	$leCalendrier .= "\t\t\t<li class=\"$nom" . "_mois_prec\">$mois_prec_texte</li>\n";
	// Mois en cours
	$mois_cour = mktime(0, 0, 0);
	if (!function_exists($check_mois) || $check_mois($mois_cour)) {
		$mois_cour_texte = "<a href=\"" . cal_get_url() . "\"><img src=\"cm.gif\" alt=\"Mois en cours\"></a>";
	} else {
		$mois_cour_texte = "";
	}
	$leCalendrier .= "\t\t\t<li class=\"$nom" . "_mois_cour\">$mois_cour_texte</li>\n";
	// Mois suivant
	$mois_suiv = mktime(0, 0, 0, $mois + 1, 1, $annee);
	if (!function_exists($check_mois) || $check_mois($mois_suiv)) {
		$mois_suiv_texte = "<a href=\"" . cal_get_url(date("Y-m", $mois_suiv), "") . "\"><img src=\"nm.gif\" alt=\"Mois suivant\"></a>";
	} else {
		$mois_suiv_texte = "&nbsp;";
	}
	$leCalendrier .= "\t\t\t<li class=\"$nom" . "_mois_suiv\">$mois_suiv_texte</li>\n";
	// Anne suivante
	$annee_suiv = mktime(0, 0, 0, $mois, 1, $annee + 1);
	if (!function_exists($check_mois) || $check_mois($annee_suiv)) {
		$annee_suiv_texte = "<a href=\"" . cal_get_url(date("Y-m", $annee_suiv), "") . "\"><img src=\"ny.gif\" alt=\"Ann&eacute;e suivante\"></a>";
	} else {
		$annee_suiv_texte = "&nbsp;";
	}
	$leCalendrier .= "\t\t\t<li class=\"$nom" . "_annee_suiv\">$annee_suiv_texte</li>\n";
	$leCalendrier .= "\t\t</ul>\n\t</div>\n";
	$leCalendrier .= "</div>\n";
	// Retour de la chaine contenant le Calendrier
	return $leCalendrier;
}

// fonction de dtermination de l'url demande
function get_complete_url() {
	if (isset($_SERVER['SCRIPT_URL']) && isset($_SERVER['REQUEST_URI']) && isset($_SERVER['SCRIPT_URI'])) {
		return str_replace($_SERVER['SCRIPT_URL'], $_SERVER['REQUEST_URI'], $_SERVER['SCRIPT_URI']);
	} else {
		return 'http://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
	}
}

// fonction de dtermination de l'url de la page en fonction des paramtres
function cal_get_url($mois = "", $jour = "") {
	global $url_rewritting;
	
	$chemin = get_path();
	if ($url_rewritting == true) {
		if ($mois != '') {
			if ($jour != '') {
				return "$chemin$mois.$jour.html";
			} else {
				return "$chemin$mois.$mois-01.html";
			}
		} elseif ($jour != '') {
			$moistmp = substr($jour, 0, strrpos($jour, '-'));
			return "$chemin$moistmp.$jour.html";
		} else {
			$moistmp = date("Y-m");
			$jourtmp = date("Y-m-d");
			return "$chemin$moistmp.$jourtmp.html";
		}
	} else {
		if ($mois != '') {
			if ($jour != '') {
				return "$chemin?mois=$mois&jour=$jour";
			} else {
				return "$chemin?mois=$mois&jour=$mois-01";
			}
		} elseif ($jour != '') {
			$moistmp = substr($jour, 0, strrpos($jour, '-'));
			return "$chemin?mois=$moistmp&jour=$jour";
		} else {
			$moistmp = date("Y-m");
			$jourtmp = date("Y-m-d");
			return "$chemin?mois=$moistmp&jour=$jourtmp";
		}
	}
}

// fonction de dtermination de l'url racine du calendrier
function get_path() {
	$url_complete = get_complete_url();
	if (eregi("^(.*\/)[^\/]*\.html$", $url_complete, $match )) {
		return $match[1];
	} elseif (eregi("/^(.*\/)index\.php$", $url_complete, $match )) {
		return $match[1];
	} else {
		return $url_complete;
	}
}
?>
