

<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="ISO-8859-1" />

<style>
h1 {
	color: Blue;
	text-align: center;
}

.Titre h1:before {
	content: url("http://www.firebirdsql.org/images/logo_left_90.gif");
}

.Titre h1:after {
	content: url("http://www.mysql.fr/common/logos/logo-mysql-110x57.png");
}

h2 {
	color: DarkBlue;
}

h3 {
	color: BlueViolet;
}

p {
	margin-left: 30px;
}
</style>

</head>

<body>
<?php

#######################################################
#           SCRIPT DE CONVERSION DE BDD               #
#               INTERBASE -> MYSQL                    #
#             le 25/05/2011 par F CASTEL              #
#######################################################
//source: http://www.phpcs.com/codes/CONVERTISSEUR-INTERBASE-MYSQL_44643.aspx

#script
/*
 * Fonction: Copier une base Firebird (existante) dans une base MySQL
 *           Copie des tables (sauf system) et des donnes
 *           Crer la base MySQL ou craser celle existante
 *
 * Config des Tests:
 *  - WampServer 2.0 (extension php_interbase : actif)
 *  - Windows 7
 *  - Firebird Server 2.5
 *  - PHP 5.2
 *  - FireFox 4
 *
 * pas de gestion des clefs des tables!!!!! TODO
 * gestion propre des erreurs : TODO
 */

//chrono
$temps_debut = microtime(true);

//plus de limite de temps
set_time_limit(0); //pas tres classe mais sinon sa bloque si > 30sec
echo '<div class="Titre"><h1>' . 'Firebird vers MySQL' . '</h1></div>';

//CREER base MySQL
if ($_POST['MySQLNew'] == 'new') {
	echo "<h2>" . 'Cration de la base MySQL' . "</h2>";
	$pdo = new PDO('mysql:host=localhost', 'root', '', array(PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION));
	$requete = 'CREATE DATABASE ' . $_POST['MySQLDBName'] . ' DEFAULT CHARACTER SET latin1 COLLATE latin1_general_ci';
	echo "<p>" . $requete . "</p>";
	$pdo->prepare($requete)->execute();

}

echo "<h2>" . 'Les Bases de donnes' . "</h2>";

//PARAMETRES INTERBASE
$utilisateur_interbase = $_POST['FirebirdUser'];
$passe_interbase = $_POST['FirebirdPassword'];
$dsn_interbase = "firebird:dbname=" . $_POST['FirebirdHost'] . ":" . str_ireplace('\\', '\\\\', $_POST['FirebirdDBName']); //il faut doubler les \
$bdd_interbase = new PDO($dsn_interbase, $utilisateur_interbase, $passe_interbase);
//$bdd_interbase->exec("SET CHARACTER SET ISO8859_1");
echo "<h3>" . 'Firebird' . "</h3>";
echo "<p>" . $dsn_interbase . "</p>";

//PARAMETRES MYSQL
$utilisateur_mysql = $_POST['MySQLUser'];
$passe_mysql = $_POST['MySQLPassword'];
$dsn_mysql = 'mysql:host=' . $_POST['MySQLHost'] . ';dbname=' .  $_POST['MySQLDBName'];
$bdd_mysql = new PDO($dsn_mysql, $utilisateur_mysql,$passe_mysql);
//$bdd_mysql->exec("SET CHARACTER SET latin1");
echo "<h3>" . 'MySQL' . "</h3>";
echo "<p>" . $dsn_mysql . "</p>";

//RAZ base MySQL
if ($_POST['MySQLNew'] == 'erase') {
	echo "<h2>" . 'Supprimer toutes les tables MySQL' . "</h2>";
	//	lister les tables
	$requete = 'SHOW TABLES FROM test1';
	$statement = $bdd_mysql->prepare($requete, array(PDO::ATTR_CURSOR, PDO::CURSOR_FWDONLY));
	$statement->execute();
	$tables = $statement->fetchAll(PDO::FETCH_ASSOC );
	echo "<p>" . count($tables) . ' Tables  traiter' . "</p>";

	//	virer chaque table
	echo '<p>';
	foreach($tables as $table){
		$requete = 'DROP TABLE ' . $table['Tables_in_test1'];
		echo $requete . '<br />';
		$bdd_mysql->exec($requete);
	}
	echo '</p>';
}

//LISTE TABLES FIREBIRD

//liste les tables de la BDD
$requete = 'SELECT DISTINCT rdb$relation_name FROM rdb$relation_fields
WHERE rdb$view_context IS NULL
  AND rdb$system_flag = 0'; //Injection de la requte permettant de rcuprer les tables
$statement = $bdd_interbase->prepare($requete, array(PDO::ATTR_CURSOR, PDO::CURSOR_FWDONLY));
$statement->execute();
$tables = $statement->fetchAll(PDO::FETCH_ASSOC );

//traiter chaque table
echo "<h2>" . 'Creation des tables FIREBIRD dans la base MySQL' . "</h2>";
echo "<p>" . count($tables) . ' Tables  traiter' . "</p>";
foreach ($tables as $table) {
	//traiter une table
	echo "<h3>" . $table['RDB$RELATION_NAME'] . "</h3>";

	//lire la structure de la table
	$requete = 'SELECT rel_field.rdb$field_position, rel_field.rdb$field_name, field.RDB$FIELD_TYPE, field.RDB$FIELD_LENGTH, rel_field.RDB$NULL_FLAG
                        FROM rdb$relations rel
                          JOIN rdb$relation_fields rel_field
                            ON rel_field.rdb$relation_name = rel.rdb$relation_name
                          JOIN rdb$fields field
                            ON rel_field.rdb$field_source = field.rdb$field_name
                        WHERE rel.rdb$relation_name = \'' .$table['RDB$RELATION_NAME'] .'\'
                        ORDER BY rel_field.rdb$field_position, rel_field.rdb$field_name';
	$statement = $bdd_interbase->prepare($requete, array(PDO::ATTR_CURSOR, PDO::CURSOR_FWDONLY));
	$statement->execute();
	$res_struc_table = $statement->fetchAll(PDO::FETCH_ASSOC);

	//Construction de la requte de cration de la table dans MySQL
	$req_create_table = "CREATE TABLE `".trim($table['RDB$RELATION_NAME'])."` (";
	$first = true;

	//pour chaque champ
	foreach ($res_struc_table as $field) {
		$struct_champ = TypeChamp($field['RDB$FIELD_TYPE'] ,$field['RDB$FIELD_LENGTH']);
		//si field 1 pas de virgule
		if (!$first) {
			$req_create_table .= " , ";
		}
		$first = false; //c'est plus le 1er champ

		$req_create_table .= "`".trim($field['RDB$FIELD_NAME'])."` ".$struct_champ[0];
		if ($struct_champ[1]) {
			$req_create_table .= "(".$struct_champ[1].")";
		}
		if ($field['RDB$NULL_FLAG'] == 0) {
			$req_create_table .= " NULL";
		} else {
			$req_create_table .= " NOT NULL";
		}
	}
	$req_create_table .=  ") ENGINE = MyISAM"; //clore instruction
	echo '<p>';
	print_r($req_create_table);
	echo '</p>';

	//crer la table dans MySQL
	$bdd_mysql->exec($req_create_table);

}

//importer les donnes
if (isset($_POST['Import'])) {
	echo "<h2>" . 'Import des donnes FIREBIRD dans la base MySQL' . "</h2>";
	foreach ($tables as $table) {
		echo "<h3>" . $table['RDB$RELATION_NAME'] . "</h3>";
		//selections des donnes firebird
		$requete = 'SELECT * FROM ' . $table['RDB$RELATION_NAME'];
		$statement = $bdd_interbase->prepare($requete, array(PDO::ATTR_CURSOR, PDO::CURSOR_FWDONLY));
		$statement->execute();
		$data = $statement->fetchAll(PDO::FETCH_ASSOC );
		echo '<p>' . count($data) . ' entres' . '</p>';

		//Construction de la requte d'insertion des donnes
		foreach ($data as $row) { //chaque ligne de table
			$req_insert = "INSERT INTO `" . trim($table['RDB$RELATION_NAME']) . "` SET ";
			$first = true;
			$key = key($row);
			$val = current($row);
			reset($row);
			while(list ($key, $val) = each ($row))	//chaque champ
			{
				if (!$first) {
					$req_insert .= " , ";
				}
				$first = false;//c'est plus le 1er champ
				//Correction des valeurs texte
				$val = str_replace("'","\'",$val);
				//$val = utf8_decode($val);
				$req_insert .= "`" . $key . "`='" . addslashes($val) . "'";
			}
			//insert LA ligne dans MySQL
			$bdd_mysql->exec($req_insert);
		}
	}

}


//FIN
echo '<h1>' . 'Script execut !' . '</h1>';
$temps_fin = microtime(true);
echo '<p><strong>' . 'Temps d\'execution : '.round($temps_fin - $temps_debut, 0) . ' secondes' . '</strong></p>';

?>
</body>
</html>

<?php

#FONCTIONS
function TypeChamp ($champ,$taille) {
	switch ($champ) {
		case 7:
			return array('SMALLINT',$taille);
			break;
		case 8:
			return array('INT',$taille);
			break;
		case 16:
			return array('BIGINT',$taille);
			break;
		case 10:
			return array('FLOAT','');
			break;
		case 11:
			//return 'D_Float';
			return 'erreur';
			break;
		case 27:
			return array('DOUBLE','');
			break;
		case 9:
			//return 'Quad';
			return 'erreur';
			break;
		case 14:
			return array('CHAR',$taille);
			break;
		case 37:
			return array('VARCHAR',$taille);
			break;
		case 40:
			//return 'CString';
			return 'erreur';
			break;
		case 13:
			return array('TIME','');
			break;
		case 12:
			return array('DATE','');
			break;
		case 35:
			return array('TIMESTAMP','');
			break;
		case 261:
			return array('BLOB','');
			break;
	}
}
#FIN FONCTIONS


?>