# phpMyAdmin MySQL-Dump
# http://phpwizard.net/phpMyAdmin/
#
# --------------------------------------------------------

# adapted for phpMyAgenda 

# --------------------------------------------------------
#
# table struture 'EventPoll'
#

DROP TABLE IF EXISTS EventPoll;
CREATE TABLE EventPoll (
   nEventPollID int(5) NOT NULL auto_increment,
   nEventID int(5) DEFAULT '0' NOT NULL,
   szPollQuestion varchar(255),
   bMultipleChoice tinyint(1) DEFAULT '0',
   bAllowUsersToChangeVote tinyint(1) DEFAULT '1',
   dtAllowUsersToChangeVoteUntil datetime DEFAULT '0000-00-00 00:00:00',
   bAllowWriteInVotes tinyint(1) DEFAULT '0',
   valid tinyint(1) DEFAULT '0',
   PRIMARY KEY (nEventPollID),
   KEY ix_nEventID (nEventID)
);

# --------------------------------------------------------
#
# table struture 'EventPollOption'
#

DROP TABLE IF EXISTS EventPollOption;
CREATE TABLE EventPollOption (
   nEventPollOptionID int(5) NOT NULL auto_increment,
   nEventPollID int(5) DEFAULT '0' NOT NULL,
   szOption varchar(128) NOT NULL,
   PRIMARY KEY (nEventPollOptionID),
   KEY ix_nEventPollID (nEventPollID)
);

# --------------------------------------------------------
#
# table struture 'EventPollOptionVote'
#

DROP TABLE IF EXISTS EventPollOptionVote;
CREATE TABLE EventPollOptionVote (
   nEventPollOptionVoteID int(5) NOT NULL auto_increment,
   nEventPollOptionID int(5) DEFAULT '0' NOT NULL,
   nUserID int(5) DEFAULT '0' NOT NULL,
   PRIMARY KEY (nEventPollOptionVoteID),
   KEY ix_nUserID (nUserID),
   KEY ix_nEventPollOptionID (nEventPollOptionID)
);

# --------------------------------------------------------
#
# table struture 'EventRegisteredUser'
#

DROP TABLE IF EXISTS EventRegisteredUser;
CREATE TABLE EventRegisteredUser (
   nEventRegisteredUserID int(10) NOT NULL auto_increment,
   nEventID int(5) DEFAULT '0' NOT NULL,
   nUserID int(11) DEFAULT '0' NOT NULL,
   PRIMARY KEY (nEventRegisteredUserID),
   KEY ix_EventID (nEventID),
   KEY ix_UserID (nUserID)
);

# --------------------------------------------------------
#
# table struture 'PermissionCode'
#

DROP TABLE IF EXISTS PermissionCode;
CREATE TABLE PermissionCode (
   nPermissionCode int(10) unsigned DEFAULT '0' NOT NULL,
   strPermissionCode varchar(64) NOT NULL,
   strDescription varchar(255) NOT NULL,
   PRIMARY KEY (nPermissionCode)
);

# --------------------------------------------------------
#
# table struture 'UserEventType'
#

DROP TABLE IF EXISTS UserEventType;
CREATE TABLE UserEventType (
   nUserID int(5) DEFAULT '0' NOT NULL,
   nEventTypeID int(5) DEFAULT '0' NOT NULL,
   bEmailWhenOtherUsersRegister tinyint(1) DEFAULT '0' NOT NULL,
   szEmailAddress varchar(255) NOT NULL
);

# --------------------------------------------------------
#
# table struture 'UserPermissionCode'
#

DROP TABLE IF EXISTS UserPermissionCode;
CREATE TABLE UserPermissionCode (
   nUserPermissionCode int(11) DEFAULT '0' NOT NULL,
   nUserID int(11) DEFAULT '0' NOT NULL,
   nPermissionCode int(11) DEFAULT '0' NOT NULL,
   PRIMARY KEY (nUserPermissionCode)
);

# --------------------------------------------------------
#
# table struture 'admin'
#

DROP TABLE IF EXISTS admin;
CREATE TABLE admin (
   id int(5) NOT NULL auto_increment,
   user varchar(50) NOT NULL,
   pass varchar(50) NOT NULL,
   szFirstName varchar(32) NOT NULL,
   szLastName varchar(32) NOT NULL,
   szEmailAddress varchar(255) NOT NULL,
   lang varchar(20) DEFAULT 'english' NOT NULL,
   active tinyint(2) DEFAULT '0' NOT NULL,
   lastlogin datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
   permissions varchar(20) DEFAULT '00011' NOT NULL,
   sid varchar(255) NOT NULL,
   addplace tinyint(2) DEFAULT '0' NOT NULL,
   placerights tinyint(2) DEFAULT '0' NOT NULL,
   placeautoupdate tinyint(2) DEFAULT '0' NOT NULL,
   PRIMARY KEY (id),
   UNIQUE id_2 (id),
   KEY id (id)
);

#
# dumping table  'admin'
#

INSERT INTO admin VALUES ( '1', 'admin', '21232f297a57a5a743894a0e4a801fc3', 'phpMyAgenda Administrator', '', '', 'english', '1', '', '1221', '', '0', '1', '1');
INSERT INTO admin VALUES ( '2', '{PUBLICUSER}', '', 'Guest', '', '', 'english', '1', '', '0000', '548fcab46c61cfcffa79f2070231c900f2566', '0', '0', '0');
INSERT INTO admin VALUES ( '3', 'write', 'efb2a684e4afb7d55e6147fbe5a332ee', '', '', '', 'english', '1', '', '0121', '', '1', '0', '1');

# --------------------------------------------------------
#
# table struture 'contacts'
#

DROP TABLE IF EXISTS contacts;
CREATE TABLE contacts (
   id int(5) NOT NULL auto_increment,
   name varchar(100) NOT NULL,
   email varchar(100) NOT NULL,
   url smallint(5) DEFAULT '0' NOT NULL,
   phone varchar(100) NOT NULL,
   fax varchar(100) NOT NULL,
   address varchar(255) NOT NULL,
   town varchar(100) NOT NULL,
   zipcode varchar(20) NOT NULL,
   country varchar(50) NOT NULL,
   valid tinyint(1) DEFAULT '0' NOT NULL,
   name1 varchar(50) NOT NULL,
   name2 varchar(50) NOT NULL,
   name3 varchar(50) NOT NULL,
   name4 varchar(50) NOT NULL,
   name5 varchar(50) NOT NULL,
   surname1 varchar(20) NOT NULL,
   surname2 varchar(20) NOT NULL,
   surname3 varchar(20) NOT NULL,
   surname4 varchar(20) NOT NULL,
   surname5 varchar(20) NOT NULL,
   function1 varchar(20) NOT NULL,
   function2 varchar(20) NOT NULL,
   function3 varchar(20) NOT NULL,
   function4 varchar(20) NOT NULL,
   function5 varchar(20) NOT NULL,
   email1 varchar(255) NOT NULL,
   email2 varchar(255) NOT NULL,
   email3 varchar(255) NOT NULL,
   email4 varchar(255) NOT NULL,
   email5 varchar(255) NOT NULL,
   phone1 varchar(20) NOT NULL,
   phone2 varchar(20) NOT NULL,
   phone3 varchar(20) NOT NULL,
   phone4 varchar(20) NOT NULL,
   phone5 varchar(20) NOT NULL,
   fax1 varchar(20) NOT NULL,
   fax2 varchar(20) NOT NULL,
   fax3 varchar(20) NOT NULL,
   fax4 varchar(20) NOT NULL,
   fax5 varchar(20) NOT NULL,
   owner int(5) DEFAULT '0' NOT NULL,
   PRIMARY KEY (id),
   UNIQUE id_2 (id),
   KEY id (id),
   KEY contacturl (url)
);

# --------------------------------------------------------
#
# table struture 'date'
#

DROP TABLE IF EXISTS date;
CREATE TABLE date (
   id int(5) NOT NULL auto_increment,
   start datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
   end datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
   event smallint(5) DEFAULT '1' NOT NULL,
   place smallint(5) DEFAULT '1' NOT NULL,
   valid tinyint(1) DEFAULT '0' NOT NULL,
   owner int(5) DEFAULT '0' NOT NULL,
   PRIMARY KEY (id),
   UNIQUE id_2 (id),
   KEY id (id)
);

# --------------------------------------------------------
#
# table struture 'events'
#

DROP TABLE IF EXISTS events;
CREATE TABLE events (
   id int(5) NOT NULL auto_increment,
   title varchar(255) NOT NULL,
   description text NOT NULL,
   url smallint(5) DEFAULT '0' NOT NULL,
   type smallint(5) DEFAULT '0' NOT NULL,
   contact1 smallint(5) DEFAULT '0' NOT NULL,
   contact2 smallint(5) DEFAULT '0' NOT NULL,
   contact3 smallint(5) DEFAULT '0' NOT NULL,
   contact4 smallint(5) DEFAULT '0' NOT NULL,
   contact5 smallint(5) DEFAULT '0' NOT NULL,
   valid smallint(5) DEFAULT '0' NOT NULL,
   owner int(5) DEFAULT '0' NOT NULL,
   image varchar(255) NOT NULL,
   emailsent smallint(5) DEFAULT '0' NOT NULL,
   PRIMARY KEY (id),
   UNIQUE id_2 (id),
   KEY id (id),
   KEY referer (contact1)
);

# --------------------------------------------------------
#
# table struture 'eventtype'
#

DROP TABLE IF EXISTS eventtype;
CREATE TABLE eventtype (
   id smallint(5) NOT NULL auto_increment,
   type varchar(50) NOT NULL,
   type_en varchar(50) NOT NULL,
   owner int(5) DEFAULT '0' NOT NULL,
   PRIMARY KEY (id),
   UNIQUE id_2 (id),
   KEY id (id)
);

# --------------------------------------------------------
#
# table struture 'place'
#

DROP TABLE IF EXISTS place;
CREATE TABLE place (
   id int(5) NOT NULL auto_increment,
   name varchar(100) NOT NULL,
   address varchar(255) NOT NULL,
   town varchar(100) NOT NULL,
   zipcode varchar(20) NOT NULL,
   country varchar(50) NOT NULL,
   contact1 smallint(5) DEFAULT '0' NOT NULL,
   url smallint(5) DEFAULT '0' NOT NULL,
   phone varchar(100) NOT NULL,
   fax varchar(100) NOT NULL,
   valid tinyint(1) DEFAULT '0' NOT NULL,
   contact2 smallint(5) DEFAULT '0' NOT NULL,
   contact3 smallint(5) DEFAULT '0' NOT NULL,
   contact4 smallint(5) DEFAULT '0' NOT NULL,
   contact5 smallint(5) DEFAULT '0' NOT NULL,
   owner int(5) DEFAULT '0' NOT NULL,
   PRIMARY KEY (id),
   UNIQUE id_2 (id),
   KEY id (id),
   KEY url (url)
);

# --------------------------------------------------------
#
# table struture 'placerights'
#

DROP TABLE IF EXISTS placerights;
CREATE TABLE placerights (
   id int(11) NOT NULL auto_increment,
   userid int(11) DEFAULT '0' NOT NULL,
   placeid int(11) DEFAULT '0' NOT NULL,
   PRIMARY KEY (id, userid),
   KEY userid (userid)
);

# --------------------------------------------------------
#
# table struture 'url'
#

DROP TABLE IF EXISTS url;
CREATE TABLE url (
   id int(5) NOT NULL auto_increment,
   url varchar(255) NOT NULL,
   owner int(5) DEFAULT '0' NOT NULL,
   PRIMARY KEY (id),
   UNIQUE id_2 (id),
   KEY id (id)
);

