<?php


/* define a generic object */
if(!defined("_CLASSOBJECT"))
{
    define("_CLASSOBJECT",TRUE);
    class object {};
}

/* setup the configuration object */
$CFG                                    = new object;

$CFG->dbhost                    = "{DBHOST}";
$CFG->dbname                    = "{DBNAME}";
$CFG->dbuser                    = "{DBUSER}";
$CFG->dbpass                    = "{DBPASS}";

$CFG->publicuser                = "{PUBLICUSER}";

$CFG->wwwroot                   = "/{WWWROOT}";
$CFG->agenda_root               = "{AGENDAROOT}";

$CFG->ssl_level                 = {SSLLEVEL};                               // specifies the ssl level to use
                                                                            // 0 = no ssl
                                                                            // 1 = ssl on sensitive forms
                                                                            // 2 = ssl always

if(isset($agendauser))
    $CFG->dirroot               = "./";
else
    $CFG->dirroot               = "../";
$CFG->templatedir               = "$CFG->dirroot/templates";
$CFG->libdir                    = "$CFG->dirroot/lib";
$CFG->imagedir                  = "$CFG->wwwroot/images";
$CFG->image_event_dir           = "imevent";

$CFG->table_admin               = "admin";                                  // admin table name in database
$CFG->table_contact             = "contacts";                               // contacts table name in database
$CFG->table_date                = "date";                                   // date table name in database
$CFG->table_event               = "events";                                 // events table name in database
$CFG->table_eventtype           = "eventtype";                              // eventtype table name in database
$CFG->table_usereventtype       = "UserEventType";                          // UserEventType table name in database
$CFG->table_EventRegisteredUser = "EventRegisteredUser";                    // EventRegisteredUser table name in database
$CFG->table_EventPoll           = "EventPoll";                              // EventPoll table name in database
$CFG->table_EventPollOption     = "EventPollOption";                        // EventPollOption table name in database
$CFG->table_EventPollOptionVote = "EventPollOptionVote";                    // EventPollOptionVote table name in database
$CFG->table_place               = "place";                                  // place table name in database
$CFG->table_url                 = "url";                                    // url table name in database
$CFG->table_placerights         = "placerights";                            // placerights table name in database

$CFG->limit_image_display_x     = 60;                                       // limit thumbnail size to x pixels width
$CFG->limit_image_display_y     = 90;                                       // limit thumbnail size to y pixels height

$CFG->limit_event_display_x     = 800;                                      // limit event cells to x pixels width
$CFG->limit_event_display_y     = 600;                                      // limit event cells to y pixels height

$PMA_VERSION                    = "3.0.001 Final";
$PMA_DATE                       = "2006-January-24";

/* Site Administrator and Email Server Information */
$strSiteEmailAdminName          = "{EMAILADMINNAME}";                       // This is the friendly name for the system mailer
$strSiteEmailAdminAddress       = "{EMAILADMINEMAIL}";                      // This is the email address of the system mailer
$strSMTPServer                  = "";                                       // Leave blank if you wish to use the local smtp or postfix daemon
$strLocalHost                   = "{LOCALHOST}";                            // Not necessary if you are using the local smtp or postfix daemon

/* define database error handling behavior, since we are in development stages
 * we will turn on all the debugging messages to help us troubleshoot */
$DB_DEBUG                       = false;
$DB_DIE_ON_FAIL                 = false;
$DEBUG                          = false;

/* turn on verbose error reporting (15) to see all warnings and errors */
if($DEBUG)
    error_reporting(E_ALL);
else
    error_reporting(E_ERROR | E_PARSE);

// Installed languages:
// you can add your language by adding it to the array.
// (note you must provide all files that contains the lang (i.e help_english.htm, ...)
$instlang               = array(1=>"francais" , "english" , "espanol" , "german" , "slovene");
$defaultlang            =   $instlang[2];                                   // default language

// these color are used in the user interface.
$COLOR_BORDER           =   "#5B8BAB";
$COLOR_BKGND            =   "#E1EAEF";

/* load up standard libraries */
include("$CFG->libdir/stdlib.php3");
include("$CFG->libdir/dblib.php3");

/* setup some global variables */

$ME = ereg_replace ("/php/php.exe" , "" , $PHP_SELF);

/* connect to the database */
db_connect($CFG->dbhost, $CFG->dbname, $CFG->dbuser, $CFG->dbpass);
?>
