<?php
// script from emmanuel vanneau (phpMyAgenda)
// $Id: auth.inc.php3, 2001/05/29 

if(!isset($AUTHINCLUDE)):
	$AUTHINCLUDE = 1;

class AuthAgenda
{
	// Table configuration
	var $acct_table				= 'admin';        			// the table your accounts are in
	var $placerightstable		= 'placerights';  			// the table for place rights list
	var $id_col		    		= 'id'; 		  			// the table your accounts are in
	var $username_col    		= 'user';         			// the name of the username column
	var $firstname_col    		= 'szFirstName';   			// the name of the first name column
	var $lastname_col    		= 'szLastName';         	// the name of the last name column
	var $emailaddress_col		= 'szEmailAddress';			// the name of the email address column
	var $pass_col        		= 'pass';         			// the name of the password column
	var $status_col      		= 'active';       			// the name of the active column
	var $lang_col      			= 'lang';     				// the name of the lang column
	var $last_col      			= 'lastlogin';				// the name of the last login column
	var $perm_col      			= 'permissions';			// the name of the permission column
	var $sid_col      			= 'sid';	 				// the name of the session id column
	var $addplace_col			= 'addplace';				// the name of the addplace column
	var $placerights_col 		= 'placerights';			// the name of the placerights column
	var $placeautoupdate_col 	= 'placeautoupdate';		// the name of the placeautoupdate column
	
	var $magicword0      		= "Lucida";       			// 1st MagicWord to encode cookie value
	var $magicword1      		= "Gravement";    			// 2nd MagicWord to encode cookis value

	var $id						= "";						// this user identifier in the database 
	var $login					= "";						// login value
	var $language				= "english";			 	// language of this login
	var	$active					= ""; 						// active 
	var $sid					= "";						// sid of this user
	var $lastlogin				= "";						// last login datetime

	// Permissions
	var $permissions			= "00000";				 	// user permissions (default = read_own, edit_own)

	// Raw format
	var $perm_raw_admin	 		= 0;						// raw format permission for admin
	var	$perm_raw_own	 		= 0;						// raw format permission for own data
	var	$perm_raw_all	 		= 0;						// raw format permission for all data
	var $perm_raw_basic			= 0;						// raw format permission for basic user privs

	// Boolean Format
	var $perm_admin		 		= 0;						// permission to read its own data
	var $perm_read_own			= 0;						// permission to read its own data
	var $perm_edit_own	 		= 0;						// permission to edit/delete its own data
	var $perm_read_all	 		= 0;						// permission to read all data
	var $perm_edit_all	 		= 0;						// permission to edit/delete all data
	var $perm_basic				= 0;						// permission to access basic user services		- False useful for public accounts / accounts that require no login

	var $place_can_add	 		= 0;						// permission to add places 
	var $place_access			= 0;						// permission to access place page
	var $place_autoupdate		= 1;						// autoupdate place access list 
	var $place_list      		= "";						// partial access place list
		
	var $redirect        		= "";
  
  function Init()
  {
	global $HTTP_REFERER;
	global $HTTP_POST_VARS;
	global $CFG;
    
    if(!isset($HTTP_REFERER))
    	$HTTP_REFERER = "";

    if(!isset($HTTP_POST_VARS))
    	$HTTP_POST_VARS = "";
    	
    if (!isset($HTTP_POST_VARS["redirect"]))
    {
      $this->redirect = $HTTP_REFERER;
    }
    else
    {
      $this->redirect = $HTTP_POST_VARS["redirect"];
    }
    $this->acct_table = $CFG->table_admin;

  }

	function explode_permissions()
	{
		// Admin Priv
	  	$this->perm_raw_admin 	= substr($this->permissions , 0 , 1);
		$this->perm_admin 		= (($this->perm_raw_admin+1-1) == 1);

		// Read/Edit All Events Priv
  		$this->perm_raw_all 	= substr($this->permissions , 1 , 1);
		$this->perm_read_all 	= (($this->perm_raw_all+1-1) == 1);
		$this->perm_edit_all 	= (($this->perm_raw_all+1-1) == 2);

		// Read/Edit Own Events Priv
	  	$this->perm_raw_own 	= substr($this->permissions , 2 , 1);
		$this->perm_read_own	= (($this->perm_raw_own+1-1) == 1);
		$this->perm_edit_own 	= (($this->perm_raw_own+1-1) == 2);

		// Basic User Priv
	  	$this->perm_raw_basic 	= substr($this->permissions , 3 , 1);
		$this->perm_basic 		= (($this->perm_raw_basic+1-1) == 1);
	}
	
	function get_place_list()
	{
		global $CFG;
		$qid = db_query("SELECT placeid FROM $CFG->table_placerights WHERE userid='$this->id'");
		$i	 =0;
		while ($r = db_fetch_object($qid))
		{
			$this->place_list[$i++] = $r->placeid;			
		}
	}

	function require_auth($perm="read", $requirebasic=true)
	{
		// Do login
		// perm	check the permission allow to user.
	
		global $CFG;			// from form
		global $login;			// from form
		global $dologin;		// from form
		global $sid;

		if(isset($login))
		{
			$this->authenticate();
		}
		else
		{
			if((!isset($sid) && $requirebasic == true) || $dologin == 1)
				$this->show_login_form();
			else
			{
				if(!isset($sid) && $requirebasic == false)
				{
					$qid = db_query("SELECT sid FROM $this->acct_table WHERE user='".formatSQLString($CFG->publicuser)."'");
					if(db_num_rows($qid) > 0)
					{
						$a = db_fetch_array($qid);
						$sid = $a[$this->sid_col];
					 	setcookie("sid" , $sid, time()+60*60*8, '/');
					}
				}

				$qid = db_query("SELECT * FROM $this->acct_table WHERE sid='".formatSQLString($sid)."'");
				$a 								= db_fetch_array($qid);
				if(!db_num_rows($qid) || ($a[$this->username_col] == $CFG->publicuser && $requirebasic == true))
					$this->show_login_form();
				else
				{
					$this->id						= $a[$this->id_col];
					$this->login					= $a[$this->username_col];
					$this->language					= $a[$this->lang_col];
					$this->active					= $a[$this->status_col];
					$this->lastlogin				= $a[$this->last_col];
					$this->permissions				= $a[$this->perm_col];
					$this->explode_permissions();
					$this->sid						= $a[$this->sid_col];
					$this->place_can_add	 		= $a[$this->addplace_col];
					$this->place_access		 		= $a[$this->placerights_col];
					$this->place_autoupdate			= $a[$this->placeautoupdate_col];

					debug("test ".$this->addplace_col." ".$a[$this->addplace_col]);
					debug("test ".$this->placerights_col." ".$a[$this->placerights_col]);
					debug("test ".$this->placeautoupdate_col." ".$a[$this->placeautoupdate_col]);

					if($this->place_access == 2)
					{
						debug("getplacelist");
						$this->get_place_list();					
					}
				}
			}
		}
	}

	function get_auth_by_id($id = 0)
	{
		$qid = db_query("SELECT * FROM $this->acct_table WHERE id='".formatSQLString($id)."'");
		if(!db_num_rows($qid))
			return 0;
		else
		{
    	    $a 								= db_fetch_array($qid);
    	    $this->id						= $a[$this->id_col];
    		$this->login					= $a[$this->username_col];
    		$this->szFirstName				= $a[$this->firstname_col];
    		$this->szLastName				= $a[$this->lastname_col];
    		$this->szEmailAddress			= $a[$this->emailaddress_col];
    		$this->language					= $a[$this->lang_col];
    		$this->active					= $a[$this->status_col];
    		$this->lastlogin				= $a[$this->last_col];
    		$this->permissions			  	= $a[$this->perm_col];
    		$this->explode_permissions();
    		$this->sid						= $a[$this->sid_col];
    		$this->place_can_add	 		= $a[$this->addplace_col];
    		$this->place_access		 		= $a[$this->placerights_col];
    		$this->place_autoupdate			= $a[$this->placeautoupdate_col];
    		if($this->place_access == 2)
    			$this->get_place_list();					
		}
	}


	function authenticate()
	{
	
		  // These are the names of the vars from the login form,
		  // so make sure you use them when you create your form
		  // in HTML.
		
		global $login;
		global $acct_pass;
		global $CFG;
		
		$qid = db_query("SELECT * FROM $this->acct_table WHERE $this->username_col = '".formatSQLString($login)."'");
		if (db_num_rows($qid) != 1)
		{
			syslog(LOG_INFO,"phpMyAgenda SECURITY: Login from IP address ".$this->GetIP()." FAILED for $login due to username not found.");
			$this->show_login_form("failed");
		}
		else
		{
			$a 								= db_fetch_array($qid);
			$this->id						= $a[$this->id_col];
			$this->login					= $a[$this->username_col];
			$this->szFirstName				= $a[$this->firstname_col];
			$this->szLastName				= $a[$this->lastname_col];
			$this->szEmailAddress			= $a[$this->emailaddress_col];
			$this->language					= $a[$this->lang_col];
			$this->active					= $a[$this->status_col];
			$this->lastlogin				= $a[$this->last_col];
			$this->permissions				= $a[$this->perm_col];
			$this->explode_permissions();
			$this->sid						= $a[$this->sid_col];
			$this->place_can_add	 		= $a[$this->addplace_col];
			$this->place_access		 		= $a[$this->placerights_col];
			$this->place_autoupdate			= $a[$this->place_autoupdate];
		
			if ($a[$this->pass_col] != md5($acct_pass))
			{
				debug("pass failed");
				syslog(LOG_INFO,"phpMyAgenda SECURITY: Login from IP address ".$this->GetIP()." FAILED for $this->login due to wrong password.");
				$this->show_login_form("Login failed");
			}
			elseif ($a[$this->status_col] == 0) 
			{
				debug("active failed");
				syslog(LOG_INFO,"phpMyAgenda SECURITY: Login from IP address ".$this->GetIP()." FAILED for $this->login due to inactive user.");
				$this->show_login_form("Profile not active. Contact your administrator");
			}
			else
			{
				$this->set_login_cookie();
				syslog(LOG_INFO,"phpMyAgenda SECURITY: $this->login successfully logged in from IP address ".$this->GetIP().".");
				if($this->place_access == 2)
					$this->get_place_list();					
			}
		}
	}

	function GetIP()
	{
	   if (getenv("HTTP_CLIENT_IP") && strcasecmp(getenv("HTTP_CLIENT_IP"), "unknown"))
	           $ip = getenv("HTTP_CLIENT_IP");
	       else if (getenv("HTTP_X_FORWARDED_FOR") && strcasecmp(getenv("HTTP_X_FORWARDED_FOR"), "unknown"))
	           $ip = getenv("HTTP_X_FORWARDED_FOR");
	       else if (getenv("REMOTE_ADDR") && strcasecmp(getenv("REMOTE_ADDR"), "unknown"))
	           $ip = getenv("REMOTE_ADDR");
	       else if (isset($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] && strcasecmp($_SERVER['REMOTE_ADDR'], "unknown"))
	           $ip = $_SERVER['REMOTE_ADDR'];
	       else
	           $ip = "unknown";
	   return($ip);
	}

  function set_login_cookie()
  {
	  srand(time());
	  $this->sid = md5(time() + rand(0,10000));
		
		$qid = db_query("UPDATE $this->acct_table SET sid='$this->sid', $this->last_col=NOW() WHERE $this->username_col = '".formatSQLString($this->login)."'");
	 	setcookie("sid" , $this->sid, time()+60*60*8, '/');
  }

	function log_out()
	{
		global $CFG;
		if ($CFG->publicuser != $this->login) 
		{
			$qid = db_query("UPDATE $this->acct_table SET sid='', $this->last_col=NOW() WHERE $this->username_col = '".formatSQLString($this->login)."'");
		}
	 	setcookie("sid" , '', time()+1, '/');
	}

  function show_login_form($failed="")
  {
    global $ME;
    global $CFG;
    global $redirect;
    
    if(!isset($redirect))
     $redirect="";

    include($CFG->dirroot."admin/login.php3");
    exit;
  }
  
  function can_edit_own()
  {
  	return ($this->perm_edit_own || $this->perm_admin);
  }
  
  function can_read_own()
  {
  	return ($this->perm_read_own || $this->perm_admin);
  }
  
  function can_edit_all()
  {
  	return ($this->perm_edit_all || $this->perm_admin);
  }
  
  function can_read_all()
  {
  	return ($this->perm_read_all || $this->perm_edit_all || $this->perm_admin);
  }
  
  function place_access_all()
  {
  	return ($this->place_access == 1 || $this->perm_admin);
  }
  
  function place_access_none()
  {
  	return ($this->place_access == 0);
  }
  
  function place_access_partial()
  {
  	return ($this->place_access == 2 || $this->perm_admin);
  }
  
  function can_add_place()
  {
  	return ($this->is_admin() || ($this->place_access_all() && $this->place_can_add));
  }

  function can_do_basic()
  {
  	return ($this->perm_basic == 1);
  }

  function check_user_can_edit($table , $id=0)
	{
		// check that user can add/edit/delete the record $id in table $table
		
		if(!isset($table))
			return false;
	
		if($this->is_admin() || $this->can_edit_all())
		  return true;
		else
		{
			if($this->can_edit_own())
			{
				if(!$id)
				 return true;		// check not on a speficic event
				 
				$qido = db_query("SELECT id FROM $table WHERE id=$id AND owner=$this->id");
				$ok = db_num_rows($qido);
				db_free_result($qido);		
				return $ok;
			}
			else
			 	return false;
		}
		return false;
	}

  
  function is_admin()
  {
  	return $this->perm_admin;
  }
  
  function is_basic()
  {
  	return $this->perm_basic;
  }

	function fill_permission_option($current = "")
	{
		global $strRight;
		if(!isset($strRight))
		$strRight	= array("admin"=>"Administrator" , "write"=>"Read / Write" , "read"=>"Read only");
		
		if(empty($current))
			$current = $this->permissions;

		$opt = "<option name='permission' value='admin' ";
		
		if($current == "admin")
			$opt .= " selected ";
		
		$opt .= ">$strRight[admin]</option>"; 
		$opt .= "<option name='permission' value='write' ";
		
		if($current == "write")
			$opt .= " selected ";
		
		$opt .= ">$strRight[write]</option>"; 
		$opt .= "<option name='permission' value='read' ";
		
		if($current == "read")
			$opt .= " selected ";
		
		$opt .= ">$strRight[read]</option>"; 
		return $opt;
	}
}


//function CheckAuth()
//{
 $Auth = new AuthAgenda;
 $Auth->Init();
 if (isset($requirebasicuser)) 
 {
	 $Auth->require_auth("read",  $requirebasicuser);
 }
 else
 {
	 $Auth->require_auth();
 }

//}

endif;
?>