<?php
session_start();

/*
	surveillance_navigation : 

	@Input : string, array (repertoire_membre in array.inc.php)
	@Output : bool

	Fonction qui vérifie que l'internaute ne va pas dans des répertoires specifiques (voir dans array.inc.php)
*/

function surveillance_navigation($repertoire)
{
   $repertoire_visiteur = array("membre" => 0, "rep_interdit" => 1);
   $repertoire_membre = array("rep_interdit" => 0); 
   if( 
       ( empty($_SESSION['membre']) && array_key_exists($repertoire, $repertoire_visiteur) ) // Visiteur
       || ( !empty($_SESSION['membre']) && array_key_exists($repertoire, $repertoire_membre) ) // Membre
   ){
       return true;
   }
   return false;
}



/*
	erreur_404 :
	Fonction qui simule une erreur 404, privant l'internaute d'accèder au contenu.
*/

	function erreur_404()
	{
		echo '<h1>Tu viens de te perdre !</h1><p>Tu n\'a pas la permission d\'acceder a ce dossier.</p>';
		exit();
	}


	$inc_file = get_included_files();
	if(surveillance_navigation(array_pop(explode(DIRECTORY_SEPARATOR, dirname($inc_file[0])))))
 	{
 		echo erreur_404(); 
 	}


?>

	
