<?php
use Tests\TestCase;

use Illuminate\Foundation\Testing\WithoutMiddleware;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\DatabaseTransactions;

class CrudTest extends TestCase
{

    /**
     * A basic test example.
     *
     * @return void
     */
    public function testExample()
    {
        $content = nl2br(file_get_contents('routes/api_builder.php'));
        $content = str_replace("\r", "", $content);
        $content = str_replace("\n", "", $content);
        $this->assertEquals('<?php<br /><br />/*<br />|--------------------------------------------------------------------------<br />| API Routes<br />|--------------------------------------------------------------------------<br />|<br />| Here is where all API routes are defined.<br />|<br />*/<br /><br /><br /><br />',$content);

        $content = nl2br(file_get_contents('routes/web_builder.php'));
        $content = str_replace("\r", "", $content);
        $content = str_replace("\n", "", $content);
        $this->assertEquals('<?php<br /><br />/* custom routes generated by CRUD */<br />',$content);

        $content = nl2br(file_get_contents('resources/views/admin/layouts/menu.blade.php'));
        $content = str_replace("\r", "", $content);
        $content = str_replace("\n", "", $content);
        $this->assertEquals('',$content);
    }
}
