"use strict";
$(document).ready(function(){
    var form = $("#form");
    form.steps({
        headerTag: "h6",
        bodyTag: "div",
        transitionEffect: "slideLeft",
        onStepChanging: function (event, currentIndex, newIndex) {
            // Allways allow previous action even if the current form is not valid!
            if (currentIndex > newIndex) {
                return true;
            }
            // Forbid next action on "Warning" step if the user is to young
            if (newIndex === 3 && Number($("#age-2").val()) < 18) {
                return false;
            }
            // Needed in some cases if the user went back (clean up)
            if (currentIndex < newIndex) {
                // To remove error styles
                form.find(".body:eq(" + newIndex + ") label.error").remove();
                form.find(".body:eq(" + newIndex + ") .error").removeClass("error");
            }
            form.validate().settings.ignore = ":disabled,:hidden";
            return form.valid();
        },
        onFinishing: function (event, currentIndex) {
            form.validate().settings.ignore = ":disabled";
            return form.valid();
        },
        onFinished: function (event, currentIndex) {
            $('#btnGenerate').click();
        }
    }).validate({
        errorPlacement: function errorPlacement(error, element) {
            element.before(error);
        }
    });

    $('.txtValidation').select2();

    $('.wrapper').addClass('hide_menu');

    $('#form').bootstrapValidator({
        fields: {
            model_name: {
                validators: {
                    notEmpty: {
                        message: 'Enter Model name'
                    },
                    regexp: {
                        regexp: /^[a-zA-Z']*$/,
                        message: 'The modal name can consist of characters only'
                    }
                }
            },
            myClass: {
                selector: '.txtFieldName',
                validators: {
                    notEmpty: {
                        message: 'required'
                    }
                }
            }
        }
    });
    $('input:checkbox').iCheck({
        checkboxClass: 'icheckbox_square-blue',
        radioClass: 'iradio_square-blue'
    });

    $("select").select2({width: '100%'});
    var fieldIdArr = [];
    $(function () {


        $("#drdCommandType").on("change", function () {
            if ($(this).val() == "infyom:scaffold") {
                $('#chSwag').hide();
                $('#chTest').hide();
            }
            else {
                $('#chSwag').show();
                $('#chTest').show();
            }
        });

        $(document).ready(function () {
            var htmlStr = '<tr class="item" style="display: table-row;"></tr>';
            var commonComponent = $(htmlStr).filter("tr").load(componentUrl);

            setTimeout(function () {
                $("#btnAdd").trigger('click');
            }, 200);

            $("#btnAdd").on("click", function () {
                var item = $(commonComponent).clone();
                initializeCheckbox(item);
                $("#container").append(item);
            });

            $("#btnTimeStamps").on("click", function () {
                var item_created_at = $(commonComponent).clone();
                $(item_created_at).find('.txtFieldName').val("created_at");
                renderTimeStampData(item_created_at);
                initializeCheckbox(item_created_at);
                $("#container").append(item_created_at);


                var item_updated_at = $(commonComponent).clone();
                $(item_updated_at).find('.txtFieldName').val("updated_at");
                renderTimeStampData(item_updated_at);
                initializeCheckbox(item_updated_at);
                $("#container").append(item_updated_at);
            });

            $("#btnPrimary").on("click", function () {
                var item = $(commonComponent).clone();
                renderPrimaryData(item);
                initializeCheckbox(item);
                $("#container").append(item);
            });

            $("#btnModalReset").on("click", function () {
                location.reload();

            });

            function capitalizeFirstLetter(string) {
                return string.charAt(0).toUpperCase() + string.slice(1);
            }

            $('#txtModelName').on('blur', function () {
                var modelname = {
                    modelName: capitalizeFirstLetter($('#txtModelName').val())
                }
                $.ajax({
                    url: modelCheckUrl,
                    type: 'POST',
                    dataType: 'json',
                    contentType: 'application/json',
                    data: JSON.stringify(modelname),
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function (result) {
                        if (result.status == false) {
                            swal({
                                title: 'error',
                                text: result.message,
                                type: "error",
                                closeOnConfirm: false,
                                showLoaderOnConfirm: true
                            });
                            $('#btnGenerate').prop('disabled', true);
                        }
                        else {
                            $('#btnGenerate').prop('disabled', false);
                        }

                    },
                });
            });

            $('#btnGenerate').on('click',function() {

                var fieldCheck = true;
                $('table > tbody  > tr').each(function() {
                    var fieldName = $(this).find('.txtFieldName').val();
                    if(fieldName == ''){
                        fieldCheck = false;
                        swal(
                            'Oops...',
                            'You must fill field name!',
                            'error'
                        );
                        return false;
                    }
                });
                if(fieldCheck == false){
                    return false;
                }

                var fieldArr = [];
                var primaryKey = '';
                var validationArray,validationString;
                $('.item').each(function () {

                    var htmlType = $(this).find('.drdHtmlType');
                    var htmlValue = "";
                    if ($(htmlType).val() == "select" || $(htmlType).val() == "radio") {
                        htmlValue = $(this).find('.drdHtmlType').val() + ':' + $(this).find('.txtHtmlValue').val();
                    }
                    else {
                        htmlValue = $(this).find('.drdHtmlType').val();
                    }
                    validationArray = $(this).find('.txtValidation').val();

                    if(validationArray==null){
                        validationString = '';
                    }
                    else
                        validationString = validationArray.join('|');

                    var primarycheck = $(this).find('.chkPrimary').prop('checked');
                    if (primarycheck == true) {
                        primaryKey = $(this).find('.txtFieldName').val();
                    }

                    fieldArr.push({
                        fieldInput: $(this).find('.txtFieldName').val() + ':' + $(this).find('.txtdbType').val(),
                        htmlType: htmlValue,
                        validations: validationString,
                        searchable: $(this).find('.chkSearchable').prop('checked'),
                        fillable: $(this).find('.chkFillable').prop('checked'),
                        primary: $(this).find('.chkPrimary').prop('checked'),
                        inForm: $(this).find('.chkInForm').prop('checked'),
                        inIndex: $(this).find('.chkInIndex').prop('checked')
                    });
                });

                //check if atleast one field added or not
                if(fieldArr.length == 0)
                {

                    swal(
                        'Oops...',
                        'You must add atleast one field!',
                        'error'
                    );
                    //TODO: find an elegant way to stop execution
                    throw new Error();
                }

                fieldArr.unshift({
                    fieldInput:'id:increments',
                    htmlType : validationString,
                    validations:false,
                    searchable:false,
                    fillable: false,
                    primary:true,
                    inForm:false,
                    inIndex:false
                });


                var data = {
                    modelName: capitalizeFirstLetter($('#txtModelName').val()),
                    commandType: $('#drdCommandType').val(),
                    tableName: $('#txtCustomTblName').val(),
                    iconName: $('#leftMenuIcons').val(),
                    iconColor: $('#iconColor').val(),
                    prefix: $('#txtPrefix').val(),
                    primary: primaryKey,
                    paginate: $('#txtPaginate').val(),
                    migrate: $('#chkMigrate').prop('checked'),
                    options: {
                        softDelete: $('#chkDelete').prop('checked'),
                        save: $('#chkSave').prop('checked'),
                        swagger: $('#chkSwagger').prop('checked'),
                        tests: $('#chkTestCases').prop('checked'),
                        datatables: $('#chkDataTable').prop('checked')
                    },
                    fields: fieldArr
                };

                data['_token'] = $('#token').val();

                $.ajax({
                    url: generateUrl,
                    type: "POST",
                    dataType: 'json',
                    contentType: 'application/json',
                    data: JSON.stringify(data),
                    success: function (result) {
//                            swal('success',result,"success");
                        swal({title:'success',text: result, type: "success",closeOnConfirm: false,showLoaderOnConfirm: true},
                            function(){
                                setTimeout(function(){location.reload();}, 1500);

                            });

                    },
                    error: function (result) {
                        //swal('error',result,'failed');
                        swal({
                            title: "error",
                            text: result,
                            type: "error"
                        });
                    }
                });

                return false;
            });

            function renderPrimaryData(el) {

                $('.chkPrimary').iCheck(getiCheckSelection(false));

                $(el).find('.txtFieldName').val("id");
                $(el).find('.txtdbType').val("increments");
                $(el).find('.chkSearchable').attr('checked', false);
                $(el).find('.chkFillable').attr('checked', false);
                $(el).find('.chkPrimary').attr('checked', true);
                $(el).find('.chkInForm').attr('checked', false);
                $(el).find('.chkInIndex').attr('checked', false);
            }

            function renderTimeStampData(el) {
                $(el).find('.txtdbType').val("timestamp");
                $(el).find('.chkSearchable').attr('checked', false);
                $(el).find('.chkFillable').attr('checked', false);
                $(el).find('.chkPrimary').attr('checked', false);
                $(el).find('.chkInForm').attr('checked', false);
                $(el).find('.chkInIndex').attr('checked', false);
                $(el).find('.drdHtmlType').val('date').trigger('change');
            }

        });

        function initializeCheckbox(el) {
            $(el).find('input:checkbox').iCheck({
                checkboxClass: 'icheckbox_square-blue',
                radioClass: 'iradio_square-blue'
            });
            $(el).find("select").select2({width: '100%'});

            $(el).find(".chkPrimary").on("ifClicked", function () {
                $('.chkPrimary').each(function () {
                    $(this).iCheck('uncheck');
                });
            });

            $(el).find(".chkPrimary").on("ifChanged", function () {
                if ($(this).prop('checked') == true) {
                    $(el).find(".chkSearchable").iCheck('uncheck');
                    $(el).find(".chkFillable").iCheck('uncheck');
                    $(el).find(".chkInForm").iCheck('uncheck');
                }
            });

            var htmlType = $(el).find('.drdHtmlType');

            $(htmlType).select2().on('change', function () {
                if ($(htmlType).val() == "select" || $(htmlType).val() == "radio")
                    $(el).find('.htmlValue').show();
                else
                    $(el).find('.htmlValue').hide();
            });

        }

    });

    function getiCheckSelection(value) {
        if (value == true)
            return 'checked';
        else
            return 'uncheck';
    }

    function removeItem(e) {
        e.parentNode.parentNode.parentNode.removeChild(e.parentNode.parentNode);
    }

    $('#txtModelName').keyup(function(){
        var modalName=$('#txtModelName').val();
        var tableName=modalName.concat('s');
        $('#txtCustomTblName').val(tableName);
        $('#txtCustomTblName').css('text-transform','lowercase');
        if(modalName==''){
            $('#txtCustomTblName').val('');
        }
    });
    $('.material-icons').on('click', function () {

        var icon_name = $(this).text();
        $('#leftMenuIcons').val(icon_name);
        $('#iconsModal').modal('hide');

    });

    $(function() {

        $('.txtHtmlValue').on('keypress', function(e) {
            if (e.which == 32)
                return false;
        });
        $( "#txtModelName" ).on('keydown',function(e) {
            var key = e.keyCode;
            return ((key >= 65 && key <= 90) || key == 8);

        });
        $( "body" ).on('keypress','.txtFieldName',function(e) {
            var x = $(this).val() + String.fromCharCode(e.charCode);
            if (e.charCode == 0) {
                return;
            }
            if (x.match(/^\w+$/) == null) {
                e.preventDefault();
            }
        });

    });

});