Dropzone.autoDiscover = false;

$(function() {

    var _url = $("#_url").val();
    var ib_app_url = $("#ib_app_url").val();
    var ibox_title = $("#ibox_title");

    var $ib_add_file = $("#ib_add_file");

    var $ib_add_folder = $("#ib_add_folder");

    var $ib_save = $("#ib_save");

    var p_dir;

    var c_path = '';

    var f_selected = '';

    var $del_file = $("#del_file");
    var $del_folder = $("#del_folder");

    var $ib_internal_editor = $("#ib_internal_editor");

    var $editor_area = $("#editor");

    $other_file = $("#other_file");


    var editor = ace.edit("editor");
    editor.setTheme("ace/theme/monokai");
    editor.getSession().setMode("ace/mode/php");

    var ib_file_supported = ["php", "html", "css", "tpl", "json", "js", "htaccess", "md", "csv", "txt" ];
    var ib_img_supported = ["png", "jpg", "gif", "jpeg" ];



    function f_ib_file_tree() {


        $('#ib_tree').fileTree({
            root: '/',
            script: _url + 'ide/file/tree/',
            expandSpeed: 1000,
            collapseSpeed: 1000
        }, function(file) {



            $(".ib_f_selected").removeClass('ib_f_selected');
            file.addClass('ib_f_selected');

            f_selected = file.attr('rel');

            var ext = f_selected.substr(f_selected.lastIndexOf('.') + 1);

            $ib_internal_editor.block({ message: block_msg });

            ibox_title.html(f_selected);

            $del_file.html('<i class="fa fa-file"></i> ' + f_selected);
            $del_file.attr('data-path', f_selected);

            var modelist = ace.require("ace/ext/modelist");
            var mode = modelist.getModeForPath(f_selected).mode;
            editor.session.setMode(mode);


            if ($.inArray(ext, ib_file_supported) != -1)
            {
                // found it
                var isHidden = $editor_area.is(':hidden');

                if(isHidden){
                    $editor_area.show();
                }

                $other_file.html("");

                $.post( _url + "ide/file/get/", { file: f_selected })
                    .done(function( data ) {
                        $ib_internal_editor.unblock();
                        editor.$blockScrolling = Infinity;
                        editor.setValue(data, -1);
                        editor.setValue(data, 1);

                    });
            }

            else if ($.inArray(ext, ib_img_supported) != -1){
                $editor_area.hide();
                $ib_internal_editor.unblock();
                $other_file.html("<img class=\"img-responsive\" alt=\"'" + f_selected +"'\" src='" + ib_app_url+ f_selected +"'></img>");

            }

            else if (ext == 'zip'){

                $editor_area.hide();
                $ib_internal_editor.unblock();
                $other_file.html('<a href="' + _url +'ide/file/unzip/'+ window.btoa(f_selected) +'" class="btn btn-primary"><i class="fa fa-file-archive-o"></i> Unzip .'+ f_selected +'</a>');

            }

            else{
                $editor_area.hide();
                $ib_internal_editor.unblock();
            }



        },function(dir){

            $(".ib_f_selected").removeClass('ib_f_selected');
            dir.addClass('ib_f_selected');
            c_path = dir.attr('rel');

            $del_folder.html('<i class="fa fa-folder"></i> ' + c_path);
            $del_folder.attr('data-path', c_path);

        });
    }

    f_ib_file_tree();

    function editor_reset() {
        editor.$blockScrolling = Infinity;
        editor.setValue('');
        f_selected = '';
        ibox_title.html("iBilling Editor");
        $del_file.html('...');
        $del_file.attr('data-path', '...');
        $del_folder.html('...');
        $del_folder.attr('data-path', '...');
    }

    function editor_open(file, path) {

        if( path.charAt( 0 ) === '/' ){
            path = path.slice( 1 );
        }

        f_selected = path + file;

        ibox_title.html(f_selected);

        $del_file.html('<i class="fa fa-file"></i> ' + f_selected);
        $del_file.attr('data-path', f_selected);


        $.post( _url + "ide/file/get/", { file: f_selected })
            .done(function( data ) {
                editor.$blockScrolling = Infinity;
                editor.setValue(data, -1);
                editor.setValue(data, 1);

            });


    }

    var ib_upload_handler = new Dropzone("#upload_container",
        {
            url: _url + "ide/file/upload/",
            maxFiles: 10
        }
    );

    ib_upload_handler.on('sending', function(file, xhr, formData){
        formData.append('c_path', c_path);
    });

    ib_upload_handler.on("success", function(file) {
        location.reload();
    });

    $ib_save.on('click', function(e) {
        e.preventDefault();

        var codes = editor.getValue();

        if(c_path == ''){
            p_dir = '(Current Directory: root)';
        }
        else{
            p_dir = '(Current Directory: ' + c_path + ')';
        }

       if(f_selected == ''){



           bootbox.prompt("File Name ? " + p_dir, function(result) {
               if (result === null) {

               } else {
                   $.post( _url + "ide/file/save/", { file: result, path: c_path, codes: codes, new: 'yes' })
                       .done(function( data ) {
                           // if(c_path == ''){
                           //     c_path = '/';
                           // }
                           // f_selected = c_path + result;
                           // f_ib_file_tree();

                           location.reload();

                       });
               }
           });

       }

       else{

       $ib_internal_editor.block({ message: block_msg });



           $.post( _url + "ide/file/save/", { file: f_selected, path: c_path, codes: codes, new: 'no' })
               .done(function( data ) {
                   $ib_internal_editor.unblock();
               });

       }


    });

    $del_file.on('click', function(e) {
        e.preventDefault();

        var del_path = $(this).attr("data-path");

        if(del_path == '...'){
            bootbox.alert("Please select a file.", function() {

            });
            return;
        }

        bootbox.confirm("Are you sure? You want to delete file- " + del_path, function(result) {
            if(result){
                $.post( _url + "ide/file/delete/", { file: del_path })
                    .done(function( data ) {

                        // f_ib_file_tree();
                        // editor_reset();

                        location.reload();

                    });
            }
        });




    });

    $del_folder.on('click', function(e) {
        e.preventDefault();
        var del_path = $(this).attr("data-path");

        if(del_path == '...'){
            bootbox.alert("Please select a Folder.", function() {

            });
            return;
        }

        bootbox.confirm("Are you sure? You want to delete folder- " + del_path, function(result) {
            if(result){
                $.post( _url + "ide/file/delete_folder/", { file: del_path })
                    .done(function( data ) {

                        f_ib_file_tree();
                        editor_reset();

                    });
            }
        });

    });






    $ib_add_file.on('click', function(e) {

        e.preventDefault();



        if(c_path == ''){
            p_dir = '(Current Directory: root)';
        }
        else{
            p_dir = '(Current Directory: ' + c_path + ')';
        }

        bootbox.prompt("File Name ? " + p_dir, function(result) {
            if (result === null) {

            } else {
                $.post( _url + "ide/file/create/", { file: result, path: c_path })
                    .done(function( data ) {

                        f_ib_file_tree();
                        editor_reset();
                    });
            }
        });







    });


    $ib_add_folder.on('click', function(e) {

        e.preventDefault();

        var p_dir;

        if(c_path == ''){
            p_dir = '(Current Directory: root)';
        }
        else{
            p_dir = '(Current Directory: ' + c_path + ')';
        }

        bootbox.prompt("Folder Name ? " + p_dir, function(result) {
            if (result === null) {

            } else {
                $.post( _url + "ide/file/create_folder/", { file: result, path: c_path })
                    .done(function( data ) {
                        editor_reset();
                        f_ib_file_tree();
                    });
            }
        });







    });




});