<!doctype html>
<html lang="en" data-ng-app="FileManagerApp">
<head>
    <!--
      * Angular FileManager v1.5.1 (https://github.com/joni2back/angular-filemanager)
      * Jonas Sciangula Street <joni2back@gmail.com>
      * Licensed under MIT (https://github.com/joni2back/angular-filemanager/blob/master/LICENSE)
    -->
    <meta name="viewport" content="initial-scale=1.0, user-scalable=no">
    <meta charset="utf-8">
    <title>{$_title}</title>
    <link rel="shortcut icon" href="{$app_url}application/storage/icon/favicon.ico" type="image/x-icon" />

    <!-- third party -->
    <script src="{$app_url}application/plugins/ide/lib/angular/angular.min.js"></script>
    <script src="{$app_url}application/plugins/ide/lib/angular/angular-translate.min.js"></script>
    <script src="{$app_url}application/plugins/ide/views/js/ng-file-upload.min.js"></script>
    <script src="{$_theme}/js/jquery-1.10.2.js"></script>
    <script src="{$_theme}/js/bootstrap.min.js"></script>
    <link rel="stylesheet" href="{$app_url}application/plugins/ide/views/css/paper.min.css" />



    <!-- Comment if you need to use raw source code -->
    <link href="{$app_url}application/plugins/ide/lib/angular/filemanager.min.css" rel="stylesheet">
    <script src="{$app_url}application/plugins/ide/lib/angular/filemanager.min.js"></script>
    <!-- /Comment if you need to use raw source code -->

    <script type="text/javascript">
        //example to override angular-filemanager default config
        angular.module('FileManagerApp').config(['fileManagerConfigProvider', function (config) {
            var defaults = config.$get();
            config.set({
                appName: 'IDE File Manager',
                pickCallback: function(item) {
                    var msg = 'Picked %s "%s" for external use'
                            .replace('%s', item.type)
                            .replace('%s', item.fullPath());
                    window.alert(msg);
                },

                allowedActions: angular.extend(defaults.allowedActions, {
                    pickFiles: false,
                    pickFolders: false,
                }),
            });
        }]);
    </script>
</head>

<body class="ng-cloak">
<angular-filemanager></angular-filemanager>
</body>
</html>
