<?php
_auth();
$action = route(2);

// Ajax Response

function editor_deleteDir($dirPath) {
    if (! is_dir($dirPath)) {
        throw new InvalidArgumentException("$dirPath must be a directory");
    }
    if (substr($dirPath, strlen($dirPath) - 1, 1) != '/') {
        $dirPath .= '/';
    }
    $files = glob($dirPath . '*', GLOB_MARK);
    foreach ($files as $file) {
        if (is_dir($file)) {
            editor_deleteDir($file);
        } else {
            unlink($file);
        }
    }
    rmdir($dirPath);
}

switch ($action){

    case 'tree':

        $_POST['dir'] = urldecode($_POST['dir']);

//        if($_app_stage == 'Demo'){
//            $root = './vendor/';
//
//        }
//        else{
//            $root = './';
//        }

        $root = './';

        if( file_exists($root . $_POST['dir']) ) {
            $files = scandir($root . $_POST['dir']);
            natcasesort($files);
            if( count($files) > 2 ) { /* The 2 accounts for . and .. */
                echo "<ul class=\"jqueryFileTree\" style=\"display: none;\">";
                // All dirs
                foreach( $files as $file ) {
                    if( file_exists($root . $_POST['dir'] . $file) && $file != '.' && $file != '..' && is_dir($root . $_POST['dir'] . $file) ) {
                        echo "<li class=\"directory collapsed\"><a href=\"#\" rel=\"" . htmlentities($_POST['dir'] . $file) . "/\">" . htmlentities($file) . "</a></li>";
                    }
                }
                // All files
                foreach( $files as $file ) {
                    if( file_exists($root . $_POST['dir'] . $file) && $file != '.' && $file != '..' && !is_dir($root . $_POST['dir'] . $file) ) {
                        $ext = preg_replace('/^.*\./', '', $file);
                        echo "<li class=\"file ext_$ext\"><a href=\"#\" rel=\"" . htmlentities($_POST['dir'] . $file) . "\">" . htmlentities($file) . "</a></li>";
                    }
                }
                echo "</ul>";
            }
        }


        break;

    case 'get':

        $file = $_POST['file'];
        $file = ltrim($file, '/');

        if($_app_stage == 'Demo'){

            $ext = substr($file, strrpos($file, '.')+1);

            if($ext == 'php'){
                ib_die("<?php ".PHP_EOL ." //Sorry, Viewing PHP Source is disabled in the Demo Mode, check other files, e.g.- css / js. ".PHP_EOL ." //You may test by writing some code. Or view documentation here- https://cloudonex.github.io/ide/".PHP_EOL);
            }

        }



        $contents = file_get_contents($file);

        if ($contents === false) {
            ib_die('Unable to Open File: '.$file);
        } else {

            echo $contents;

        }



        break;

    case 'create':


        if($_app_stage == "Demo"){

            ib_die('Unable to create file in Demo Mode');

        }

        $file = $_POST['file'];
        $path = $_POST['path'];
        $path = ltrim($path, '/');

       // check path exist

        $create_file = $path.$file;



        if(file_exists($create_file)){

           ib_die('failed');

        }
        else{

            $fh = fopen($create_file, 'w') or die("Can't create file");

        }




        break;

    case 'create_folder':

        if($_app_stage == "Demo"){

            ib_die('Unable to create folder in Demo Mode');

        }

        $file = $_POST['file'];
        $path = $_POST['path'];
        $path = ltrim($path, '/');

        // check path exist

        $create_file = $path.$file;



//        if(file_exists($create_file)){
//
//            ib_die('failed');
//
//        }
//        else{
//
//            $fh = fopen($create_file, 'w') or die("Can't create file");
//
//        }

        if(mkdir($create_file)){
            ib_die('ok');
        }
        else{
            ib_die('failed');
        }


        break;



    case 'delete':

        if($_app_stage == "Demo"){

            ib_die('Unable to delete file in Demo Mode');

        }

        $file = $_POST['file'];
        $file = ltrim($file, '/');

       if(file_exists($file)){
           unlink($file);
           ib_die('ok');
       }
       else{
          ib_die('failed');
       }

        break;

    case 'delete_folder':

        if($_app_stage == "Demo"){

            ib_die('Unable to delete folder in Demo Mode');

        }

        $file = $_POST['file'];
        $file = ltrim($file, '/');

        try {

            editor_deleteDir($file);

        } catch (Exception $e) {
            die("failed");
        }


        break;

    case 'save':

        if($_app_stage == "Demo"){

            ib_die('Unable to Save file in Demo Mode');

        }

        $is_new = _post('new');

        $codes = $_POST['codes'];

        $file = $_POST['file'];
        $path = $_POST['path'];
        $path = ltrim($path, '/');

        // supported files

        $ib_file_supported = array("php", "html", "css", "tpl", "json", "js", "htaccess", "md", "csv", "txt");



        if($is_new == 'yes'){



            // check path exist

            $create_file = $path.$file;



            if(file_exists($create_file)){

                ib_die('failed');

            }
            else{

//                $fh = fopen($create_file, 'w') or die("Can't create file");


                $fp = fopen($create_file, 'w');
                fwrite($fp, $codes);
                fclose($fp);

            }

        }

        else{

            $create_file = ltrim($file, '/');
            $fp = fopen($create_file, 'w');
            fwrite($fp, $codes);
            fclose($fp);

        }



        ib_die('stream_ok');



        break;

    case 'upload':

        if($_app_stage == "Demo"){

           _msglog('e', 'Uploading File is disabled in the demo mode.');
            ib_close();

        }

        $path = $_POST['c_path'];
        $path = ltrim($path, '/');

        if($path == ''){
            $path = './';
        }

        $uploader   =   new Uploader();
        $uploader->setDir($path);
        $uploader->sameName(true);
        $uploader->allowAllFormats();  //allowed extensions list//
        if($uploader->uploadFile('file')){   //txtFile is the filebrowse element name //
            $uploaded  =   $uploader->getUploadName(); //get uploaded file name, renames on upload//

            _msglog('s',$path.$uploaded. " Uoloaded Successfully."); //get upload error message

        }else{//upload failed
            _msglog('e',$uploader->getMessage(). " $path"); //get upload error message
        }


        break;

    case 'unzip':

        if($_app_stage == "Demo"){

            ib_die('Unable to Unzip file in Demo Mode');

        }

        $file = route(3);



        $file = base64_decode($file);
        $file = ltrim($file, '/');


        $path = dirname($file).'/';



        $msg = '';

        if (class_exists('ZipArchive')) {
            $zip = new ZipArchive;

            $res = $zip->open($file);
            if ($res === TRUE) {

                $zip->extractTo($path);


//                if($zip->close()){
//
//                }
//                //

            } else {
                $msg .= 'An error occured while unzipping the file. <br>';
            }
        }

        else{
            $msg .= 'PHP ZipArchive Class is not Available! <br>';
        }

        if($msg != ''){
            _msglog('e',$msg);
        }
        else{
            _msglog('s','File Extracted');
        }


        r2(U.'ide/init/render/');

        break;


    case 'app_backup':

        if($_app_stage == "Demo"){

            ib_die('Unable to Create backup in Demo Mode');

        }

// Get real path for our folder
        $rootPath = realpath('./');


        $filename = 'ibilling_bakcup_'.date('M_d_Y_H_i_s').'.zip';

// Initialize archive object
        $zip = new ZipArchive();
        $zip->open($filename, ZipArchive::CREATE | ZipArchive::OVERWRITE);

// Create recursive directory iterator
        /** @var SplFileInfo[] $files */
        $files = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($rootPath),
            RecursiveIteratorIterator::LEAVES_ONLY
        );

        foreach ($files as $name => $file)
        {
            // Skip directories (they would be added automatically)
            if (!$file->isDir())
            {
                // Get real and relative path for current file
                $filePath = $file->getRealPath();
                $relativePath = substr($filePath, strlen($rootPath) + 1);

                // Add current file to archive
                $zip->addFile($filePath, $relativePath);
            }
        }

// Zip archive will be created only after closing object
        $zip->close();

        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename='.basename($filename));
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($filename));
        readfile($filename);


        break;


    default:

        echo 'null';
}