<?php

/**
 * CEmail - Email Construction Class
 * @package phpMyAgenda 3.0
 * @Author Tyree Jackson (phpMyAgenda 3.0)
 * @version $Id$
 * @copyright 2004
 * $Id: poll.inc.php3, v3.0 2004/01/06
 **/

if(!defined("_CEmail")):

define("_CEmail",TRUE); 

include_once("phpmailer/class.phpmailer.php");

class CEmail
{
	var $tokens					= array();
	var $strFromEmailAddress	= '';
	var $strFromEmailName		= '';
	var $strToEmailAddress		= '';
	var $strToEmailName			= '';
	var $strSubject				= '';
	var $strBody				= '';
	var $strHTMLBody			= '';
	var $strSMTPServer			= '';
	var $strLocalHost			= '';

	function init($strFromEmailAddress, $strFromEmailName, $strToEmailAddress, $strToEmailName, $strSubject, $strBody, $strHTMLBody, $strSMTPServer, $strLocalHost)
	{
		// Reset the tokens
		$tokens					= array();
		if (isset($strFromEmailAddress))
			$this->strFromEmailAddress	= $strFromEmailAddress;

		if (isset($strFromEmailName))
			$this->strFromEmailName		= $strFromEmailName;

		if (isset($strToEmailAddress))
			$this->strToEmailAddress	= $strToEmailAddress;

		if (isset($strToEmailName))
			$this->strToEmailName		= $strToEmailName;

		if (isset($strSubject))
			$this->strSubject			= $strSubject;

		if (isset($strBody))
			$this->strBody				= $strBody;

		if (isset($strHTMLBody))
			$this->strHTMLBody			= $strHTMLBody;

		if (isset($strSMTPServer))
			$this->strSMTPServer		= $strSMTPServer;

		if (isset($strLocalHost))
			$this->strLocalHost			= $strLocalHost;
	}

	function AddToken ($tokenKey, $tokenValue)
	{
		$this->tokens[$tokenKey] = $tokenValue;
		$this->strSubject = ereg_replace ("%".$tokenKey , $tokenValue , $this->strSubject);
		$this->strBody = ereg_replace ("%".$tokenKey , $tokenValue , $this->strBody);
		$this->strHTMLBody = ereg_replace ("%".$tokenKey , $tokenValue , $this->strHTMLBody);
	}

	function ApplyTokens($strString)
	{
		$strReturnString = $strString;

		foreach($this->tokens as $tokenKey => $tokenValue)
		{
			$strReturnString = ereg_replace ("%".$tokenKey , $tokenValue , $strReturnString);
		}
		
		return $strReturnString;
	}

	function SetSubject($strSubject)
	{
		$this->strSubject = $this->ApplyTokens($strSubject);
	}

	function SetBody($strBody)
	{
		$this->strBody = $this->ApplyTokens($strBody);
	}

	function SetHTMLBody($strHTMLBody)
	{
		$this->strHTMLBody = $this->ApplyTokens($strHTMLBody);
	}

	function SendMail()
	{
		if ($this->strToEmailAddress != '') 
		{
			debug("Sending email to $this->strToEmailAddress");
//			SendMail($this->strFromEmailAddress, $this->strFromEmailName, $this->strToEmailAddress, $this->strToEmailName, $this->strSubject, $this->strBody, $this->strHTMLBody);
	        $this->Mail = new PHPMailer();
	
	        $this->Mail->Priority = 3;
	        $this->Mail->Encoding = "8bit";
	        $this->Mail->CharSet = "iso-8859-1";
	        $this->Mail->From = $this->strFromEmailAddress;
	        $this->Mail->FromName = $this->strFromEmailName;
	        $this->Mail->Sender = $this->strFromEmailAddress;
	        $this->Mail->Subject = $this->strSubject;
	        $this->Mail->Body = $this->strHTMLBody;
			$this->Mail->IsHTML(true);
	        $this->Mail->AltBody = $this->strBody;
	        $this->Mail->WordWrap = 0;
	        $this->Mail->Host = $this->strSMTPServer;
	        $this->Mail->Port = 25;
	        $this->Mail->Helo = $this->strLocalHost;
	        $this->Mail->SMTPAuth = false;
	        $this->Mail->Username = "";
	        $this->Mail->Password = "";
	        $this->Mail->PluginDir = "";
			$this->Mail->AddReplyTo($this->strFromEmailAddress, $this->strFromEmailName);
	
	        if(strlen($this->Mail->Host) > 0)
	            $this->Mail->Mailer = "smtp";
	        else
	        {
	            $this->Mail->Mailer = "mail";
	        }
	        
            $this->Mail->AddAddress($this->strToEmailAddress, $this->strToEmailName);
			if (!$this->Mail->Send()) {
				// Log the attempt to send the message.
				syslog(LOG_INFO,"phpMyAgenda Mail: An error occurred while attempting to send the email: $this->Mail->ErrorInfo");
			}
		}
	}
}
endif; // define
?>