<?php
/**
 * Poll Include
 * @package phpMyAgenda 3.0
 * @Author Tyree Jackson (phpMyAgenda 3.0)
 * @version $Id$
 * @copyright 2004
 * $Id: poll.inc.php3, v3.0 2004/02/21
 **/
/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

if(!isset($POLLINCLUDE)):
	$POLLINCLUDE = 1;

function print_add_poll_form($idevent) {
/* print a blank poll form so we can add a new events */

	global $CFG,$ME;

	$frm["newmode"]     	  = "ins_poll";
	
	$frm["szPollQuestion"]			= "";
	$frm["bMultipleChoice"]    		= "";
	$frm["bAllowUsersToChangeVote"] = "";
	$frm["bAllowWriteInVotes"]      = "";

	$frm["idevent"]					= $idevent;
	
	$frm["valid"] 					= 0;
	$frm["nbpolloption"]			= 0;

	include("templates/poll_form.php3");
}

function print_edit_poll_form($idpoll) {
/* edit poll form */

	global $CFG,$ME;
	
	debug("Editing poll ".$idpoll);
	$qid = db_query("SELECT * FROM $CFG->table_EventPoll WHERE nEventPollID = $idpoll");
	$frm = db_fetch_array($qid);

	$frm["newmode"] = "update_poll";

	$frm["idevent"]	= $frm["nEventID"];
	$frm["idpoll"]	= $frm["nEventPollID"];
	if ($frm['dtAllowUsersToChangeVoteUntil'] > 0)
		explode_date($frm["dtAllowUsersToChangeVoteUntil"] , $frm["dtAllowUsersToChangeVoteUntilYear"] , $frm["dtAllowUsersToChangeVoteUntilMonth"] , $frm["dtAllowUsersToChangeVoteUntilDay"] , $frm["dtAllowUsersToChangeVoteUntilHour"] , $frm["dtAllowUsersToChangeVoteUntilMin"]);
		
	// Grab options for this poll
	$qid2 = db_query("SELECT * FROM $CFG->table_EventPollOption WHERE nEventPollID=".$idpoll);
	$frm["nbpolloption"]	= db_num_rows($qid2);
	$j=0;
	while ($s = db_fetch_object($qid2))
	{
      	$frm["polloption".$j] 		= $s->szOption;
      	$frm["polloptionid".$j++] 	= $s->nEventPollOptionID;
	}


	include("templates/poll_form.php3");
}


function insert_poll($frm , $valid = 0)
{
	global $CFG;
	$szPollQuestion					= formatSQLString($frm['szPollQuestion']);
	$bMultipleChoice 				= isset($frm['bMultipleChoice']) ? 1 : 0;
	$bAllowUsersToChangeVote 		= isset($frm['bAllowUsersToChangeVote']) ? 1 : 0;
	$dtAllowUsersToChangeVoteUntil 	= isset($frm['dtAllowUsersToChangeVoteUntil']) ? $frm['dtAllowUsersToChangeVoteUntil'] : null;
	$bAllowWriteInVotes       		= isset($frm['bAllowWriteInVotes']) ? 1 : 0;

	debug("INSERT INTO $CFG->table_EventPoll
	       (nEventID, szPollQuestion, bMultipleChoice, bAllowUsersToChangeVote, dtAllowUsersToChangeVoteUntil, bAllowWriteInVotes, valid)
	        VALUES ($frm[idevent], '$szPollQuestion',$bMultipleChoice, $bAllowUsersToChangeVote , '$dtAllowUsersToChangeVoteUntil', $bAllowWriteInVotes, $valid)");
	$qid = db_query("INSERT INTO $CFG->table_EventPoll
	       (nEventID, szPollQuestion, bMultipleChoice, bAllowUsersToChangeVote, dtAllowUsersToChangeVoteUntil, bAllowWriteInVotes, valid)
	        VALUES ($frm[idevent], '$szPollQuestion',$bMultipleChoice, $bAllowUsersToChangeVote , '$dtAllowUsersToChangeVoteUntil', $bAllowWriteInVotes, $valid)");
	$nEventPollID = db_insert_id();
	return $nEventPollID;
}

function update_poll($idpoll , $frm)
{
	global $CFG;
	$bMultipleChoice 				= isset($frm['bMultipleChoice']) ? 1 : 0;
	$bAllowUsersToChangeVote 		= isset($frm['bAllowUsersToChangeVote']) ? 1 : 0;
	$dtAllowUsersToChangeVoteUntil 	= isset($frm['dtAllowUsersToChangeVoteUntil']) && $frm['dtAllowUsersToChangeVoteUntil'] != '' ? "'".$frm['dtAllowUsersToChangeVoteUntil']."'" : 'null';
	$bAllowWriteInVotes       		= isset($frm['bAllowWriteInVotes']) ? 1 : 0;

	$qid = db_query("UPDATE $CFG->table_EventPoll SET 
										szPollQuestion 			      = '$frm[szPollQuestion]' , 
										bMultipleChoice			      = $bMultipleChoice , 
										bAllowUsersToChangeVote       = '$bAllowUsersToChangeVote', 
										dtAllowUsersToChangeVoteUntil = $dtAllowUsersToChangeVoteUntil,
										bAllowWriteInVotes            = $bAllowWriteInVotes
									WHERE nEventPollID = $idpoll");
}

function delete_poll($idpoll)
{
	global $CFG;
	debug("DELETE EventPollOptionVote FROM $CFG->table_EventPollOptionVote epov, $CFG->table_EventPollOption epo WHERE epov.nEventPollOptionID = epo.nEventPollOptionID AND epo.nEventPollID = $idpoll");
	$qid = db_query("DELETE EventPollOptionVote FROM $CFG->table_EventPollOptionVote epov, $CFG->table_EventPollOption epo WHERE epov.nEventPollOptionID = epo.nEventPollOptionID AND epo.nEventPollID = $idpoll");
	debug("Deleting options.");
	$qid = db_query("DELETE FROM $CFG->table_EventPollOption WHERE nEventPollID = $idpoll");
	debug("Deleting poll.");
	$qid = db_query("DELETE FROM $CFG->table_EventPoll WHERE nEventPollID = $idpoll");
}

function remove_nonvalid_polls()
{
	global $CFG;
 	db_query("DELETE FROM $CFG->table_EventPollOptionVote WHERE (SELECT ep.valid FROM $CFG->table_EventPoll ep JOIN $CFG->table_EventPollOption epo ON ep.nEventPollID = epo.nEventPollID WHERE epo.nEventPollOptionID = $CFG->table_EventPollOptionVote.nEventPollOptionID) = 0");
 	db_query("DELETE FROM $CFG->table_EventPollOption WHERE (SELECT valid FROM $CFG->table_EventPoll WHERE $CFG->table_EventPoll.nEventPollID = $CFG->table_EventPollOption.nEventPollID) = 0");
 	db_query("DELETE FROM $CFG->table_EventPoll WHERE valid=0");
 	debug("removing non valid poll");
}

function delete_poll_from_event($idevent){
// remove all polls refering to $iddevent
	global $CFG;
 	db_query("DELETE FROM $CFG->table_EventPollOptionVote WHERE (SELECT ep.nEventID FROM $CFG->table_EventPoll ep JOIN $CFG->table_EventPollOption epo ON ep.nEventPollID = epo.nEventPollID WHERE epo.nEventPollOptionID = $CFG->table_EventPollOptionVote.nEventPollOptionID) = $idevent");
 	db_query("DELETE FROM $CFG->table_EventPollOption WHERE (SELECT nEventID FROM $CFG->table_EventPoll WHERE $CFG->table_EventPoll.nEventPollID = $CFG->table_EventPollOption.nEventPollID) = $idevent");
 	db_query("DELETE FROM $CFG->table_EventPoll WHERE nEventID = $idevent");
}

function validate_poll_form(&$frm , $mode, $idpoll)
{
	// validate date form
  global $CFG,$ME;
  debug("validating poll form");
 	$validation 			= false;
 	$validation_step  = 0;

 	if(empty($frm["szPollQuestion"]))
 	{
	  $validation = true;
 	}

	if ($frm["dtAllowUsersToChangeVoteUntilMonth"] != '' || $frm["dtAllowUsersToChangeVoteUntilDay"] != '' || $frm["dtAllowUsersToChangeVoteUntilYear"] != '' || $frm["dtAllowUsersToChangeVoteUntilHour"] != '' || $frm["dtAllowUsersToChangeVoteUntilMin"] != '')
     	if(!checkdate($frm["dtAllowUsersToChangeVoteUntilMonth"] , $frm["dtAllowUsersToChangeVoteUntilDay"] , $frm["dtAllowUsersToChangeVoteUntilYear"]) ||
     		 !validate_date($frm["dtAllowUsersToChangeVoteUntilHour"]  	, 0 , 23) ||
     		 !validate_date($frm["dtAllowUsersToChangeVoteUntilMin"]  	, 0 , 59))
    	{
    		$validation 								  = true;
    	 	$validation_dtAllowUsersToChangeVoteUntilMin  = 1;
    	 	debug("error during validation on checkdate vote until date");
    	}

 	if($validation)
 	{
 		$frm["newmode"] = $mode;

		if (isset($idpoll))
		{
        	// Grab options for this poll
        	$qid2 = db_query("SELECT * FROM $CFG->table_EventPollOption WHERE nEventPollID=".$idpoll);
        	$frm["nbpolloption"]	= db_num_rows($qid2);
        	$j=0;
        	while ($s = db_fetch_object($qid2))
        	{
              	$frm["polloption".$j] 		= $s->szOption;
              	$frm["polloptionid".$j++] 	= $s->nEventPollOptionID;
        	}
		}
 		include("templates/poll_form.php3");
		return false;
 	}
 	return true; 	  
}
endif;
?>