<?php
// script from emmanuel vanneau (phpMyAgenda)
// $Id: place.inc.php3, v2.0 2001/01/06 
/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/
if(!isset($PLACEINCLUDE)):
	$PLACEINCLUDE = 1;

function print_add_place_form($idevent) {
/* print a blank places form so we can add a new places */

	global $CFG,$ME;
	
	$frm["newmode"]     	  = "ins_place";
	$frm["nextstep"] 				= "";
	$frm["idevent"]					= $idevent;

	$frm["name"]    				= "";
	$frm["address"] 				= "";
	$frm["town"]    				= "";
	$frm["zipcode"] 				= "";
	$frm["country"] 				= "";
	$frm["contact1"] 				= "";
	$frm["contact2"] 				= "";
	$frm["contact3"] 				= "";
	$frm["contact4"] 				= "";
	$frm["contact5"] 				= "";
	$frm["contactname1"]		= "";
	$frm["contactname2"]		= "";
	$frm["contactname3"]		= "";
	$frm["contactname4"]		= "";
	$frm["contactname5"]		= "";
	$frm["url"]     				= "<select name=\"url\">"
				       							. "<option value=0> </option>"
										        . db_listbox("SELECT id, url FROM $CFG->table_url", "0")
										        . "</select>";
	$frm["phone"]   				= "";
	$frm["fax"]     				= "";
	$frm["owner"]						= "";
	
	$frm["submit_caption"] 	= "Next step";
	$frm["valid"] 					= 0;
	
	include("templates/place_form.php3");
}

function print_select_place_form($idevent , $idplace = 0 , $iddate = 0) {
/* print a places list box so we can select a place */

	global $CFG,$ME,$Auth;
	
	$frm["newmode"]     	  = "selected_place";
	$frm["idevent"]					= $idevent;
	$frm["iddate"]					= $iddate;
	if($Auth->place_access_all())
		$query = "SELECT id, name FROM $CFG->table_place ORDER BY name";
	elseif($Auth->place_access_partial())
	{
		$count = count($Auth->place_list);
		debug("count place = $count");
		$query = "SELECT id, name FROM $CFG->table_place"; 
		if($count)
		{
			$query .= " WHERE (";
			for($i=0 ; $i<$count ; $i++)
			{
				if($i != 0)
					$query .= " OR";
				$query .= " id = ".$Auth->place_list[$i];
			}		
			$query .= " )";
		}
		else
			$query .= " WHERE 0"; // list empty so display no places
		$query .= " ORDER BY name";
	}	
	debug("query = $query");
	$frm["place"]						= "<select name=\"place\">".db_listbox($query , $idplace)."</select>";
	$frm["submit_caption"] 	= "Next step";
	$frm["valid"] 					= 0;
	
	include("templates/place_select.php3");
}

function remove_nonvalid_places()
{
	global $Auth,$CFG;
 	debug("removing non valid place");
	db_query("DELETE FROM $CFG->table_place WHERE valid=0 AND owner=$Auth->id");
}

function get_places($id){
	
	global $CFG;
	$qid = db_query("SELECT * FROM $CFG->table_place WHERE  id = $id");
	$frm = db_fetch_array($qid);
	return $frm;
}

function check_unique_place($frm)
{
//Check that place with fields in $frm is not present in the table
//return : 0 if not present in table
//         place.id if present

	global $CFG;
  $query = "SELECT id FROM $CFG->table_place WHERE ";
  $query .= "name='".$frm["name"]."' AND ";
  $query .= "address='".$frm["address"]."' AND ";
  $query .= "town='".$frm["town"]."' AND ";
  $query .= "zipcode='".$frm["zipcode"]."' AND ";
  $query .= "country='".$frm["country"]."' AND ";
  $query .= "url='".$frm["url"]."' AND ";
  $query .= "phone='".$frm["phone"]."' AND ";
  $query .= "fax='".$frm["fax"]."'";
  $qid = db_query($query);
  if($row = mysql_fetch_array ($qid))
   return $row["id"];
  return 0;
}

function print_edit_places_form($id , $idevent = 0)
{
/* print a places form so we can add a edit the selected places */

  global $CFG, $ME;

  /* load up the information for the places */
  $frm = get_places($id);

  /* set values for the form */
  $frm["newmode"] = "update_place";
  $frm["idevent"] = $idevent;
  for($i=1 ; $i<=5 ; $i++)
	{
		$idc 	= $frm["contact".$i];
		$qidc = db_query("SELECT id,name FROM $CFG->table_contact WHERE id = $idc");
		if(db_num_rows($qidc))
		{
			$r = db_fetch_object($qidc);
   		$frm["contactname".$i]	=	$r->name;
   	}
   	else
   		$frm["contactname".$i]	=	"";
  	db_free_result($qidc);
	}
  $frm["url"]       = "<select name=\"url\">"
       							. "<option value=0> </option>"
       							. db_listbox("SELECT id, url FROM $CFG->table_url ORDER BY url ", $frm["url"])
       							. "</select>";
  $frm["submit_caption"] = "Save Changes";

  include("templates/place_form.php3");
}

function replace_place($id)
{
// used to scan dates to get item with place=$id
// replace these items url's with 1(No url);

	global $CFG;
	$replaced = replace_in_table($CFG->table_date , "place" , "$id" , "0");
	if($replaced)
		echo "<div class=normal>The place has been found in <b>$replaced events</b>. Replacing these places' url with default</div>";
}

function delete_places($id) {
	global $CFG, $ME;
	
	/* replacing this place in other tables*/
	replace_place($id);
	
	/* delete this places */
	$qid = db_query("DELETE FROM $CFG->table_place WHERE id = $id");
}

function insert_places($frm,  $valid = "1")
{
/* add a new subplaces under the parent $id.  all the fields that we want are
 * going to in the variable $frm */

  global $CFG, $ME , $Auth;
  $id = check_unique_place($frm);
  if($id)
  {
  	$frm["name"] .= " (2)";
  }

  if($frm["url"] == 0 && !empty($frm["newurl"]))
 	{
 		$frm["url"] = insert_url($frm);
 		debug("inserting url ".$frm["newurl"]." as id=".$frm["url"]);
 	}
 	
  $query = "INSERT INTO $CFG->table_place 
  								(id, name, address, town, zipcode, country, contact1 , contact2 , contact3 , contact4 , contact5 , url, phone, fax , valid , owner) 
  				VALUES ('', 
  				'$frm[name]', 
  				'$frm[address]', 
  				'$frm[town]', 
  				'$frm[zipcode]', 
  				'$frm[country]', 
  				'$frm[contact1]', 
  				'$frm[contact2]', 
  				'$frm[contact3]', 
  				'$frm[contact4]', 
  				'$frm[contact5]', 
  				'$frm[url]', 
  				'$frm[phone]', 
  				'$frm[fax]', 
  				'$valid',
  				'$Auth->id')";

  $qid = db_query($query);
  return db_insert_id();
}

function update_places($id, $frm) {
/* update the places $id with new values.  all the fields that we want are
 * going to in the variable $frm */

  global $CFG, $ME;

  if($frm["url"] == 0 && !empty($frm["newurl"]))
 	{
 		$frm["url"] = insert_url($frm);
 		debug("inserting url ".$frm["newurl"]." as id=".$frm["url"]);
 	}

  $qid = db_query("
  UPDATE place SET
          name 			= '$frm[name]'
          ,address 	= '$frm[address]'
          ,town 		= '$frm[town]'
          ,zipcode 	= '$frm[zipcode]'
          ,country 	= '$frm[country]'
          ,contact1	= '$frm[contact1]'
          ,contact2	= '$frm[contact2]'
          ,contact3	= '$frm[contact3]'
          ,contact4	= '$frm[contact4]'
          ,contact5	= '$frm[contact5]'
          ,url 			= '$frm[url]'
          ,phone 		= '$frm[phone]'
          ,fax 			= '$frm[fax]'
  WHERE id = $id
  ");

}

function print_places_list($orderby="") {
/* read all the categories from the database and print them into a table.  we
 * will use a template to display the listings to keep this main script clean */

  global $CFG, $ME, $Auth;
  $req_listplaces = "SELECT p.id , p.name, p.address , p.town, p.zipcode, p.country, p.owner, 
             p.phone, p.fax
             FROM   $CFG->table_place p WHERE 1";
	if(!$Auth->is_admin())
	{
		debug("no admin");
		if($Auth->can_read_own() 
			|| $Auth->can_edit_own() 
			|| $Auth->place_access_partial() 
			|| $Auth->place_access_all()) // user can read or edit its own events
		{
			if($Auth->can_read_own() || $Auth->can_edit_own() && !($Auth->place_access_partial() || $Auth->place_access_all()))
			{
				debug("own ok");
				$req_listplaces .= " AND p.owner = $Auth->id";
			}
			if($Auth->place_access_partial())
			{
				$count = count($Auth->place_list);
				debug("count place = $count");
				if($count)
				{
					$req_listplaces .= " AND (";
					for($i=0 ; $i<$count ; $i++)
					{
						if($i != 0)
							$req_listplaces .= " OR";
						$req_listplaces .= " p.id = ".$Auth->place_list[$i];
					}		
					$req_listplaces .= " )";
				}
			}
		}
		else
			$req_listevents .= "AND 0"; // avoid displaying any event
		
		if($Auth->place_access_none())
			$req_listevents .= " AND 0"; // avoid displaying any event (override all other access)
	}
	else
		debug("admin");
  if($orderby)
   $req_listplaces .= " ORDER BY ".$orderby." ASC";
	debug("list places = ".$req_listplaces);
  $qid = db_query($req_listplaces);

  include("templates/places_list.php3");
}

function validate_place_form($frm , $mode)
{
  global $CFG,$ME;
 	if(empty($frm["name"]))
 	{
 		$frm["newmode"]   = $mode;
	  $frm["url"]    = "<select name=\"url\">"
	          . "<option value=0> </option>"
	          . db_listbox("SELECT id, url FROM $CFG->table_url ORDER BY url", $frm["url"])
	          . "</select>";
	  $validation = true;
	  $id = $frm["id"];
 		include("templates/place_form.php3");
 		return false;
 	}
 	return true; 	  
}	

function	add_contact_to_place($idplace , $idcontact)
{
	// Add a contact reference to the event
	global $CFG;
	$qid = db_query("SELECT * FROM $CFG->table_place WHERE id=$idplace");
  $r 	 = db_fetch_array($qid);
  $done= false;
  for($i=1 ; $i<=5 && !$done ; $i++)
	{
		$cid = "contact".$i;
		if($r[$cid] == 0)
		{
			db_query("UPDATE $CFG->table_place SET $cid = $idcontact WHERE id=$idplace");
			debug("contact place # $i added");
			$done = true;
		}
  }
}

function update_contact_to_place($idplace , $idcontact , $idcontactnumber=0)
{
	global $CFG;
	$cid = "contact".$idcontactnumber;
	debug("updating $cid");
	db_query("UPDATE $CFG->table_place SET $cid = $idcontact WHERE id=$idplace");
	debug("contact place # $idcontactnumber updated");
}

function	remove_contact_from_place($idplace , $idcontact)
{
	// remove a contact reference from the event
	global $CFG;
	$cid = "contact".$idcontact;
	db_query("UPDATE $CFG->table_place SET $cid = 0 WHERE id=$idplace");
	debug("contact place # $idcontact remove");
}
endif;
?>