<?php
// phpMyAgenda Visitor interface library
// This file contains all functions needed to link user interfaces to phpMyAgenda Engine.
//
// creation : 26/03/2001 Manu Vanneau

// UI interface is mainly composed of a left menu and various display pages.
if(!isset($VISITORUIINCLUDE)):
	$VISITORUIINCLUDE = 1;

class CSingleEvent
{
	// this class manage calendar display
  // 09/04/2001 Manu vanneau mvanneau@hotmail.com

	var $id			 		= 0;					// the event id to display
	var $place 	 		= 0;					// the event's place id to display
	var $contact 		= 0;					// the event's contact to display
	var $language		= "english";	// Display language

	function Init($language)
	{
		// Initialize the single event display
		global $placesel, $contactsel,$id, $modeagenda;

		if(!isset($id))
			$id=0;
		if(!isset($placesel))
			$placesel=0;
		if(!isset($contactsel))
			$contactsel=0;

		$this->id 			= $id;
		$this->place 		= $placesel;
		$this->contact 	= $contactsel;
		$this->language = $language;
		$this->modeagenda = $modeagenda;
	}

	function DisplayEvent()
	{
		// do the query

		global $Auth, $rootagenda, $CFG, $strOrganizer, $strMoreInfo, $ME, $strMorePlace, $strMoreOrga, $strRegisterForEvent, $strUnregisterForEvent, $modeagenda, $strLogin;
		include("admin/include/events.inc.php3");

		$query 			= "SELECT e.* , t.type typevent FROM $CFG->table_event e, $CFG->table_eventtype t WHERE e.id=$this->id AND e.type = t.id";
		debug($query);
		$qidevent   = db_query($query);
		$r   		= db_fetch_object($qidevent);
	  if($r->image != "")
	  {
	  	$r->image = $CFG->image_event_dir."/".$r->image;
	  	if(is_file($r->image))
	  	{
	  		$size = getimagesize($r->image);
		  	$size = limit_image_size($size , $CFG->limit_image_display_x , $CFG->limit_image_display_y);
		  	$r->imagex = $size[0];
		  	$r->imagey = $size[1];
		  }
		  else
		  {
		  	$r->imagex = $CFG->limit_image_display_x;
		  	$r->imagey = $CFG->limit_image_display_y;
		  }
	  }
    echo " <table border='0' cellspacing='0' cellpadding='1' width='100%'>\n";
		echo "  <tr>\n";
		echo "    <td valign='top' width='".$CFG->limit_image_display_x."'>\n";
		if($r->image != "")
			echo "<a href='".$r->image."' target='_blank'><img alt=' ' src='".$r->image."' width='".$r->imagex."' height='".$r->imagey."' border=0></a>\n";
		else
			echo "&nbsp;";
		echo "	</td>\n";
		echo "  <td>\n";
    echo " 	<table border='0' cellspacing='0' cellpadding='1' width='100%'>\n";
    echo "   	<tr class=result_title> \n";
    echo "      <td colspan='2'>\n";
    echo pv($r->title)."&nbsp;</td>\n";
    echo "    </tr>\n";
    echo "    <tr class=result_type> \n";
    echo "    	<td colspan='2'>\n";
    echo pv($r->typevent)."&nbsp;</td>\n";
    echo "    </tr>\n";
    echo "    <tr class=normal> \n";
    echo "    	<td height='15' colspan='2' style=\"white-space:normal;\">\n";
    echo pv($r->description)."&nbsp;</td>\n";
    echo "    </tr>\n";
    $qidate = db_query("SELECT start, end, place.name, place.id  FROM $CFG->table_date date ,$CFG->table_place place WHERE date.place = place.id AND date.event = '$r->id' GROUP BY date.start ORDER BY date.start");
		echo "    <tr>\n";
    echo "    	<td colspan='2'> \n";
    echo "    		<table width='100%' border='0' cellspacing='0' cellpadding='0'>\n";
    echo "        	<tr>\n";
		if(db_num_rows($qidate) > 0)
		{
      echo "        	<td colspan='2' height='19'>\n";
      echo "          	<table width='100%' border='0' cellspacing='0' cellpadding='0'>\n";
      echo "							<tr><td class=result_description><br>$strMorePlace</td></tr>\n";
      while($dates  = db_fetch_object($qidate))
      {
				echo "<tr><td class=normal width='50%' nowrap>".dispdate($dates->start , $dates->end , $this->language)."&nbsp;</td>\n";

				if ($this->place == 0)
				    $this->place = $dates->id;

    		echo "<td class=normal> at &nbsp;&nbsp;&nbsp;<a href=\"$ME?id=$this->id&placesel=$dates->id&contactsel=$this->contact&modeagenda=".$modeagenda."\">$dates->name</a></td></tr>\n";
    	}
    	db_free_result($qidate);

      echo "            </table>\n";
      echo "          </td>\n";
    }
    //echo "        </td>\n";
    echo "      </tr>\n";
    echo "      </table>\n";
    echo "      </td>\n";
    echo "      </tr>\n";
    echo "			<tr><td class=result_description><br>$strMoreOrga</td></tr>\n";
    echo "    	<tr>\n";
    echo "      	<td class=normal width='89%'>\n";
    $query = "SELECT id, name FROM $CFG->table_contact WHERE ";
    $contact = array(1=>$r->contact1 , $r->contact2 , $r->contact3 , $r->contact4 , $r->contact5);
		$i = 0;
		for($n=1 ; $n<=5 ; $n++)
		{
			if($contact[$n])
			{
				$i++;
				$query .= "id = '$contact[$n]' ";
				if($n<5 && $contact[$n+1])
					$query .= " OR ";
			}
		}
		if($i)
		{
			$qicon = db_query($query);
			echo $strOrganizer." : ";
			for($z=0 ; $z<$i ; $z++)
			{
				$con = db_fetch_array($qicon);
				echo "<a href=\"$ME?id=$this->id&placesel=$this->place&contactsel=$con[id]&modeagenda=".$modeagenda."\">".$con["name"]."</a>";
				if($z<$i-1)
					echo " | ";
			}
			db_free_result($qicon);
		}
		echo "          </td>\n";
    echo "        </tr>\n";
	if ($Auth->can_do_basic())
	{
	    echo "    	<tr>\n";
	    echo "      	<td class=normal width='89%'>\n";
		$this->DisplayRegisteredUsers($this->id, $Auth->id);
		echo "          </td>\n";
	    echo "      </tr>\n";
	    echo "    	<tr>\n";
	    echo "      	<td class=normal width='89%'>\n";

	    $searchString = '';
	    if ($modeagenda == 'search')
	    {
	        $searchString.= "&selecttype=".$_GET['selecttype'];
	        $searchString.= "&selectmonth=".$_GET['selectmonth'];
	        $searchString.= "&selectyear=".$_GET['selectyear'];
	        $searchString.= "&selectmonthend=".$_GET['selectmonthend'];
	        $searchString.= "&selectyearend=".$_GET['selectyearend'];
	        $searchString.= "&selectplace=".$_GET['selectplace'];
	        $searchString.= "&selectcontact=".$_GET['selectcontact'];
	        $searchString.= "&orderby=".$_GET['orderby'];
	        $searchString.= "&limit=".$_GET['limit'];
	        $searchString.= "&recherche=1";
	   }

		if ($this->bCurrentUserRegistered == false)
		{
		  	echo "<a href=\"eventregisteruser.php3?referrer=infoevent&nEventID=$this->id&id=$this->id&language=$this->language&modeagenda=$this->modeagenda&register=1$searchString\">$strRegisterForEvent</a>";
		}
		else
		{
		  	echo "<a href=\"eventregisteruser.php3?referrer=infoevent&nEventID=$this->id&id=$this->id&language=$this->language&modeagenda=$this->modeagenda&register=0$searchString\">$strUnregisterForEvent</a>";
		}
	}

	echo "          </td>\n";
    echo "      </tr>\n";

	echo "    	<tr>\n";
	echo "      	<td class=result_description width='89%'>&nbsp;\n";
	echo "          </td>\n";
	echo "      </tr>\n";

	echo "    	<tr>\n";
	echo "      	<td class=result_description width='89%'>\n";
	echo $this->DisplayEventPolls($this->id, $Auth->id, 'infoevent', $this->bCurrentUserRegistered);
	echo "          </td>\n";
	echo "        </tr>\n";

    echo "      </table>\n";
    echo "    </td>\n";
    echo "  </tr>\n";
    echo "</table>\n";
	echo "</td>\n";
	echo "</tr>\n";
	echo "</table>\n";

    // Load up the query parameters passed in to pass back to the referrer
    $queryString = '';
	$delimeter   = '?';
    foreach($_GET as $postVarKey => $postVarVal)
    {
    	$queryString .= "$delimeter$postVarKey=$postVarVal";
		$delimeter = '&';
    }

    echo "<table border='0' cellspacing='0' cellpadding='1' width='100%'>\n";
    echo "	<tr> \n";
    echo "		<td class=normal>\n";
	echo "			<a href=\"agenda.php3$queryString#$this->id\">Back to Calendar</a>\n";
	echo "		</td>\n";
	echo "	</tr>\n";
    if (!$Auth->can_do_basic())
	{
		echo "  <tr>\n";
	    echo "    <td class=normal nowrap><a href='/infoevent.php3?&nEventID=$this->id&id=$this->id&language=$this->language&modeagenda=$this->modeagenda$searchString&dologin=1'>$strLogin</a></td>\n";
		echo "	</tr>\n";
	}
	echo "</table>\n";
		db_free_result($qidevent);
	}

	function DisplayRegisteredUsers($nEventID, $nCurrentUserID)
	{
		global $CFG, $strRegisteredUsers;
		$blankOrComma = "";
		$req_listeventusers = "SELECT eru.nEventRegisteredUserID, u.user, u.szFirstName, u.szLastName, eru.nUserID FROM $CFG->table_EventRegisteredUser eru JOIN $CFG->table_admin u ON eru.nUserID = u.id
  										  WHERE  eru.nEventID = $nEventID ORDER BY u.szFirstName, u.szLastName";
	    $qid = db_query($req_listeventusers);

		$this->bCurrentUserRegistered = false;
		echo("                                                                                    <u>$strRegisteredUsers</u>\n                                                                                    <BR>\n");
		while ($r = db_fetch_object($qid))
		{
			if ($r->nUserID == $nCurrentUserID)
			{
				$this->bCurrentUserRegistered = true;
			}
	      	echo $blankOrComma;
      		echo "                                                                                    ".$r->szFirstName.' '.$r->szLastName.'['.$r->user.']';
			$blankOrComma = "\n                                                                                    <BR>\n";
		}
	}

	function DisplayEventPolls($nEventID, $nCurrentUserID, $refferer, $bCurrentUserRegistered)
	{
		global $CFG, $strChangeVoteUntil, $strVoteClosed, $strEventPolls, $strVoteNow;
		$blankOrComma = "";
		$req_listeventpolls = "SELECT ep.nEventPollID, ep.szPollQuestion, ep.bMultipleChoice, CASE WHEN ep.bAllowUsersToChangeVote = 1 AND (ep.dtAllowUsersToChangeVoteUntil > NOW() OR ep.dtAllowUsersToChangeVoteUntil IS NULL) THEN 1 WHEN ep.bAllowUsersToChangeVote = 1 AND (ep.dtAllowUsersToChangeVoteUntil <= NOW()) THEN -1 ELSE 0 END AS bAllowUsersToChangeVote, ep.dtAllowUsersToChangeVoteUntil, ep.bAllowWriteInVotes FROM $CFG->table_EventPoll ep
  										  WHERE  ep.nEventID = $nEventID ORDER BY ep.nEventPollID";
	    $qid = db_query($req_listeventpolls);
		if (db_num_rows($qid) == 0)
			return;


		$align = $refferer == 'soon' ? 'left' : 'center';
		echo "<table align=$align border=0 width=100% cellpadding=4 cellspacing=0><tr>" ;
		echo "<th class=normal_search_poll colspan=3 align=\"left\"><u>$strEventPolls</u><BR><HR></th></tr>";
		$bShowVoteSubmitButton = false;
		while ($r = db_fetch_object($qid))
		{
    		if ($r->bAllowUsersToChangeVote == 1)
    			$bAllowUsersToChangeVote = true;

			echo "<tr><td class=normal_search_poll width=\"200\" valign=\"top\" align=\"left\">";
      		echo "<font color=\"#000000\"><b>".$r->szPollQuestion."</b></font>";
			if ($bAllowUsersToChangeVote && isset($r->dtAllowUsersToChangeVoteUntil) && $r->dtAllowUsersToChangeVoteUntil != '')
				echo "<BR><BR>".ereg_replace("%changeVoteUntilTime", dispdate($r->dtAllowUsersToChangeVoteUntil , $r->dtAllowUsersToChangeVoteUntil , $this->language), $strChangeVoteUntil)."";
			elseif  (!$bAllowUsersToChangeVote && isset($r->dtAllowUsersToChangeVoteUntil) && $r->dtAllowUsersToChangeVoteUntil != '')
				echo "<BR><BR>$strVoteClosed";

			echo "</td>";
			echo "<td nowrap class=normal_search_poll align=\"left\">" ;

			$time = time();
    		if ($r->bAllowUsersToChangeVote == 1 && $bCurrentUserRegistered)
				echo "<input type=\"hidden\" name=\"nPollID-$r->nEventPollID\" value=\"$r->nEventPollID\">";
			$bUserHasVoted = $this->DisplayEventPollOptions($r->nEventPollID, $r->bMultipleChoice, $r->bAllowUsersToChangeVote, $r->bAllowWriteInVotes, $nEventID, $nCurrentUserID, $refferer, $bCurrentUserRegistered);
			if ((!$bUserHasVoted && $r->bAllowUsersToChangeVote != -1) || ($bUserHasVoted && $r->bAllowUsersToChangeVote == 1))
				$ShowVoteSubmitButton = true;
			echo "</td><td class=normal_search_poll width=\"50\">&nbsp;</td></tr><tr><td class=normal_search_poll colspan=2><HR></td><td class=normal_search_poll width=\"50\">&nbsp;</td></tr>";
		}

		if ($ShowVoteSubmitButton && $bCurrentUserRegistered)
		{
			echo "<tr><td class=normal_search_poll valign=\"top\">";
			echo "</td>";
			echo "<td align=\"left\" class=normal_search_poll>";
			echo "<a href=\"\" onClick=\"Submitvote(); return false;\">$strVoteNow</a>";
			echo "</td></td><td class=normal_search_poll width=\"50\">&nbsp;</td></tr>";
		}
		echo "</table>\n";
	}

	function DisplayEventPollOptions($nEventPollID, $bMultipleChoice, $bAllowUsersToChangeVote, $bAllowWriteInVotes, $nEventID, $nCurrentUserID, $refferer, $bCurrentUserRegistered)
	{
		global $CFG, $strWriteInVote;
		$blankOrComma = "";

		// Get total number of votes for this poll
		$req_listeventpolloptionvotes = "SELECT epov.nEventPollOptionVoteID FROM $CFG->table_EventPollOption epo JOIN $CFG->table_EventPollOptionVote epov ON epo.nEventPollOptionID = epov.nEventPollOptionID JOIN $CFG->table_EventRegisteredUser eru ON epov.nUserID = eru.nUserID AND eru.nEventID = $nEventID
  										  WHERE epo.nEventPollID = $nEventPollID";
	    $qid = db_query($req_listeventpolloptionvotes);
		$TotalNumberOfVotes = db_num_rows($qid);

		// Get information regarding the current user and the poll
		$req_listeventpolloptionvotes = "SELECT epov.nEventPollOptionVoteID FROM $CFG->table_EventPollOption epo JOIN $CFG->table_EventPollOptionVote epov ON epo.nEventPollOptionID = epov.nEventPollOptionID JOIN $CFG->table_EventRegisteredUser eru ON epov.nUserID = eru.nUserID AND eru.nEventID = $nEventID
  										  WHERE epo.nEventPollID = $nEventPollID AND epov.nUserID = $nCurrentUserID";
	    $qid = db_query($req_listeventpolloptionvotes);
		$bUserHasVoted = db_num_rows($qid)>0 ? true : false;
		$bUserCanVote = ($bAllowUsersToChangeVote == 1 || ($bAllowUsersToChangeVote == 0 && !$bUserHasVoted));

		// List out the poll options
		$req_listeventpolloptions = "SELECT epo.nEventPollOptionID, epo.szOption FROM $CFG->table_EventPollOption epo
  										  WHERE  epo.nEventPollID = $nEventPollID ORDER BY epo.nEventPollOptionID";
	    $qid = db_query($req_listeventpolloptions);

		$disabled = ($bAllowUsersToChangeVote == 0 && $bUserHasVoted) || $bAllowUsersToChangeVote == -1 ? " DISABLED" : "";
		while ($r = db_fetch_object($qid))
		{
    		$req_listeventpolloptionuservote = "SELECT COUNT(epov.nEventPollOptionVoteID) AS bCurrentUserVotedOption FROM $CFG->table_EventPollOptionVote epov
											  WHERE epov.nEventPollOptionID = $r->nEventPollOptionID AND epov.nUserID = $nCurrentUserID";
    	    $qid2 = db_query($req_listeventpolloptionuservote);
			$s = db_fetch_object($qid2);

			$checked = $s->bCurrentUserVotedOption > 0 ? " CHECKED" : "";
	      	echo $blankOrComma;
			if ($bCurrentUserRegistered)
			{
				if ($bMultipleChoice == 0)
					echo "<input type=\"radio\" name=\"bOption-$nEventPollID\" value=\"bOptionVote-$r->nEventPollOptionID\"$checked$disabled>";
				else
					echo "<input type=\"checkbox\" name=\"bOptionVote-$r->nEventPollOptionID\"$checked$disabled>";
			}

      		echo "".$r->szOption;
			$this->DisplayEventPollOptionVotes($TotalNumberOfVotes, $r->nEventPollOptionID, $nEventPollID, $nEventID, $nCurrentUserID, $refferer);
			$blankOrComma = "<BR>";
		}

        if ($bAllowWriteInVotes == 1 && $bCurrentUserRegistered)
        {
	      	echo "<BR>";
			if ($bMultipleChoice == 0)
				echo "<input type=\"radio\" name=\"bOption-$nEventPollID\" value=\"bOptionVote-W$nEventPollID\"$disabled>";
			else
				echo "<input type=\"checkbox\" name=\"bOptionVote-W$nEventPollID\"$disabled>";

			echo "$strWriteInVote <input type=\"text\" name=\"szEventPollWriteIn-$nEventPollID\" value=\"\"$disabled>";
        }


		return $bUserHasVoted;
	}

	function DisplayEventPollOptionVotes($TotalNumberOfVotes, $nEventPollOptionID, $nEventPollID, $nEventID, $nCurrentUserID, $refferer)
	{

		if ($TotalNumberOfVotes == 0)
			$percent = 0;
		else
		{
    		global $CFG;
    		$blankOrComma = "";
    		$req_listeventpolloptionvotes = "SELECT epov.nUserID FROM $CFG->table_EventPollOptionVote epov JOIN $CFG->table_EventRegisteredUser eru ON epov.nUserID = eru.nUserID AND eru.nEventID = $nEventID
      										  WHERE epov.nEventPollOptionID = $nEventPollOptionID";
    	    $qid = db_query($req_listeventpolloptionvotes);
    		$OptionNumberOfVotes = db_num_rows($qid);
    		$percent = round(($OptionNumberOfVotes * 100) / $TotalNumberOfVotes,0);
		}
		echo  " - $percent% ".DrawProgressBar($percent,"#5b8bab", "#FFFFFF") ;
	}

	function DisplayPeopleContact($contactdisp , $index)
	{
		// Display information about people on the contact

		global $strName, $strSurname, $strFunction, $strPhone, $strFax, $strEmail;
    echo "<table width='100%' border='0' cellspacing='0' cellpadding='0'>";
    echo "	<tr>";
    echo "  	<td width='2' align='center'>&nbsp;</td>";
    echo "  	<td colspan='3' valign='top'>";
    echo "   		<table width='100%' border='0' cellspacing='0' cellpadding='0'>";
    echo "   	  	<tr>";
    echo "        	<td width='80'  class=normal_search nowrap> $strName &nbsp;</td>";
    echo "        	<td width='110' class=normal_search nowrap>";
    echo pv($contactdisp["name$index"])."</td>";
    echo "        	<td width='80'  class=normal_search nowrap>&nbsp;&nbsp;&nbsp;$strSurname &nbsp;</td>";
    echo "        	<td width='110' class=normal_search nowrap>";
    echo pv($contactdisp["surname$index"])."</td>";
    echo "        	<td width='266' class=normal_search nowrap>&nbsp;&nbsp;&nbsp;  $strFunction ";
    echo pv($contactdisp["function$index"])."</td>";
    echo "      	</tr>";
    echo "      	<tr>";
    echo "        	<td width='80' class=normal_search nowrap>$strPhone &nbsp;</td>";
    echo "        	<td width='110' class=normal_search nowrap>";
    echo pv($contactdisp["phone$index"])."</td>";
    echo "        	<td width='80' class=normal_search nowrap>&nbsp;&nbsp;&nbsp;$strFax </td>";
    echo "        	<td width='110' class=normal_search nowrap>";
    echo pv($contactdisp["fax$index"])."</td>";
    echo "        	<td width='266' class=normal_search> &nbsp;</td>";
    echo "      	</tr>";
    echo "      	<tr>";
    echo "        	<td nowrap width='80' class=normal_search>   $strEmail  &nbsp; </td>";
    echo "        	<td colspan='4' class=normal_search nowrap><a href='mailto:";
    echo pv($contactdisp["email$index"])."'>";
    echo pv($contactdisp["email$index"])."</a></td>";
    echo "      	</tr>";
    echo "    	</table>";
    echo "  	</td>";
    echo "	</tr>";
		echo "</table>";
	}

	function DisplayContact()
	{
		// Display the selected contact ($this->contact)
		if(!$this->contact)
		{
			debug("No contact selected");
			return;
		}

		global $strContacts , $strName , $strAddress , $strZipcode , $strTown, $strCountry, $strPhone, $strFax, $strEmail, $strURL;
		include ("admin/include/contacts.inc.php3");
		include ("admin/include/url.inc.php3");
		debug("display contact = $this->contact");
		$contactdisp = get_contact($this->contact);
		if($contactdisp["url"])
		{
			$contact = get_url($contactdisp["url"]);
			$contactdisp["url"] = $contact["url"];
		}

		echo "<table width='575' border='0' cellspacing='0' cellpadding='0' align='left'>";
  	echo "	<tr>";
    echo "		<td width='10'>&nbsp;</td>";
    echo "		<td colspan='3' valign='top' nowrap>";
    echo "		  <table width='100%' border='0' cellspacing='0' cellpadding='2'>";
    echo "		    <tr>";
    echo "					<td class=tdsingletitle>";
    echo pv($contactdisp["name"])."</td>";
    echo "				</tr>";
    echo "		    <tr>";
    echo "					<td>";
    echo "						<table width='100%' border='0' cellspacing='0' cellpadding='0' align='center'>";
		echo "              <tr>";
		echo "                <td width='2' align='center'>&nbsp;</td>";
    echo "		            <td colspan='3' valign='top'>";
    echo "		              <table cellpadding='0' cellspacing='1' width='100%'>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strName &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo                        pv($contactdisp["name"])."</td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strAddress &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo                        pv($contactdisp["address"])."</td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strZipcode &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo                        pv($contactdisp["zipcode"])."</td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strTown &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo                        pv($contactdisp["town"])."</td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strCountry &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo                        pv($contactdisp["country"])."</td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strPhone / $strFax &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo                        pv($contactdisp["phone"])." / ";
		echo												pv($contactdisp["fax"])."</td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strEmail &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'><a href='mailto:";
		echo                        pv($contactdisp["email"])."'>";
		echo												pv($contactdisp["email"])."</a></td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strURL &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo "												<a href='http://";
		echo                        		pv($contactdisp["url"])."' target='_blank'>";
		echo                        		pv($contactdisp["url"])."</a></td>";
    echo "										</tr>";
		echo "                  </table>";
    echo "								</td>";
		echo "              </tr>";
		echo "            </table>";
    echo "		      </td>";
    echo "				</tr>";
    echo "			<tr>";
    echo "		<td>&nbsp;</td>";
    echo "	</tr>";
    echo "	<tr> ";
    echo "		<td>";
		echo "	  	<table cellpadding='0' cellspacing='1' width='100%'>";
		echo "	    	<tr>";
		echo "	      	<td class=tdsingletitle2 valign='top'>&nbsp;$strContacts</td>";
		echo "	        <td valign='top'>";
		for($i=0;$i<5;$i++)
		{
			$this->DisplayPeopleContact($contactdisp , $i+1);
			echo "<br>";
		}
		echo "					</td>";
		echo " 	      </tr>";
		echo "			</table>";
		echo "		</td>";
		echo "	</tr>";
		echo "</table>";
	}

	function DisplayPlace()
	{
		// Display the selected place ($this->place)
		if(!$this->place)
		{
			debug("No place selected");
			return;
		}

		debug("display place = $this->place");
		global $ME, $strContact, $strName , $strAddress , $strZipcode , $strTown, $strCountry, $strPhone, $strFax, $strURL, $URLINCLUDE, $CONTACTINCLUDE;
		include ("admin/include/place.inc.php3");
		debug("url include = a".$URLINCLUDE."b");
		include ("admin/include/url.inc.php3");
		include ("admin/include/contacts.inc.php3");
		$placedisp = get_places($this->place);
		if($placedisp["url"])
		{
			$contact = get_url($placedisp["url"]);
			$placedisp["url"] = $contact["url"];
		}

		echo "<table width='575' border='0' cellspacing='0' cellpadding='0' align='left'>";
  	echo "	<tr>";
    echo "		<td width='10'>&nbsp;</td>";
    echo "		<td  colspan='3' valign='top' nowrap>";
    echo "			<table width='100%' border='0' cellspacing='0' cellpadding='2'>";
    echo "		    <tr>";
		echo "          <td class=tdsingletitle>";
    echo pv($placedisp["name"])."</td>";
    echo "				</tr>";
    echo "				<tr>";
    echo "					<td>";
    echo "						<table width='100%' border='0' cellspacing='0' cellpadding='0' align='center'>";
		echo "              <tr>";
		echo "                <td width='2' align='center'>&nbsp;</td>";
    echo "		            <td colspan='3' valign='top'>";
		echo "		              <table cellpadding='0' cellspacing='1' width='100%'>";
		echo "	                  <tr>";
		echo "                      <td class=normal nowrap width='15%'>$strName &nbsp;</td>";
		echo "	                    <td class=normal colspan='2' width='85%'>";
    echo 												pv($placedisp["name"])."</td>";
    echo "										</tr>";
		echo "	                  <tr>";
		echo "                      <td class=normal nowrap width='15%'>$strAddress &nbsp;</td>";
		echo "	                    <td class=normal colspan='2' width='85%'>";
    echo 												pv($placedisp["address"])."</td>";
    echo "										</tr>";
		echo "	                  <tr>";
		echo "                      <td class=normal nowrap width='15%'>$strZipcode &nbsp;</td>";
		echo "	                    <td class=normal colspan='2' width='85%'>";
    echo 												pv($placedisp["zipcode"])."</td>";
    echo "										</tr>";
		echo "	                  <tr>";
		echo "                      <td class=normal nowrap width='15%'>$strTown &nbsp;</td>";
		echo "	                    <td class=normal colspan='2' width='85%'>";
    echo 												pv($placedisp["town"])."</td>";
    echo "										</tr>";
		echo "	                  <tr>";
		echo "                      <td class=normal nowrap width='15%'>$strCountry &nbsp;</td>";
		echo "	                    <td class=normal colspan='2' width='85%'>";
    echo 												pv($placedisp["country"])."</td>";
    echo "										</tr>";
    echo "		                <tr>";
    echo "		                  <td class=normal nowrap width='15%'>$strPhone / $strFax &nbsp;</td>";
    echo "		                  <td class=normal colspan='2' width='85%'>";
		echo                        pv($placedisp["phone"])." / ";
		echo												pv($placedisp["fax"])."</td>";
    echo "										</tr>";
		echo "	                  <tr>";
		echo "                      <td class=normal nowrap width='15%'>$strURL &nbsp;</td>";
		echo "	                    <td class=normal colspan='2' width='85%'>";
    echo "												<a href='http://";
    echo 												pv($placedisp["url"])."' target='_blank'>";
   	echo 												pv($placedisp["url"])."</a></td>";
    echo "										</tr>";
	  for($i=1 ; $i<=5 ; $i++)
	  {
	  	if($placedisp["contact".$i])
	  	{
	  		echo "<tr><td class=normal nowrap width='15%'>$strContact </td>";
	  		$DispContact = get_contact($placedisp["contact".$i]);
	  		echo "<td class=normal colspan='2' width='85%'><a href=\"$ME?id=$this->id&placesel=$this->place&contactsel=$i\">".$DispContact["name"]."</a></tr>";
	  	}
	  }
		echo "                  </table>";
    echo "		            </td>";
		echo "              </tr>";
    echo "		        </table>";
    echo "					</td>";
    echo "				</tr>";
    echo "			</table>";
    echo "		</td>";
    echo "	</tr>";
		echo "</table>";
	}
}

class CVisitorUI
{
	var $includepage	= ""; 				// page included (function of the mode selected)
	var $modeagenda   	= "search";			// display mode
	var $language;							// language display
	var $placeid;							// specific place to search

	var $Calendar;							// Calendar object
	var $Search;                      		// Search object
	var $Single;							// Single event object

	function Init($pagesuffix = "")
	{
		// Initialiaze left menu and language list box
		// Set cookie with language
		// Set include page


		global $langCookie;							// var from cookie
		global $formlang;							// var from form
		global $defaultlang;						// default language from application.php3
		global $modeagenda;							// Agenda display mode
		global $uisetplace;							// Agenda Specific place

		if(!isset($this->language) || empty($this->language))
			$this->language = $defaultlang;

		if(isset($langCookie))						// check if language var comes from cookie
			$this->language = $langCookie;

		if(isset($formlang))
		{
			$this->language = $formlang;			// check if language comes from form
			@setcookie("langCookie" , $this->language);
			unset($formlang); 						// to avoid calling setcookie twice
		}

		if(!isset($uisetplace))
					$this->placeid = 0;
		else	$this->placeid = $uisetplace;

		if(!isset($modeagenda))
					$this->modeagenda = "search";
		else	$this->modeagenda = $modeagenda;

		debug("modeagenda = ".$this->modeagenda);
		switch($this->modeagenda)
		{
			case	"search" : 	$this->includepage = "agenda".$pagesuffix."2.php3"; break;
			case	"about" : 	$this->includepage = "about.".$this->language.".php3"; break;
			case	"calendar":	$this->includepage = "calendar.php3"; break;

//			default :  $this->includepage = $pageprefix."agenda2.php3"; break;   // Where is $pageprefix defined?
			default :  $this->includepage = "agenda2.php3"; break;
		}
	}

	function DisplayLangSelect()
	{
		// Display Language selection list box
		global $strSelectLang , $langCookie;
		echo $strSelectLang;
		echo "  <select name='formlang' onChange='OnSubmit()'>";
		echo option_language($this->language);
		echo "</select>";
	}

	function DisplayLeftMenu()
	{
		// Display Left Menu

		global $ME, $CFG, $Auth, $strAbout, $strAdmin, $strSearch, $strSoon, $strCalendar, $strLogout, $strLogin, $strPreference, $strAddEvent, $strPublicMenuTitle, $strUserMenuTitle;

        $securityLevel1Prefix = ($CFG->ssl_level >= 1 ? "https://" : "http://").$CFG->agenda_root;
        $securityLevel2Prefix = ($CFG->ssl_level >= 2 ? "https://" : "http://").$CFG->agenda_root;


		echo "<table width='100%' border='0' cellspacing='0' cellpadding='2'>\n";
		if ($Auth->login == $CFG->publicuser )
		{
    		echo "  <tr>\n";
    	    echo "    <td class=tdmenu nowrap>$strPublicMenuTitle<BR><HR></td>\n";
    		echo "	</tr>\n";
    	}
    	else
    	{
    		echo "  <tr>\n";
    	    echo "    <td class=tdmenu nowrap>".ereg_replace("%username", $Auth->login, $strUserMenuTitle)."<BR><HR></td>\n";
    		echo "	</tr>\n";
    	}
		echo "  <tr>\n";
	    echo "    <td class=tdmenu nowrap><a href='".$securityLevel2Prefix."$ME?modeagenda=about'>$strAbout</a></td>\n";
		echo "	</tr>\n";
		if ($Auth->can_do_basic())
		{
			echo "  <tr>\n";
		    echo "    <td class=tdmenu nowrap><a href='".$securityLevel1Prefix."/admin/index.php3'>$strAdmin</a></td>\n";
			echo "	</tr>\n";
		}
		echo "  <tr>\n";
	    echo "    <td class=tdmenu nowrap><a href='".$securityLevel2Prefix."$ME?modeagenda=search'>$strSearch</a></td>\n";
		echo "	</tr>\n";
		echo "  <tr>\n";
	    echo "    <td class=tdmenu nowrap><a href='".$securityLevel2Prefix."$ME?modeagenda=soon'>$strSoon</a></td>\n";
		echo "	</tr>\n";
		echo "  <tr>\n";
	    echo "    <td class=tdmenu nowrap><a href='".$securityLevel2Prefix."$ME?modeagenda=calendar'>$strCalendar</a></td>\n";
		echo "	</tr>\n";
		if ($Auth->can_do_basic())
		{
			echo "  <tr>\n";
		    echo "    <td class=tdmenu nowrap><a href='".$securityLevel1Prefix."/admin/events.php3?mode=add'>$strAddEvent</a></td>\n";
			echo "	</tr>\n";
			echo "  <tr>\n";
		    echo "    <td class=tdmenu nowrap><a href='".$securityLevel1Prefix."/admin/preference.php3'>$strPreference</a></td>\n";
			echo "	</tr>\n";
			echo "  <tr>\n";
		    echo "    <td class=tdmenu nowrap><a href='".$securityLevel2Prefix."/admin/logout.php3'>$strLogout</a></td>\n";
			echo "	</tr>\n";
		}
		elseif (!$Auth->can_do_basic())
		{
			echo "  <tr>\n";
		    echo "    <td class=tdmenu nowrap><a href='".$securityLevel1Prefix."/agenda.php3?modeagenda=soon&dologin=1'>$strLogin</a></td>\n";
			echo "	</tr>\n";
		}
		echo "</table>\n";
	}

	function InitCalendar()
	{
		$this->Calendar = new CCalendar;
		$this->Calendar->Init($this->language);
		//$this->Calendar->SetPlace($this->placeid);
	}

	function InitSearch($mode = "search")
	{
		$this->Search = new CSearch;
		$this->Search->Init($mode);
		//$this->Search->SetPlace($this->placeid);
	}

	function InitSingleEvent()
	{
		$this->Single = new CSingleEvent;
		$this->Single->Init($this->language);
	}
	function DoVote()
	{
		GLOBAL $mode, $Auth, $CFG;
		$CanVoteOnPoll = array();
		if ($mode == "dovote")
		{
			$nDeletedEventPollID[0] = 0;
        	foreach($_POST as $postVarKey => $postVarVal)
        	{
				if (substr($postVarKey, 0, 8) == "nPollID-")
				{
	                $nLoopEventPollID = $postVarVal;
            		$req_listeventpolls = "SELECT CASE WHEN ep.bAllowUsersToChangeVote = 1 AND (ep.dtAllowUsersToChangeVoteUntil > NOW() OR ep.dtAllowUsersToChangeVoteUntil IS NULL) THEN 1 ELSE 0 END AS bAllowUsersToChangeVote FROM $CFG->table_EventPoll ep
              										  WHERE  ep.nEventPollID = $nLoopEventPollID";
            	    $qid = db_query($req_listeventpolls);
					$r = db_fetch_object($qid);
						if ($r->bAllowUsersToChangeVote == 1)
						{
							$CanVoteOnPoll[$nLoopEventPollID] = true;
		   					db_query("DELETE $CFG->table_EventPollOptionVote FROM $CFG->table_EventPollOptionVote, $CFG->table_EventPollOption WHERE $CFG->table_EventPollOptionVote.nEventPollOptionID = $CFG->table_EventPollOption.nEventPollOptionID AND $CFG->table_EventPollOption.nEventPollID = $nLoopEventPollID AND $CFG->table_EventPollOptionVote.nUserID = $Auth->id");
						}
						else
						{
							$CanVoteOnPoll[$nLoopEventPollID] = false;
						}
				}
			}

        	foreach($_POST as $postVarKey => $postVarVal)
        	{
				if (substr($postVarKey, 0, 12) == "bOptionVote-")
				{
	                $nLoopEventPollOptionID = substr($postVarKey, 12);
					$bRecordVote = true;
				}
				elseif (substr($postVarKey, 0, 8) == "bOption-")
				{
	                $nLoopEventPollOptionID = substr($postVarVal, 12);
					$bRecordVote = true;
				}
				else
				{
	                $nLoopEventPollOptionID = 0;
					$bRecordVote = false;
				}

        		if ( $bRecordVote )
                {
                    if (substr($nLoopEventPollOptionID, 0, 1) == 'W')
                    {
                        $nLoopEventPollID = substr($nLoopEventPollOptionID, 1);
    					if ($CanVoteOnPoll[$nLoopEventPollID] == true)
                            $this->RecordUserWriteInVote($nLoopEventPollID, $Auth->id, formatSQLString($_POST["szEventPollWriteIn-$nLoopEventPollID"]));
                    }
                    else
                    {
                    	$qid = db_query("SELECT * FROM $CFG->table_EventPollOption epo JOIN $CFG->table_EventPoll ep ON epo.nEventPollID = ep.nEventPollID WHERE epo.nEventPollOptionID = $nLoopEventPollOptionID");
                    	$frm = db_fetch_array($qid);
    					if ($CanVoteOnPoll[$frm['nEventPollID']] == true)
    						$this->RecordUserVote($Auth->id, $nLoopEventPollOptionID);
    			    	db_free_result($qid);
    			    }
                }
			}

		}
	}
	function RecordUserVote($nUserID, $nEventPollOptionID)
	{
		GLOBAL $CFG;
		db_query("DELETE FROM $CFG->table_EventPollOptionVote WHERE nEventPollOptionID = $nEventPollOptionID AND nUserID = $nUserID");
		db_query("INSERT INTO $CFG->table_EventPollOptionVote (nEventPollOptionID, nUserID) values ($nEventPollOptionID, $nUserID)");
	}
	function RecordUserWriteInVote($nEventPollID, $nUserID, $szWriteInVote)
	{
		GLOBAL $CFG;
    	$qid = db_query("SELECT nEventPollOptionID FROM $CFG->table_EventPollOption WHERE szOption like '$szWriteInVote' AND nEventPollID = $nEventPollID");
        if (db_num_rows($qid) == 0)
        {
    		$qid = db_query("INSERT INTO $CFG->table_EventPollOption (nEventPollID, szOption) values ($nEventPollID, '$szWriteInVote')");
    		$nEventPollOptionID = db_insert_id();
    		$this->RecordUserVote($nUserID, $nEventPollOptionID);
    	}
    	else
    	{
    	    $s = db_fetch_object($qid);
    	    $nEventPollOptionID = $s->nEventPollOptionID;
    		$this->RecordUserVote($nUserID, $nEventPollOptionID);
    	}
	}
}

class CSearch
{
  // this class manage search over the database
  // 05/04/2001 Manu vanneau mvanneau@hotmail.com

	var $language			       = "english";	// Display language
	var $recherche           = 0;         // doing some search ? 0=false, 1=true
	var $edge                = 0;         // current display starts at $edge
	var $numevents           = 0;         // number of events founds
	var $result              = "";        // search results
	var $mode                = "search";    // search mode ("soon": retrieve next events since today,
																				//							"search" : display search engine
	var $placeid						 = 0;					// specific place to search
	var $orgaid							 = 0;					// specific orga to search

  // list boxes
  var $limit_option        = "";  // limit result listbox
  var $orderby_option      = "";  // orderby listbox
  var $contact_option      = "";  // contact listbox
  var $place_option        = "";  // place listbox
  var $year_end_option     = "";  // year end listbox
  var $year_option         = "";  // year listbox
  var $month_end_option    = "";  // month end listbox
  var $month_option        = "";  // month listbox
  var $type_option         = "";  // event type listbox

  // filter variables
  var $orderby             = "";  // orderby filter
  var $limit               = 10;  // limit result
  var $selectyear          = "";  // year filter
  var $selectyearend       = "";  // yearend filter
  var $selectcontact       = "";  // contact filter
  var $selectplace         = "";  // place filter
  var $selectmonth         = "";  // month filter
  var $selectmonthend      = "";  // month end filter
  var $selecttype          = "";  // event type filter

  function Init()
  {
    // Init search class with variables passed thru the form

    // Get global variable from form
    global $limit, $recherche, $edge, $orderby,$selectmonth, $selectyear, $selectmonthend, $selectyearend;
    global $selecttype, $selectplace, $selectcontact, $modeagenda, $language;


	  if(isset($modeagenda))
  	  $this->mode = $modeagenda;

	  if(isset($language))
  	  $this->language = $language;

    if(!isset($limit))
		  $this->limit = 10;
		else
		  $this->limit = $limit;

  	if(!isset($recherche))
  	{
  		// if recherche is NOT defined, we initialize object with default value
  		$this->recherche			= 0;
  	  $this->edge           = "";
  	  $this->orderby        = "";
  	  $this->selectmonth    = "";
  	  $this->selectyear     = "";
  	  $this->selectmonthend = "";
  	  $this->selectyearend  = "";
  	  $this->selecttype     = "";
  	  $this->selectplace    = "";
  	  $this->selectcontact  = "";
  	  $this->limit					= 10;
  		debug   ("recherche NOT defined");
  	}
  	else
  	{
  		// if recherche is defined, we initialize object with global values
  	  $this->recherche	= $recherche;
  	  $this->edge           = $edge;
  	  $this->orderby        = $orderby;
  	  $this->selectmonth    = $selectmonth;
  	  $this->selectyear     = $selectyear;
  	  $this->selectmonthend = $selectmonthend;
  	  $this->selectyearend  = $selectyearend;
  	  $this->selecttype     = $selecttype;
  	  $this->selectplace    = $selectplace;
  	  $this->selectcontact  = $selectcontact;
  	  $this->limit		= $limit;
  	  debug   ("recherche defined");
  	  debug   ("select place : ".$selectplace);
  	  debug   ("this select place : ".$this->selectplace);
  	}
  }

	function SetPlace($placeid = 0)
	{
		$this->placeid = $placeid;
		$this->selectplace	= $this->placeid;
	}

	function SetOrganizer($orgaid = 0)
	{
		$this->orgaid = $orgaid;
		$this->selectcontact	= $this->orgaid;
	}

	function DisplaySearchEngine()
	{
		// Display Search Engine
		// written in a table
		// uses form 'entryform' that must be present in the template page

		global $ME, $CFG, $selecttype;
    global $strSearch , $strType , $strBetween, $strAnd , $strPlace, $strOrganizer , $strOrder, $strDisplay, $strResultBy;
    global $strExplain, $strSearch2, $strHelp, $strTitle, $strDate;

  	// Get eventtypes from db and put them into a listbox
  	$this->type_option    = "<select name=\"selecttype\">"
  	                    . "<option value=''> </option>"
  	                    . db_listbox("SELECT id, type FROM $CFG->table_eventtype ORDER BY type",$this->selecttype)
  	                    . "</select>";

  	// format month select and put them into a listbox
   	$this->month_option   = "<select name=\"selectmonth\">"
  	                      . "<option value=''></option>"
  												. option_month($this->selectmonth , $this->language)
  												. "</select>";

  	// format month select for end of date and put them into a listbox
  	$this->month_end_option= "<select name=\"selectmonthend\">"
  	                      . "<option value=''></option>"
  												. option_month($this->selectmonthend , $this->language)
  												. "</select>";


  	// format year select and put them into a listbox
  	$this->year_option    = "<select name=\"selectyear\">"
  	                      . "<option value=''></option>"
  												.	option_year($this->selectyear , 2000 , 2010)
  												. "</select>";

  	// format year select for end of date and put them into a listbox
  	$this->year_end_option = "<select name=\"selectyearend\">"
  	                      . "<option value=''></option>"
  												.	option_year($this->selectyearend , 2000 , 2010)
  												. "</select>";

  	// Get places from db and put them into a listbox
  	$this->place_option		= "<select name=\"selectplace\">"
  	                      . "<option value=''></option>";
		if($this->placeid)
			$this->place_option	.=	db_listbox("SELECT id, name FROM $CFG->table_place WHERE id='$this->placeid' ORDER BY name" , $this->placeid). "</select>";
		else
			$this->place_option	.=	db_listbox("SELECT id , name FROM $CFG->table_place ORDER BY name" , $this->selectplace). "</select>";


  	// Get contacts from db and put them into a listbox
  	$this->contact_option	= "<select name=\"selectcontact\">"
  	                      . "<option value=''></option>";
		if($this->orgaid)
  		$this->contact_option .=	db_listbox("SELECT id, name FROM $CFG->table_contact WHERE id='$this->orgaid' ORDER BY name" , $this->orgaid). "</select>";
		else
  		$this->contact_option .=	db_listbox("SELECT id, name FROM $CFG->table_contact ORDER BY name" , $this->selectcontact). "</select>";

    // Fill "order by" listbox
    $this->orderby_option        = "<select name='orderby'><option value=''";
  	if($this->orderby == "")
  				$this->orderby_option .= " selected ";
  	$this->orderby_option 			.=  "> &nbsp;</option><option value='type'";
   	if($this->orderby == "type")
  				$this->orderby_option .= " selected ";
    $this->orderby_option 			.= ">$strType</option><option value='title'";
   	if($this->orderby == "title")
  				$this->orderby_option .= " selected ";
    $this->orderby_option 			.= ">$strTitle</option><option value='start'";
     	if($this->orderby == "start")
  				$this->orderby_option .= " selected ";
    $this->orderby_option 			.= ">$strDate</option></select>";

   	// Fill "limit" list box
   	debug ("limit = ".$this->limit);
    $this->limit_option       	 = "<select name='limit'><option value='5'";
  	if($this->limit == 5)
  				$this->limit_option   .= " selected ";
  	$this->limit_option 				.=  ">5</option><option value='10'";
   	if($this->limit == 10)
  				$this->limit_option 	.= " selected ";
    $this->limit_option 				.= ">10</option><option value='20'";
   	if($this->limit == 20)
  				$this->limit_option 	.= " selected ";
    $this->limit_option 				.= ">20</option></select>";


    // Display all this information into a table
    echo "<table class=border width='100%' border='0' cellspacing='3' cellpadding='2'>\n";
    echo "<tr><td><table width='100%' border='0' cellspacing='0' cellpadding='2'>\n";
    echo "  <tr class=tdsearch>\n";
    echo "    <td width='2%' valign='top'>$strSearch</td>\n";
    echo "    <td>\n";
    echo "      <table border='0' cellspacing='0' cellpadding='0' width='100%'>\n";
    echo "        <tr>\n";
    echo "          <td height='106'>\n";
    echo "            <table border='0' cellspacing='0' cellpadding='1' width='100%'>\n";
    echo "              <tr class=calendar_today>\n";
    echo "                <td>\n";
    echo "                  <table border='0' cellspacing='0' cellpadding='1' width='100%'>\n";
    echo "                    <tr>\n";
    echo "                      <td class=normal_search width='100' nowrap><div align='right'>$strType</div></td>\n";
    echo "                      <td class=normal_search nowrap>&nbsp;&nbsp;$this->type_option</td>\n";
    echo "                    </tr>\n";
    echo "                    <tr>\n";
    echo "                      <td class=normal_search width='100' nowrap><div align='right'>$strBetween</div></td>\n";
    echo "                      <td class=normal_search nowrap>&nbsp;&nbsp;$this->month_option $this->year_option $strAnd $this->month_end_option $this->year_end_option &nbsp;</td>\n";
    echo "                    </tr>\n";
    echo "                    <tr> \n";
    echo "                      <td class=normal_search width='100' nowrap><div align='right'>$strPlace</div></td>\n";
    echo "                      <td class=normal_search nowrap>&nbsp;&nbsp;$this->place_option</td>\n";
    echo "                    </tr>\n";
    echo "                    <tr>\n";
    echo "                      <td class=normal_search width='100' nowrap><div align='right'>$strOrganizer</div></td>\n";
    echo "                      <td class=normal_search nowrap>&nbsp;&nbsp;$this->contact_option</td>\n";
    echo "                    </tr>\n";
    echo "                    <tr> \n";
    echo "                      <td class=normal_search width='100' nowrap><div align='right'>$strOrder</div></td>\n";
    echo "                      <td class=normal_search nowrap valign='middle'>&nbsp;\n";
    echo "                        $this->orderby_option &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\n";
    echo "                        $strDisplay $this->limit_option $strResultBy</td>\n";
    echo "                    </tr>\n";
    echo "                  </table>\n";
    echo "                </td>\n";
    echo "              </tr>\n";
    echo "            </table>\n";
    echo "          </td>\n";
    echo "        </tr>\n";
    echo "      </table>\n";
    echo "    </td>\n";
    echo "    <td class=tdsearch valign='top'>\n";
    echo "      <p>$strExplain</p>\n";
    echo "      <p align='center'>\n";
    echo "        <a href='javascript:Submitedge(0);'> \n";
    echo "        <img alt='Search'  src='images/search2.gif' width='37' height='37' border='0' align='absmiddle'>&nbsp;$strSearch2</a><br>\n";
    echo "        <a href='$ME?modeagenda=about#moteur'><img alt='Help' src='images/helpagenda2.gif' width='27' height='28' border='0' align='absmiddle'> \n";
    echo "        $strHelp</a>\n";
    echo "      </p>\n";
    echo "    </td>\n";
    echo "  </tr>\n";
    echo "</table></td></tr></table>\n";
	}

	function DisplayNumEvent()
	{
	  // Display number of events found
    global $strResult, $strEventsFound, $strEventFound, $strDisp, $strTo, $strPrevPage, $strNextPage, $strNotFound, $rootagenda;
    if($this->recherche)
    {
      if($this->numevents)
  		{
  			echo $strResult." : ";
  			echo "<b>$this->numevents</b> ";
			if($this->numevents > 1)
				echo $strEventsFound;
			else
				echo $strEventFound;

        echo "<br>$strDisp <b>";
        echo $this->edge+1;
        echo "</b> $strTo <b>";
        if($this->numevents > $this->edge+$this->limit)
          echo $this->edge+$this->limit;
        else
          echo $this->numevents;
        echo "</b><br>";

        echo "<div align='center'>";
        if($this->edge >= $this->limit)
        {
            $newedge = $this->edge - $this->limit;
            echo "<a href='javascript:Submitedge($newedge);'>$strPrevPage</a> ";
        }
        $total_page = $this->numevents / $this->limit;
        if($total_page >= 1)
        	for($i=1 ; $i<=$total_page+1 ; $i++)
	        {
	            $newedge = ($i-1) * $this->limit;
	            if($newedge != $this->edge)
	            	echo "<a href='javascript:Submitedge($newedge);'>$i</a> ";
	            else echo "$i ";
	        }
        if($this->numevents > ($this->edge + $this->limit))
        {
            $newedge = $this->edge + $this->limit;
            echo " <a href='javascript:Submitedge($newedge);'>$strNextPage</a>";
        }
        echo "</div>";
      }
      else
       echo $strNotFound;
    }
    else
      echo "&nbsp;";
	}

	function DisplayResults()
	{
        global $Auth, $strSoon, $rootagenda, $CFG, $strOrganizer, $strRegisterForEvent, $strUnregisterForEvent, $strMoreInfo, $modeagenda  ;
        if($this->mode == "soon")
            echo "<td class=comingsoon>$strSoon<br>&nbsp;</td>\n";

        include("admin/include/events.inc.php3");

        // main table
        echo "                        <table width='100%' border='0' cellspacing='0' cellpadding='0'>\n";
        echo "                            <tr align='center'>\n";
        echo "                                <td>\n";
        if($this->edge != "")
            $index = $this->edge;
        else
            $index = 0;

        while ($r = db_fetch_object($this->result))
        {
            if($r->image != "")
            {
                $r->image = $CFG->image_event_dir."/".$r->image;
                if(is_file($r->image))
                {
                    $size = getimagesize($r->image);
                    $size = limit_image_size($size , $CFG->limit_image_display_x , $CFG->limit_image_display_y);
                    $r->imagex = $size[0];
                    $r->imagey = $size[1];
                }
                else
                {
                    $r->imagex = $CFG->limit_image_display_x;
                    $r->imagey = $CFG->limit_image_display_y;
                }
            }

            $index++;
            echo "                                    <table border='0' cellspacing='0' cellpadding='1' width='100%'>\n";
            echo "                                        <tr>\n";
            echo "                                            <td width='".$CFG->limit_image_display_x."'>";

            if($r->image != "")
                echo "<a href='".$r->image."' target='_blank'><img alt=' ' src='".$r->image."' width='".$r->imagex."' height='".$r->imagey."' border=0></a>";
            else
                echo "&nbsp;";

            echo "                                            </td>\n";
            echo "                                            <td>\n";

            // Load up the query parameters passed in to pass back to the referrer
            $queryString = '';
            foreach($_GET as $postVarKey => $postVarVal)
            {
                $queryString .= "&$postVarKey=$postVarVal";
            }
            foreach($_POST as $postVarKey => $postVarVal)
            {
                $queryString .= "&$postVarKey=$postVarVal";
            }

            // Open Border
            echo "                                                <table class=border width=\"90%\" border=\"0\" cellspacing=\"5\" cellpadding=\"2\" >\n";
            echo "                                                    <tr>\n";
            echo "                                                        <td class=tdmenu_title nowrap<span class=tdmenu>\n";
            echo "                                                            <table border='0' cellspacing='0' cellpadding='1' width='100%'>\n";
            echo "                                                                <tr class=result_title> \n";
            echo "                                                                    <td colspan='2'>$index. <a name=\"$r->id\" href='".$rootagenda."infoevent.php3?id=$r->id&language=$this->language&modeagenda=$modeagenda$searchString'>";
            echo pv($r->title)."</a>&nbsp;</td>\n";
            echo "                                                                </tr>\n";
            echo "                                                                <tr class=result_type> \n";
            echo "                                                                    <td colspan='2'>";
            echo pv($r->type)."&nbsp;</td>\n";
            echo "                                                                </tr>\n";
            echo "                                                                <tr class=result_description> \n";
            echo "                                                                    <td height='15' colspan='2' style=\"white-space:normal;\">";
            echo pv($r->description)."&nbsp;</td>\n";
            echo "                                                                </tr>\n";
            $qidate = db_query("SELECT start, end, place.name FROM $CFG->table_date date ,$CFG->table_place place WHERE date.place = place.id AND date.event = '$r->id' GROUP BY date.start ORDER BY date.start");
            echo "                                                                <tr>\n";
            echo "                                                                    <td colspan='2'> \n";
            echo "                                                                        <table width='100%' border='0' cellspacing='0' cellpadding='0'>\n";
            echo "                                                                            <tr>\n";
            if(db_num_rows($qidate) > 0)
            {
                echo "                                                                                <td colspan='2' height='19'>\n";
                echo "                                                                                    <table width='100%' border='0' cellspacing='0' cellpadding='0'>\n";
                while($dates  = db_fetch_object($qidate))
                {
                    echo "                                                                                        <tr>\n";
                    echo "                                                                                            <td class=result_description width='50%' nowrap>".dispdate($dates->start , $dates->end , $this->language)."&nbsp;</td>\n";
                    echo "                                                                                            <td class=result_description> at &nbsp;&nbsp;&nbsp;$dates->name</td>\n";
                    echo "                                                                                        </tr>\n";
                }
                db_free_result($qidate);

                echo "                                                                                    </table>\n";
                echo "                                                                                </td>\n";
            }
            echo "                                                                            </tr>\n";
            echo "                                                                            <tr>\n";
            echo "                                                                                <td class=result_description width='100%'>\n";
            $query = "SELECT name FROM $CFG->table_contact WHERE ";
            $contact = array(1=>$r->contact1 , $r->contact2 , $r->contact3 , $r->contact4 , $r->contact5);
            $i = 0;
            for($n=1 ; $n<=5 ; $n++)
            {
                if($contact[$n])
                {
                    $i++;
                    $query .= "id = '$contact[$n]' ";
                    if($n<5 && $contact[$n+1])
                    $query .= " OR ";
                }
            }
            if($i)
            {
                $qicon = db_query($query);
                echo "                                                                                    ".$strOrganizer." : ";
                for($z=0 ; $z<$i ; $z++)
                {
                    $con = db_fetch_array($qicon);
                    echo $con["name"];
                    if($z<$i-1)
                    echo " | ";
                }
                db_free_result($qicon);
            }
            echo "\n                                                                                </td>\n";
            echo "                                                                            </tr>\n";
            echo "                                                                            <tr>\n";
            echo "                                                                                <td class=result_description width='89%'>&nbsp;</td>\n";
            echo "                                                                            </tr>\n";
            echo "                                                                            <tr>\n";
            echo "                                                                                <td class=result_description width='89%'>\n";
            $cse = new CSingleEvent();

            $searchString = '';
            if ($modeagenda == 'search')
            {
                $searchString.= "&selecttype=$this->selecttype";
                $searchString.= "&selectmonth=$this->selectmonth";
                $searchString.= "&selectyear=$this->selectyear";
                $searchString.= "&selectmonthend=$this->selectmonthend";
                $searchString.= "&selectyearend=$this->selectyearend";
                $searchString.= "&selectplace=$this->selectplace";
                $searchString.= "&selectcontact=$this->selectcontact";
                $searchString.= "&orderby=$this->orderby";
                $searchString.= "&limit=$this->limit";
                $searchString.= "&recherche=1";
            }

            if ($Auth->can_do_basic())
            {
                $cse->DisplayRegisteredUsers($r->id, $Auth->id);
                if ($cse->bCurrentUserRegistered == false)
                {
                    echo "                                                                                    <BR><a href=\"eventregisteruser.php3?referrer=agenda&modeagenda=$modeagenda&nEventID=$r->id&register=1$searchString\">$strRegisterForEvent</a>\n";
                }
                else
                {
                    echo "                                                                                    <BR><a href=\"eventregisteruser.php3?referrer=agenda&modeagenda=$modeagenda&nEventID=$r->id&register=0$searchString\">$strUnregisterForEvent</a>\n";
                }
            }

            echo "                                                                                </td>\n";

            echo "                                                                                <td class=result_description width='11%'><div align='right'><a href='".$rootagenda."infoevent.php3?id=$r->id&language=$this->language&modeagenda=$modeagenda$searchString'>$strMoreInfo</a></div></td>\n";
            echo "                                                                            </tr>\n";

            echo "                                                                            <tr>\n";
            echo "                                                                                <td class=result_description width='89%'>&nbsp;</td>\n";
            echo "                                                                            </tr>\n";
            echo "                                                                        </table>\n";
            echo "                                                                    </td>\n";
            echo "                                                                </tr>\n";
            echo "                                                            </table>\n";
            echo "                                                        </span></td>\n";
            echo "                                                    </tr>\n";
            echo "                                                </table>\n";
            echo "                                                <table border='0' cellspacing='0' cellpadding='1' width='90%'>\n";
            echo "                                                    <tr class=result_title> \n";
            echo "                                                        <td colspan='2'> \n";
            echo "                                                            <table width='100%' border='0' cellspacing='0' cellpadding='0'>\n";
            echo "                                                                <tr>\n";
            echo "                                                                    <td class=result_description width='89%'>\n";

            echo "                                                                        ";
            $cse->DisplayEventPolls($r->id, $Auth->id, 'soon', $cse->bCurrentUserRegistered);

            echo "                                                                    </td>\n";
            echo "                                                                </tr>\n";
            echo "                                                            </table>\n";
            echo "                                                        </td>\n";
            echo "                                                    </tr>\n";
            echo "                                                </table>\n";
            echo "                                            </td>\n";
            echo "                                        </tr>\n";
            echo "                                        <tr><td height='20' colspan='2' valign='top'><hr  size='2'></td></tr>\n";
            echo "                                    </table>\n";

        }
        echo "                                </td>\n";
        echo "                            </tr>\n";
        echo "                        </table>\n";
        db_free_result($this->result);
	}

	function DoSearchSoon()
	{
		global $CFG;

	  $req_listevents  = "SELECT e.id , e.title, e.image, e.description, e.contact1, e.contact2, e.contact3, e.contact4, e.contact5 , t.type , d.start
													FROM   $CFG->table_event e, $CFG->table_eventtype t , $CFG->table_date d
													WHERE  t.id = e.type
													AND d.event = e.id
													AND d.start >= NOW() ";
		if($this->placeid)
			$req_listevents .= "AND d.place = $this->placeid ";
		$req_listevents 	.= "GROUP BY e.id ORDER BY d.start ASC
													LIMIT 0 , 5 ";
		debug("listing request = $req_listevents");
		$this->result  = db_query($req_listevents);
		$this->numevents = db_num_rows($this->result);
  }

	function DoSearchAgenda()
	{
	  debug   ("modeagenda = search");

		global $CFG;
		if(empty($this->edge))
		{
		  $this->edge = 0;
		}

		if(!empty($this->selectmonth))
		 $monthstart = $this->selectmonth;
		else
		 $monthstart = 1;

		if(!empty($this->selectyear))
		 $yearstart = $this->selectyear;
		else
		 $yearstart = "1900";

		if(!empty($this->selectmonthend))
		 $monthend = $this->selectmonthend;
		else
		 $monthend = 12;

		if(!empty($this->selectyearend))
		 $yearend = $this->selectyearend;
		else
		 $yearend = "2100";

		$selectdate = !empty($this->selectyear) || !empty($this->selectmonth) || !empty($this->selectyearend) || !empty($this->selectmonthend);

		// format the query
		$req_listevents 		 = "SELECT e.id , e.image , e.title, e.description, e.contact1, e.contact2, e.contact3, e.contact4, e.contact5, t.type ";
		if($selectdate || $this->orderby == "start")
			$req_listevents 	.= ", d.start ";
		if($this->selectplace)
			$req_listevents 	.= ", p.name ";
		$req_listevents			.= "FROM   $CFG->table_event e, $CFG->table_eventtype t ";
		if($selectdate || $this->orderby == "start" || $this->selectplace)
			$req_listevents 	.= ", $CFG->table_date d ";
		if($this->selectplace)
			$req_listevents 	.= ", $CFG->table_place p ";
		$req_listevents 		.= "WHERE  t.id = e.type ";

		if(!empty($this->selecttype))
		  $req_listevents .= " AND e.type=$this->selecttype ";


		if($selectdate || $this->orderby == "start")
		{
		    $date    = formatSQLdate($yearstart , $monthstart , 1);
		    $dateend = formatSQLdate($yearend , $monthend , 31, 23, 59);
		    $req_listevents .= " AND d.event = e.id AND d.start >='$date' AND d.start <='$dateend'";
		}

		if(!empty($this->selectplace))
		 $req_listevents .= " AND p.id = $this->selectplace AND d.place = $this->selectplace AND d.event = e.id ";

		if(!empty($this->selectcontact))
		 $req_listevents .= " AND (	e.contact1=$this->selectcontact OR
		 														e.contact2=$this->selectcontact OR
		 														e.contact3=$this->selectcontact OR
		 														e.contact4=$this->selectcontact OR
		 														e.contact5=$this->selectcontact) ";

		$req_listevents .= " GROUP BY e.id ";

		if($this->orderby)
		{
		 	$req_listevents .= " ORDER BY ".$this->orderby." ASC";
		}
		debug("listing request = $req_listevents");
		// do the query
		$qidnum    = db_query($req_listevents);
		$this->numevents = db_num_rows($qidnum);
		db_free_result($qidnum);
		$this->result       = db_query($req_listevents." LIMIT $this->edge, $this->limit");
	}

  function DoSearch()
  {
    debug("modeagenda(Dosearch) = ".$this->mode);
    switch($this->mode)
    {
      case "search" : if($this->recherche == 1)
                        $this->DoSearchAgenda();
                      break;
      case "soon"   : $this->DoSearchSoon(); break;
			default : break;
    }
  }

	function DoSoon()
	{
	  $req_listevents 		 = "SELECT e.id , e.title, e.description, e.contact1, e.contact2, e.contact3, e.contact4, e.contact5 , t.type , d.start
													FROM   events e, eventtype t , date d
													WHERE  t.id = e.type
													AND d.event = e.id
													AND d.start >= NOW()
													ORDER BY d.start ASC
													LIMIT 0 , 5";
    $soon = 1;
		debug("listing request = $req_listevents");
		$qid  = db_query($req_listevents);

	}
}

class CCalendar
{
  // this class manage calendar display
  // 05/04/2001 Manu vanneau mvanneau@hotmail.com


	var $today 				= 0;					// Today index
	var $month 				= 1;					// Month (january by default)
	var $year  				= 2001;				// Year (2001 by default)
	var $days	 				= 31;					// number of day in $month;
	var $dayone				= 1;					// first day index (Sunday = 0, ...)
	var $daylast			= 7;					// last day index (Sunday = 0,...)
	var	$size 				= "expanded"; 	// select 'reduced' / 'expanded' calendar display
	var $selectedday 	= 0;					// current selected day
	var $language			= "english";	// Display language
	var $eventtext 		= "";					// Event text for reduced calendar
	var $datetext			= "";					// Date text for reduced calendar
	var $placeid			= 0;					// specific place to search

	function Init($language = "english")
	{
		// Initialize calendar
		global $selectedday , $month , $year , $size;

		if(!isset($selectedday))
			$selectedday = 0;

	  if(isset($month) && isset($year))
	   $datime = mktime(1,1,1,$month,1,$year);
	  else
	   $datime = time();

	  if(!isset($month))
	    $month = date("n",$datime);
	  if(!isset($year))
	    $year = date("Y",$datime);

		$this->month 		 = $month;
		$this->year  		 = $year;
		$this->selectedday = $selectedday;
		$this->language	 = $language;

	  $time  = time();
	  if($this->month != date("n",$time) || $this->year != date("Y",$time))
	   $this->today = 0;
	  else
	   $this->today = date("j", $time);

	  if ( (($this->month < 8) && ($this->month % 2 == 1)) || (($this->month > 7) && ($this->month % 2 == 0)) )
	    $this->days = 31;
	  if ( (($this->month < 8) && ($this->month % 2 == 0)) || (($this->month > 7) && ($this->month % 2 == 1)) )
	    $this->days = 30;
	  if ($this->month == 2)
	    $this->days = (date("L",$datime)) ? 29 : 28;

	  $this->dayone = date("w",mktime(1,1,1,$this->month,1,$this->year));
	  $this->daylast = date("w",mktime(1,1,1,$this->month,$this->days,$this->year));

		if(!isset($size))
			$this->size = "expanded";
		else
			$this->size = $size;
	}

	function SetPlace($placeid = 0)
	{
		$this->placeid = $placeid;
	}

	function DisplayMonthOption()
	{
		// Display option box filled with months. this->month is selected
		global $defaultbgcolor;
  	echo "<select name=\"month\" onChange='OnSubmit2()' bgcolor='$defaultbgcolor'>
	       <option value=''></option>".
				 option_month($this->month)."
				 </select>";
	}

	function DisplayYearOption()
	{
		// Display option box filled with years. this->year is selected
  	echo "<select name=\"year\" onChange='OnSubmit2()'>
	        <option value=''></option>".
					option_year($this->year , $this->year-5 , $this->year+5)."
					</select>";
	}

	function DisplayReducedCalendar($language)
	{
		// display reduced calendar
		// generate a table with day organized by weeks

		// global variables
		global $daylist , $monthlist , $ME, $CFG, $modeagenda;

		// display month and year list box + day labels
		echo "<table border='0' cellpadding='0' cellspacing='0' width='200' height='115'>\n";
    echo "	<tr>\n";
		echo "		<td colspan='7' valign='middle' align='center'>\n";
		$this->DisplayMonthOption();
		$this->DisplayYearOption();
		echo "		</td>\n";
    echo "	</tr>\n";
    echo "	<tr>\n";
    echo "		<td class=Calendar_title width='15%'>".limit_text($daylist[1] , 3 , '')."</td>";
    echo "		<td class=Calendar_title width='15%'>".limit_text($daylist[2] , 3 , '')."</td>";
    echo "		<td class=Calendar_title width='15%'>".limit_text($daylist[3] , 3 , '')."</td>";
    echo "		<td class=Calendar_title width='15%'>".limit_text($daylist[4] , 3 , '')."</td>";
    echo "		<td class=Calendar_title width='15%'>".limit_text($daylist[5] , 3 , '')."</td>";
    echo "		<td class=Calendar_title width='15%'>".limit_text($daylist[6] , 3 , '')."</td>";
    echo "		<td class=Calendar_title width='15%'>".limit_text($daylist[7] , 3 , '')."</td>";

    // calculate the span for the first day
    $span1 = 0;
  	$span2 = 0;
  	if($this->dayone != 0)
  	  $span1 = $this->dayone;
	  if(6 - $this->daylast != 0)
	    $span2 = 6 - $this->daylast;

		$this->eventtext = "";

	  // for each day of this month
	  for($i = 1; $i <= $this->days; $i++)
	  {
	    // get the day index for this date
	    $dayofweek = date("w",mktime(1,1,1,$this->month,$i,$this->year));
	    $width = "14%";

	    if($dayofweek == 0 || $dayofweek == 6)
	      $width = "15%";

			// format date using formatSQLdate in stdlib.php3
			$date    = formatSQLdate($this->year , $this->month , $i , 23 , 59);
			$dateend = formatSQLdate($this->year , $this->month , $i);
			$req_listevents = "SELECT e.id ,e.title, t.type,d.start,d.end
    									 FROM   $CFG->table_event e, $CFG->table_eventtype t , $CFG->table_date d
											 WHERE  t.id = e.type
											 AND 		d.event = e.id AND d.start<='$date' AND d.end >='$dateend'";
			if($this->placeid)
				$req_listevents .= " AND d.place = $this->placeid ";

	  	$qid = db_query($req_listevents);
			$eventonday = db_num_rows($qid);

	    // Select the class style to display this day
	    $class = "td_calendar";
	    if($i == $this->today)
	  	  $class = "calendar_today";

	    if($eventonday)
	  	  $class = "calendar_usedday";

	    if($i == $this->selectedday)
	    {
	      // if this day has been selected by user, retrieve events for this day
	  	  $class = "calendar_selday";
				$num=0;
				while ($r = db_fetch_object($qid))
				{
					if($num)
						$this->eventtext .= "<hr size=1>";

                    // Load up the query parameters passed in to pass back to the referrer
                    $queryString = '';
                    foreach($_GET as $postVarKey => $postVarVal)
                    {
                    	$queryString .= "&$postVarKey=$postVarVal";
                    }
                    foreach($_POST as $postVarKey => $postVarVal)
                    {
                    	$queryString .= "&$postVarKey=$postVarVal";
                    }

					$this->eventtext .= "$r->type : <a href='infoevent.php3?id=$r->id$queryString'>$r->title</a>";
					$num++;
				}
				$this->datetext = $daylist[$dayofweek+1]." $i ".$monthlist[$this->month]." $this->year";
	    }

	    if($i == 1 || $dayofweek == 0)
	    {
	      echo " <tr>\n";
	      if($span1 > 0 && $i == 1)
	        echo "  <td colspan=\"$span1\"><font face=\"null\"></td>\n";
	    }

	    if($this->selectedday == $i)
	     $nextselect = 0;
	    else
	     $nextselect = $i;


      echo "<td class=$class width='$width' align='center'>";
      echo "<a href=$ME?modeagenda=calendar&selectedday=$nextselect&month=$this->month&year=$this->year&size=reduced>";
      echo $i."</td>";

	    if($i == $this->days)
      {
      	if($span2 > 0)
        	echo "  <td colspan=\"$span1\"></td>\n";
	    }
	    if($dayofweek == 6 || $i == $this->days)
	      echo " </tr>\n";
	  }
		echo "</table>";
	}

	function DisplayLegend()
	{
    // display calendar legend
		// generate a table

		global $strToday , $strSelDay ,$strEventDay;

		echo "<table width='100%' border='0' cellspacing='0' cellpadding='2'>";
    echo "	<tr>";
    echo "		<td class=calendar_today width='8%'>&nbsp;</td>";
    echo "		<td class=normal width='92%' >$strToday</td>";
    echo "	</tr>";
    echo "	<tr>";
		echo "		<td class=calendar_selday width='8%'>&nbsp; </td>";
		echo "		<td class=normal width='92%' >$strSelDay</td>";
    echo "  </tr>";
		echo "	<tr>";
		echo "		<td class=calendar_usedday width='8%'>&nbsp; </td>";
		echo "		<td class=normal width='92%' >$strEventDay</td>";
		echo "	</tr>";
		echo "</table>";
	}

	function DisplayExpandedCalendar()
	{
    // display expanded calendar
		// generate a table with day as a list

		global $Auth, $daylist , $monthlist, $ME, $CFG, $modeagenda;

		// display month and year list box + day labels
    echo "<table border='0' cellpadding='0' cellspacing='2' width='100%'>";
    echo "<tr>";
    echo "	<td colspan='9' valign='middle' align='center' height='12'>";
    echo "		<font face='Arial, Helvetica, sans-serif' size='3'><b>";
 		$this->DisplayMonthOption();
		$this->DisplayYearOption();
		echo "</b></td>";
    echo "</tr>";

    // for each day of the selected month
	  for($i = 1; $i <= $this->days; $i++)
	  {
	    // get the day index for this date
  	  $dayofweek = date('w',mktime(1,1,1,$this->month,$i,$this->year));
    	$width = '14%';

    	if($dayofweek == 0 || $dayofweek == 6)
      	$width = '15%';

	    // Select the class style to display this day
	    $class = "Calendar_title";
	    if($i == $this->today)
	  	  $class = "calendar_today";

		  if($this->selectedday == $i)
	     $nextselect = 0;
	    else
	     $nextselect = $i;

			// format date using formatSQLdate in stdlib.php3
			$date    = formatSQLdate($this->year , $this->month , $i , 23 , 59);
			$dateend = formatSQLdate($this->year , $this->month , $i);
	    $req_listevents = "SELECT e.id , e.title, t.type,d.start,d.end
	    									FROM   $CFG->table_event e, $CFG->table_eventtype t , $CFG->table_date d
  										  WHERE  t.id = e.type AND 	d.event = e.id AND d.start<='$date' AND d.end >='$dateend'";
 			if($this->placeid)
				$req_listevents .= " AND d.place = $this->placeid ";
	    $qid = db_query($req_listevents);


      // display day + eventtext if some
      echo "  <tr> ";
      echo "		<td class=Calendar_title width='5%'>".limit_text($daylist[$dayofweek+1] , 3 , '')."</td>";
      echo "    <td class=$class width='5%'>$i</td>";
      echo "    <td class=tdCalendar_text width='90%'>";
      $num=0;
      while ($r = db_fetch_object($qid))
      {
      	if($num)
      		echo "<hr size=1>";

        // Load up the query parameters passed in to pass back to the referrer
        $queryString = '';
        foreach($_GET as $postVarKey => $postVarVal)
        {
        	$queryString .= "&$postVarKey=$postVarVal";
        }
        foreach($_POST as $postVarKey => $postVarVal)
        {
        	$queryString .= "&$postVarKey=$postVarVal";
        }

      	echo "$r->type : <a href='infoevent.php3?id=$r->id$queryString'>";
      	echo pv($r->title);
      	echo "</a>";
		$this->DisplayEventRegisteredUsers($r->id, $Auth->id);
      	$num++;
      }
			echo "    </td>";
			echo "  </tr>";
		}
		echo "</table>";

	}
	function DisplayEventRegisteredUsers($eventID, $nCurrentUserID)
	{
		global $CFG, $Auth;
		$blankOrComma = "";
		$req_listeventusers = "SELECT eru.nEventRegisteredUserID, u.user, u.szFirstName, u.szLastName, eru.nUserID FROM $CFG->table_EventRegisteredUser eru JOIN $CFG->table_admin u ON eru.nUserID = u.id
  										  WHERE  eru.nEventID = $eventID ORDER BY u.szFirstName, u.szLastName";
	    $qid = db_query($req_listeventusers);

		echo(" (");
		$bCurrentUserRegistered = false;
		while ($r = db_fetch_object($qid))
		{
			if ($nCurrentUserID == $r->nUserID)
			{
				$bCurrentUserRegistered = true;
			}

			echo $blankOrComma;
//      		echo($r->user.'['.$r->szFirstName.']');
      		echo('<span onMouseover="ddrivetip(\''.$r->szFirstName.' '.$r->szLastName.'\',\'yellow\', 100)" onMouseout="hideddrivetip()">'.$r->user.'</span>');
			$blankOrComma = ", ";
		}
		echo(")");
		if ($Auth->can_do_basic())
		{
			if ($bCurrentUserRegistered == false)
			{
		      	echo " - <a href=\"eventregisteruser.php3?nEventID=$eventID&nUserID=$nCurrentUserID&register=1\">Register For Event</a>";
			}
			else
			{
		      	echo " - <a href=\"eventregisteruser.php3?nEventID=$eventID&nUserID=$nCurrentUserID&register=0\">Unregister For Event</a>";
			}
		}
	}
}

function DrawProgressBar($nPercentage, $szProgressBarColor, $szProgressBarEmptyColor)
{
	$szHTMLProgressBar.="<table border=0 cellspacing=0 cellpadding=0 width=100 height=10>";
	$szHTMLProgressBar.="<tr>";
	$szHTMLProgressBar.="<td>";
	$szHTMLProgressBar.="<table cellspacing=0 cellpadding=0 height=10 width=\"$nPercentage\" bgcolor=$szProgressBarColor>";
	$szHTMLProgressBar.="<tr>";
	$szHTMLProgressBar.="<td>";
	$szHTMLProgressBar.="</td>";
	$szHTMLProgressBar.="</tr>";
	$szHTMLProgressBar.="</table>";
	$szHTMLProgressBar.="</td>";
	$szHTMLProgressBar.="<td width=\"".(100-$nPercentage)."\" bgcolor=$szProgressBarEmptyColor>";
	$szHTMLProgressBar.="</td>";
	$szHTMLProgressBar.="</tr>";
	$szHTMLProgressBar.="</table>";
	return $szHTMLProgressBar;
}

endif;

$agendauser = 1;								// set phpMyAgenda to user mode
include ("application.php3");					// phpMyAgenda configuration vars
$requirebasicuser = false;
include ("admin/include/auth.inc.php3");
$UI = new CVisitorUI;
if(!isset($pagesuffix))
	$pagesuffix = "";
$UI->Init($pagesuffix);
include("lang/$UI->language.lang.php3");		// language definition


?>
