<?php
/**
* Generation des dates pour realiser un calendrier
*
* Cette class genere toutes les dates necessaire pour realiser un calendrier
* les dates sont retournees sous forme array()
* les dates generees sont :
* 		- tous les jours de la periode du calendrier passee en parametre
* 		- tous les weekends de la periode du calendrier passee en parametre
* 		- tous les jours feries fixes francais de la periode du calendrier passee en parametre
* 		- tous les jours feries variables (paques, pentecote,ascension) de la periode du calendrier passee en parametre
*		- le cumul par ordre chronologique croissant des jours feries
*
* @version 1.0
* @author BRIZARD Olivier <o.brizard@gmail.com>
* @link http://www.beemoon.fr
* @copyright Copyright (c) 2010, BRIZARD Olivier
* @license http://creativecommons.org/licenses/by-sa/2.0/fr/
*/

class Calendrier{
	
	// Les attributs prives retournes par __get()
	private $_lesJours;
	private $_lesWeekends;
	private $_lesAnnees;
	private $_lesFeriesFixes;
	private $_lesFeriesVariables;
	private $_tousLesFeries;
	private $_toutLeCalendrier;
	
	// Les attributs prives non retournes
	private $_dateDeb;
	private $_dateFin;	
	private $_config = "conf.ini";	     
	private $configFile = array();
	    
   	public function __construct($date_deb,$date_fin){
   		// Controle que le module Calendar est chargé
   		if (!extension_loaded("calendar")) {echo "Cette class utilise les fonctions de Calendar.";exit();}
   		
  		// Chargement du fichier de configuration des jours feries
  		 if (file_exists($this->_config)) {
	       $this->configFile = parse_ini_file($this->_config,true);
	       $this->displayDate = $this->configFile['displayDate']; 
	       // Fixe la timezone
	       $this->timezoneTmp = $this->configFile['fuseauHoraire'];
	       if (isset($this->timezoneTmp[timezone])){
	       	date_default_timezone_set($this->timezoneTmp[timezone]);
	       	//echo $this->timezoneTmp[timezone]. '<br />';
	       	}
	       	
	     }else{
	     	echo "Il n'existe pas de fichier de configuration des dates f&eacute;ri&eacute;es<br/>";
	     	echo "Ce fichier doit se nommer 'joursFeries.ini' avec la m&ecirc;me synthaxe que le fichier php.ini<br/>";
	     	echo "Vous pouvez renommer le fichier 'joursFeries.ini.sample'<br/>";
	     	exit();
	     } 
    	// ==> Fin de chargement du fichier des jours feries
     
     	// Controle les arguments d'instanciation
		$i = func_num_args();        
		switch ($i) {
		    case 0:
		        $this->_dateDeb = '01-01-'.date('Y');
       			$this->_dateFin = '31-12-'.date('Y');
		        break;
		    case 2:
		        if (strtotime ($date_fin) - strtotime ($date_deb) < 0) {
		          $this->_dateDeb = $date_fin;
		          $this->_dateFin = $date_deb;
		        }else{
			      $this->_dateDeb = $date_deb;
       			  $this->_dateFin = $date_fin;
		        }
		        break;
		    default:
		       echo 'Les arguments d\'instanciations sont incorrects<br/>';
		       echo 'Sans argument le calendrier s\'&eacute;tendra du 1er janvier au 31 d&eacute;cembre de l\'ann&eacute;e en cours<br/>';
		       echo '<br/>';
		       echo 'usage: $ma_variable = new Calendrier()<br/>';
	           echo 'usage: $ma_variable = new Calendrier(\'date_deb\',\'date_fin\');';
	           exit();
		}
		// ==> Fin de controle les arguments d'instanciation
		
		// ==> initialisation des variables		
		$this->_lesJours = $this->jours();
		$this->_lesWeekends = $this->weekends();
		$this->_lesAnnees = $this->annees();
		$this->_lesFeriesFixes = $this->feriesFixes();
		$this->_lesFeriesVariables = $this->feriesVariables();
		$this->_tousLesFeries = $this->tousLesFeries();
		$this->_toutLeCalendrier = $this->toutLeCalendrier();

      } 
     
/**
* Calcule tous les jours de la periode demandees
*
* @param void
* @return array
*/      
	private function jours(){
		 $date1= strtotime($this->_dateDeb);
	     $date2= strtotime($this->_dateFin);	    
	     $nbjour=($date2-$date1)/60/60/24;
	    
	     for($i=1;$i<=$nbjour+1;$i++){
	     	if($this->displayDate[unixTime]=='0'){
	     		$numDay=jddayofweek(unixtojd($date1));
	     		$jours[date('d-m-Y',$date1)]=$this->labelJour($numDay);
	     	}else{
	     		$numDay=jddayofweek(unixtojd($date1));
				$jours[$date1]=$this->labelJour($numDay);
	     	}
				$date1= strtotime('+1 day', $date1);
	     }	     
	     return $jours;
	}


/**
* Calcule tous les weekends de la periode demandee
*
* @param void
* @return array
*/
	private function weekends(){
		$lesJours = $this->_lesJours;
	
		foreach ($lesJours as $key=>$value) {
			if($this->displayDate[unixTime]=='0'){
				if(jddayofweek(unixtojd(strtotime($key)))==0) {$weekend[$key]=$this->labelJour(jddayofweek(unixtojd(strtotime($key))));}
				if(jddayofweek(unixtojd(strtotime($key)))==6) {$weekend[$key]=$this->labelJour(jddayofweek(unixtojd(strtotime($key))));}
			}else{
				if(jddayofweek(unixtojd($key))==0) {$weekend[$key]=$this->labelJour(jddayofweek(unixtojd($key)));}
				if(jddayofweek(unixtojd($key))==6) {$weekend[$key]=$this->labelJour(jddayofweek(unixtojd($key)));}
			}
		}
		unset($key);
		unset($value);
		
		return $weekend;
	}


/**
* Recupere les annees de la periode demandee
*
* @param void
* @return array
*/
	private function annees(){
		$lesJours = $this->_lesJours;
		
		$i=0;
		foreach ($lesJours as $key=>$value) {
			if($this->displayDate[unixTime]=='0'){
		    	$anneeTmp = date('Y',strtotime($key));
			}else{
				$anneeTmp = date('Y',$key);
			}
		    if (!in_array($anneeTmp, $annee)) {
			    $annee[$i]=$anneeTmp;
			    $i++;
			}
		}
		unset($key);
		unset($value);
		
		return $annee;
	}
	

/**
* Recupere les jours feriees fixes de la periode demandee
*
* @param void
* @return array
*/
	private function feriesFixes(){
		$lesJours = $this->_lesJours;
		$annee = $this->_lesAnnees;
		
		$feriesFixes=array();
		$joursFeriesFixes=$this->configFile['joursFeriesFixes'];	
		$feriesFixes=array();
		foreach ($annee as $value) {
			foreach ($joursFeriesFixes as $labelJour => $dateJour) {
				if($this->displayDate[unixTime]=='0'){
					$formatDate=$dateJour.'-'.$value;
				}else{
					$formatDate=strtotime($dateJour.'-'.$value);
				}
				if (in_array($formatDate, array_keys($lesJours))) {
					if($this->displayDate[unixTime]=='0'){
						$feriesFixes[$dateJour.'-'.$value]= $labelJour;
					}else{
						$feriesFixes[strtotime($dateJour."-".$value)]= $labelJour;
					}
				}
			}
			unset($labelJour);
			unset($dateJour);
		}
		unset($value);
		return $feriesFixes;
	}


/**
* Calcule le jour de Paques
*
* @param annee
* @return date formatee "d-m-Y"
*/
	private function paques($annee){
		$paques =  date("d-m-Y", easter_date($annee));
		$lundipaques = date("d-m-Y",strtotime('+1 day',  easter_date($annee)));
		return array($paques,$lundipaques);
	}
	

/**
* Calcule le jour de l'ascension
* Jour de paques + 39 jours
*
* @param annee
* @return date formatee "d-m-Y"
*/
	private function ascension($annee){
		$ascension = date("d-m-Y",easter_date($annee)+(60*60*24*39));
		return $ascension;
	}


/**
* Calcule le jour du lundi de Pentecote
* Jour de paques + 49 jours
*
* @param annee
* @return date formatee "d-m-Y"
*/	
	private function pentecote($annee){
		$pentecote = date("d-m-Y",easter_date($annee)+(60*60*24*49));
		$lundipentecote = date("d-m-Y",strtotime('+1 day', easter_date($annee)+(60*60*24*49)));
		return array($pentecote,$lundipentecote);
	}


/**
* Recupere les jours feriees variables de la periode demandee
*
* @param void
* @return array
*/
	private function feriesVariables(){
		$lesJours = $this->_lesJours;
		$annee = $this->_lesAnnees;
		
		$feriesVariables=array();	
		$joursFeriesVariables=$this->configFile['joursFeriesVariables'];
		
		foreach ($annee as $value) {
			if($this->displayDate[unixTime]=='0'){	
				if($joursFeriesVariables['lundi de Paques']=='1'){
				$tmp = $this->paques($value);
				$feriesVariablesTmp[$tmp[0]]='P&acirc;ques';
				$feriesVariablesTmp[$tmp[1]]='lundi de P&acirc;ques';
				}
				if($joursFeriesVariables[Ascension]=='1'){
				$feriesVariablesTmp[$this->ascension($value)]='Ascension';
				}
				if($joursFeriesVariables['lundi de Pentecote']=='1'){
				$tmp = $this->pentecote($value);
				$feriesVariablesTmp[$tmp[0]]='Pentecote';
				$feriesVariablesTmp[$tmp[1]]='lundi de Pentecote';	
				}
				
			}else{
			
				if($joursFeriesVariables['lundi de Paques']=='1'){
				$tmp = $this->paques($value);
				$feriesVariablesTmp[$tmp[0]]='P&acirc;ques';
				$feriesVariablesTmp[$tmp[1]]='lundi de P&acirc;ques';
				}
				if($joursFeriesVariables[Ascension]=='1'){
				$feriesVariablesTmp[strtotime($this->ascension($value))]='Ascension';
				}
				if($joursFeriesVariables['lundi de Pentecote']=='1'){
				$tmp = $this->pentecote($value);
				$feriesVariablesTmp[$tmp[0]]='Pentecote';
				$feriesVariablesTmp[$tmp[1]]='lundi de Pentecote';	
				}
			}		 
		}
		unset($value);
		
		$feriesVariables=array();
		foreach ($feriesVariablesTmp as $key => $label) {
			if (in_array($key, array_keys($lesJours))) {
				$feriesVariables[$key]=$label;
			}
		}	
		unset($key);
		unset($label);
		
		return $feriesVariables;
	}


/**
* Recupere tous les jours feriees fixes et variables de la periode demandee
*
* @param void
* @return array
*/
	private function tousLesFeries(){
		
		$feries=array();
		
		// dates et labels
		$joursFeriesVariables=$this->_lesFeriesVariables;
		$joursFeriesFixes=$this->_lesFeriesFixes;
		
		// Que les dates
		$listeDatesFixes=array_keys($joursFeriesFixes);
		$listeDatesVariables=array_keys($joursFeriesVariables);	
			
					
		 if($this->displayDate[unixTime]=='0'){
			foreach ($listeDatesFixes as $key=>$value) {
				$listeDatesFixes[$key]=strtotime($value);
			}
			unset($key);
			unset($value);
						
			foreach ($listeDatesVariables as $key=>$value) {
				$listeDatesVariables[$key]=strtotime($value);
			}
			unset($key);
			unset($value);
			
			if(count($listeDatesFixes)>0 AND count($listeDatesVariables)>0){
				$toutesDates=array_merge($listeDatesFixes,$listeDatesVariables);
				$tousLabel=array_merge($joursFeriesFixes,$joursFeriesVariables);
				$feries=array_combine($toutesDates,$tousLabel);
				
			}else{
				if(count($listeDatesFixes)==0){
					$toutesDates=$listeDatesVariables;
					$tousLabel=$joursFeriesVariables;
					$feries=array_combine($toutesDates,$tousLabel);
					
				}else{
					$toutesDates=$listeDatesFixes;
					$tousLabel=$joursFeriesFixes;
					$feries=array_combine($toutesDates,$tousLabel);
				}
			}
			// On trie sur les dates (keys) au format timestamp unix
			// puis on les convertit en date formatee "d-m-Y"	
			ksort($feries);			
			$tmp1=array_keys($feries);      
	       	$tmp2=array_values($feries);
	       	foreach ($tmp1 as $key=>$value) {
					$tmp3[$key]=date("d-m-Y",$value);
				}
			unset($key);
			unset($value); 
	       	$feries=array_combine($tmp3,$tmp2);
	       	       
		}else{

			if(count($listeDatesFixes)>0 AND count($listeDatesVariables)>0){
				$toutesDates=array_merge($listeDatesFixes,$listeDatesVariables);
				$tousLabel=array_merge($joursFeriesFixes,$joursFeriesVariables);
				$feries=array_combine($toutesDates,$tousLabel);			
			}else{
				if(count($listeDatesFixes)==0){
					$feries=$joursFeriesVariables;			
				}else{
					$feries=$joursFeriesFixes;
				}
			}
			
			ksort($feries);			
		}
		return $feries;
	}
	

/**
* Toutes les dates et labels des dates dans un tableau de la periode demandee
*
* @param void
* @return array
*/
	private function toutLeCalendrier(){
		$lesJours=$this->_lesJours;
		$lesWeekends=$this->_lesWeekends;
		$lesAnnees=$this->_lesAnnees;
		$tousLesFeries=$this->_tousLesFeries;
		$datesFeries=array_keys($tousLesFeries);
		
		foreach($lesAnnees as $annee){
			foreach ($lesJours as $keyJours=>$valueJours) {
		    	if (date("Y",strtotime($keyJours)) == $annee) {	
		    		$anneeTmp = date("Y",strtotime($keyJours));		    		
					$moisTmp = date("m",strtotime($keyJours)); 			
					$joursTmp = date("j",strtotime($keyJours));
					$joursTmp2 = date("d-m-Y",strtotime($keyJours)); 			
					if (!in_array($joursTmp2, $datesFeries)) {				    
					    $explodeCalendar[$annee][$moisTmp][$joursTmp]=$valueJours;
					}
					else{
						$explodeCalendar[$annee][$moisTmp][$joursTmp][$valueJours]=$tousLesFeries[$joursTmp2];
					}			
		    	}
			}
		}
		
		return $explodeCalendar;	
	}
	
	
		
/**
* Acces aux attributs prives du calendrier
*
* @param nom de l'attribut
* @return array
*/ 
	public function __get($nameAttribut) {
	    $temp='_'.$nameAttribut;
	    return $this->$temp;
	  }


/**
* Converti le label des jours
*
* @param int valeur numerique du jour entre 0 et 6
* @return string chaine de caracteres du jour
*/ 
	public function labelJour($numJour){
		$test=preg_match("/^0/",$numJours);		
		if($test){$numJour=preg_replace('/^0/',"", $numJour);}
		
		$strJours = $this->configFile['labelsJours'];	
		return $strJours[$numJour];			
	}
	
		  
/**
* Conversion des mois numériques en chaine de caracteres
*
* @param int valeur numerique du mois entre 1 et 12
* @return string chaine de caracteres du mois
*/ 	  
	
	public function labelMois($numMois) {
		$test=preg_match("/^0/",$numMois);		
		if($test){$numMois=preg_replace('/^0/',"", $numMois);}
		
		$strMois = $this->configFile['labelsMois'];	
		return $strMois[$numMois];	
	  }
	  
}
?>