<?php
/******************************************************************************************************************************************************************************
****												DEVELOPPER PAR TOULISSE ERIC (2008)										      ***
*******************************************************************************************************************************************************************************
****												              VERSION 1.0 													      ***
/******************************************************************************************************************************************************************************
					  ***********************************************************************************************************************
					  **  --------------------------------------------------------------------------------------------------------------------------------          **
					  **  --------------------------------------------CLASS DES FICHIERS PDF (GESTION GLOBALE)------------------------------        **
					  **  --------------------------------------------------------------------------------------------------------------------------------          **
					  ***********************************************************************************************************************
  *****************************************************************************************************************************************************************************/ 
include("Class_Objet_Pdf.php");

Class Fichier_PDF{
	//FICHIER PDF
	private  $Contenu_tampon;
	private	 $Version;
	private  $NombreObjet;
	//OBJET DIVERS
	private  $Trailer;
	private  $XHref;
	private  $NumInfo;
	private  $NumCat;
	//private $ListeObjets=array();
	

	
/*--------------------------------------------------------------------------------------------------------------------------------
  --------------------------------------------CONSTRUCTUER ET DESTRUCTEUR--------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
 public function __construct(){}
 public function __destruct(){
	$this->Contenu_tampon="";
	$this->NombreObjet=0;
	$this->XHref->__destruct();
	$this->Trailer->__destruct();
 }
 
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------OUVERTURE DU DOCUMENT----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
		public function Ouvrir($Document){
		
				//LECTURE
				$this->Contenu_tampon="";
				$fichier = fopen ($Document, "r");
				while (!feof($fichier)) {					
					$this->Contenu_tampon .= fgets($fichier, 4096);
				}
				fclose ($fichier);
				
				//VERSION
				if($this->Est_Valide()){
					$this->Version=substr($this->Contenu_tampon,5,3);
					//ANALYSE DU CONTENU
					$this->Analyse_Document();
				}else{
					$this->Version="0";
				}
				
				
		}

/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------DEMANDE DU CONTENU DOCUMENT------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
		public function Obtenir_Contenu(){
			return $this->Contenu_tampon;
		}
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------TAILLE DU DOCUMENT----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
		public function Obtenir_Taille(){
			return strlen($this->Contenu_tampon);
		}
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------PDF VALIDE----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
		public function Est_Valide(){
			
			if(substr($this->Contenu_tampon,0,4)=="%PDF"){
				$res=true;
			}else{
				$res=false;
			}
			return $res;
		 }
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------PDF VERSION----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
		 public function Obtenir_Version(){
			return $this->Version;
		 }
		 
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------NOMBRE DE PAGE----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
  
		 public function Obtenir_Nombre_De_Pages(){
			$bin=$this->Obtenir_liste_pages();
			$cpt=sizeof($bin);
			
			return $cpt;			
		 }



/*--------------------------------------------------------------------------------------------------------------------------------
  --------------------------NOMBRE DE PAGEEN CONSIDERANT CELLES NON REFERENCE --------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
		 //NOTE : TEMPS EXECUTION TRES LONG
		 //SI DIFFERENT DU NOMBRE DE PAGES REFERENCE ALORS LE FICHIER N4ETPASAUX NORMES
		 public function Obtenir_Nombre_de_Pages_presentes(){
			$nb=$this->NombreObjet-1;			
			$cpt=0;
			$i=0;
			$j=0;
			while($i<$nb){
				if($this->XHref->Objet_Existe($j)){
					$i++;
					if($this->Charge_Objet($j,$this->XHref->Obtenir_Version_objet($j))->Get_Type()=="Page"){
						$cpt++;				
					}					
				}
				$j++;
							
			}
		 }
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------PARENT DE PAGE----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 		 
	public function Obtenir_Parent_De_Objet($Num){
		$Parent=$this->Charge_Objet($Num,$this->XHref->Obtenir_Version_objet($Num))->Obtenir_Information_Simple("/Parent");
		if($Parent!=""){
			$Parent=trim($Parent);
			$Parent=substr($Parent,0,strpos($Parent," "));
		}
		return $Parent;		
	}
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------CONTENT DE PAGE----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 		
	public function Obtenir_Objet_Content_De_Objet($Num){
		$Content=$this->Charge_Objet($Num,$this->XHref->Obtenir_Version_objet($Num))->Obtenir_Information_Simple("/Contents");
		$Listeobj=array();
		if($Content!=""){			
			$Pos_Objet=0;
		
			$Detection=" R"; //NON MODIFIABLE
			
			while(!(strpos($Content,$Detection,$Pos_Objet)===false)){
				
				$Pos_Objet=strpos($Content,$Detection,$Pos_Objet);
				$pos=$Pos_Objet;
				
				while(substr($Content,$pos,1)==" "){
					$pos--;
				}
				
			
				while(is_numeric(substr($Content,$pos,1))){				
					$pos--;
				}
					
				while(substr($Content,$pos,1)==" "){
					$pos--;
				}
				
				$Objet="";
				while(is_numeric(substr($Content,$pos,1))){				
					$Objet=substr($Content,$pos,1).$Objet;
					
					$pos--;
				}
				$Listeobj[sizeof($Listeobj)]=$Objet;

				
				$Pos_Objet++;
			}		
		}
		
		return $Listeobj;	
	}
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------RESSOURCE DE PAGE----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 			
	public function Obtenir_Objets_Ressources_De_Objet($Num){
		$Listeobj=array();		
		$Content=$this->Charge_Objet($Num,$this->XHref->Obtenir_Version_objet($Num))->Obtenir_Information_Complexe("/Resources");
		
		$Pos_Objet=0;
		
		$Detection=" R"; //NON MODIFIABLE
		
		while(!(strpos($Content,$Detection,$Pos_Objet)===false)){
			$Pos_Objet=strpos($Content,$Detection,$Pos_Objet);
			$pos=$Pos_Objet;
			
			while(substr($Content,$pos,1)==" "){
				$pos--;
			}
			
		
			while(substr($Content,$pos,1)!=" "){				
				$pos--;
			}
				
			while(substr($Content,$pos,1)==" "){
				$pos--;
			}
			
			$Objet="";
			while(substr($Content,$pos,1)!=" "){				
				$Objet=substr($Content,$pos,1).$Objet;
				$pos--;
			}
			$Listeobj[sizeof($Listeobj)]=$Objet;
			
			$Pos_Objet++;
		}
		return $Listeobj;
	}
	
/*--------------------------------------------------------------------------------------------------------------------------------
  ------------------------------------------------AUTEUR DU DOCUMENT----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 		
	public function Obtenir_Auteur_Du_Document(){
		$this->Decompose_Objet($this->NumInfo,$Num,$version);
		if($this->NumInfo!=0){
			$Auteur=$this->Charge_Objet($Num,$this->XHref->Obtenir_Version_objet($this->NumInfo),"Objets_Info")->Obtenir_Auteur();
		}else{
			$Auteur="";
		}
		return $Auteur;
	}
/*--------------------------------------------------------------------------------------------------------------------------------
  ------------------------------------------------CREATEUR DU DOCUMENT----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 		
	public function Obtenir_Createur_Du_Document(){
		$this->Decompose_Objet($this->NumInfo,$Num,$version);
		if($this->NumInfo!=0){
			$Createur=$this->Charge_Objet($Num,$this->XHref->Obtenir_Version_objet($this->NumInfo),"Objets_Info")->Obtenir_Createur();
		}else{
			$Createur="";
		}
		return $Createur;
	}
/*--------------------------------------------------------------------------------------------------------------------------------
  ------------------------------------------------TITRE DU DOCUMENT----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 		
	public function Obtenir_Titre_Du_Document(){
		$this->Decompose_Objet($this->NumInfo,$Num,$version);
		if($Num!=0){
			$obj=$this->Charge_Objet($Num,$this->XHref->Obtenir_Version_objet($this->NumInfo),"Objets_Info");
			
			$Createur=$obj->Obtenir_Titre();
		}else{
			$Createur="";
		}
		return $Createur;
	}
	/*--------------------------------------------------------------------------------------------------------------------------------
  ------------------------------------------------MC DU DOCUMENT----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 		
	public function Obtenir_Mots_Cles_Du_Document(){
		$this->Decompose_Objet($this->NumInfo,$Num,$version);
		if($this->NumInfo!=0){
		
			$Createur=$this->Charge_Objet($Num,$this->XHref->Obtenir_Version_objet($this->NumInfo),"Objets_Info")->Obtenir_MC();
		}else{
			$Createur="";
		}
		return $Createur;
	}
/*--------------------------------------------------------------------------------------------------------------------------------
  ------------------------------------------------VERSION DE L'OBJET----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 		
	public function Obtenir_Version_Objet($Num){
		if($this->XHref->Objet_Existe($Num)){
			$res=$this->XHref->Obtenir_Version_objet($Num);
		}else{
			$res="";
			$this->_Remonter_Erreur(6,"Objet Inexistant : $Num! ".sizeof($this->ListeObjets));
		}
		return trim($res);
	}
/*--------------------------------------------------------------------------------------------------------------------------------
  ------------------------------------------------VERSION MAX OBJET----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 		
	 public function Obtenir_Max_Version_Objet(){
		$nb=$this->XHref->Nombre_Objets();
		$Max=0;
		$i=0;
		$j=0;
		while($i<$nb){
			if($this->XHref->Objet_Existe($j)){
				$i++;
				$ver=$this->XHref->Obtenir_Version_objet($j);
				if($ver>$Max){
					$Max=$ver;
				}
			}
			$j++;			
		}
		return $Max;
	 }
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------RESSOURCE DE PAGE----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 			
	public function Obtenir_liste_pages($Num=0){
		//SI NUM N'est pas definit on prend le premier liste de pages
		if($Num==0){
			$NumLP=$this->Obtenir_Objet_liste_pages();
			
			$this->Decompose_Objet($NumLP,$Num,$Version);
		}
		
		//LISTE DES ENFANTS
		$Obj_ListePages=$this->Charge_Objet($Num,$this->XHref->Obtenir_Version_objet($Num));
		$Obj_ListePages->Obtenir_Information_Simple("/Kids");
		$Detection=" R"; //NON MODIFIABLE
		$Pos_Objet=0;
		
		$Content=$Obj_ListePages->Obtenir_Information_Complexe("/Kids","[","]");
		while(!(strpos($Content,$Detection,$Pos_Objet)===false)){
			$Pos_Objet=strpos($Content,$Detection,$Pos_Objet);
			$pos=$Pos_Objet;
			
			while(substr($Content,$pos,1)==" "){
				$pos--;				
			}
			
		
			while(substr($Content,$pos,1)!=" "){				
				$pos--;
			}
				
			while(substr($Content,$pos,1)==" "){
				$pos--;
			}
			
			$Objet="";
			while(is_numeric(substr($Content,$pos,1))){				
				$Objet=substr($Content,$pos,1).$Objet;
				$pos--;
			}
			$Obj_EnCours=$this->Charge_Objet($Objet,$this->XHref->Obtenir_Version_objet($Objet));
			if(strtolower($Obj_EnCours->Get_Type())=="pages"){		
				//LISTE DE PAGES EN FILS
				$bin=$this->Obtenir_liste_pages($Objet);
				for($i=0;$i<sizeof($bin);$i++){
					$Listeobj[sizeof($Listeobj)]=$bin[$i];
				}
				unset($bin);
			}else{
				if(strtolower($Obj_EnCours->Get_Type())=="page"){
					$Listeobj[sizeof($Listeobj)]=$Objet;
				}else{
					$this->_Remonter_Erreur(7,"Type de page fille inconnu ($Objet) : ".$this->ListeObjets[$Objet]->Get_Type());
				}
			}
			
			$Pos_Objet++;
		}
		
		return $Listeobj;
	}
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------LISTES DES PAGES----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 			
  public function Obtenir_Objet_liste_pages(){

    $this->Decompose_Objet($this->NumCat,$Num,$Version);
	
	$res=$this->Charge_Objet($Num,$this->XHref->Obtenir_Version_objet($Num));
	
	return $this->Charge_Objet($Num,$this->XHref->Obtenir_Version_objet($Num))->Obtenir_Information_Simple("/Pages");
  }
  
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------OBTENIR OBJET----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/
  public function Obtenir_Objet($Num){
	if($this->XHref->Objet_Existe($Num)){		
		$res=$this->Charge_Objet($Num,$this->XHref->Obtenir_Version_objet($Num));
	}else{
		$this->_Remonter_Erreur(6,"Objet Inexistant : $Num");
	}
	return $res;
  }
  
 /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------OBTENIR CONTENU OBJET----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
  public function Obtenir_Contenu_Objet($Num){
	if($this->XHref->Objet_Existe($Num)){		
		$res=$this->Charge_Objet($Num,$this->XHref->Obtenir_Version_objet($Num))->Get_Contenu();
	}else{
		$res="";
		$this->_Remonter_Erreur(6,"Objet Inexistant : $Num! ");
	}
	return $res;
  }
 /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------TROUVER OBJET A POSITION----------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/
  public function Obtenir_Objet_A_Position($Pos){
	if($Pos>0 && $Pos<=strlen($this->Contenu_tampon)){		
		$Lettre=substr($this->Contenu_tampon,$Pos,1);
		//ON arrive jusqu'au chiffre (on vire espace et retour ligne)
		while(!is_numeric($Lettre)){
			$Pos++;
			$Lettre=substr($this->Contenu_tampon,$Pos,1);
		}
		//On prend le chiffre
		$res="";
		while(is_numeric($Lettre)){
			$res.=$Lettre;
			$Pos++;
			$Lettre=substr($this->Contenu_tampon,$Pos,1);
		}
	}else{
		$this->_Remonter_Erreur(8,"Taille en dehors du fichier : $Pos");
	}
	return $res;
  }
  
 /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------FONCTIONS PRIVEES---------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 	 
  
  
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------ANALYSE LE FICHIER---------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/
	private function Analyse_Document(){
		//On trouve le trailer
		$this->Trouve_Trailer();
		//nombre d'objet
		$this->NombreObjet=$this->Trailer->Get_Taille_Fichier();
		//Objet Info
		$this->NumInfo=$this->Trailer->Get_Objet_Info();		
		$this->Decompose_Objet($this->NumInfo,$Num,$Version,"R");
		$this->Charge_Objet($Num,$Version);
		//OBJET CATALOGUE
		$this->NumCat=$this->Trailer->Get_Catalogue_Fichier();
		
		
	}
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------CHARGE UN OBJET---------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/
	 private function Charge_Objet($Num,$Version="0",$Classe="Objets_PDF"){	  
		  $pos_debut=0;
		  $pos_fin=0;
		  if($this->NumInfo==$Num && $Classe=="Objets_PDF"){
				$Classe="Objets_Info";
		  }
		  $this->XHref->Obtenir_Position_objet($Num,$pos_debut,$pos_fin);		  
		  $Contenu=substr($this->Contenu_tampon,$pos_debut,$pos_fin-$pos_debut);
		  	  
		  //ON PREND QUE LE DEBUT
		  $Detection=" obj";
		  if (!strpos($Contenu,$Detection)===false){
			$pos=strpos($Contenu,$Detection)+strlen($Detection);
			while(substr($Contenu,$pos,1)==chr(10) || substr($Contenu,$pos,1)==chr(13)){
				$pos++;
			}
			$Contenu=substr($Contenu,$pos,strlen($Contenu)-$pos);			
		  }
		  //ON ENLEVE  LA FIN 
		  $Detection="endobj";
		  if (!strpos($Contenu,$Detection)===false){
			$pos=strpos($Contenu,$Detection);
			while(substr($Contenu,$pos,1)==chr(10) || substr($Contenu,$pos,1)==chr(13)){
				$pos--;
			}
			$Contenu=substr($Contenu,0,$pos);			
		  }		
		  $Resultat=new $Classe($Contenu);
		  $Resultat->Set_Numero($Num);
		  $Resultat->Set_OffSet($pos_debut);
		  return $Resultat;
	 }
	 
	 /*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------DECOMPOSE LE NOM D'UN OBJET---------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/
	 private function Decompose_Objet($Phrase,&$NumObjet,&$Version,$Arret="R"){
		$pos=strpos($Phrase,$Arret);
		if($pos===false){
			//ON Y FAIT KOI ?
		}else{
			$Phrase=substr($Phrase,0,$pos);
			$Phrase=trim($Phrase);			
			$tab=explode(" ",$Phrase);
			$NumObjet=$tab[0];
			$Version=$tab[1];			
		}
	 }
	/*--------------------------------------------------------------------------------------------------------------------------------
  --------------------------------------------AFFICHE UNE ERREUR--------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/ 
	private function _Remonter_Erreur($Numero,$Erreur){
		echo "<br><u>Erreur n".$Numero."</u><br><b>".$Erreur."</b><br>";
		exit();
	}
/*--------------------------------------------------------------------------------------------------------------------------------
  ---------------------------------------------------TROUVE LE TRAILER---------------------------------------------------------
  --------------------------------------------------------------------------------------------------------------------------------*/
	private function Trouve_Trailer(){
		
		$pos1=0;
		$Detection1="trailer";
		$Position=0;
		$Trouver=false;
		//ON TROUVE TOUS LES TRAILERS
		while(!(strpos($this->Contenu_tampon,$Detection1,$pos1)===false)){
			$pos1=strpos($this->Contenu_tampon,$Detection1,$pos1);
			
			//Si on a un retour a la ligne avant
			if(substr($this->Contenu_tampon,($pos1-1),1)==chr(10) || substr($this->Contenu_tampon,($pos1-1),1)==chr(13) || substr($this->Contenu_tampon,($pos1-1),1)==" "){
				//et un retour a la ligne apres
				if(substr($this->Contenu_tampon,($pos1+strlen($Detection1)),1)==chr(10) || substr($this->Contenu_tampon,($pos1+strlen($Detection1)),1)==chr(13)  || substr($this->Contenu_tampon,($pos1+strlen($Detection1)),1)==" "){
					$Trouver=true;
					$Position=$pos1;						
					
						$Last=strpos($this->Contenu_tampon,"%%EOF",$Position);
						if($Last===false){
							$this->_Remonter_Erreur(9,"%%EOF ABSENT");
						}else{
							//SI LE TRAILER N'EXISTE PAS ON LE CREER SINON ON LUI AFFECTE UN CONTENU
							if ($this->Trailer instanceof  Objets_Trailer){
								
								$this->Trailer->Set_Contenu(substr($this->Contenu_tampon,$Position,$Last-$Position));
								$this->Trailer->Set_Offset($Position);
							}else{						
								$this->Trailer=new Objets_Trailer(substr($this->Contenu_tampon,$Position,$Last-$Position));
								$this->Trailer->Set_Offset($Position);
							}
						}
					
					
					//ON GENERE L'OBJET XHREF
					    $Xhref_Position=$this->Trailer->Get_Xhref_position();	
						
						$Contenu=substr($this->Contenu_tampon,$Xhref_Position,$Position-$Xhref_Position);						
						$ListeDetections=array();
						$ListeDetections[0]="xref";
						$ListeDetections[1]="xhref";
						$i=0;
						$Detection=$ListeDetections[$i];
						while((strpos($Contenu,$Detection)===false) && $i<sizeof($ListeDetections)){
							$i++;
							$Detection=$ListeDetections[$i];	
												
						}
						
						//ON TROUVE LA POSITION
						if( TrouvePosition($Contenu,$Detection)===false){
							$this->_Remonter_Erreur(4,"Xref Non existant dans les rfrences croiss");
						}else{
							$pos=0;
							while(!(strpos($Contenu,$Detection,$pos+1)===false)){
								$pos=strpos($Contenu,$Detection,$pos+1);
													

							}
							
							//$Contenu=substr($Contenu,$pos,strlen($Contenu)-$pos);
							$Contenu=substr($Contenu,$pos,$this->Trailer->Get_Offset()-$pos);
						}
						
						
						//echo $Contenu."<br>\r\n";
						//ON CREER OU MODIFIE L'OBJET XHREF						
						if (! $this->XHref instanceof  Objets_Xhref){
							$this->XHref=new Objets_Xhref($Contenu);
							$this->XHref->Set_Fichier_Pdf($this);
							$this->XHref->Set_OffSet(($pos+$Xhref_Position));
						}else{
							$this->XHref->Set_Contenu($Contenu);
						}
						$this->XHref->ListeOffset();
				}
			}
			
			
			$pos1++;
			
		}
		
		//ERREUR SI PAS DE TRAILER
		if (!$Trouver){
			$this->_Remonter_Erreur(1,"Objet Trailer Absent");
		}
		
	}
}

function TrouvePosition($Contenu,$Mot,$debug=false){
	$taille=strlen($Mot);
	$tailleC=strlen($Contenu);
	$i=0;
	$resultat=false;
	while ($resultat===false && (($i+$taille)<$tailleC)){
		
		if (substr($Contenu,$i,$taille)==$Mot){
			$resultat=$i;
		}
		$i++;
	}
	
	return $resultat;
}
?>