<?php
	/**
	* @name captcha
	* Afficher  une image avec 5 caractres gnr alatoirement.
	* 
	* @param Numeric iNbCaract : nombre de caractre
	* @param Array aTextColor : Code couleur(RGB) spar par des virgules de la couleur du texte.
	* @param Array aBgColor : Code couleur(RGB) spar par des virgules de la couleur de fond.
	* @param Array aBorderColor : Code couleur(RGB) spar par des virgules de la couleur de bordure.
	*
	* @return Image l'image cre.
	*/
	
	function captcha ($iNbCaract,$aTextColor, $aBgColor, $aBorderColor ) {
		//vrification d'existance de la fonction
		if ( !function_exists('imagecreatetruecolor') ){
			return false;
		}

		//test des paramtres
		if (!is_int($iNbCaract))
			$iNbCaract = 5;
			
		
		if ( is_array($aTextColor) && count($aTextColor)=== 3 ){ // si c'est un tableau de 3 
			for($i=0; $i<3;$i++){
				if ( $aTextColor[$i] < 0 || $aTextColor[$i] > 255 ){ // si ce n'est pas compris entre 0 et 255
					$aTextColor[$i] = 0; // on met  zro = blanc
				} 
			}
		}else { // c'est pas un tableau de 3
			$aTextColor = array(0,0,0);		
		}

		if ( is_array($aBgColor) && count($aBgColor)=== 3 ){ // si c'est un tableau de 3 
			for($i=0; $i<3;$i++){
				if ( $aBgColor[$i] < 0 || $aBgColor[$i] > 255 ){ // si ce n'est pas compris entre 0 et 255
					$aBgColor[$i] = 255; // on met  255 = noir
				} 
			}
		}else { // c'est pas un tableau de 3
			$aBgColor = array(255,255,255);		
		}
		
		if ( is_array($aBorderColor) && count($aBorderColor)=== 3 ){ // si c'est un tableau de 3 
			for($i=0; $i<3;$i++){
				if ( $aBorderColor[$i] < 0 || $aBorderColor[$i] > 255 ){ // si ce n'est pas compris entre 0 et 255
					$aBorderColor[$i] = 0; // on met  zro = blanc
				} 
			}
		}else { // c'est pas un tableau de 3
			$aBorderColor = array(0,0,0);		
		}		
		//fin test des paramtres
			
		//variables
		$iWidth = $iNbCaract * 20;
		$iHeight = 27;
		$iFontSize = 5; // de 1  5
		$sRep = "./captcha/";
		//fin variables
					
		//chiffre
		$aCaractere = array();
		for ($i=0; $i<=9; $i++) 
			$aCaractere[]  = $i;
		//majuscule
		for ($i=65; $i<=90; $i++) 
			$aCaractere[] = chr($i);
		//minuscule
		for ($i=97; $i<=122; $i++) 
			$aCaractere[] = chr($i);
				
		//texte alatoire
		$sTexte = "";
		$sTexteImg = "";
		$iLenCaractere = sizeof($aCaractere)-1;
		for ($cpt=0;$cpt<$iNbCaract;$cpt++) {
			$iNum_caract=rand(0, $iLenCaractere );
			$sTexte .= $aCaractere[$iNum_caract];
			$sTexteImg .= $aCaractere[$iNum_caract] . " ";
		}
					
		//enregistrement du texte dans la session
		$_SESSION['captcha'] = $sTexte;
				
		//cration d'une image
		$rImage = imagecreatetruecolor ($iWidth, $iHeight);
		
		//couleur du texte
		if (count($aTextColor) === 3)
			$cText_color = imagecolorallocate ($rImage, $aTextColor[0], $aTextColor[1], $aTextColor[2]);
				
		// couleur de fond
		if (count($aBgColor) === 3)
			$cBg_color = imagecolorallocate ($rImage, $aBgColor[0], $aBgColor[1], $aBgColor[2]);
					
		// couleur de fond
		if (count($aBorderColor) === 3)
			$cBorder_color = imagecolorallocate ($rImage, $aBorderColor[0], $aBorderColor[1], $aBorderColor[2]);
		
		// on dessine la bordure
		imagefilledrectangle($rImage, 0, 0, $iWidth, $iHeight,$cBorder_color);
		imagefilledrectangle($rImage, 1, 1, $iWidth-2, $iHeight-2,$cBg_color);
					
		// on crit le texte
		imagestring ($rImage, $iFontSize, 10, 5,  $sTexteImg, $cText_color);
		
		// on brouille l'image : floue
		imagefilter($rImage, IMG_FILTER_SMOOTH, 2); //IMG_FILTER_EMBOSS, IMG_FILTER_SMOOTH
		
		// Rotation
		$rImage = imagerotate($rImage, 5, $cBg_color);
		
		return imagepng($rImage);
		
		imagedestroy ($rImage);
	}
	
?>