<?php
define ('MSG_WRONG_STYLE_TYPE','Style non paramtrable');

/**
* class myIterator  implements Iterator,Countable,Seekableiterator,ArrayAccess
*/
class myIterator  implements Iterator,Countable,Seekableiterator,ArrayAccess
{
  /**
  * property protected array $oItems:
  *
  * desc: tableau d'lments .
  */
  protected $oItems=null;
  
  /**
  * property protected int $ipos
  *
  * desc: indice itrative de Position relative
  */
  protected $iPos=0;
  
  /**
  * property protected int $iMin
  *
  * desc: indice minimale de bornage
  */
  protected $iMin=0;
  
  /**
  * property protected int $iLimit
  *
  * desc: nombre limite d'occurences bornes
  */
  protected $iLimit;
  
  /**
  * property int  $iOffset
  *
  * desc: Indice itrative de Position absolue
  */
  protected $iOffset=0;
  
  /**
  * public function constructor
  *  
  * param int $iMin
  * param int $iLimit
  */  
  public function __construct($iMin,$iLimit)
  {
    $this->oItems=array();
    $this->iLimit=$iLimit;
    $this->iMin=$iMin;
  }
  
  /**
  * public function add
  *
  * desc: empile le tableau pass en paramtres sur la pile existante statique
  *
  * param int $iMin
  * param int $iLimit
  */  
  public function add($array)
  {
    $this->oItems[]=$array;
  }
  
  /**
  * public function setLimit
  *
  * desc: Dfinit un bornage $it => indice de dpart , $l => longueur de la plage en occurences
  * 
  * param int $it 
  * param int $l 
  */  
  public function setLimit($it,$l)
  {
    if (is_int($it)&&is_int($l))
    {
      if ($l>0)
      {
        $this->iMin=$it;
        $this->iLimit=$l;
        $this->iOffset=$it;
      }
    }
  }
  
  /**
  * public function current 
  * 
  * desc: Methode itrative interface iterator 
  */
  public function current()
  {
    if ($this->valid())
      return current($this->oItems);
  }
  
  /**
  * public function valid 
  * 
  * desc: Methode itrative interface iterator 
  */
  public function valid()
  {
    return ( $this->iOffset >= $this->iMin && $this->iPos < ($this->iLimit) ) ;
    
  }
  
  /**
  * public function next 
  * 
  * desc: Methode itrative interface iterator 
  */
  public function next()
  {
    $this->iPos++;
    $this->iOffset++;      
    return next($this->oItems);
    
  }
  
  /**
  * public function key 
  * 
  * desc: Methode itrative interface iterator 
  */
  public function key()
  {
    if ($this->valid())
      return key($this->oItems);
  }
  
  /**
  * public function rewind 
  * 
  * desc: Methode itrative interface iterator 
  */
  public function rewind()
  {
    reset ($this->oItems);
    $position = 0;
    while($position < $this->iMin) 
    {
      next($this->oItems);
      $position++;
    }
    $this->iPos=0;
    $this->iOffset=$this->iMin;
    if (!$this->valid()) 
      throw new Exception('Invalid seek position');
    
  }
  
  /**
  * public function count 
  * 
  * desc: Methode de comptage interface countable 
  */
  public function count()
  {
    return count($this->oItems);
  }
  
  /**
  * public function seek 
  * 
  * desc: Methode itrative interface seekableIterator 
  */
  public function seek($index)
  {
    $this->rewind();
    $position = $this->iMin;
    while($position < $index && $this->valid()) 
    {
      $this->next();
      $position++;
    }
    if (!$this->valid()) 
    {
      throw new Exception('Invalid seek position');
    }
  }
  
  /**
  * public function OffsetExists 
  *
  * desc: Methode d' acces aux tableaux, interface arrayAccess 
  *
  * param $iOffset int 
  */
  public function OffsetExists($iOffset)
  {
    if ($iOffset < $this->iLimit && $iOffset >= $this->iMin)
      return true;
    else return false;
  }
  
  /**
  * public function OffsetGet 
  * 
  * desc: Methode itrative interface arrayAccess 
  */
  public function OffsetGet($iOffset)
  {
    if ($this->OffsetExists($iOffset))
      return $this->oItems[$iOffset];
  }
  
  /**
  * public function OffsetSet 
  * desc: Methode itrative interface arrayAccess 
  */
  public function OffsetSet($iOffset,$val)
  {
    throw new Exception ('Acces Impossible en criture');
  }
  
  public function OffsetUnset($iOffset)
  {
    
  }
  
}


/**
* class monthIterator extends myIterator
*/
class monthIterator extends myIterator
{
  /**
  * property int $startmonth 
  * indice minimale du bornage au mois 
  */
  private $startmonth;
  
  /**
  * property int $startyear 
  * indice minimale du bornage  l'anne 
  */
  private $startyear;
  
  /**
  * property int $iM 
  * indice de position du mois 
  */
  private $iM;
  
  /**
  * property int $iM 
  * indice de position de l'anne 
  */
  private $iY;
 
  /**
  * public function __construct
  * Constructeur.
  * 
  * @param string $start au format mm/yyyy  
  * @param int $period en mois
  */
  public function __construct($start,$period=100)
  {
    if (substr($start,2,1)!=='/')
      throw new Exception('Paramtre Invalide pour constructeur format mm/yyyy');
    
    $expl=explode('/',$start);
    
    if( ((int)$expl[0]) <= 12 && ((int)$expl[0]) > 0 )
      $this->startmonth=(int)$expl[0];
    else throw new Exception('Format du mois invalide') ;
    
    if ( ((int)$expl[1]) >= 1000 && ((int)$expl[1]) < 9999 )
      $this->startyear=(int)$expl[1];
    else throw new Exception('Format anne invalide');
    
    parent::__construct(0,$period);
  }
  
  
  /**
  * public function 
  * 
  * desc: Getter
  * param: mixed $prop 
  * return object
  */
  public function __get ($prop)
  {
    if (isset($this->$prop))
    return $this->$prop;
  }
  
  /**
  * public Function nextM 
  *
  * desc: positionne les indices iM et iY (mois et anne) de l'iterateur.   
  */
  public function NextM()
  {
    if( $this->iM < 12)
    {
      $this->iM++;
    }
    else
    {
      $this->iM = 1;
      $this->iY++;
    }
  }
  
  /**
  * public Function next 
  *
  * desc: methode iterative.   
  */
  public function next()
  {
    parent::next();
    $this->NextM();
  }
  
  /**
  * public Function rewind 
  *
  * desc: methode iterative.   
  */
  public function rewind()
  {
    parent::rewind();
    $this->iM = $this->startmonth;
    $this->iY = $this->startyear;
  }
}

/**
* Class calendar
*/
class calendar 
{
  /**
  * property object $monthIterator
  */
  private $monthIterator;
  
  /**
  * property array $fixClosed
  * 
  * desc listing des jours fris fixes 
  */
  private $fixClosed=array('Jour de l\'an'=>'01/01',
                           'Fete du Travail'=>'01/05',
                           'Armist. 1945'=>'08/05',
                           'Fete nat'=>'14/07',
                           'assomption'=>'15/08',
                           'Toussaint'=>'01/11',
                           'Armist. 1918'=>'11/11',
                           'Noel'=>'25/12');
  /**
  * property array $variants
  * 
  * desc list modifiables des jours fris variables
  */                         
  private $variants=array();
  
  /**
  * property array $settable
  * 
  * desc list des proprits modifiables
  */
  private $settable=array(  );
  
  /**
  * function Constructor
  * 
  * param string $start format 'mm/yyyy'
  * param int $period  
  *
  */
  public function __construct ($start,$period)
  {
    $this->monthIterator=new monthIterator($start,$period);
    $i=$this->monthIterator->iMin;
    $this->monthIterator->rewind();
    while ( $i < $this->monthIterator->iLimit)
    { 
      $this->monthIterator->add(self::createmonth($this->monthIterator->iM,$this->monthIterator->iY));
      $this->monthIterator->NextM();
      $i++;
    }
  }
  
  /**
  * public function checkFormat 
  * 
  * desc: vrifie si une date est au format spcifi
  * 
  * param: string $val
  * param: $format dd/mm defaut
  * return: bool 
  */
  public function checkFormat($val,$format='dd/mm')
  {
    switch($format)
    {
      case 'dd/mm':
          if (substr($val,2,1)!=='/')
            return false;
          $expl=explode('/',$val);
          if (!( ((int)$expl[0]) > 0 && ((int)$expl[0]) < 32 ))
            return false;
          if( !(((int)$expl[1]) <= 12 && ((int)$expl[1]) > 0) )
            return false;
          return true;
          break;
      case 'mm/dd':
          if (substr($val,2,1)!=='/')
            return false;
          $expl=explode('/',$val);
          if (!( ((int)$expl[1]) > 0 && ((int)$expl[1]) < 32 ))
            return false;
          if( !(((int)$expl[0]) <= 12 && ((int)$expl[0]) > 0) )
            return false;
          return true;
          break;
      case 'dd-mm':
          if (substr($val,2,1)!=='-')
            return false;
          $expl=explode('-',$val);
          if (!( ((int)$expl[0]) > 0 && ((int)$expl[0]) < 32 ))
            return false;
          if( !(((int)$expl[1]) <= 12 && ((int)$expl[1]) > 0) )
            return false;
          return true;
          break;
       case 'mm-dd':
          if (substr($val,2,1)!=='-')
            return false;
          $expl=explode('-',$val);
          if (!( ((int)$expl[1]) > 0 && ((int)$expl[1]) < 32 ))
            return false;
          if( !(((int)$expl[0]) <= 12 && ((int)$expl[0]) > 0) )
            return false;
          return true;
          break;
       case 'dd/mm/yyyy':
          if (substr($val,2,1)!=='/')
            return false;
          if (substr($val,5,1)!=='/')
            return false;
          $expl=explode('/',$val);
          if (!( ((int)$expl[0]) > 0 && ((int)$expl[0]) < 32 ))
            return false;
          if( !(((int)$expl[1]) <= 12 && ((int)$expl[1]) > 0) )
            return false;
          if( !(((int)$expl[2]) < 1000 && ((int)$expl[2]) > 9999) )
            return false;
          return true;
          break;
       case 'dd-mm-yyyy':
          if (substr($val,2,1)!=='-')
            return false;
          if (substr($val,5,1)!=='-')
            return false;
          $expl=explode('-',$val);
          if (!( ((int)$expl[0]) > 0 && ((int)$expl[0]) < 32 ))
            return false;
          if( !(((int)$expl[1]) <= 12 && ((int)$expl[1]) > 0) )
            return false;
          if( !(((int)$expl[2]) < 1000 && ((int)$expl[2]) > 9999) )
            return false;
          return true;
          break;
        case 'yyyy/mm/dd':
          if (substr($val,2,1)!=='/')
            return false;
          if (substr($val,5,1)!=='/')
            return false;
          $expl=explode('/',$val);
          if (!( ((int)$expl[2]) > 0 && ((int)$expl[2]) < 32 ))
            return false;
          if( !(((int)$expl[1]) <= 12 && ((int)$expl[1]) > 0) )
            return false;
          if( !(((int)$expl[0]) < 1000 && ((int)$expl[0]) > 9999) )
            return false;
          return true;
          break;
        case 'yyyy-mm-dd':
          if (substr($val,2,1)!=='-')
            return false;
          if (substr($val,5,1)!=='-')
            return false;
          $expl=explode('-',$val);
          if (!( ((int)$expl[2]) > 0 && ((int)$expl[2]) < 32 ))
            return false;
          if( !(((int)$expl[1]) <= 12 && ((int)$expl[1]) > 0) )
            return false;
          if( !(((int)$expl[0]) < 1000 && ((int)$expl[0]) > 9999) )
            return false;
          return true;
          break;
        default:
        return false;
    }
  } 
  
  /**
  * public function isClosed 
  * 
  * desc: vrifie si un jour est feri
  * 
  * param: string $daymth
  * return: bool 
  */
  public function isClosed($daymth)
  {
    $this->makeVariants();
    return (in_array($daymth,$this->fixClosed)||in_array($daymth,$this->variants) );
  }
  
  public function getClosed($daymth)
  {
  	$closedkey=array_keys(array_merge($this->fixClosed,$this->variants),$daymth);
  	if (count($closedkey)>0)
  		return (array_pop($closedkey));
  	//print_r ($closedkey);
  }
  
  /**
  * public function __get 
  * 
  * desc: Getter
  * 
  * param: mixed $prop
  * return: property object 
  */
  public function __get($prop)
  {
    if (isset($this->$prop))
      return $this->$prop;
    else if (array_key_exists($prop,$this->variants))
      return $this->variants[$prop];
    else return false;
  }
  
  /**
  * public function __set 
  * 
  * desc: setter si la proprit est 'paques' => autoset propriete 'ascenssion' 
  *                                                  et  propriete 'pentecote'
  * 
  * param: mixed $prop
  * param: mixed $val 
  */
  public function __set($prop,$val)
  {
    if (in_array($prop,$this->settable))
    {
      
    }
    else throw new Exception ('propriete invalide');    
  }
  
  /**
  * function getCurrentMonth
  * 
  * desc:renvoit le mois et l'anne en cours
  * 
  * return string format ('mm/yyyy') 
  */
  public function getCurrentMonth()
  {
    return (($this->monthIterator->iM<10)?'0'.$this->monthIterator->iM.'/'.$this->monthIterator->iY:$this->monthIterator->iM.'/'.$this->monthIterator->iY);
  }
  
  /**
  * function getNextM
  * 
  * desc:renvoit le mois prochain ou l'anne du prochain mois en cours
  * 
  * param char 'M' ou 'Y'
  * return int 
  */
  public function getNextM($mode,$numMonths=1)
  {
    if (is_int($numMonths)&&$numMonths>0)
    {
      switch ($mode)
      { 
      case 'M':
        return(date('m',mktime(0, 0, 0, $this->monthIterator->iM+$numMonths, 1, $this->monthIterator->iY)));
       break;
      case 'Y':
        return(date('Y',mktime(0, 0, 0, $this->monthIterator->iM+$numMonths, 1, $this->monthIterator->iY)));
      break;
      }
      
    }
    else return null;
  }
  
  /**
  * function getPrevM
  * 
  * desc:renvoit le mois prcdent ou l'anne du prcdent mois en cours
  * 
  * param char 'M' ou 'Y'
  * return int 
  */
  public function getPrevM($mode,$numMonths=1)
  {
    if (is_int($numMonths)&&$numMonths>0)
    {
      switch ($mode)
      { 
        case 'M':
          return (date('m',mktime(0, 0, 0, $this->monthIterator->iM-$numMonths, 1, $this->monthIterator->iY)));
        break;
        case 'Y':
          return(date('Y',mktime(0, 0, 0, $this->monthIterator->iM-$numMonths, 1, $this->monthIterator->iY)));
        break;
      }
    }
    else return null;
  }
  
  /**
  * public function makeVariants
  * 
  * Desc: calcule paques,pentecote et jour feries algo de Oudin 
  */
  public function makeVariants()
  {
    //pques
    $year=$this->monthIterator->iY;
    $G=$year%19;
    $C=floor($year/100);
    $C_4=floor($C/4);
    $E=floor((8*$C+13)/25);
    $H=(19*$G+$C-$C_4-$E+15)%30;
    $K=floor($H/28);
    $P=floor(29/($H+1));
    $Q=floor((21-$G)/11);
    $I=($K*$P*$Q -1)*$K+$H;
    $B=floor($year/4)+$year;
    $J1=$B+$I+2+$C_4-$C;
    $J2=$J1%7;
    $R=28+$I-$J2;
    $day=(int)date('d',(mktime(0,0,0,3,1+$R,$year)));
    $mth=(int)date('m',(mktime(0,0,0,3,1+$R,$year)));
    
    if ($day<10)
      $day='0'.$day;
    if ($mth<10)
      $mth='0'.$mth;
    
    $val=$this->variants['paques']=$day.'/'.$mth;
    
    //ascenssion
    $dasc=(int)date('d',(mktime(0,0,0,$mth,$day+38,$this->monthIterator->iY)));
    $masc=(int)date('m',(mktime(0,0,0,$mth,$day+38,$this->monthIterator->iY)));
    if ($dasc<10)
      $dasc='0'.$dasc;
    if ($masc<10)
      $masc='0'.$masc;    
    $this->variants['ascenssion']=$dasc.'/'.$masc;
    
    //pentecte    
    $dasc=(int)date('d',(mktime(0,0,0,$mth,$day+49,$this->monthIterator->iY)));
    $masc=(int)date('m',(mktime(0,0,0,$mth,$day+49,$this->monthIterator->iY)));
    if ($dasc<10)
      $dasc='0'.$dasc;
    if ($masc<10)
      $masc='0'.$masc;
    $this->variants['Dans le cul']=$dasc.'/'.$masc;
  }
  
  /**
  * public Static function
  * 
  * desc: Methode de fabrication de calendrier de type tableau au mois
  * 
  * param int $month
  * param int $year
  * return array
  */
  public static function createmonth($month,$year)
  {
    // jour de la semaine du premier du mois
    $fom = date ("w",mktime(0, 0, 0, $month, 1, $year));
    $day=1;
    $start=false;
    //combien de jours dans le mois?
    $max=date('t',mktime(0, 0, 0, $month, 1, $year));
    //formatage en chaine
    if ($month < 10)
      $month = '0'.$month;
    //init
    $d=0 ;
    //Le calendrier va occuper 6 lignes(semaines) de 7 colonnes(jours) pour le mois au maximum
    for ( $i=0 ; $i < 6 ; $i++ ) 
    {
      for ( $j=0 ; $j < 7 ;$j++ ) 
      {
        //dbut du comptage au 1er du mois pour la premiere semaine
        if ($i==0) 
        {
          if ($fom == $d)
          {
            $start=true;
            $day=1;
          }
        }
        if ($day < $max+1) 
        {
          if ($start ===true)
          {
            if ($day<10)
              $cal[$j][]='0'.$day;
            else 
              $cal[$j][]=$day;
            $day++;
          }
          else
            $cal[$j][]='';
        }
        else 
          $cal[$j][]='';
        $d++;
      }
    }
    return $cal;    
  }
}

/**
* class htmlCalendar extends calendar
*/
class htmlCalendar extends calendar
{
  /**
  * private property string domTextBoxId
  * 
  * desc : l'id de la text box
  */
  private $domTextBoxId;
  
  /**
  * proprerty array settable
  * 
  * desc : les proprits modifiables
  */
  private $settable=array('cssHeader',
                          'cssSunday',
                          'cssClosed',
                          'cssWeekday',
                          'cssToday',
                          'cssLink',
                          'cssFooter',
                          'MonthByMonth',
                          'MonthPerLines',
                          'tdWidth',
                          'tdHeight',
                          'target',
                          'clickable');
                          
  const CkAll = 0;
  const CkClosed = 1;
  const CkOpened = 2;
  const CksunDay = 4;
  /**
  * proprerty array style
  * 
  * desc: le tableau des proprits de style 
  */
  private $style=array();
  
  /**
  * proprerty string html
  * 
  * desc: la chaine html stockant le calendrier au format html 
  */
  private $html;
  
  /**
  * public function __set 
  * 
  * desc: Setter
  * 
  * param:string $type
  * param string $strVal
  */
  public function __set($type,$strVal)
  {
    if (in_array($type,$this->settable))
    {
      $this->style[$type]=$strVal;
    }
    else parent::__set($type,$strVal); 
  }
  
  /**
  * public function __construct
  * 
  * desc: Initialisation et constrcution des objets parents
  */
  public function __construct($boxId=null,$month=null,$year=null,$period=1)
  {
    $this->domTextBoxId=$boxId;
    $this->MonthByMonth=false;
    $this->MonthPerLines=4;
    $this->clickable=self::CkOnlyOpened;
    $m=isset($month)?(int)$month:(int)date('m');
    $y=isset($year)?(int)$year:(int)date('Y');
    if ($m<10)
      $m='0'.$m;
    parent::__construct($m.'/'.$y,$period);
   }
  
  /**
  * public function __get 
  * 
  * desc: Getter
  * 
  * param: mixed $prop
  * return: mixed value 
  */
  
  public function __get($prop)
  {
    if (parent::__get($prop))
      return parent::__get($prop);
    if (array_key_exists($prop,$this->style))
      return $this->style[$prop];
  }
  
  /**
  * public function getHtml 
  * 
  * desc: Construit et rcupre le tableau en chaine html
  * 
  * return: string  
  */
  public function getHtml()
  {
    $tdW=$this->tdWidth;
    $tdH=$this->tdHeight;
    
    if ($this->target=='opener')
    	$close='self.close();';
    else $close='';
            
    $cnt=1;
    $this->html='';
    
    $this->html.='<table border="0" cellpadding="0" cellspacing="0" >
          <!--DWLayoutTable-->';
    
    //Le calendrier va occuper 5 lignes(semaines) de 7 colonnes(jours) pour le mois au maximum
    foreach ($this->monthIterator as $key=>$month)
    {
      if ($cnt%$this->MonthPerLines==$this->MonthPerLines)
        $this->html.='<tr><td valign="top">';
      else $this->html.='<td valign="top">';
      
      $MONTH=date('M',mktime(0, 0, 0, $this->monthIterator->iM, 1, $this->monthIterator->iY));
        
      if ($this->MonthByMonth!==false)
      {
        $prevm=$this->getPrevM('M');
        $prevprevm=$this->getPrevM('M',$this->monthIterator->iLimit);
        $prevy=$this->getPrevM('Y');
        $prevprevy=$this->getPrevM('Y',$this->monthIterator->iLimit);
        $nextm=$this->getNextM('M');
        $nextnextm=$this->getNextM('M',$this->monthIterator->iLimit);
        $nexty=$this->getNextM('Y');
        $nextnexty=$this->getNextM('Y',$this->monthIterator->iLimit);
        $chooseMonth='
        <a class="'.$this->cssLink.'" href="?month='.$prevprevm.'&year='.$prevprevy.'"><<</a><a class="'.$this->cssLink.'" href="?month='.$prevm.'&year='.$prevy.'">&nbsp;<&nbsp;</a>&nbsp;'.$MONTH.'&nbsp;&nbsp;'.$this->monthIterator->iY.'&nbsp;<a class="'.$this->cssLink.'" href="?month='.$nextm.'&year='.$nexty.'&box='.$this->domTextBoxId.'">&nbsp;>&nbsp;</a><a class="'.$this->cssLink.'" href="?month='.$nextnextm.'&year='.$nextnexty.'&box='.$this->domTextBoxId.'">>></a>';
      }
      else $chooseMonth='&nbsp;'.$MONTH.'&nbsp;&nbsp;'.$this->monthIterator->iY.'&nbsp;';
      
      $this->html.= '
        <table border="0" cellpadding="0" cellspacing="0" >
        <!--DWLayoutTable-->
          <tr>
            <td width="'.$tdW.'" height="'.$tdH.'" valign="middle" align="center" class="'.$this->cssHeader.'">D</td>
            <td width="'.$tdW.'" valign="middle" align="center" class="'.$this->cssHeader.'">L</td>
            <td width="'.$tdW.'" valign="middle" align="center" class="'.$this->cssHeader.'">M</td>
            <td width="'.$tdW.'" valign="middle" align="center" class="'.$this->cssHeader.'">M</td>
            <td width="'.$tdW.'" valign="middle" align="center" class="'.$this->cssHeader.'">J</td>
            <td width="'.$tdW.'" valign="middle" align="center" class="'.$this->cssHeader.'">V</td>
            <td width="'.$tdW.'" valign="middle" align="center" class="'.$this->cssHeader.'">S</td>
          </tr>';
      for ($j=0;$j<6;$j++)
      {
        $this->html.='<tr>';
        for ($k=0;$k<7;$k++)  
        {
          if ($this->monthIterator->iM < 10)
            $mth='0'.$this->monthIterator->iM;
          else $mth=$this->monthIterator->iM;
          
          $title =' title="click it to select in the box"';
          
          if ($k!=0)
          {
          	$class=$this->cssWeekday;
           	if ($this->clickable===self::CkOnlyOpened ||$this->clickable===self::CkAll)
            {
            	$click='<a href = "#" class="'.$this->cssLink.'" onclick="'.$this->target.'.document.getElementById(\''.$this->domTextBoxId.'\').value=\''.$month[$k][$j].'/'.$mth.'/'.$this->monthIterator->iY.'\';'.$close.' " '.$title.'>';
          		$endclick='</a>';
            }
            else
            { 
            	$click='';
            	$endclick='';
            }
          }
          
          if ($k==0)
          {
            $class=$this->cssSunday;
            if ($this->clickable===self::CkClosed ||$this->clickable===self::CkAll)
            {
            	$click='<a href = "#" class="'.$this->cssLink.'" onclick="'.$this->target.'.document.getElementById(\''.$this->domTextBoxId.'\').value=\''.$month[$k][$j].'/'.$mth.'/'.$this->monthIterator->iY.'\';'.$close.' " '.$title.'>';
          		$endclick='</a>';
            }
            else
            { 
            	$click='';
            	$endclick='';
            }
          }
          if ($this->isClosed($month[$k][$j].'/'.$mth))
          {
            $class=$this->cssClosed;
            $title='title="'.$this->getClosed($month[$k][$j].'/'.$mth).'"';
            if ($this->clickable===self::CkClosed ||$this->clickable===self::CkAll)
            {
            	$endclick='</a>';
            	$click='<a href = "#" class="'.$this->cssLink.'" onclick="'.$this->target.'.document.getElementById(\''.$this->domTextBoxId.'\').value=\''.$month[$k][$j].'/'.$mth.'/'.$this->monthIterator->iY.'\';'.$close.' " '.$title.'>';
            }
            else 
            {
            	$click='';
             	$endclick='';
            }
          }
          if ( ($month[$k][$j] == (int)date('d')) and ($this->monthIterator->iM== (int)date('m')) and ($this->monthIterator->iY == (int)date('Y')) )
          {  
            $class = $this->cssToday;
            $click='<a href = "#" class="'.$this->cssLink.'" onclick="'.$this->target.'.document.getElementById(\''.$this->domTextBoxId.'\').value=\''.$month[$k][$j].'/'.$mth.'/'.$this->monthIterator->iY.'\';'.$close.' " '.$title.'>';
          	$endclick='</a>';
          }
          
         	if($month[$k][$j]!='')
          	$this->html.= '<td width="'.$tdW.'" height="'.$tdH.'" valign="middle" align="center" class="'.$class.'">'.$click.(int)$month[$k][$j].$endclick.'</td>';
          else 
            $this->html.= '<td width="'.$tdW.'" height="'.$tdH.'" valign="middle" align="center" class="'.$class.'">&nbsp;</td>';
        }
        $this->html.= '</tr>';
      }
      $this->html.= '</table><table border="0" cellpadding="0" cellspacing="0" ><tr><td class="'.$this->cssFooter.'">'.$chooseMonth.'</td></tr></table>';
      
      if ($cnt%$this->MonthPerLines!=0)
        $this->html.= '</td>';
      else 
        if ($cnt!=1)
          $this->html.= '</td></tr>';
        else $this->html.= '</td>';
      	$cnt++;
    }
    $this->html.= '</table>';
    return $this->html;
  }
}
?>
