<?php
/**
 * Description of Password
 *
 * @author dtouaux <damien.touaux@hotmail.fr>
 * 2015/09/10
 */

require_once $_SERVER['DOCUMENT_ROOT'] . '/PHPExcel/Classes/PHPExcel.php';

class Password {
    private $nbChars; //nb de caractres dans le mot de passe
    private $nbPass; //nb de mot de passe  gnrer
    private $alphabet = array('a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z');
    private $upperAlphabet;
    private $numerics = array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
    private $specials = array('"', ',', '?', ';', '.', ':', '/', '!', '%', '+', '-', '=', '[', ']', '(', ')', '{', '}', '@', '&', '#', '|', '_', '$', '<', '>');
    
    private $hasLower = NULL;
    private $hasUpper = NULL;
    private $hasNumerics = NULL;
    private $hasSpecials = NULL;
    private $noSimilarity = NULL;
    
    public $typeExport = NULL;
    
    public $nbTypes = 0;
    private $repartitionChars = array('alphabet' => 0, 'upperAlphabet' => 0, 'numerics' => 0, 'specials' => 0);
    
    public $listPass = array();

    public function __construct($nbChars = 8, $nbPass = 1) {
        $this->nbChars = $nbChars;
        $this->nbPass = $nbPass;
        $this->upperAlphabet = array_map('strtoupper', $this->alphabet);
    }
    
    public function __set($name, $value)
    {
        switch($name){
            case "noSimilarity": //virer les caractres similaires
                unset($this->alphabet[array_search("l", $this->alphabet)]);
                unset($this->upperAlphabet[array_search("I", $this->upperAlphabet)]);
                unset($this->upperAlphabet[array_search("O", $this->upperAlphabet)]);
                unset($this->numerics[array_search("1", $this->numerics)]);
                unset($this->numerics[array_search("0", $this->numerics)]);
                unset($this->specials[array_search("|", $this->specials)]);
            default:    
                $this->$name = $value;
                break;
        }
    }
    
    public function display(){
        foreach ($this->listPass as $value) {
            echo "<br />" . $value;
        }
    }
    
    //gnration de l'export
    public function generate(){
        switch ($this->typeExport) {
            case "texte":
                $this->exportTexte($this->generateList());
                break;

            case "xml":
                $this->exportXML($this->generateList());
                break;

            case "json":
                $this->exportJSON($this->generateList());
                break;

            case "excel":
                $this->exportExcel($this->generateList());
                break;

            case "csv":
                unset($this->specials[array_search(";", $this->specials)]);
                unset($this->specials[array_search('"', $this->specials)]);
                unset($this->specials[array_search('=', $this->specials)]);
                $this->exportCSV($this->generateList());
                break;

            default:
                unset($this->specials[array_search("<", $this->specials)]);
                unset($this->specials[array_search(">", $this->specials)]);
                $this->generateList();
                break;
        }
    }
    
    /*
     * Export Txt
     */
    private function exportTexte($array = array()){
        $filename = 'password-' . date('YmdHis') . '.txt';
        $file = fopen($filename, 'w+');
        foreach ($array as $pass) {
            fwrite($file, $pass . "\r\n");
        }
        fclose($file);        
        
        header ('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header ('Content-Type: application/octet-stream');
        header ('Content-Length: ' . filesize($filename));
        header ("Content-Disposition: attachment; filename=\"$filename\"");  
        readfile($filename);
        unlink($filename);
        die();
    }
    
    /*
     * Export XML
     */
    public function exportXML($array = array()) {
        $filename = 'password-' . date('YmdHis') . '.xml';
        $dom = NEW DOMDocument('1.0', 'utf-8');
        $dom->formatOutput = true;
        $main_node = $dom->appendChild(new DOMElement('PASSWORDS'));
        foreach ($array as $password) {
            $pass = $main_node->appendChild(new DOMElement('PASS'));
            $cdata = $dom->createCDATASection($password);
            $pass->appendChild($cdata);
        }
        $dom->save($filename);
        header ('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header ('Content-Type: application/octet-stream');
        header ('Content-Length: ' . filesize($filename));
        header ("Content-Disposition: attachment; filename=\"$filename\"");  
        readfile($filename);
        unlink($filename);
    }
    
    /*
     * Export XML
     */
    public function exportJSON($array = array()) {
        $filename = 'password-' . date('YmdHis') . '.json';
        $file = fopen($filename, 'w+');
        fwrite($file, json_encode($array));
        fclose($file);        
        
        header ('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header ('Content-Type: application/octet-stream');
        header ('Content-Length: ' . filesize($filename));
        header ("Content-Disposition: attachment; filename=\"$filename\"");  
        readfile($filename);
        unlink($filename);
        die();
    }
    
    /*
     * Export XML
     */
    private function exportCSV($array = array()) {
        $filename = 'password-' . date('YmdHis') . '.csv';
        $output = '';
        $i = 1;
        foreach ($array as $password) {
            $output .= $this->filtre_csv($password).";";
            if($i == 10){
                $output .= "\r\n";
                $i = 1;
            }else{
                $i++;
            }
        }
       
        header('Content-Type: application/csv-tab-delimited-table; charset=utf-8');
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("Content-disposition: filename=" . $filename);
        echo $output;
        unlink($filename);
        die();
    }
    
    /*
     * filtre csv
     */
    private function filtre_csv($string, $separator = "\t"){
	return str_replace(array($separator, "\r\n", "\n", "\r"), array(" ", " ", " ", " "), html_entity_decode(htmlspecialchars_decode($string, ENT_QUOTES)));
    }
    
    /*
     * Export Excel
     */
    public function exportExcel($array = array()) {
        $filename = 'password' . date('YmdHis') . '.xls';
        $objPHPExcel = new PHPExcel();

        //on dfinit les proprits de notre document
         $objPHPExcel->getProperties()
         ->setCreator($_SERVER['SERVER_NAME'])
         ->setLastModifiedBy($_SERVER['SERVER_NAME'])
         ->setTitle("Password Generator")
         ->setSubject("Passwords List");

         $sheet = $objPHPExcel->getActiveSheet();

        $sheet->getProtection()->setSheet(true);
        $sheet->getProtection()->setSheet(true);
        $sheet->getProtection()->setSort(true);
        $sheet->getProtection()->setInsertRows(true);
        $sheet->getProtection()->setFormatCells(true);

        $styleFont = array(
            'font'  => array(
                'bold'  => true,
                'color' => array('rgb' => '000000'),
                'size'  => 11,
                'name'  => 'Calibri'
            ));        

        $styleFontListe = array(
            'font'  => array(
                'bold'  => false,
                'color' => array('rgb' => '000000'),
                'size'  => 11,
                'name'  => 'Calibri'
            ));        

        $sheet->getColumnDimension('A')->setWidth(25);
        $objPHPExcel->getActiveSheet()->getStyle('A')->applyFromArray($styleFont);
        $sheet->setCellValue('A1', "Passwords");
        
        $i = 2;
        
        foreach ($array as $key => $value) {
            $array[$key] = iconv("ISO-8859-1//TRANSLIT","UTF-8", html_entity_decode(strip_tags($value), ENT_HTML5, "ISO-8859-1"));
            $objPHPExcel->getActiveSheet()->getStyle('A' . $i)->applyFromArray($styleFontListe);
            $sheet->setCellValue('A' . $i, $value);
            $i++;
        }
        
        $objPHPExcel->setActiveSheetIndex(0);
        //crire les donnes dans le fichier Excel
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');

        header('Content-type: application/vnd.ms-excel;');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        $objWriter->save('php://output');
        unlink($filename);
        die();
        
    }
    
    /*
     * retourner la liste des mots de passe
     * return array
     */
    private function generateList(){
        //repartir les caractres
        $mod = $this->nbChars % $this->nbTypes;
        $std = ($this->nbChars - $mod) / $this->nbTypes;
        if(!$mod){
            if ($this->hasLower) $this->repartitionChars['alphabet'] = $std;
            if ($this->hasUpper) $this->repartitionChars['upperAlphabet'] = $std;
            if ($this->hasNumerics) $this->repartitionChars['numerics'] = $std;
            if ($this->hasSpecials) $this->repartitionChars['specials'] = $std;
        }else{
            if($this->hasSpecials){
                $this->repartitionChars['specials'] = (array_sum($this->repartitionChars) + $std + $mod == $this->nbChars)? $std + $mod : $std;
            }
            if($this->hasNumerics){
                $this->repartitionChars['numerics'] = (array_sum($this->repartitionChars) + $std + $mod == $this->nbChars)? $std + $mod : $std;
            }
            if($this->hasUpper){
                $this->repartitionChars['upperAlphabet'] = (array_sum($this->repartitionChars) + $std + $mod == $this->nbChars)? $std + $mod : $std;
            }
            if($this->hasLower){
                $this->repartitionChars['alphabet'] = (array_sum($this->repartitionChars) + $std + $mod == $this->nbChars)? $std + $mod : $std;
            }
            
        }
        
        for($i = 1; $i <= $this->nbPass; $i++){
            $this->listPass[] = $this->generatePassword();
        }
        
        return $this->listPass;
    }
    
    //calcul 
    
    /*
     * gnrer un mot de passe
     * return string
     */
    private function generatePassword(){
        $pass = "";
        if ($this->hasLower) $pass .= $this->returnChars($this->repartitionChars['alphabet'], 'alphabet');
        if ($this->hasUpper) $pass .= $this->returnChars($this->repartitionChars['upperAlphabet'], 'upperAlphabet');
        if ($this->hasNumerics) $pass .= $this->returnChars($this->repartitionChars['numerics'], 'numerics');
        if ($this->hasSpecials) $pass .= $this->returnChars($this->repartitionChars['specials'], 'specials');
        return str_shuffle($pass);
    }
    
    /*
     * retourne des caractres
     * return string
     */
    private function returnChars($nb, $type){
        $array = $this->$type;
        $chars = "";
        for($i = 1; $i <= $nb; $i++){
            //$chars .= $array[mt_rand(0, count($array) - 1)];
            $chars .= $array[array_rand($array)];
        }
        return $chars;
    }
    
}

?>
