<?php
	namespace DataBase;

	class Credential{
		private $login;
		private $password;

		public function __construct($log, $pass){
			$this->login = $log;
			$this->password = $pass;
		}

		public function login($value = null){
			if(is_null($value)){
				return $this->login;
			}else{
				$this->login = $value;
			}
		}

		public function password($value = null){
			if(is_null($value)){
				return $this->password;
			}else{
				$this->password = $value;
			}
		}
	}

	abstract class DataBase{
		protected $address = "localhost";
		protected $port = 0;
		protected $credential;
		protected $query = array();
		protected $db;
		protected $base = "";


		public function __construct($add, $port, $cred){
			$this->address = $add;
			$this->port = $port;
			$this->credential = $cred;
		}

		public function base($value = null){
			if(is_null($value)){
				return $this->base;
			}else{
				$this->base = $value;
			}
            return $this;
		}

		abstract protected function send($query);
		
		public function exec($q = null){
			if(is_null($q)){
                if(isset($this->query["select"])){
				    $q = "SELECT ".$this->query["select"];
				    if(isset($this->query["from"])){
					    $q = $q." FROM ".$this->query["from"];
				    }
				    if(isset($this->query["where"])){
					    $q = $q." WHERE ".$this->query["where"];
				    }
				    if(isset($this->query["order"])){
					    $q = $q." ORDER BY ".$this->query["order"];
				    }
                }else if(isset($this->query["insert"])){
                    $q = "INSERT INTO ".$this->base." (".implode(",",$this->query["insert"]).") VALUES (".implode(",",$this->query["values"]).")";
                }
			}
			return $this->send($q);
		}
		
		public function select($part){
            $this->query = array();
			$this->query["select"] = $part;
			return $this;
		}
        public function insert($part){
            $this->query = array();
			$this->query["insert"] = $part;
			return $this;
		}
		public function from($part){
			$this->query["from"] = $part;
            return $this;
		}
		public function where($part){
			$this->query["where"] = $part;
            return $this;
		}
		public function order($part){
			$this->query["order"] = $part;
            return $this;
		}
        public function values($part){
			$this->query["values"] = $part;
            return $this;
		}

		abstract public function close();
	}
?>